/*
 * Decompiled with CFR 0.152.
 */
package org.geojsf.web.rest.area;

import net.sf.ahtutils.exception.ejb.UtilsConstraintViolationException;
import net.sf.ahtutils.exception.ejb.UtilsNotFoundException;
import net.sf.ahtutils.factory.xml.status.XmlTypeFactory;
import net.sf.ahtutils.interfaces.facade.UtilsFacade;
import net.sf.ahtutils.interfaces.model.status.UtilsDescription;
import net.sf.ahtutils.interfaces.model.status.UtilsLang;
import net.sf.ahtutils.interfaces.model.status.UtilsStatus;
import net.sf.ahtutils.model.interfaces.with.EjbWithDescription;
import net.sf.ahtutils.model.interfaces.with.EjbWithLang;
import net.sf.ahtutils.monitor.DataUpdateTracker;
import net.sf.ahtutils.web.rest.AbstractUtilsRest;
import net.sf.ahtutils.xml.aht.Aht;
import net.sf.ahtutils.xml.sync.DataUpdate;
import org.geojsf.factory.ejb.area.EjbBasinFactory;
import org.geojsf.interfaces.model.area.GeoBasin;
import org.geojsf.interfaces.rest.area.basin.surface.GeoJsfAreaBasinSurfaceRestExport;
import org.geojsf.interfaces.rest.area.basin.surface.GeoJsfAreaBasinSurfaceRestImport;
import org.geojsf.model.xml.area.Areas;
import org.geojsf.model.xml.area.Basin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeoJsfAreaBasinRest<L extends UtilsLang, D extends UtilsDescription, BASIN extends GeoBasin<L, D, BASIN, MODEL>, MODEL extends UtilsStatus<MODEL, L, D>>
extends AbstractUtilsRest<L, D>
implements GeoJsfAreaBasinSurfaceRestExport,
GeoJsfAreaBasinSurfaceRestImport {
    static final Logger logger = LoggerFactory.getLogger(GeoJsfAreaBasinRest.class);
    private final Class<MODEL> cM;
    private final Class<BASIN> cB;
    private EjbBasinFactory<L, D, BASIN, MODEL> efBasin;

    public GeoJsfAreaBasinRest(UtilsFacade fUtils, String[] defaultLangs, Class<L> cL, Class<D> cD, Class<BASIN> cB, Class<MODEL> cM) {
        super(fUtils, defaultLangs, cL, cD);
        this.cB = cB;
        this.cM = cM;
        this.efBasin = EjbBasinFactory.factory(cL, cD, cB);
    }

    public static <L extends UtilsLang, D extends UtilsDescription, BASIN extends GeoBasin<L, D, BASIN, MODEL>, MODEL extends UtilsStatus<MODEL, L, D>> GeoJsfAreaBasinRest<L, D, BASIN, MODEL> factory(UtilsFacade fGeoMonitoring, String[] defaultLangs, Class<L> cL, Class<D> cD, Class<BASIN> cB, Class<MODEL> cM) {
        return new GeoJsfAreaBasinRest<L, D, BASIN, MODEL>(fGeoMonitoring, defaultLangs, cL, cD, cB, cM);
    }

    public Aht exportGeoJsfWaterSurfaceBasinModel() {
        return this.exportStatus(this.cM);
    }

    public DataUpdate importGeoJsfAreaBasinSurfaceModel(Aht models) {
        return this.importStatus(this.cM, null, models);
    }

    public DataUpdate importGeoJsfAreaBasinSurface(Areas basins) {
        return this.importBasins(basins);
    }

    public Areas exportGeoJsfWaterSurfaceBasins() {
        return this.exportBasins();
    }

    private Areas exportBasins() {
        logger.warn("NYI");
        return null;
    }

    private DataUpdate importBasins(Areas basins) {
        DataUpdateTracker dut = new DataUpdateTracker(true);
        dut.setType(XmlTypeFactory.build((String)this.cB.getName(), (String)"DB Import"));
        for (Basin basin : basins.getBasin()) {
            try {
                UtilsStatus model = (UtilsStatus)this.fUtils.fByCode(this.cM, basin.getModel().getCode());
                GeoBasin ejb = this.efBasin.build(basin, model);
                ejb = (GeoBasin)this.fUtils.persist((Object)ejb);
                this.efLang.persistMissingLangs(this.fUtils, this.defaultLangs, (EjbWithLang)ejb);
                this.efDescription.persistMissingLangs(this.fUtils, this.defaultLangs, (EjbWithDescription)ejb);
                dut.success();
            }
            catch (UtilsNotFoundException e) {
                dut.fail((Throwable)e, true);
            }
            catch (UtilsConstraintViolationException e) {
                dut.fail((Throwable)e, true);
            }
        }
        return dut.toDataUpdate();
    }
}

