/*
 * Decompiled with CFR 0.152.
 */
package org.geojsf.web.rest.monitoring;

import java.util.ArrayList;
import net.sf.ahtutils.exception.ejb.UtilsConstraintViolationException;
import net.sf.ahtutils.exception.ejb.UtilsNotFoundException;
import net.sf.ahtutils.factory.xml.status.XmlTypeFactory;
import net.sf.ahtutils.interfaces.facade.UtilsFacade;
import net.sf.ahtutils.interfaces.model.status.UtilsDescription;
import net.sf.ahtutils.interfaces.model.status.UtilsLang;
import net.sf.ahtutils.interfaces.model.status.UtilsStatus;
import net.sf.ahtutils.model.interfaces.with.EjbWithDescription;
import net.sf.ahtutils.model.interfaces.with.EjbWithLang;
import net.sf.ahtutils.monitor.DataUpdateTracker;
import net.sf.ahtutils.web.rest.AbstractUtilsRest;
import net.sf.ahtutils.xml.aht.Aht;
import net.sf.ahtutils.xml.sync.DataUpdate;
import org.geojsf.factory.ejb.monitoring.EjbStationFactory;
import org.geojsf.interfaces.model.monitoring.GeoStation;
import org.geojsf.interfaces.model.monitoring.GeoStationCapability;
import org.geojsf.interfaces.rest.monitoring.station.GeoJsfMonitoringStationRestExport;
import org.geojsf.interfaces.rest.monitoring.station.GeoJsfMonitoringStationRestImport;
import org.geojsf.model.xml.monitoring.Station;
import org.geojsf.model.xml.monitoring.Stations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeoJsfMonitoringStationRest<L extends UtilsLang, D extends UtilsDescription, STATION extends GeoStation<L, D, STATION, CAP, CAPT, CAPS>, CAP extends GeoStationCapability<L, D, STATION, CAP, CAPT, CAPS>, CAPT extends UtilsStatus<CAPT, L, D>, CAPS extends UtilsStatus<CAPS, L, D>>
extends AbstractUtilsRest<L, D>
implements GeoJsfMonitoringStationRestExport,
GeoJsfMonitoringStationRestImport {
    static final Logger logger = LoggerFactory.getLogger(GeoJsfMonitoringStationRest.class);
    private final Class<STATION> cStation;
    private final Class<CAP> cCap;
    private final Class<CAPT> cCapT;
    private final Class<CAPS> cCapS;
    private EjbStationFactory<L, D, STATION, CAP, CAPT, CAPS> efStation;

    public GeoJsfMonitoringStationRest(UtilsFacade fUtils, String[] defaultLangs, Class<L> cL, Class<D> cD, Class<STATION> cStation, Class<CAP> cCap, Class<CAPT> cCapT, Class<CAPS> cCapS) {
        super(fUtils, defaultLangs, cL, cD);
        this.cStation = cStation;
        this.cCap = cCap;
        this.cCapT = cCapT;
        this.cCapS = cCapS;
        this.efStation = EjbStationFactory.factory(cL, cD, cStation);
    }

    public static <L extends UtilsLang, D extends UtilsDescription, STATION extends GeoStation<L, D, STATION, CAP, CAPT, CAPS>, CAP extends GeoStationCapability<L, D, STATION, CAP, CAPT, CAPS>, CAPT extends UtilsStatus<CAPT, L, D>, CAPS extends UtilsStatus<CAPS, L, D>> GeoJsfMonitoringStationRest<L, D, STATION, CAP, CAPT, CAPS> factory(UtilsFacade fGeoMonitoring, String[] defaultLangs, Class<L> cL, Class<D> cD, Class<STATION> cStation, Class<CAP> cCap, Class<CAPT> cCapT, Class<CAPS> cCapS) {
        return new GeoJsfMonitoringStationRest<L, D, STATION, CAP, CAPT, CAPS>(fGeoMonitoring, defaultLangs, cL, cD, cStation, cCap, cCapT, cCapS);
    }

    public DataUpdate importGeoJsfMonitoringCapabilityTypes(Aht types) {
        return this.importStatus(this.cCapT, null, types);
    }

    public DataUpdate importGeoJsfMonitoringCapabilityStatus(Aht statuses) {
        return this.importStatus(this.cCapS, null, statuses);
    }

    public DataUpdate importGeoJsfMonitoringStations(Stations stations) {
        DataUpdateTracker dut = new DataUpdateTracker(true);
        dut.setType(XmlTypeFactory.build((String)this.cStation.getName(), (String)"DB Import"));
        for (Station station : stations.getStation()) {
            GeoStation ejb;
            try {
                ejb = (GeoStation)this.fUtils.fByCode(this.cStation, station.getCode());
                dut.success();
            }
            catch (UtilsNotFoundException e) {
                try {
                    ArrayList capabilities = new ArrayList();
                    ejb = this.efStation.build(station, capabilities);
                    ejb = (GeoStation)this.fUtils.persist((Object)ejb);
                    this.efLang.persistMissingLangs(this.fUtils, this.defaultLangs, (EjbWithLang)ejb);
                    this.efDescription.persistMissingLangs(this.fUtils, this.defaultLangs, (EjbWithDescription)ejb);
                    dut.success();
                }
                catch (UtilsConstraintViolationException e1) {
                    dut.fail((Throwable)e1, true);
                }
            }
        }
        return dut.toDataUpdate();
    }

    public Aht exportGeoJsfMonitoringCapabilityTypes() {
        return this.exportStatus(this.cCapT);
    }

    public Aht exportGeoJsfMonitoringCapabilityStatus() {
        return this.exportStatus(this.cCapS);
    }

    public Stations exportGeoJsfMonitoringStations() {
        return null;
    }
}

