/*
 * Decompiled with CFR 0.152.
 */
package org.geojsf.interfaces.rest;

import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;

@Path(value="/rest")
public interface GeoServerRestInterface {
    @GET
    @Path(value="/styles")
    @Produces(value={"application/xml"})
    public String styles();

    @GET
    @Path(value="/workspaces/{workspace}/styles")
    @Produces(value={"application/xml"})
    public String styles(@PathParam(value="workspace") String var1);

    @GET
    @Path(value="/styles/{style}.sld")
    @Produces(value={"application/xml"})
    public String style(@PathParam(value="style") String var1);

    @GET
    @Path(value="/workspaces/{workspace}/styles/{style}.sld")
    @Produces(value={"application/xml"})
    public String style(@PathParam(value="workspace") String var1, @PathParam(value="style") String var2);

    @DELETE
    @Path(value="/workspaces/{workspace}/styles/{code}.sld")
    @Produces(value={"application/xml"})
    public String delete(@PathParam(value="workspace") String var1, @PathParam(value="code") String var2, @QueryParam(value="purge") boolean var3);

    @DELETE
    @Path(value="/styles/{code}.sld")
    @Produces(value={"application/xml"})
    public String delete(@PathParam(value="code") String var1, @HeaderParam(value="purge") boolean var2);

    @POST
    @Path(value="/workspaces/{workspace}/styles.sld")
    @Produces(value={"application/xml"})
    @Consumes(value={"application/vnd.ogc.sld+xml"})
    public String createStyle(@PathParam(value="workspace") String var1, String var2);

    @GET
    @Path(value="/workspaces")
    @Produces(value={"application/xml"})
    public String workspaces();

    @GET
    @Path(value="/workspaces/{workspace}.xml")
    @Produces(value={"application/xml"})
    public String workspace(@PathParam(value="workspace") String var1);

    @POST
    @Path(value="/workspaces.xml")
    @Produces(value={"application/xml"})
    @Consumes(value={"application/xml"})
    public String createWorkspace(String var1);

    @GET
    @Path(value="/namespaces")
    @Produces(value={"application/xml"})
    public String namespaces();

    @GET
    @Path(value="/namespaces/{workspace}.xml")
    @Produces(value={"application/xml"})
    public String namespace(@PathParam(value="workspace") String var1);

    @POST
    @Path(value="/namespaces.xml")
    @Produces(value={"application/xml"})
    @Consumes(value={"application/xml"})
    public String createNamespace(String var1);

    @GET
    @Path(value="/workspaces/{workspace}/datastores")
    @Produces(value={"application/xml"})
    public String dataStores(@PathParam(value="workspace") String var1);

    @GET
    @Path(value="/workspaces/{workspace}/datastores/{datastore}.xml")
    @Produces(value={"application/xml"})
    public String dataStore(@PathParam(value="workspace") String var1, @PathParam(value="datastore") String var2);

    @POST
    @Path(value="/workspaces/{workspace}/datastores.xml")
    @Produces(value={"application/xml"})
    @Consumes(value={"application/xml"})
    public String createDatastore(@PathParam(value="workspace") String var1, String var2);

    @GET
    @Path(value="/workspaces/{workspace}/coveragestores")
    @Produces(value={"application/xml"})
    public String coverageStores(@PathParam(value="workspace") String var1);

    @GET
    @Path(value="/workspaces/{workspace}/coveragestores/{coveragestore}.xml")
    @Produces(value={"application/xml"})
    public String coverageStore(@PathParam(value="workspace") String var1, @PathParam(value="coveragestore") String var2);

    @POST
    @Path(value="/workspaces/{workspace}/coveragestores.xml")
    @Produces(value={"application/xml"})
    @Consumes(value={"application/xml"})
    public String createCoverageStore(@PathParam(value="workspace") String var1, String var2);

    @GET
    @Path(value="/workspaces/{workspace}/coveragestores/{coveragestore}/coverages.xml")
    @Produces(value={"application/xml"})
    public String coverages(@PathParam(value="workspace") String var1, @PathParam(value="coveragestore") String var2);

    @GET
    @Path(value="/workspaces/{workspace}/coveragestores/{coveragestore}/coverages/{coverage}.xml")
    @Produces(value={"application/xml"})
    public String coverage(@PathParam(value="workspace") String var1, @PathParam(value="coveragestore") String var2, @PathParam(value="coverage") String var3);

    @POST
    @Path(value="/workspaces/{workspace}/coveragestores/{coveragestore}/coverages.xml")
    @Produces(value={"application/xml"})
    @Consumes(value={"application/xml"})
    public String createCoverage(@PathParam(value="workspace") String var1, @PathParam(value="coveragestore") String var2, String var3);

    @GET
    @Path(value="/layers")
    @Produces(value={"application/xml"})
    public String getLayers();

    @GET
    @Path(value="/layers/{layer}.xml")
    @Produces(value={"application/xml"})
    @Consumes(value={"application/xml"})
    public String layer(@PathParam(value="layer") String var1);

    @PUT
    @Path(value="/layers/{layer}.xml")
    @Produces(value={"application/xml"})
    @Consumes(value={"application/xml"})
    public String updatelayer(@PathParam(value="layer") String var1, String var2);

    @GET
    @Path(value="/workspaces/{workspace}/datastores/{datastore}/featuretypes.xml")
    @Produces(value={"application/xml"})
    public String featureTypes(@PathParam(value="workspace") String var1, @PathParam(value="datastore") String var2);

    @GET
    @Path(value="/workspaces/{workspace}/datastores/{datastore}/featuretypes/{featuretype}.xml")
    @Produces(value={"application/xml"})
    public String featureType(@PathParam(value="workspace") String var1, @PathParam(value="datastore") String var2, @PathParam(value="featuretype") String var3);

    @POST
    @Path(value="/workspaces/{workspace}/datastores/{datastore}/featuretypes.xml")
    @Produces(value={"application/xml"})
    @Consumes(value={"application/xml"})
    public String createFeatureType(@PathParam(value="workspace") String var1, @PathParam(value="datastore") String var2, String var3);
}

