/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.cqengine;

import com.googlecode.cqengine.ConcurrentIndexedCollection;
import com.googlecode.cqengine.persistence.Persistence;
import com.googlecode.cqengine.persistence.onheap.OnHeapPersistence;
import com.googlecode.cqengine.persistence.support.ObjectStore;
import com.googlecode.cqengine.query.Query;
import com.googlecode.cqengine.query.QueryFactory;
import com.googlecode.cqengine.query.option.ArgumentValidationOption;
import com.googlecode.cqengine.query.option.FlagsEnabled;
import com.googlecode.cqengine.query.option.IsolationLevel;
import com.googlecode.cqengine.query.option.IsolationOption;
import com.googlecode.cqengine.query.option.QueryOptions;
import com.googlecode.cqengine.resultset.ResultSet;
import com.googlecode.cqengine.resultset.closeable.CloseableFilteringResultSet;
import com.googlecode.cqengine.resultset.closeable.CloseableResultSet;
import com.googlecode.cqengine.resultset.iterator.IteratorUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class TransactionalIndexedCollection<O>
extends ConcurrentIndexedCollection<O> {
    public static final String STRICT_REPLACEMENT = "STRICT_REPLACEMENT";
    final Class<O> objectType;
    volatile Version currentVersion;
    final Object writeMutex = new Object();
    final AtomicLong versionNumberGenerator = new AtomicLong();

    public TransactionalIndexedCollection(Class<O> objectType) {
        this(objectType, OnHeapPersistence.withoutPrimaryKey());
    }

    public <A extends Comparable<A>> TransactionalIndexedCollection(Class<O> objectType, Persistence<O, A> persistence) {
        super(persistence);
        this.objectType = objectType;
        this.currentVersion = new Version(Collections.emptySet());
    }

    void incrementVersion(Iterable<O> objectsToExcludeFromNextVersion) {
        Version previousVersion = this.currentVersion;
        this.currentVersion = new Version(objectsToExcludeFromNextVersion);
        previousVersion.lock.writeLock().lock();
    }

    Version acquireReadLockForCurrentVersion() {
        Version currentVersion;
        do {
            currentVersion = this.currentVersion;
        } while (!currentVersion.lock.readLock().tryLock());
        return currentVersion;
    }

    @Override
    public boolean update(Iterable<O> objectsToRemove, Iterable<O> objectsToAdd) {
        return this.update(objectsToRemove, objectsToAdd, QueryFactory.noQueryOptions());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean update(Iterable<O> objectsToRemove, Iterable<O> objectsToAdd, QueryOptions queryOptions) {
        if (IsolationOption.isIsolationLevel(queryOptions, IsolationLevel.READ_UNCOMMITTED)) {
            return super.update(objectsToRemove, objectsToAdd, queryOptions);
        }
        if (!ArgumentValidationOption.isSkip(queryOptions)) {
            TransactionalIndexedCollection.ensureUpdateSetsAreDisjoint(objectsToRemove, objectsToAdd);
        }
        Object object = this.writeMutex;
        synchronized (object) {
            queryOptions = this.openRequestScopeResourcesIfNecessary(queryOptions);
            try {
                Iterator<O> objectsToRemoveIterator = objectsToRemove.iterator();
                Iterator<O> objectsToAddIterator = objectsToAdd.iterator();
                if (!objectsToRemoveIterator.hasNext() && !objectsToAddIterator.hasNext()) {
                    boolean bl = false;
                    return bl;
                }
                if (FlagsEnabled.isFlagEnabled(queryOptions, STRICT_REPLACEMENT) && !TransactionalIndexedCollection.objectStoreContainsAllIterable(this.objectStore, objectsToRemove, queryOptions)) {
                    boolean bl = false;
                    return bl;
                }
                boolean modified = false;
                if (objectsToAddIterator.hasNext()) {
                    this.incrementVersion(objectsToAdd);
                    modified = this.doAddAll(objectsToAdd, queryOptions);
                }
                if (objectsToRemoveIterator.hasNext()) {
                    this.incrementVersion(objectsToRemove);
                    modified = this.doRemoveAll(objectsToRemove, queryOptions) || modified;
                }
                this.incrementVersion(Collections.emptySet());
                boolean bl = modified;
                return bl;
            }
            finally {
                this.closeRequestScopeResourcesIfNecessary(queryOptions);
            }
        }
    }

    @Override
    public boolean add(O o) {
        return this.update(Collections.emptySet(), Collections.singleton(o));
    }

    @Override
    public boolean remove(Object object) {
        return this.update(Collections.singleton(object), Collections.emptySet());
    }

    @Override
    public boolean addAll(Collection<? extends O> c) {
        return this.update(Collections.emptySet(), c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.update(c, Collections.emptySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean retainAll(Collection<?> c) {
        Object object = this.writeMutex;
        synchronized (object) {
            QueryOptions queryOptions = this.openRequestScopeResourcesIfNecessary(null);
            try {
                HashSet objectsToRetain = new HashSet(c.size());
                for (Object object2 : c) {
                    if (object2 == null) continue;
                    Object o = object2;
                    objectsToRetain.add(o);
                }
                ResultSet objectsToRemove = super.retrieve(QueryFactory.not(QueryFactory.in(QueryFactory.selfAttribute(this.objectType), objectsToRetain)), queryOptions);
                Iterator objectsToRemoveIterator = objectsToRemove.iterator();
                if (!objectsToRemoveIterator.hasNext()) {
                    boolean o = false;
                    return o;
                }
                this.incrementVersion(objectsToRemove);
                boolean modified = this.doRemoveAll(objectsToRemove, queryOptions);
                this.incrementVersion(Collections.emptySet());
                boolean bl = modified;
                return bl;
            }
            finally {
                this.closeRequestScopeResourcesIfNecessary(queryOptions);
            }
        }
    }

    @Override
    public synchronized void clear() {
        this.retainAll(Collections.emptySet());
    }

    @Override
    public ResultSet<O> retrieve(Query<O> query) {
        return this.retrieve(query, QueryFactory.noQueryOptions());
    }

    @Override
    public ResultSet<O> retrieve(Query<O> query, QueryOptions queryOptions) {
        if (IsolationOption.isIsolationLevel(queryOptions, IsolationLevel.READ_UNCOMMITTED)) {
            return super.retrieve(query, queryOptions);
        }
        final Version thisVersion = this.acquireReadLockForCurrentVersion();
        ResultSet<O> results = super.retrieve(query, queryOptions);
        CloseableResultSet versionReadingResultSet = new CloseableResultSet<O>(results, query, queryOptions){

            @Override
            public void close() {
                super.close();
                thisVersion.lock.readLock().unlock();
            }
        };
        if (thisVersion.objectsToExclude.iterator().hasNext()) {
            return new CloseableFilteringResultSet<O>(versionReadingResultSet, query, queryOptions){

                @Override
                public boolean isValid(O object, QueryOptions queryOptions) {
                    Iterable objectsToExclude = thisVersion.objectsToExclude;
                    return !TransactionalIndexedCollection.iterableContains(objectsToExclude, object);
                }
            };
        }
        return versionReadingResultSet;
    }

    static <O> boolean iterableContains(Iterable<O> objects, O o) {
        if (objects instanceof Collection) {
            return ((Collection)objects).contains(o);
        }
        if (objects instanceof ResultSet) {
            return ((ResultSet)objects).contains(o);
        }
        return IteratorUtil.iterableContains(objects, o);
    }

    static <O> boolean objectStoreContainsAllIterable(ObjectStore<O> objectStore, Iterable<O> candidates, QueryOptions queryOptions) {
        if (candidates instanceof Collection) {
            return objectStore.containsAll((Collection)candidates, queryOptions);
        }
        for (O candidate : candidates) {
            if (objectStore.contains(candidate, queryOptions)) continue;
            return false;
        }
        return true;
    }

    static <O> void ensureUpdateSetsAreDisjoint(Iterable<O> objectsToRemove, Iterable<O> objectsToAdd) {
        for (O objectToRemove : objectsToRemove) {
            if (!TransactionalIndexedCollection.iterableContains(objectsToAdd, objectToRemove)) continue;
            throw new IllegalArgumentException("The sets of objectsToRemove and objectsToAdd are not disjoint [for all objectsToRemove, objectToRemove.equals(objectToAdd) must return false].");
        }
    }

    class Version {
        final ReadWriteLock lock = new ReentrantReadWriteLock();
        final Iterable<O> objectsToExclude;
        final long versionNumber;

        Version(Iterable<O> objectsToExclude) {
            this.versionNumber = TransactionalIndexedCollection.this.versionNumberGenerator.incrementAndGet();
            this.objectsToExclude = objectsToExclude;
        }
    }
}

