/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.cqengine.persistence.composite;

import com.googlecode.cqengine.attribute.SimpleAttribute;
import com.googlecode.cqengine.index.Index;
import com.googlecode.cqengine.index.sqlite.ConnectionManager;
import com.googlecode.cqengine.index.sqlite.RequestScopeConnectionManager;
import com.googlecode.cqengine.persistence.Persistence;
import com.googlecode.cqengine.persistence.support.ObjectStore;
import com.googlecode.cqengine.query.option.QueryOptions;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class CompositePersistence<O, A extends Comparable<A>>
implements Persistence<O, A> {
    final Persistence<O, A> primaryPersistence;
    final Persistence<O, A> secondaryPersistence;
    final List<? extends Persistence<O, A>> additionalPersistences;
    final ConcurrentMap<Index<O>, Persistence<O, A>> indexPersistences = new ConcurrentHashMap<Index<O>, Persistence<O, A>>(1, 1.0f, 1);

    public CompositePersistence(Persistence<O, A> primaryPersistence, Persistence<O, A> secondaryPersistence, List<? extends Persistence<O, A>> additionalPersistences) {
        CompositePersistence.validatePersistenceArguments(primaryPersistence, secondaryPersistence, additionalPersistences);
        this.primaryPersistence = primaryPersistence;
        this.secondaryPersistence = secondaryPersistence;
        this.additionalPersistences = additionalPersistences;
    }

    @Override
    public SimpleAttribute<O, A> getPrimaryKeyAttribute() {
        return this.primaryPersistence.getPrimaryKeyAttribute();
    }

    @Override
    public boolean supportsIndex(Index<O> index) {
        Persistence<O, A> persistence = this.getPersistenceForIndexOrNullWithCaching(index);
        return persistence != null;
    }

    public Persistence<O, A> getPersistenceForIndex(Index<O> index) {
        Persistence<O, A> persistence = this.getPersistenceForIndexOrNullWithCaching(index);
        if (persistence == null) {
            throw new IllegalStateException("No persistence is configured for index: " + index);
        }
        return persistence;
    }

    @Override
    public ObjectStore<O> createObjectStore() {
        return this.primaryPersistence.createObjectStore();
    }

    Persistence<O, A> getPersistenceForIndexOrNullWithCaching(Index<O> index) {
        Persistence<O, A> existing;
        Persistence<O, A> persistence = (Persistence<O, A>)this.indexPersistences.get(index);
        if (persistence == null && (persistence = this.getPersistenceForIndexOrNull(index)) != null && (existing = this.indexPersistences.putIfAbsent(index, persistence)) != null) {
            persistence = existing;
        }
        return persistence;
    }

    Persistence<O, A> getPersistenceForIndexOrNull(Index<O> index) {
        if (this.primaryPersistence.supportsIndex(index)) {
            return this.primaryPersistence;
        }
        if (this.secondaryPersistence.supportsIndex(index)) {
            return this.secondaryPersistence;
        }
        for (Persistence<O, A> additionalPersistence : this.additionalPersistences) {
            if (!additionalPersistence.supportsIndex(index)) continue;
            return additionalPersistence;
        }
        return null;
    }

    public Persistence<O, A> getPrimaryPersistence() {
        return this.primaryPersistence;
    }

    public Persistence<O, A> getSecondaryPersistence() {
        return this.secondaryPersistence;
    }

    public List<? extends Persistence<O, A>> getAdditionalPersistences() {
        return this.additionalPersistences;
    }

    static <O, A extends Comparable<A>> void validatePersistenceArguments(Persistence<O, A> primaryPersistence, Persistence<O, A> secondaryPersistence, List<? extends Persistence<O, A>> additionalPersistences) {
        SimpleAttribute<O, A> primaryKeyAttribute = CompositePersistence.validatePersistenceArgument(primaryPersistence, null);
        primaryKeyAttribute = CompositePersistence.validatePersistenceArgument(secondaryPersistence, primaryKeyAttribute);
        for (Persistence<O, A> additionalPersistence : additionalPersistences) {
            CompositePersistence.validatePersistenceArgument(additionalPersistence, primaryKeyAttribute);
        }
    }

    static <O, A extends Comparable<A>> SimpleAttribute<O, A> validatePersistenceArgument(Persistence<O, A> persistence, SimpleAttribute<O, A> primaryKeyAttribute) {
        if (persistence == null) {
            throw new NullPointerException("The Persistence argument cannot be null.");
        }
        if (persistence.getPrimaryKeyAttribute() == null) {
            throw new IllegalArgumentException("All Persistence implementations in a CompositePersistence must have a primary key.");
        }
        if (primaryKeyAttribute == null) {
            primaryKeyAttribute = persistence.getPrimaryKeyAttribute();
        } else if (!primaryKeyAttribute.equals(persistence.getPrimaryKeyAttribute())) {
            throw new IllegalArgumentException("All Persistence implementations must be on the same primary key.");
        }
        return primaryKeyAttribute;
    }

    @Override
    public void openRequestScopeResources(QueryOptions queryOptions) {
        if (queryOptions.get(ConnectionManager.class) == null) {
            queryOptions.put(ConnectionManager.class, new RequestScopeConnectionManager(this));
        }
    }

    @Override
    public void closeRequestScopeResources(QueryOptions queryOptions) {
        ConnectionManager connectionManager = queryOptions.get(ConnectionManager.class);
        if (connectionManager instanceof RequestScopeConnectionManager) {
            ((RequestScopeConnectionManager)connectionManager).close();
            queryOptions.remove(ConnectionManager.class);
        }
    }

    public static <O, A extends Comparable<A>> CompositePersistence<O, A> of(Persistence<O, A> primaryPersistence, Persistence<O, A> secondaryPersistence, List<? extends Persistence<O, A>> additionalPersistences) {
        return new CompositePersistence<O, A>(primaryPersistence, secondaryPersistence, additionalPersistences);
    }

    public static <O, A extends Comparable<A>> CompositePersistence<O, A> of(Persistence<O, A> primaryPersistence, Persistence<O, A> secondaryPersistence) {
        return new CompositePersistence<O, A>(primaryPersistence, secondaryPersistence, Collections.emptyList());
    }
}

