/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.kafka;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.RemovalCause;
import com.github.benmanes.caffeine.cache.RemovalListener;
import com.github.benmanes.caffeine.cache.Ticker;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import com.vividsolutions.jts.geom.Envelope;
import java.util.concurrent.TimeUnit;
import org.geotools.data.FeatureReader;
import org.geotools.data.collection.DelegateFeatureReader;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.collection.DelegateFeatureIterator;
import org.locationtech.geomesa.kafka.CreateOrUpdate;
import org.locationtech.geomesa.kafka.Delete;
import org.locationtech.geomesa.kafka.FeatureHolder;
import org.locationtech.geomesa.kafka.LiveFeatureCache;
import org.locationtech.geomesa.kafka.LiveFeatureCacheCQEngine$;
import org.locationtech.geomesa.memory.cqengine.GeoCQEngine;
import org.locationtech.geomesa.memory.cqengine.GeoCQEngine$;
import org.locationtech.geomesa.utils.collection.SelfClosingIterator$;
import org.locationtech.geomesa.utils.geotools.Conversions;
import org.locationtech.geomesa.utils.geotools.Conversions$;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.Id;
import org.opengis.filter.IncludeFilter;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.GenSetLike;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.JavaConversions$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.mutable.Map;
import scala.collection.mutable.Set$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00055e\u0001B\u0001\u0003\u0001-\u0011\u0001\u0004T5wK\u001a+\u0017\r^;sK\u000e\u000b7\r[3D#\u0016sw-\u001b8f\u0015\t\u0019A!A\u0003lC\u001a\\\u0017M\u0003\u0002\u0006\r\u00059q-Z8nKN\f'BA\u0004\t\u00031awnY1uS>tG/Z2i\u0015\u0005I\u0011aA8sO\u000e\u00011\u0003\u0002\u0001\r%Y\u0001\"!\u0004\t\u000e\u00039Q\u0011aD\u0001\u0006g\u000e\fG.Y\u0005\u0003#9\u0011a!\u00118z%\u00164\u0007CA\n\u0015\u001b\u0005\u0011\u0011BA\u000b\u0003\u0005Aa\u0015N^3GK\u0006$XO]3DC\u000eDW\r\u0005\u0002\u0018=5\t\u0001D\u0003\u0002\u001a5\u0005a1oY1mC2|wmZ5oO*\u00111\u0004H\u0001\tif\u0004Xm]1gK*\tQ$A\u0002d_6L!a\b\r\u0003\u00171\u000b'0\u001f'pO\u001eLgn\u001a\u0005\tC\u0001\u0011\t\u0011)A\u0005E\u0005\u00191O\u001a;\u0011\u0005\rRS\"\u0001\u0013\u000b\u0005\u00152\u0013AB:j[BdWM\u0003\u0002(Q\u00059a-Z1ukJ,'BA\u0015\t\u0003\u001dy\u0007/\u001a8hSNL!a\u000b\u0013\u0003#MKW\u000e\u001d7f\r\u0016\fG/\u001e:f)f\u0004X\r\u0003\u0005.\u0001\t\u0005\t\u0015!\u0003/\u0003A)\u0007\u0010]5sCRLwN\u001c)fe&|G\rE\u0002\u000e_EJ!\u0001\r\b\u0003\r=\u0003H/[8o!\ti!'\u0003\u00024\u001d\t!Aj\u001c8h\u0011!)\u0004A!A!\u0002\u00171\u0014A\u0002;jG.,'\u000f\u0005\u00028\u00016\t\u0001H\u0003\u0002:u\u0005)1-Y2iK*\u00111\bP\u0001\tG\u00064g-Z5oK*\u0011QHP\u0001\tE\u0016tW.\u00198fg*\u0011q\bH\u0001\u0007O&$\b.\u001e2\n\u0005\u0005C$A\u0002+jG.,'\u000fC\u0003D\u0001\u0011\u0005A)\u0001\u0004=S:LGO\u0010\u000b\u0004\u000b\"KEC\u0001$H!\t\u0019\u0002\u0001C\u00036\u0005\u0002\u000fa\u0007C\u0003\"\u0005\u0002\u0007!\u0005C\u0003.\u0005\u0002\u0007a\u0006C\u0004L\u0001\t\u0007I\u0011\u0001'\u0002\u000b\u001d,wnY9\u0016\u00035\u0003\"AT*\u000e\u0003=S!\u0001U)\u0002\u0011\r\fXM\\4j]\u0016T!A\u0015\u0003\u0002\r5,Wn\u001c:z\u0013\t!vJA\u0006HK>\u001c\u0015+\u00128hS:,\u0007B\u0002,\u0001A\u0003%Q*\u0001\u0004hK>\u001c\u0017\u000f\t\u0005\bs\u0001\u0011\r\u0011\"\u0003Y+\u0005I\u0006\u0003B\u001c[9\u000eL!a\u0017\u001d\u0003\u000b\r\u000b7\r[3\u0011\u0005u\u0003gBA\u0007_\u0013\tyf\"\u0001\u0004Qe\u0016$WMZ\u0005\u0003C\n\u0014aa\u0015;sS:<'BA0\u000f!\t\u0019B-\u0003\u0002f\u0005\tia)Z1ukJ,\u0007j\u001c7eKJDaa\u001a\u0001!\u0002\u0013I\u0016AB2bG\",\u0007\u0005C\u0004j\u0001\t\u0007I\u0011\u00016\u0002\u0011\u0019,\u0017\r^;sKN,\u0012a\u001b\t\u0005YFd6-D\u0001n\u0015\tqw.A\u0004nkR\f'\r\\3\u000b\u0005At\u0011AC2pY2,7\r^5p]&\u0011!/\u001c\u0002\u0004\u001b\u0006\u0004\bB\u0002;\u0001A\u0003%1.A\u0005gK\u0006$XO]3tA!)a\u000f\u0001C\u0001o\u0006!1/\u001b>f)\u0005A\bCA\u0007z\u0013\tQhBA\u0002J]RDQA\u001e\u0001\u0005\u0002q$\"\u0001_?\t\u000by\\\b\u0019A@\u0002\u0003\u0019\u0004B!!\u0001\u0002\b5\u0011\u00111\u0001\u0006\u0004\u0003\u000bA\u0013A\u00024jYR,'/\u0003\u0003\u0002\n\u0005\r!A\u0002$jYR,'\u000fC\u0004\u0002\u000e\u0001!\t%a\u0004\u0002\u000f\rdW-\u00198VaR\u0011\u0011\u0011\u0003\t\u0004\u001b\u0005M\u0011bAA\u000b\u001d\t!QK\\5u\u0011\u001d\tI\u0002\u0001C!\u00037\tQc\u0019:fCR,wJ]+qI\u0006$XMR3biV\u0014X\r\u0006\u0003\u0002\u0012\u0005u\u0001\u0002CA\u0010\u0003/\u0001\r!!\t\u0002\rU\u0004H-\u0019;f!\r\u0019\u00121E\u0005\u0004\u0003K\u0011!AD\"sK\u0006$Xm\u0014:Va\u0012\fG/\u001a\u0005\b\u0003S\u0001A\u0011IA\u0016\u000399W\r\u001e$fCR,(/\u001a\"z\u0013\u0012$2aYA\u0017\u0011\u001d\ty#a\nA\u0002q\u000b!!\u001b3\t\u000f\u0005M\u0002\u0001\"\u0011\u00026\u0005i!/Z7pm\u00164U-\u0019;ve\u0016$B!!\u0005\u00028!A\u0011\u0011HA\u0019\u0001\u0004\tY$\u0001\u0005u_\u0012+G.\u001a;f!\r\u0019\u0012QH\u0005\u0004\u0003\u007f\u0011!A\u0002#fY\u0016$X\rC\u0004\u0002D\u0001!\t%a\u0004\u0002\u000b\rdW-\u0019:\t\u000f\u0005\u001d\u0003\u0001\"\u0001\u0002J\u0005\u0011r-\u001a;SK\u0006$WM\u001d$pe\u001aKG\u000e^3s)\u0011\tY%a\u001f\u0011\t\u00055\u0013Q\u000f\b\u0005\u0003\u001f\nyG\u0004\u0003\u0002R\u0005%d\u0002BA*\u0003KrA!!\u0016\u0002d9!\u0011qKA1\u001d\u0011\tI&a\u0018\u000e\u0005\u0005m#bAA/\u0015\u00051AH]8pizJ\u0011!C\u0005\u0003\u000f!I!!\u0002\u0004\n\u0007\u0005\u001dD!A\u0003vi&d7/\u0003\u0003\u0002l\u00055\u0014\u0001C4f_R|w\u000e\\:\u000b\u0007\u0005\u001dD!\u0003\u0003\u0002r\u0005M\u0014a\u00029bG.\fw-\u001a\u0006\u0005\u0003W\ni'\u0003\u0003\u0002x\u0005e$A\u0001$S\u0015\u0011\t\t(a\u001d\t\u000f\u0005\u0015\u0011Q\ta\u0001\u007f\"9\u0011q\u0010\u0001\u0005\u0002\u0005\u0005\u0015a\u00014jIR!\u00111JAB\u0011!\t))! A\u0002\u0005\u001d\u0015aA5egB!\u0011\u0011AAE\u0013\u0011\tY)a\u0001\u0003\u0005%#\u0007")
public class LiveFeatureCacheCQEngine
implements LiveFeatureCache,
LazyLogging {
    private final SimpleFeatureType sft;
    private final GeoCQEngine geocq;
    private final Cache<String, FeatureHolder> cache;
    private final Map<String, FeatureHolder> features;
    private final Logger logger;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        LiveFeatureCacheCQEngine liveFeatureCacheCQEngine = this;
        synchronized (liveFeatureCacheCQEngine) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public GeoCQEngine geocq() {
        return this.geocq;
    }

    private Cache<String, FeatureHolder> cache() {
        return this.cache;
    }

    public Map<String, FeatureHolder> features() {
        return this.features;
    }

    @Override
    public int size() {
        return this.features().size();
    }

    @Override
    public int size(Filter f) {
        Filter filter = f;
        IncludeFilter includeFilter = Filter.INCLUDE;
        return !(filter != null ? !filter.equals(includeFilter) : includeFilter != null) ? this.features().size() : SelfClosingIterator$.MODULE$.apply(this.getReaderForFilter(f)).length();
    }

    @Override
    public void cleanUp() {
        this.cache().cleanUp();
    }

    @Override
    public void createOrUpdateFeature(CreateOrUpdate update) {
        SimpleFeature sf = update.feature();
        String id = sf.getID();
        FeatureHolder old = (FeatureHolder)this.cache().getIfPresent((Object)id);
        Object object = old == null ? BoxedUnit.UNIT : BoxesRunTime.boxToBoolean((boolean)this.geocq().remove(old.sf()));
        Envelope env = Conversions.RichSimpleFeature$.MODULE$.geometry$extension(Conversions$.MODULE$.RichSimpleFeature(sf)).getEnvelopeInternal();
        this.geocq().add(sf);
        this.cache().put((Object)id, (Object)new FeatureHolder(sf, env));
    }

    @Override
    public FeatureHolder getFeatureById(String id) {
        return (FeatureHolder)this.cache().getIfPresent((Object)id);
    }

    @Override
    public void removeFeature(Delete toDelete) {
        String id = toDelete.id();
        FeatureHolder old = (FeatureHolder)this.cache().getIfPresent((Object)id);
        if (old != null) {
            this.geocq().remove(old.sf());
            this.cache().invalidate((Object)id);
        }
    }

    @Override
    public void clear() {
        this.cache().invalidateAll();
        this.geocq().clear();
    }

    @Override
    public FeatureReader<SimpleFeatureType, SimpleFeature> getReaderForFilter(Filter filter) {
        FeatureReader<SimpleFeatureType, SimpleFeature> featureReader;
        Filter filter2 = filter;
        if (filter2 instanceof Id) {
            Id id = (Id)filter2;
            featureReader = this.fid(id);
        } else {
            featureReader = this.geocq().getReaderForFilter(filter2);
        }
        return featureReader;
    }

    public FeatureReader<SimpleFeatureType, SimpleFeature> fid(Id ids) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Queried for IDs; using Guava ID index");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Iterator iter = ((GenSetLike)JavaConversions$.MODULE$.asScalaSet(ids.getIDs()).flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LiveFeatureCacheCQEngine $outer;

            public final Iterable<SimpleFeature> apply(Object id) {
                return Option$.MODULE$.option2Iterable(this.$outer.features().get((Object)id.toString()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final SimpleFeature apply(FeatureHolder x$1) {
                        return x$1.sf();
                    }
                }));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Set$.MODULE$.canBuildFrom())).iterator();
        return new DelegateFeatureReader((FeatureType)this.sft, (FeatureIterator)new DelegateFeatureIterator(JavaConversions$.MODULE$.asJavaIterator(iter)));
    }

    public LiveFeatureCacheCQEngine(SimpleFeatureType sft, Option<Object> expirationPeriod, Ticker ticker) {
        this.sft = sft;
        LazyLogging.class.$init$((LazyLogging)this);
        this.geocq = new GeoCQEngine(sft, GeoCQEngine$.MODULE$.$lessinit$greater$default$2(), GeoCQEngine$.MODULE$.$lessinit$greater$default$3());
        Caffeine cb = Caffeine.newBuilder().ticker(ticker);
        expirationPeriod.foreach((Function1)new Serializable(this, cb){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LiveFeatureCacheCQEngine $outer;
            private final Caffeine cb$1;

            public final Caffeine<String, FeatureHolder> apply(long ep) {
                return this.cb$1.expireAfterWrite(ep, TimeUnit.MILLISECONDS).removalListener((RemovalListener)new RemovalListener<String, FeatureHolder>(this, ep){
                    private final /* synthetic */ $anonfun$1 $outer;
                    private final long ep$1;

                    public void onRemoval(String key, FeatureHolder value, RemovalCause cause) {
                        RemovalCause removalCause = cause;
                        RemovalCause removalCause2 = RemovalCause.EXPIRED;
                        if (!(removalCause != null ? !removalCause.equals(removalCause2) : removalCause2 != null)) {
                            BoxedUnit boxedUnit;
                            if (this.$outer.org$locationtech$geomesa$kafka$LiveFeatureCacheCQEngine$$anonfun$$$outer().logger().underlying().isDebugEnabled()) {
                                this.$outer.org$locationtech$geomesa$kafka$LiveFeatureCacheCQEngine$$anonfun$$$outer().logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Removing feature ", " due to expiration after ", "ms"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key, BoxesRunTime.boxToLong((long)this.ep$1)})));
                                boxedUnit = BoxedUnit.UNIT;
                            } else {
                                boxedUnit = BoxedUnit.UNIT;
                            }
                            this.$outer.org$locationtech$geomesa$kafka$LiveFeatureCacheCQEngine$$anonfun$$$outer().geocq().remove(value.sf());
                        }
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.ep$1 = ep$1;
                    }
                });
            }

            public /* synthetic */ LiveFeatureCacheCQEngine org$locationtech$geomesa$kafka$LiveFeatureCacheCQEngine$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.cb$1 = cb$1;
            }
        });
        this.cache = cb.build();
        this.features = (Map)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.cache().asMap()).asScala();
    }
}

