/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.filter;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import java.util.Date;
import org.geotools.data.DataUtilities;
import org.geotools.filter.spatial.BBOXImpl;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.locationtech.geomesa.filter.Bounds;
import org.locationtech.geomesa.filter.Bounds$;
import org.locationtech.geomesa.filter.FilterHelper$;
import org.locationtech.geomesa.filter.FilterHelper$FilterHelperLogger$;
import org.locationtech.geomesa.filter.FilterHelper$SpatialOpOrder$;
import org.locationtech.geomesa.filter.FilterValues;
import org.locationtech.geomesa.filter.FilterValues$;
import org.locationtech.geomesa.filter.PropertyLiteral;
import org.locationtech.geomesa.filter.package$;
import org.locationtech.geomesa.filter.visitor.IdDetectingFilterVisitor;
import org.locationtech.geomesa.utils.geohash.GeohashUtils$;
import org.locationtech.geomesa.utils.geotools.GeometryUtils$;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.And;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.Not;
import org.opengis.filter.Or;
import org.opengis.filter.PropertyIsBetween;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.PropertyIsGreaterThan;
import org.opengis.filter.PropertyIsGreaterThanOrEqualTo;
import org.opengis.filter.PropertyIsLessThan;
import org.opengis.filter.PropertyIsLessThanOrEqualTo;
import org.opengis.filter.PropertyIsLike;
import org.opengis.filter.PropertyIsNull;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.spatial.BinarySpatialOperator;
import org.opengis.filter.spatial.Contains;
import org.opengis.filter.spatial.DWithin;
import org.opengis.filter.spatial.Intersects;
import org.opengis.filter.spatial.Overlaps;
import org.opengis.filter.spatial.Within;
import org.opengis.filter.temporal.After;
import org.opengis.filter.temporal.Before;
import org.opengis.filter.temporal.During;
import org.opengis.filter.temporal.TEquals;
import org.opengis.temporal.Period;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.BufferLike;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Set$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

public final class FilterHelper$ {
    public static final FilterHelper$ MODULE$;
    private final DateTime MinDateTime;
    private final DateTime MaxDateTime;
    private final String SafeGeomString;

    static {
        new FilterHelper$();
    }

    public DateTime MinDateTime() {
        return this.MinDateTime;
    }

    public DateTime MaxDateTime() {
        return this.MaxDateTime;
    }

    private String SafeGeomString() {
        return this.SafeGeomString;
    }

    public Filter visitBinarySpatialOp(BinarySpatialOperator op, SimpleFeatureType sft) {
        BinarySpatialOperator binarySpatialOperator;
        PropertyLiteral prop = package$.MODULE$.checkOrderUnsafe(op.getExpression1(), op.getExpression2());
        Geometry geom = (Geometry)prop.literal().evaluate(null, Geometry.class);
        Object object = geom.getUserData();
        String string = this.SafeGeomString();
        if (!(object != null ? !object.equals(string) : string != null)) {
            binarySpatialOperator = op;
        } else {
            String attribute = (String)Option$.MODULE$.apply((Object)prop.name()).filterNot((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(String x$1) {
                    return x$1.isEmpty();
                }
            }).getOrElse((Function0)new Serializable(sft){
                public static final long serialVersionUID = 0L;
                private final SimpleFeatureType sft$1;

                public final String apply() {
                    return this.sft$1 == null ? null : RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getGeomField$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(this.sft$1));
                }
                {
                    this.sft$1 = sft$1;
                }
            });
            Geometry geomCopy = GeometryUtils$.MODULE$.geoFactory().createGeometry(geom);
            Geometry trimmedGeom = geomCopy.intersection((Geometry)org.locationtech.geomesa.utils.geotools.package$.MODULE$.WholeWorldPolygon());
            if (trimmedGeom.isEmpty()) {
                binarySpatialOperator = Filter.EXCLUDE;
            } else {
                Geometry geomWithWayPoints = op instanceof BBOX ? this.addWayPointsToBBOX(trimmedGeom) : trimmedGeom;
                Geometry safeGeometry = this.org$locationtech$geomesa$filter$FilterHelper$$tryGetIdlSafeGeom(geomWithWayPoints);
                safeGeometry.setUserData((Object)this.SafeGeomString());
                binarySpatialOperator = this.recreateAsIdlSafeFilter(op, attribute, safeGeometry, prop.flipped(), this.recreateAsIdlSafeFilter$default$5());
            }
        }
        return binarySpatialOperator;
    }

    public Filter visitDwithin(DWithin op, SimpleFeatureType sft) {
        DWithin dWithin;
        PropertyLiteral prop = package$.MODULE$.checkOrderUnsafe(op.getExpression1(), op.getExpression2());
        Geometry geom = (Geometry)prop.literal().evaluate(null, Geometry.class);
        Object object = geom.getUserData();
        String string = this.SafeGeomString();
        if (!(object != null ? !object.equals(string) : string != null)) {
            dWithin = op;
        } else {
            String units = (String)Option$.MODULE$.apply((Object)op.getDistanceUnits()).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(String x$2) {
                    return x$2.trim();
                }
            }).filter((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(String x$3) {
                    return new StringOps(Predef$.MODULE$.augmentString(x$3)).nonEmpty();
                }
            }).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(String x$4) {
                    return x$4.toLowerCase();
                }
            }).getOrElse((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "meters";
                }
            });
            String string2 = units;
            double d = "meters".equals(string2) ? 1.0 : ("kilometers".equals(string2) ? 1000.0 : ("feet".equals(string2) ? 0.3048 : ("statute miles".equals(string2) ? 1609.347 : ("nautical miles".equals(string2) ? 1852.0 : 1.0))));
            double multiplier = d;
            double distanceMeters = op.getDistance() * multiplier;
            double distanceDegrees = GeometryUtils$.MODULE$.distanceDegrees(geom, distanceMeters);
            String attribute = (String)Option$.MODULE$.apply((Object)prop.name()).filterNot((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(String x$5) {
                    return x$5.isEmpty();
                }
            }).getOrElse((Function0)new Serializable(sft){
                public static final long serialVersionUID = 0L;
                private final SimpleFeatureType sft$2;

                public final String apply() {
                    return this.sft$2 == null ? null : RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getGeomField$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(this.sft$2));
                }
                {
                    this.sft$2 = sft$2;
                }
            });
            Geometry geomCopy = GeometryUtils$.MODULE$.geoFactory().createGeometry(geom);
            Geometry trimmedGeom = geomCopy.intersection((Geometry)org.locationtech.geomesa.utils.geotools.package$.MODULE$.WholeWorldPolygon());
            Geometry safeGeometry = this.org$locationtech$geomesa$filter$FilterHelper$$tryGetIdlSafeGeom(trimmedGeom);
            safeGeometry.setUserData((Object)this.SafeGeomString());
            dWithin = this.recreateAsIdlSafeFilter((BinarySpatialOperator)op, attribute, safeGeometry, prop.flipped(), BoxesRunTime.boxToDouble((double)distanceDegrees));
        }
        return dWithin;
    }

    public Geometry org$locationtech$geomesa$filter$FilterHelper$$tryGetIdlSafeGeom(Geometry geom) {
        Try try_;
        block7: {
            Geometry geometry;
            block6: {
                BoxedUnit boxedUnit;
                block5: {
                    Geometry g;
                    try_ = GeohashUtils$.MODULE$.getInternationalDateLineSafeGeometry(geom);
                    if (!(try_ instanceof Success)) break block5;
                    Success success = (Success)try_;
                    geometry = g = (Geometry)success.value();
                    break block6;
                }
                if (!(try_ instanceof Failure)) break block7;
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                if (FilterHelper$FilterHelperLogger$.MODULE$.log().underlying().isWarnEnabled()) {
                    FilterHelper$FilterHelperLogger$.MODULE$.log().underlying().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error splitting geometry on IDL for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{geom})), e);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                geometry = geom;
            }
            return geometry;
        }
        throw new MatchError((Object)try_);
    }

    private Filter recreateAsIdlSafeFilter(BinarySpatialOperator op, String property, Geometry geom, boolean flipped, Object args) {
        Filter filter;
        Geometry geometry = geom;
        if (geometry instanceof GeometryCollection) {
            GeometryCollection geometryCollection = (GeometryCollection)geometry;
            Seq<Geometry> asList = this.getGeometryListOf((Geometry)geometryCollection);
            asList.foreach((Function1)new Serializable(geom){
                public static final long serialVersionUID = 0L;
                private final Geometry geom$1;

                public final void apply(Geometry x$6) {
                    x$6.setUserData(this.geom$1.getUserData());
                }
                {
                    this.geom$1 = geom$1;
                }
            });
            filter = package$.MODULE$.ff().or(JavaConversions$.MODULE$.seqAsJavaList((Seq)asList.map((Function1)new Serializable(op, property, flipped, args){
                public static final long serialVersionUID = 0L;
                private final BinarySpatialOperator op$1;
                private final String property$1;
                private final boolean flipped$1;
                private final Object args$1;

                public final Filter apply(Geometry x$7) {
                    return FilterHelper$.MODULE$.org$locationtech$geomesa$filter$FilterHelper$$recreateFilter(this.op$1, this.property$1, x$7, this.flipped$1, this.args$1);
                }
                {
                    this.op$1 = op$1;
                    this.property$1 = property$1;
                    this.flipped$1 = flipped$1;
                    this.args$1 = args$1;
                }
            }, Seq$.MODULE$.canBuildFrom())));
        } else {
            filter = this.org$locationtech$geomesa$filter$FilterHelper$$recreateFilter(op, property, geom, flipped, args);
        }
        return filter;
    }

    private Object recreateAsIdlSafeFilter$default$5() {
        return null;
    }

    public Filter org$locationtech$geomesa$filter$FilterHelper$$recreateFilter(BinarySpatialOperator op, String property, Geometry geom, boolean flipped, Object args) {
        Tuple2 tuple2;
        block2: {
            BinarySpatialOperator binarySpatialOperator;
            block9: {
                Within within;
                block4: {
                    Expression e2;
                    Expression e1;
                    block8: {
                        block7: {
                            block6: {
                                block5: {
                                    block3: {
                                        Tuple2 tuple22;
                                        Tuple2 tuple23 = tuple2 = flipped ? new Tuple2((Object)package$.MODULE$.ff().literal((Object)geom), (Object)package$.MODULE$.ff().property(property)) : new Tuple2((Object)package$.MODULE$.ff().property(property), (Object)package$.MODULE$.ff().literal((Object)geom));
                                        if (tuple2 == null) break block2;
                                        Expression e12 = (Expression)tuple2._1();
                                        Expression e22 = (Expression)tuple2._2();
                                        Tuple2 tuple24 = tuple22 = new Tuple2((Object)e12, (Object)e22);
                                        e1 = (Expression)tuple24._1();
                                        e2 = (Expression)tuple24._2();
                                        binarySpatialOperator = op;
                                        if (!(binarySpatialOperator instanceof Within)) break block3;
                                        within = package$.MODULE$.ff().within(e1, e2);
                                        break block4;
                                    }
                                    if (!(binarySpatialOperator instanceof Intersects)) break block5;
                                    within = package$.MODULE$.ff().intersects(e1, e2);
                                    break block4;
                                }
                                if (!(binarySpatialOperator instanceof Overlaps)) break block6;
                                within = package$.MODULE$.ff().overlaps(e1, e2);
                                break block4;
                            }
                            if (!(binarySpatialOperator instanceof DWithin)) break block7;
                            within = package$.MODULE$.ff().dwithin(e1, e2, BoxesRunTime.unboxToDouble((Object)args), "meters");
                            break block4;
                        }
                        if (!(binarySpatialOperator instanceof BBOX)) break block8;
                        within = new BBOXImpl(e1, e2);
                        break block4;
                    }
                    if (!(binarySpatialOperator instanceof Contains)) break block9;
                    within = package$.MODULE$.ff().contains(e1, e2);
                }
                return within;
            }
            throw new MatchError((Object)binarySpatialOperator);
        }
        throw new MatchError((Object)tuple2);
    }

    public boolean isFilterWholeWorld(Filter f) {
        boolean bl;
        Filter filter = f;
        if (filter instanceof BBOX) {
            BBOX bBOX = (BBOX)filter;
            bl = this.isOperationGeomWholeWorld(bBOX, this.isOperationGeomWholeWorld$default$2());
        } else if (filter instanceof Intersects) {
            Intersects intersects = (Intersects)filter;
            bl = this.isOperationGeomWholeWorld(intersects, this.isOperationGeomWholeWorld$default$2());
        } else if (filter instanceof Overlaps) {
            Overlaps overlaps2 = (Overlaps)filter;
            bl = this.isOperationGeomWholeWorld(overlaps2, this.isOperationGeomWholeWorld$default$2());
        } else if (filter instanceof Within) {
            Within within = (Within)filter;
            bl = this.isOperationGeomWholeWorld(within, FilterHelper$SpatialOpOrder$.MODULE$.PropertyFirst());
        } else if (filter instanceof Contains) {
            Contains contains = (Contains)filter;
            bl = this.isOperationGeomWholeWorld(contains, FilterHelper$SpatialOpOrder$.MODULE$.LiteralFirst());
        } else {
            bl = false;
        }
        return bl;
    }

    private <Op extends BinarySpatialOperator> boolean isOperationGeomWholeWorld(Op op, Enumeration.Value order) {
        Option<PropertyLiteral> prop = package$.MODULE$.checkOrder(op.getExpression1(), op.getExpression2());
        return prop.exists((Function1)new Serializable(order){
            public static final long serialVersionUID = 0L;
            private final Enumeration.Value order$1;

            public final boolean apply(PropertyLiteral p) {
                Enumeration.Value value;
                block5: {
                    boolean bl;
                    block3: {
                        block4: {
                            block2: {
                                value = this.order$1;
                                Enumeration.Value value2 = FilterHelper$SpatialOpOrder$.MODULE$.AnyOrder();
                                Enumeration.Value value3 = value;
                                if (value2 != null ? !value2.equals(value3) : value3 != null) break block2;
                                bl = true;
                                break block3;
                            }
                            Enumeration.Value value4 = FilterHelper$SpatialOpOrder$.MODULE$.PropertyFirst();
                            Enumeration.Value value5 = value;
                            if (value4 != null ? !value4.equals(value5) : value5 != null) break block4;
                            bl = !p.flipped();
                            break block3;
                        }
                        Enumeration.Value value6 = FilterHelper$SpatialOpOrder$.MODULE$.LiteralFirst();
                        Enumeration.Value value7 = value;
                        if (value6 != null ? !value6.equals(value7) : value7 != null) break block5;
                        bl = p.flipped();
                    }
                    boolean ordered = bl;
                    return ordered && Option$.MODULE$.apply(p.literal().evaluate(null, Geometry.class)).exists((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(Geometry g) {
                            return FilterHelper$.MODULE$.isWholeWorld(g);
                        }
                    });
                }
                throw new MatchError((Object)value);
            }
            {
                this.order$1 = order$1;
            }
        });
    }

    private <Op extends BinarySpatialOperator> Enumeration.Value isOperationGeomWholeWorld$default$2() {
        return FilterHelper$SpatialOpOrder$.MODULE$.AnyOrder();
    }

    public <G extends Geometry> boolean isWholeWorld(G g) {
        return g != null && g.union().covers((Geometry)org.locationtech.geomesa.utils.geotools.package$.MODULE$.WholeWorldPolygon());
    }

    public Seq<Geometry> getGeometryListOf(Geometry inMP) {
        return (Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), inMP.getNumGeometries()).map((Function1)new Serializable(inMP){
            public static final long serialVersionUID = 0L;
            private final Geometry inMP$1;

            public final Geometry apply(int i) {
                return this.inMP$1.getGeometryN(i);
            }
            {
                this.inMP$1 = inMP$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
    }

    public Geometry addWayPointsToBBOX(Geometry g) {
        Coordinate[] correctedGeom;
        GeometryFactory gf = g.getFactory();
        Coordinate[] geomArray = g.getCoordinates();
        return geomArray.length == (correctedGeom = (Coordinate[])GeometryUtils$.MODULE$.addWayPoints((Seq)Predef$.MODULE$.wrapRefArray((Object[])geomArray)).toArray(ClassTag$.MODULE$.apply(Coordinate.class))).length ? g : gf.createPolygon(correctedGeom);
    }

    public FilterValues<Geometry> extractGeometries(Filter filter, String attribute, boolean intersect) {
        return this.org$locationtech$geomesa$filter$FilterHelper$$extractUnclippedGeometries(filter, attribute, intersect).map(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Geometry apply(Geometry x$9) {
                return x$9.intersection((Geometry)org.locationtech.geomesa.utils.geotools.package$.MODULE$.WholeWorldPolygon());
            }
        });
    }

    public boolean extractGeometries$default$3() {
        return true;
    }

    public FilterValues<Geometry> org$locationtech$geomesa$filter$FilterHelper$$extractUnclippedGeometries(Filter filter, String attribute, boolean intersect) {
        BinarySpatialOperator binarySpatialOperator;
        FilterValues filterValues;
        Filter filter2 = filter;
        if (filter2 instanceof Or) {
            Or or2 = (Or)filter2;
            Buffer all = (Buffer)JavaConversions$.MODULE$.asScalaBuffer(or2.getChildren()).map((Function1)new Serializable(attribute, intersect){
                public static final long serialVersionUID = 0L;
                private final String attribute$1;
                private final boolean intersect$1;

                public final FilterValues<Geometry> apply(Filter x$10) {
                    return FilterHelper$.MODULE$.org$locationtech$geomesa$filter$FilterHelper$$extractUnclippedGeometries(x$10, this.attribute$1, this.intersect$1);
                }
                {
                    this.attribute$1 = attribute$1;
                    this.intersect$1 = intersect$1;
                }
            }, Buffer$.MODULE$.canBuildFrom());
            Serializable serializable = new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Seq<Geometry> apply(Seq<Geometry> l, Seq<Geometry> r) {
                    return (Seq)l.$plus$plus(r, Seq$.MODULE$.canBuildFrom());
                }
            };
            Serializable join = new Serializable((Function2)serializable){
                public static final long serialVersionUID = 0L;
                private final Function2 eta$0$1$1;

                public final FilterValues<Geometry> apply(FilterValues<Geometry> left, FilterValues<Geometry> right) {
                    return FilterValues$.MODULE$.or(this.eta$0$1$1, left, right);
                }
                {
                    this.eta$0$1$1 = eta$0$1$1;
                }
            };
            filterValues = (FilterValues)all.reduceLeftOption((Function2)join).getOrElse((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final FilterValues<Geometry> apply() {
                    return FilterValues$.MODULE$.empty();
                }
            });
        } else if (filter2 instanceof And) {
            FilterValues filterValues2;
            And and2 = (And)filter2;
            Buffer all = (Buffer)((TraversableLike)JavaConversions$.MODULE$.asScalaBuffer(and2.getChildren()).map((Function1)new Serializable(attribute, intersect){
                public static final long serialVersionUID = 0L;
                private final String attribute$1;
                private final boolean intersect$1;

                public final FilterValues<Geometry> apply(Filter x$11) {
                    return FilterHelper$.MODULE$.org$locationtech$geomesa$filter$FilterHelper$$extractUnclippedGeometries(x$11, this.attribute$1, this.intersect$1);
                }
                {
                    this.attribute$1 = attribute$1;
                    this.intersect$1 = intersect$1;
                }
            }, Buffer$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(FilterValues<Geometry> x$12) {
                    return x$12.nonEmpty();
                }
            });
            if (intersect) {
                Serializable serializable = new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final Option<Geometry> apply(Geometry l, Geometry r) {
                        return Option$.MODULE$.apply((Object)l.intersection(r)).filterNot((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(Geometry x$13) {
                                return x$13.isEmpty();
                            }
                        });
                    }
                };
                Serializable intersect2 = new Serializable((Function2)serializable){
                    public static final long serialVersionUID = 0L;
                    private final Function2 eta$0$2$1;

                    public final FilterValues<Geometry> apply(FilterValues<Geometry> left, FilterValues<Geometry> right) {
                        return FilterValues$.MODULE$.and(this.eta$0$2$1, left, right);
                    }
                    {
                        this.eta$0$2$1 = eta$0$2$1;
                    }
                };
                filterValues2 = (FilterValues)all.reduceLeftOption((Function2)intersect2).getOrElse((Function0)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final FilterValues<Geometry> apply() {
                        return FilterValues$.MODULE$.empty();
                    }
                });
            } else {
                filterValues2 = new FilterValues((Seq)all.flatMap((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final Seq<Geometry> apply(FilterValues<Geometry> x$14) {
                        return x$14.values();
                    }
                }, Buffer$.MODULE$.canBuildFrom()), FilterValues$.MODULE$.apply$default$2());
            }
            filterValues = filterValues2;
        } else if (filter2 instanceof BinarySpatialOperator && package$.MODULE$.isSpatialFilter((Filter)(binarySpatialOperator = (BinarySpatialOperator)filter2))) {
            Option geometry = package$.MODULE$.checkOrder(binarySpatialOperator.getExpression1(), binarySpatialOperator.getExpression2()).withFilter((Function1)new Serializable(attribute){
                public static final long serialVersionUID = 0L;
                private final String attribute$1;

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final boolean apply(PropertyLiteral prop) {
                    if (prop.name() == null) return true;
                    String string = prop.name();
                    String string2 = this.attribute$1;
                    if (string != null) {
                        if (!string.equals(string2)) return false;
                        return true;
                    }
                    if (string2 == null) return true;
                    return false;
                }
                {
                    this.attribute$1 = attribute$1;
                }
            }).flatMap((Function1)new Serializable(filter){
                public static final long serialVersionUID = 0L;
                public final Filter filter$1;

                public final Option<Geometry> apply(PropertyLiteral prop) {
                    return Option$.MODULE$.apply(prop.literal().evaluate(null, Geometry.class)).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.17 $outer;

                        public final Geometry apply(Geometry geom) {
                            Geometry geometry;
                            Filter filter = this.$outer.filter$1;
                            if (filter instanceof DWithin) {
                                DWithin dWithin = (DWithin)filter;
                                geometry = geom.buffer(dWithin.getDistance());
                            } else if (filter instanceof BBOX) {
                                Geometry geomCopy = GeometryUtils$.MODULE$.geoFactory().createGeometry(geom);
                                Geometry trimmedGeom = geomCopy.intersection((Geometry)org.locationtech.geomesa.utils.geotools.package$.MODULE$.WholeWorldPolygon());
                                geometry = FilterHelper$.MODULE$.addWayPointsToBBOX(trimmedGeom);
                            } else {
                                geometry = geom;
                            }
                            Geometry buffered = geometry;
                            return FilterHelper$.MODULE$.org$locationtech$geomesa$filter$FilterHelper$$tryGetIdlSafeGeom(buffered);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                }
                {
                    this.filter$1 = filter$1;
                }
            });
            filterValues = new FilterValues((Seq)geometry.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Seq<Geometry> apply(Geometry geometry) {
                    return FilterHelper$.MODULE$.org$locationtech$geomesa$filter$FilterHelper$$flattenGeometry(geometry);
                }
            }).getOrElse((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Seq<Nothing$> apply() {
                    return (Seq)Seq$.MODULE$.empty();
                }
            }), FilterValues$.MODULE$.apply$default$2());
        } else {
            filterValues = FilterValues$.MODULE$.empty();
        }
        return filterValues;
    }

    public Seq<Geometry> org$locationtech$geomesa$filter$FilterHelper$$flattenGeometry(Geometry geometry) {
        Seq seq;
        Geometry geometry2 = geometry;
        if (geometry2 instanceof GeometryCollection) {
            GeometryCollection geometryCollection = (GeometryCollection)geometry2;
            seq = (Seq)((TraversableLike)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), geometryCollection.getNumGeometries()).map((Function1)new Serializable(geometryCollection){
                public static final long serialVersionUID = 0L;
                private final GeometryCollection x2$1;

                public final Geometry apply(int x$1) {
                    return this.x2$1.getGeometryN(x$1);
                }
                {
                    this.x2$1 = x2$1;
                }
            }, IndexedSeq$.MODULE$.canBuildFrom())).flatMap((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Seq<Geometry> apply(Geometry geometry) {
                    return FilterHelper$.MODULE$.org$locationtech$geomesa$filter$FilterHelper$$flattenGeometry(geometry);
                }
            }, IndexedSeq$.MODULE$.canBuildFrom());
        } else {
            seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Geometry[]{geometry}));
        }
        return seq;
    }

    public FilterValues<Tuple2<DateTime, DateTime>> extractIntervals(Filter filter, String attribute, boolean intersect, boolean handleExclusiveBounds) {
        return this.extractAttributeBounds(filter, attribute, Date.class, this.extractAttributeBounds$default$4()).map(new Serializable(handleExclusiveBounds){
            public static final long serialVersionUID = 0L;
            private final boolean handleExclusiveBounds$1;

            public final Tuple2<DateTime, DateTime> apply(Bounds<Date> bounds) {
                DateTime lower = null;
                DateTime upper = null;
                if (!bounds.inclusive() && this.handleExclusiveBounds$1) {
                    if (bounds.lower().isEmpty() || bounds.upper().isEmpty()) {
                        lower = (DateTime)bounds.lower().map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final DateTime apply(Date x$17) {
                                return new DateTime((Object)x$17, DateTimeZone.UTC);
                            }
                        }).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final DateTime apply(DateTime dt) {
                                return FilterHelper$.MODULE$.org$locationtech$geomesa$filter$FilterHelper$$roundSecondsUp(dt);
                            }
                        }).getOrElse((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final DateTime apply() {
                                return FilterHelper$.MODULE$.MinDateTime();
                            }
                        });
                        upper = (DateTime)bounds.upper().map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final DateTime apply(Date x$18) {
                                return new DateTime((Object)x$18, DateTimeZone.UTC);
                            }
                        }).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final DateTime apply(DateTime dt) {
                                return FilterHelper$.MODULE$.org$locationtech$geomesa$filter$FilterHelper$$roundSecondsDown(dt);
                            }
                        }).getOrElse((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final DateTime apply() {
                                return FilterHelper$.MODULE$.MaxDateTime();
                            }
                        });
                    } else {
                        Date lo = (Date)bounds.lower().get();
                        Date up = (Date)bounds.upper().get();
                        if (up.getTime() - lo.getTime() < 2000L) {
                            lower = new DateTime((Object)lo, DateTimeZone.UTC);
                            upper = new DateTime((Object)up, DateTimeZone.UTC);
                        } else {
                            lower = FilterHelper$.MODULE$.org$locationtech$geomesa$filter$FilterHelper$$roundSecondsUp(new DateTime((Object)lo, DateTimeZone.UTC));
                            upper = FilterHelper$.MODULE$.org$locationtech$geomesa$filter$FilterHelper$$roundSecondsDown(new DateTime((Object)up, DateTimeZone.UTC));
                        }
                    }
                } else {
                    lower = (DateTime)bounds.lower().map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final DateTime apply(Date x$15) {
                            return new DateTime((Object)x$15, DateTimeZone.UTC);
                        }
                    }).getOrElse((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final DateTime apply() {
                            return FilterHelper$.MODULE$.MinDateTime();
                        }
                    });
                    upper = (DateTime)bounds.upper().map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final DateTime apply(Date x$16) {
                            return new DateTime((Object)x$16, DateTimeZone.UTC);
                        }
                    }).getOrElse((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final DateTime apply() {
                            return FilterHelper$.MODULE$.MaxDateTime();
                        }
                    });
                }
                return new Tuple2((Object)lower, (Object)upper);
            }
            {
                this.handleExclusiveBounds$1 = handleExclusiveBounds$1;
            }
        });
    }

    public boolean extractIntervals$default$3() {
        return true;
    }

    public boolean extractIntervals$default$4() {
        return false;
    }

    public DateTime org$locationtech$geomesa$filter$FilterHelper$$roundSecondsUp(DateTime dt) {
        return dt.plusSeconds(1).withMillisOfSecond(0);
    }

    public DateTime org$locationtech$geomesa$filter$FilterHelper$$roundSecondsDown(DateTime dt) {
        int millis = dt.getMillisOfSecond();
        return millis == 0 ? dt.minusSeconds(1) : dt.withMillisOfSecond(0);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> FilterValues<Bounds<T>> extractAttributeBounds(Filter filter, String attribute, Class<T> binding, boolean intersect) {
        Filter filter2;
        Not not;
        boolean bl;
        block37: {
            String prop;
            FilterValues filterValues;
            block38: {
                FilterValues filterValues2;
                PropertyIsLike propertyIsLike;
                FilterValues filterValues3;
                PropertyIsBetween propertyIsBetween;
                bl = false;
                not = null;
                filter2 = filter;
                if (filter2 instanceof Or) {
                    Or or2 = (Or)filter2;
                    Buffer all = (Buffer)((TraversableLike)JavaConversions$.MODULE$.asScalaBuffer(or2.getChildren()).map((Function1)new Serializable(attribute, binding){
                        public static final long serialVersionUID = 0L;
                        private final String attribute$2;
                        private final Class binding$1;

                        public final FilterValues<Bounds<T>> apply(Filter x$19) {
                            return FilterHelper$.MODULE$.extractAttributeBounds(x$19, this.attribute$2, this.binding$1, FilterHelper$.MODULE$.extractAttributeBounds$default$4());
                        }
                        {
                            this.attribute$2 = attribute$2;
                            this.binding$1 = binding$1;
                        }
                    }, Buffer$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(FilterValues<Bounds<T>> x$20) {
                            return x$20.nonEmpty();
                        }
                    });
                    Serializable serializable = new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final Seq<Bounds<T>> apply(Seq<Bounds<T>> left, Seq<Bounds<T>> right) {
                            return Bounds$.MODULE$.union(left, right);
                        }
                    };
                    Serializable join = new Serializable((Function2)serializable){
                        public static final long serialVersionUID = 0L;
                        private final Function2 eta$0$3$1;

                        public final FilterValues<Bounds<T>> apply(FilterValues<Bounds<T>> left, FilterValues<Bounds<T>> right) {
                            return FilterValues$.MODULE$.or(this.eta$0$3$1, left, right);
                        }
                        {
                            this.eta$0$3$1 = eta$0$3$1;
                        }
                    };
                    return (FilterValues)all.reduceLeftOption((Function2)join).getOrElse((Function0)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final FilterValues<Bounds<T>> apply() {
                            return FilterValues$.MODULE$.empty();
                        }
                    });
                }
                if (filter2 instanceof And) {
                    FilterValues filterValues4;
                    And and2 = (And)filter2;
                    Buffer all = (Buffer)((TraversableLike)JavaConversions$.MODULE$.asScalaBuffer(and2.getChildren()).map((Function1)new Serializable(attribute, binding){
                        public static final long serialVersionUID = 0L;
                        private final String attribute$2;
                        private final Class binding$1;

                        public final FilterValues<Bounds<T>> apply(Filter x$21) {
                            return FilterHelper$.MODULE$.extractAttributeBounds(x$21, this.attribute$2, this.binding$1, FilterHelper$.MODULE$.extractAttributeBounds$default$4());
                        }
                        {
                            this.attribute$2 = attribute$2;
                            this.binding$1 = binding$1;
                        }
                    }, Buffer$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(FilterValues<Bounds<T>> x$22) {
                            return x$22.nonEmpty();
                        }
                    });
                    if (intersect) {
                        Serializable serializable = new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final Option<Bounds<T>> apply(Bounds<T> left, Bounds<T> right) {
                                return Bounds$.MODULE$.intersection(left, right);
                            }
                        };
                        Serializable intersection = new Serializable((Function2)serializable){
                            public static final long serialVersionUID = 0L;
                            private final Function2 eta$0$4$1;

                            public final FilterValues<Bounds<T>> apply(FilterValues<Bounds<T>> left, FilterValues<Bounds<T>> right) {
                                return FilterValues$.MODULE$.and(this.eta$0$4$1, left, right);
                            }
                            {
                                this.eta$0$4$1 = eta$0$4$1;
                            }
                        };
                        filterValues4 = (FilterValues)all.reduceLeftOption((Function2)intersection).getOrElse((Function0)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final FilterValues<Bounds<T>> apply() {
                                return FilterValues$.MODULE$.empty();
                            }
                        });
                        return filterValues4;
                    } else {
                        filterValues4 = new FilterValues((Seq)all.flatMap((Function1)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final Seq<Bounds<T>> apply(FilterValues<Bounds<T>> x$23) {
                                return x$23.values();
                            }
                        }, Buffer$.MODULE$.canBuildFrom()), FilterValues$.MODULE$.apply$default$2());
                    }
                    return filterValues4;
                }
                if (filter2 instanceof PropertyIsEqualTo) {
                    PropertyIsEqualTo propertyIsEqualTo = (PropertyIsEqualTo)filter2;
                    return (FilterValues)package$.MODULE$.checkOrder(propertyIsEqualTo.getExpression1(), propertyIsEqualTo.getExpression2()).filter((Function1)new Serializable(attribute){
                        public static final long serialVersionUID = 0L;
                        private final String attribute$2;

                        public final boolean apply(PropertyLiteral x$24) {
                            String string = x$24.name();
                            String string2 = this.attribute$2;
                            return !(string != null ? !string.equals(string2) : string2 != null);
                        }
                        {
                            this.attribute$2 = attribute$2;
                        }
                    }).flatMap((Function1)new Serializable(binding){
                        public static final long serialVersionUID = 0L;
                        private final Class binding$1;

                        public final Option<FilterValues<Bounds<T>>> apply(PropertyLiteral prop) {
                            return Option$.MODULE$.apply(prop.literal().evaluate(null, this.binding$1)).map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final FilterValues<Bounds<T>> apply(T lit) {
                                    return new FilterValues<Bounds<T>>((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Bounds[]{new Bounds<T>(new Some(lit), new Some(lit), true)})), FilterValues$.MODULE$.apply$default$2());
                                }
                            });
                        }
                        {
                            this.binding$1 = binding$1;
                        }
                    }).getOrElse((Function0)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final FilterValues<Bounds<T>> apply() {
                            return FilterValues$.MODULE$.empty();
                        }
                    });
                }
                if (filter2 instanceof PropertyIsBetween) {
                    String prop2;
                    propertyIsBetween = (PropertyIsBetween)filter2;
                    String string = prop2 = ((PropertyName)propertyIsBetween.getExpression()).getPropertyName();
                    String string2 = attribute;
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        Object lower = propertyIsBetween.getLowerBoundary().evaluate(null, binding);
                        Object upper = propertyIsBetween.getUpperBoundary().evaluate(null, binding);
                        Bounds bounds = new Bounds(Option$.MODULE$.apply(lower), Option$.MODULE$.apply(upper), true);
                        filterValues3 = new FilterValues((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Bounds[]{bounds})), FilterValues$.MODULE$.apply$default$2());
                        return filterValues3;
                    }
                    filterValues3 = FilterValues$.MODULE$.empty();
                    return filterValues3;
                }
                if (filter2 instanceof During) {
                    During during = (During)filter2;
                    if (Date.class.isAssignableFrom(binding)) {
                        return (FilterValues)package$.MODULE$.checkOrder(during.getExpression1(), during.getExpression2()).filter((Function1)new Serializable(attribute){
                            public static final long serialVersionUID = 0L;
                            private final String attribute$2;

                            public final boolean apply(PropertyLiteral x$25) {
                                String string = x$25.name();
                                String string2 = this.attribute$2;
                                return !(string != null ? !string.equals(string2) : string2 != null);
                            }
                            {
                                this.attribute$2 = attribute$2;
                            }
                        }).flatMap((Function1)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final Option<FilterValues<Bounds<T>>> apply(PropertyLiteral prop) {
                                return Option$.MODULE$.apply(prop.literal().evaluate(null, Period.class)).map((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final FilterValues<Bounds<T>> apply(Period p) {
                                        Date lower = p.getBeginning().getPosition().getDate();
                                        Date upper = p.getEnding().getPosition().getDate();
                                        Bounds<T> bounds = new Bounds<T>(Option$.MODULE$.apply((Object)lower), Option$.MODULE$.apply((Object)upper), false);
                                        return new FilterValues<Bounds<T>>((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Bounds[]{bounds})), FilterValues$.MODULE$.apply$default$2());
                                    }
                                });
                            }
                        }).getOrElse((Function0)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final FilterValues<Bounds<T>> apply() {
                                return FilterValues$.MODULE$.empty();
                            }
                        });
                    }
                }
                if (filter2 instanceof PropertyIsGreaterThan) {
                    PropertyIsGreaterThan propertyIsGreaterThan = (PropertyIsGreaterThan)filter2;
                    return (FilterValues)package$.MODULE$.checkOrder(propertyIsGreaterThan.getExpression1(), propertyIsGreaterThan.getExpression2()).filter((Function1)new Serializable(attribute){
                        public static final long serialVersionUID = 0L;
                        private final String attribute$2;

                        public final boolean apply(PropertyLiteral x$26) {
                            String string = x$26.name();
                            String string2 = this.attribute$2;
                            return !(string != null ? !string.equals(string2) : string2 != null);
                        }
                        {
                            this.attribute$2 = attribute$2;
                        }
                    }).flatMap((Function1)new Serializable(binding){
                        public static final long serialVersionUID = 0L;
                        private final Class binding$1;

                        public final Option<FilterValues<Bounds<T>>> apply(PropertyLiteral prop) {
                            return Option$.MODULE$.apply(prop.literal().evaluate(null, this.binding$1)).map((Function1)new Serializable(this, prop){
                                public static final long serialVersionUID = 0L;
                                private final PropertyLiteral prop$1;

                                public final FilterValues<Bounds<T>> apply(T lit) {
                                    Tuple2 tuple2;
                                    Tuple2 tuple22 = tuple2 = this.prop$1.flipped() ? new Tuple2((Object)None$.MODULE$, (Object)new Some(lit)) : new Tuple2((Object)new Some(lit), (Object)None$.MODULE$);
                                    if (tuple2 != null) {
                                        Tuple2 tuple23;
                                        Option lower = (Option)tuple2._1();
                                        Option upper = (Option)tuple2._2();
                                        Tuple2 tuple24 = tuple23 = new Tuple2((Object)lower, (Object)upper);
                                        Option lower2 = (Option)tuple24._1();
                                        Option upper2 = (Option)tuple24._2();
                                        Bounds<T> bounds = new Bounds<T>(lower2, upper2, false);
                                        return new FilterValues<Bounds<T>>((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Bounds[]{bounds})), FilterValues$.MODULE$.apply$default$2());
                                    }
                                    throw new MatchError((Object)tuple2);
                                }
                                {
                                    this.prop$1 = prop$1;
                                }
                            });
                        }
                        {
                            this.binding$1 = binding$1;
                        }
                    }).getOrElse((Function0)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final FilterValues<Bounds<T>> apply() {
                            return FilterValues$.MODULE$.empty();
                        }
                    });
                }
                if (filter2 instanceof PropertyIsGreaterThanOrEqualTo) {
                    PropertyIsGreaterThanOrEqualTo propertyIsGreaterThanOrEqualTo = (PropertyIsGreaterThanOrEqualTo)filter2;
                    return (FilterValues)package$.MODULE$.checkOrder(propertyIsGreaterThanOrEqualTo.getExpression1(), propertyIsGreaterThanOrEqualTo.getExpression2()).filter((Function1)new Serializable(attribute){
                        public static final long serialVersionUID = 0L;
                        private final String attribute$2;

                        public final boolean apply(PropertyLiteral x$28) {
                            String string = x$28.name();
                            String string2 = this.attribute$2;
                            return !(string != null ? !string.equals(string2) : string2 != null);
                        }
                        {
                            this.attribute$2 = attribute$2;
                        }
                    }).flatMap((Function1)new Serializable(binding){
                        public static final long serialVersionUID = 0L;
                        private final Class binding$1;

                        public final Option<FilterValues<Bounds<T>>> apply(PropertyLiteral prop) {
                            return Option$.MODULE$.apply(prop.literal().evaluate(null, this.binding$1)).map((Function1)new Serializable(this, prop){
                                public static final long serialVersionUID = 0L;
                                private final PropertyLiteral prop$2;

                                public final FilterValues<Bounds<T>> apply(T lit) {
                                    Tuple2 tuple2;
                                    Tuple2 tuple22 = tuple2 = this.prop$2.flipped() ? new Tuple2((Object)None$.MODULE$, (Object)new Some(lit)) : new Tuple2((Object)new Some(lit), (Object)None$.MODULE$);
                                    if (tuple2 != null) {
                                        Tuple2 tuple23;
                                        Option lower = (Option)tuple2._1();
                                        Option upper = (Option)tuple2._2();
                                        Tuple2 tuple24 = tuple23 = new Tuple2((Object)lower, (Object)upper);
                                        Option lower2 = (Option)tuple24._1();
                                        Option upper2 = (Option)tuple24._2();
                                        Bounds<T> bounds = new Bounds<T>(lower2, upper2, true);
                                        return new FilterValues<Bounds<T>>((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Bounds[]{bounds})), FilterValues$.MODULE$.apply$default$2());
                                    }
                                    throw new MatchError((Object)tuple2);
                                }
                                {
                                    this.prop$2 = prop$2;
                                }
                            });
                        }
                        {
                            this.binding$1 = binding$1;
                        }
                    }).getOrElse((Function0)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final FilterValues<Bounds<T>> apply() {
                            return FilterValues$.MODULE$.empty();
                        }
                    });
                }
                if (filter2 instanceof PropertyIsLessThan) {
                    PropertyIsLessThan propertyIsLessThan = (PropertyIsLessThan)filter2;
                    return (FilterValues)package$.MODULE$.checkOrder(propertyIsLessThan.getExpression1(), propertyIsLessThan.getExpression2()).filter((Function1)new Serializable(attribute){
                        public static final long serialVersionUID = 0L;
                        private final String attribute$2;

                        public final boolean apply(PropertyLiteral x$30) {
                            String string = x$30.name();
                            String string2 = this.attribute$2;
                            return !(string != null ? !string.equals(string2) : string2 != null);
                        }
                        {
                            this.attribute$2 = attribute$2;
                        }
                    }).flatMap((Function1)new Serializable(binding){
                        public static final long serialVersionUID = 0L;
                        private final Class binding$1;

                        public final Option<FilterValues<Bounds<T>>> apply(PropertyLiteral prop) {
                            return Option$.MODULE$.apply(prop.literal().evaluate(null, this.binding$1)).map((Function1)new Serializable(this, prop){
                                public static final long serialVersionUID = 0L;
                                private final PropertyLiteral prop$3;

                                public final FilterValues<Bounds<T>> apply(T lit) {
                                    Tuple2 tuple2;
                                    Tuple2 tuple22 = tuple2 = this.prop$3.flipped() ? new Tuple2((Object)new Some(lit), (Object)None$.MODULE$) : new Tuple2((Object)None$.MODULE$, (Object)new Some(lit));
                                    if (tuple2 != null) {
                                        Tuple2 tuple23;
                                        Option lower = (Option)tuple2._1();
                                        Option upper = (Option)tuple2._2();
                                        Tuple2 tuple24 = tuple23 = new Tuple2((Object)lower, (Object)upper);
                                        Option lower2 = (Option)tuple24._1();
                                        Option upper2 = (Option)tuple24._2();
                                        Bounds<T> bounds = new Bounds<T>(lower2, upper2, false);
                                        return new FilterValues<Bounds<T>>((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Bounds[]{bounds})), FilterValues$.MODULE$.apply$default$2());
                                    }
                                    throw new MatchError((Object)tuple2);
                                }
                                {
                                    this.prop$3 = prop$3;
                                }
                            });
                        }
                        {
                            this.binding$1 = binding$1;
                        }
                    }).getOrElse((Function0)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final FilterValues<Bounds<T>> apply() {
                            return FilterValues$.MODULE$.empty();
                        }
                    });
                }
                if (filter2 instanceof PropertyIsLessThanOrEqualTo) {
                    PropertyIsLessThanOrEqualTo propertyIsLessThanOrEqualTo = (PropertyIsLessThanOrEqualTo)filter2;
                    return (FilterValues)package$.MODULE$.checkOrder(propertyIsLessThanOrEqualTo.getExpression1(), propertyIsLessThanOrEqualTo.getExpression2()).filter((Function1)new Serializable(attribute){
                        public static final long serialVersionUID = 0L;
                        private final String attribute$2;

                        public final boolean apply(PropertyLiteral x$32) {
                            String string = x$32.name();
                            String string2 = this.attribute$2;
                            return !(string != null ? !string.equals(string2) : string2 != null);
                        }
                        {
                            this.attribute$2 = attribute$2;
                        }
                    }).flatMap((Function1)new Serializable(binding){
                        public static final long serialVersionUID = 0L;
                        private final Class binding$1;

                        public final Option<FilterValues<Bounds<T>>> apply(PropertyLiteral prop) {
                            return Option$.MODULE$.apply(prop.literal().evaluate(null, this.binding$1)).map((Function1)new Serializable(this, prop){
                                public static final long serialVersionUID = 0L;
                                private final PropertyLiteral prop$4;

                                public final FilterValues<Bounds<T>> apply(T lit) {
                                    Tuple2 tuple2;
                                    Tuple2 tuple22 = tuple2 = this.prop$4.flipped() ? new Tuple2((Object)new Some(lit), (Object)None$.MODULE$) : new Tuple2((Object)None$.MODULE$, (Object)new Some(lit));
                                    if (tuple2 != null) {
                                        Tuple2 tuple23;
                                        Option lower = (Option)tuple2._1();
                                        Option upper = (Option)tuple2._2();
                                        Tuple2 tuple24 = tuple23 = new Tuple2((Object)lower, (Object)upper);
                                        Option lower2 = (Option)tuple24._1();
                                        Option upper2 = (Option)tuple24._2();
                                        Bounds<T> bounds = new Bounds<T>(lower2, upper2, true);
                                        return new FilterValues<Bounds<T>>((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Bounds[]{bounds})), FilterValues$.MODULE$.apply$default$2());
                                    }
                                    throw new MatchError((Object)tuple2);
                                }
                                {
                                    this.prop$4 = prop$4;
                                }
                            });
                        }
                        {
                            this.binding$1 = binding$1;
                        }
                    }).getOrElse((Function0)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final FilterValues<Bounds<T>> apply() {
                            return FilterValues$.MODULE$.empty();
                        }
                    });
                }
                if (filter2 instanceof Before) {
                    Before before = (Before)filter2;
                    return (FilterValues)package$.MODULE$.checkOrder(before.getExpression1(), before.getExpression2()).filter((Function1)new Serializable(attribute){
                        public static final long serialVersionUID = 0L;
                        private final String attribute$2;

                        public final boolean apply(PropertyLiteral x$34) {
                            String string = x$34.name();
                            String string2 = this.attribute$2;
                            return !(string != null ? !string.equals(string2) : string2 != null);
                        }
                        {
                            this.attribute$2 = attribute$2;
                        }
                    }).flatMap((Function1)new Serializable(binding){
                        public static final long serialVersionUID = 0L;
                        private final Class binding$1;

                        public final Option<FilterValues<Bounds<T>>> apply(PropertyLiteral prop) {
                            return Option$.MODULE$.apply(prop.literal().evaluate(null, this.binding$1)).map((Function1)new Serializable(this, prop){
                                public static final long serialVersionUID = 0L;
                                private final PropertyLiteral prop$5;

                                public final FilterValues<Bounds<T>> apply(T lit) {
                                    Tuple2 tuple2;
                                    Tuple2 tuple22 = tuple2 = this.prop$5.flipped() ? new Tuple2((Object)Option$.MODULE$.apply(lit), (Object)None$.MODULE$) : new Tuple2((Object)None$.MODULE$, (Object)Option$.MODULE$.apply(lit));
                                    if (tuple2 != null) {
                                        Tuple2 tuple23;
                                        Option lower = (Option)tuple2._1();
                                        Option upper = (Option)tuple2._2();
                                        Tuple2 tuple24 = tuple23 = new Tuple2((Object)lower, (Object)upper);
                                        Option lower2 = (Option)tuple24._1();
                                        Option upper2 = (Option)tuple24._2();
                                        Bounds<T> bounds = new Bounds<T>(lower2, upper2, false);
                                        return new FilterValues<Bounds<T>>((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Bounds[]{bounds})), FilterValues$.MODULE$.apply$default$2());
                                    }
                                    throw new MatchError((Object)tuple2);
                                }
                                {
                                    this.prop$5 = prop$5;
                                }
                            });
                        }
                        {
                            this.binding$1 = binding$1;
                        }
                    }).getOrElse((Function0)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final FilterValues<Bounds<T>> apply() {
                            return FilterValues$.MODULE$.empty();
                        }
                    });
                }
                if (filter2 instanceof After) {
                    After after = (After)filter2;
                    return (FilterValues)package$.MODULE$.checkOrder(after.getExpression1(), after.getExpression2()).filter((Function1)new Serializable(attribute){
                        public static final long serialVersionUID = 0L;
                        private final String attribute$2;

                        public final boolean apply(PropertyLiteral x$36) {
                            String string = x$36.name();
                            String string2 = this.attribute$2;
                            return !(string != null ? !string.equals(string2) : string2 != null);
                        }
                        {
                            this.attribute$2 = attribute$2;
                        }
                    }).flatMap((Function1)new Serializable(binding){
                        public static final long serialVersionUID = 0L;
                        private final Class binding$1;

                        public final Option<FilterValues<Bounds<T>>> apply(PropertyLiteral prop) {
                            return Option$.MODULE$.apply(prop.literal().evaluate(null, this.binding$1)).map((Function1)new Serializable(this, prop){
                                public static final long serialVersionUID = 0L;
                                private final PropertyLiteral prop$6;

                                public final FilterValues<Bounds<T>> apply(T lit) {
                                    Tuple2 tuple2;
                                    Tuple2 tuple22 = tuple2 = this.prop$6.flipped() ? new Tuple2((Object)None$.MODULE$, (Object)Option$.MODULE$.apply(lit)) : new Tuple2((Object)Option$.MODULE$.apply(lit), (Object)None$.MODULE$);
                                    if (tuple2 != null) {
                                        Tuple2 tuple23;
                                        Option lower = (Option)tuple2._1();
                                        Option upper = (Option)tuple2._2();
                                        Tuple2 tuple24 = tuple23 = new Tuple2((Object)lower, (Object)upper);
                                        Option lower2 = (Option)tuple24._1();
                                        Option upper2 = (Option)tuple24._2();
                                        Bounds<T> bounds = new Bounds<T>(lower2, upper2, false);
                                        return new FilterValues<Bounds<T>>((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Bounds[]{bounds})), FilterValues$.MODULE$.apply$default$2());
                                    }
                                    throw new MatchError((Object)tuple2);
                                }
                                {
                                    this.prop$6 = prop$6;
                                }
                            });
                        }
                        {
                            this.binding$1 = binding$1;
                        }
                    }).getOrElse((Function0)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final FilterValues<Bounds<T>> apply() {
                            return FilterValues$.MODULE$.empty();
                        }
                    });
                }
                if (filter2 instanceof PropertyIsLike) {
                    propertyIsLike = (PropertyIsLike)filter2;
                    Class<T> clazz = binding;
                    Class<String> clazz2 = String.class;
                    if (!(clazz != null ? !clazz.equals(clazz2) : clazz2 != null)) {
                        String prop3;
                        String string = prop3 = ((PropertyName)propertyIsLike.getExpression()).getPropertyName();
                        String string3 = attribute;
                        if (!(string != null ? !string.equals(string3) : string3 != null)) {
                            String literal = propertyIsLike.getLiteral();
                            String lower = literal.endsWith(package$.MODULE$.MULTICHAR_WILDCARD()) ? literal.substring(0, literal.length() - package$.MODULE$.MULTICHAR_WILDCARD().length()) : literal;
                            Some upper = new Some((Object)new StringBuilder().append((Object)lower).append((Object)package$.MODULE$.WILDCARD_SUFFIX()).toString());
                            Bounds bounds = new Bounds(new Some((Object)lower), upper, true);
                            filterValues2 = new FilterValues((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Bounds[]{bounds})), FilterValues$.MODULE$.apply$default$2());
                            return filterValues2;
                        }
                        filterValues2 = FilterValues$.MODULE$.empty();
                        return filterValues2;
                    }
                }
                if (!(filter2 instanceof Not)) break block37;
                bl = true;
                not = (Not)filter2;
                if (!(not.getFilter() instanceof PropertyIsNull)) break block37;
                try {}
                catch (Exception exception) {
                    BoxedUnit boxedUnit;
                    if (FilterHelper$FilterHelperLogger$.MODULE$.log().underlying().isWarnEnabled()) {
                        FilterHelper$FilterHelperLogger$.MODULE$.log().underlying().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to extract bounds from filter '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{package$.MODULE$.filterToString((Filter)not)})), (Throwable)exception);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    filterValues = FilterValues$.MODULE$.empty();
                    return filterValues;
                }
                break block38;
                catch (Exception exception) {
                    BoxedUnit boxedUnit;
                    if (FilterHelper$FilterHelperLogger$.MODULE$.log().underlying().isWarnEnabled()) {
                        FilterHelper$FilterHelperLogger$.MODULE$.log().underlying().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to extract bounds from filter '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{package$.MODULE$.filterToString((Filter)propertyIsLike)})), (Throwable)exception);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    filterValues2 = FilterValues$.MODULE$.empty();
                }
                return filterValues2;
                catch (Exception exception) {
                    BoxedUnit boxedUnit;
                    if (FilterHelper$FilterHelperLogger$.MODULE$.log().underlying().isWarnEnabled()) {
                        FilterHelper$FilterHelperLogger$.MODULE$.log().underlying().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to extract bounds from filter '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{package$.MODULE$.filterToString((Filter)propertyIsBetween)})), (Throwable)exception);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    filterValues3 = FilterValues$.MODULE$.empty();
                }
                return filterValues3;
            }
            PropertyIsNull isNull = (PropertyIsNull)not.getFilter();
            String string = prop = ((PropertyName)isNull.getExpression()).getPropertyName();
            String string4 = attribute;
            if (!(string != null ? !string.equals(string4) : string4 != null)) {
                Bounds bounds = new Bounds(None$.MODULE$, None$.MODULE$, true);
                filterValues = new FilterValues((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Bounds[]{bounds})), FilterValues$.MODULE$.apply$default$2());
                return filterValues;
            } else {
                filterValues = FilterValues$.MODULE$.empty();
            }
            return filterValues;
        }
        if (bl) {
            FilterValues filterValues;
            FilterValues inverted = this.extractAttributeBounds(not.getFilter(), attribute, binding, this.extractAttributeBounds$default$4());
            if (inverted.isEmpty()) {
                filterValues = inverted;
                return filterValues;
            } else if (inverted.disjoint()) {
                filterValues = new FilterValues((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Bounds[]{new Bounds(None$.MODULE$, None$.MODULE$, true)})), FilterValues$.MODULE$.apply$default$2());
                return filterValues;
            } else {
                Seq uninverted = (Seq)inverted.values().map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final FilterValues<Bounds<T>> apply(Bounds<T> bound) {
                        Tuple2<Option<T>, Option<T>> tuple2;
                        block6: {
                            Seq seq;
                            block3: {
                                block5: {
                                    block4: {
                                        block2: {
                                            tuple2 = bound.bounds();
                                            if (tuple2 == null) break block2;
                                            Option option = (Option)tuple2._1();
                                            Option option2 = (Option)tuple2._2();
                                            if (!None$.MODULE$.equals(option) || !None$.MODULE$.equals(option2)) break block2;
                                            seq = (Seq)Seq$.MODULE$.empty();
                                            break block3;
                                        }
                                        if (tuple2 == null) break block4;
                                        Option option = (Option)tuple2._1();
                                        Option option3 = (Option)tuple2._2();
                                        if (!(option instanceof Some)) break block4;
                                        Some some = (Some)option;
                                        Object lo = some.x();
                                        if (!None$.MODULE$.equals(option3)) break block4;
                                        seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Bounds[]{new Bounds<T>(None$.MODULE$, new Some(lo), !bound.inclusive())}));
                                        break block3;
                                    }
                                    if (tuple2 == null) break block5;
                                    Option option = (Option)tuple2._1();
                                    Option option4 = (Option)tuple2._2();
                                    if (!None$.MODULE$.equals(option) || !(option4 instanceof Some)) break block5;
                                    Some some = (Some)option4;
                                    Object hi = some.x();
                                    seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Bounds[]{new Bounds<T>(new Some(hi), None$.MODULE$, !bound.inclusive())}));
                                    break block3;
                                }
                                if (tuple2 == null) break block6;
                                Option option = (Option)tuple2._1();
                                Option option5 = (Option)tuple2._2();
                                if (!(option instanceof Some)) break block6;
                                Some some = (Some)option;
                                Object lo = some.x();
                                if (!(option5 instanceof Some)) break block6;
                                Some some2 = (Some)option5;
                                Object hi = some2.x();
                                seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Bounds[]{new Bounds<T>(None$.MODULE$, new Some(lo), !bound.inclusive()), new Bounds<T>(new Some(hi), None$.MODULE$, !bound.inclusive())}));
                            }
                            Seq not = seq;
                            return new FilterValues<Bounds<T>>(not, FilterValues$.MODULE$.apply$default$2());
                        }
                        throw new MatchError(tuple2);
                    }
                }, Seq$.MODULE$.canBuildFrom());
                Serializable serializable = new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final Option<Bounds<T>> apply(Bounds<T> left, Bounds<T> right) {
                        return Bounds$.MODULE$.intersection(left, right);
                    }
                };
                Serializable intersect2 = new Serializable((Function2)serializable){
                    public static final long serialVersionUID = 0L;
                    private final Function2 eta$0$5$1;

                    public final FilterValues<Bounds<T>> apply(FilterValues<Bounds<T>> left, FilterValues<Bounds<T>> right) {
                        return FilterValues$.MODULE$.and(this.eta$0$5$1, left, right);
                    }
                    {
                        this.eta$0$5$1 = eta$0$5$1;
                    }
                };
                filterValues = (FilterValues)uninverted.reduceLeft((Function2)intersect2);
            }
            return filterValues;
        }
        if (!(filter2 instanceof TEquals)) return FilterValues$.MODULE$.empty();
        TEquals tEquals = (TEquals)filter2;
        return (FilterValues)package$.MODULE$.checkOrder(tEquals.getExpression1(), tEquals.getExpression2()).filter((Function1)new Serializable(attribute){
            public static final long serialVersionUID = 0L;
            private final String attribute$2;

            public final boolean apply(PropertyLiteral x$38) {
                String string = x$38.name();
                String string2 = this.attribute$2;
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
            {
                this.attribute$2 = attribute$2;
            }
        }).flatMap((Function1)new Serializable(binding){
            public static final long serialVersionUID = 0L;
            private final Class binding$1;

            public final Option<FilterValues<Bounds<T>>> apply(PropertyLiteral prop) {
                return Option$.MODULE$.apply(prop.literal().evaluate(null, this.binding$1)).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final FilterValues<Bounds<T>> apply(T lit) {
                        Bounds<T> bounds = new Bounds<T>(new Some(lit), new Some(lit), true);
                        return new FilterValues<Bounds<T>>((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Bounds[]{bounds})), FilterValues$.MODULE$.apply$default$2());
                    }
                });
            }
            {
                this.binding$1 = binding$1;
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final FilterValues<Bounds<T>> apply() {
                return FilterValues$.MODULE$.empty();
            }
        });
    }

    public <T> boolean extractAttributeBounds$default$4() {
        return true;
    }

    public Seq<String> propertyNames(Filter filter, SimpleFeatureType sft) {
        return (Seq)((SetLike)JavaConversions$.MODULE$.asScalaSet(DataUtilities.propertyNames((Filter)filter, (SimpleFeatureType)sft)).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(PropertyName x$39) {
                return x$39.getPropertyName();
            }
        }, Set$.MODULE$.canBuildFrom())).toSeq().sorted((Ordering)Ordering.String$.MODULE$);
    }

    public boolean hasIdFilter(Filter filter) {
        return BoxesRunTime.unboxToBoolean((Object)filter.accept((FilterVisitor)new IdDetectingFilterVisitor(), (Object)BoxesRunTime.boxToBoolean((boolean)false)));
    }

    public Option<Filter> filterListAsAnd(Seq<Filter> filters) {
        return package$.MODULE$.andOption(filters, (FilterFactory)package$.MODULE$.ff());
    }

    public Filter simplify(Filter filter) {
        return this.flatten(this.org$locationtech$geomesa$filter$FilterHelper$$deduplicateOrs$1(this.flatten(filter)));
    }

    public Filter flatten(Filter filter) {
        Filter filter2;
        block5: {
            Filter filter3;
            block3: {
                Filter filter4;
                block4: {
                    block2: {
                        filter2 = filter;
                        if (!(filter2 instanceof And)) break block2;
                        And and2 = (And)filter2;
                        filter3 = package$.MODULE$.ff().and(JavaConversions$.MODULE$.bufferAsJavaList(this.flattenAnd((Seq<Filter>)JavaConversions$.MODULE$.asScalaBuffer(and2.getChildren()))));
                        break block3;
                    }
                    if (!(filter2 instanceof Or)) break block4;
                    Or or2 = (Or)filter2;
                    filter3 = package$.MODULE$.ff().or(JavaConversions$.MODULE$.bufferAsJavaList(this.flattenOr((Seq<Filter>)JavaConversions$.MODULE$.asScalaBuffer(or2.getChildren()))));
                    break block3;
                }
                if (filter2 == null) break block5;
                filter3 = filter4 = filter2;
            }
            return filter3;
        }
        throw new MatchError((Object)filter2);
    }

    /*
     * WARNING - void declaration
     */
    private ListBuffer<Filter> flattenAnd(Seq<Filter> filters) {
        void var3_3;
        ListBuffer remaining = (ListBuffer)((BufferLike)ListBuffer$.MODULE$.empty()).$plus$plus(filters);
        ListBuffer result = (ListBuffer)ListBuffer$.MODULE$.empty();
        do {
            BoxedUnit boxedUnit;
            Filter filter;
            if ((filter = (Filter)remaining.remove(0)) instanceof And) {
                And and2 = (And)filter;
                remaining.appendAll((TraversableOnce)JavaConversions$.MODULE$.asScalaBuffer(and2.getChildren()));
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            result.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Filter[]{this.flatten(filter)}));
            boxedUnit = BoxedUnit.UNIT;
        } while (remaining.nonEmpty());
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private ListBuffer<Filter> flattenOr(Seq<Filter> filters) {
        void var3_3;
        ListBuffer remaining = (ListBuffer)((BufferLike)ListBuffer$.MODULE$.empty()).$plus$plus(filters);
        ListBuffer result = (ListBuffer)ListBuffer$.MODULE$.empty();
        do {
            BoxedUnit boxedUnit;
            Filter filter;
            if ((filter = (Filter)remaining.remove(0)) instanceof Or) {
                Or or2 = (Or)filter;
                remaining.appendAll((TraversableOnce)JavaConversions$.MODULE$.asScalaBuffer(or2.getChildren()));
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            result.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Filter[]{this.flatten(filter)}));
            boxedUnit = BoxedUnit.UNIT;
        } while (remaining.nonEmpty());
        return var3_3;
    }

    public final Filter org$locationtech$geomesa$filter$FilterHelper$$deduplicateOrs$1(Filter f) {
        Filter filter;
        Filter filter2 = f;
        if (filter2 instanceof And) {
            And and2 = (And)filter2;
            filter = package$.MODULE$.ff().and(JavaConversions$.MODULE$.bufferAsJavaList((Buffer)JavaConversions$.MODULE$.asScalaBuffer(and2.getChildren()).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Filter apply(Filter f) {
                    return FilterHelper$.MODULE$.org$locationtech$geomesa$filter$FilterHelper$$deduplicateOrs$1(f);
                }
            }, Buffer$.MODULE$.canBuildFrom())));
        } else if (filter2 instanceof Or) {
            Or or2;
            Or or3 = (Or)filter2;
            Buffer decomposed = (Buffer)JavaConversions$.MODULE$.asScalaBuffer(or3.getChildren()).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Seq<Filter> apply(Filter f) {
                    return package$.MODULE$.decomposeAnd(f);
                }
            }, Buffer$.MODULE$.canBuildFrom());
            Seq clauses = (Seq)decomposed.head();
            Seq duplicates = (Seq)clauses.filter((Function1)new Serializable(decomposed){
                public static final long serialVersionUID = 0L;
                private final Buffer decomposed$1;

                public final boolean apply(Filter c) {
                    return ((IterableLike)this.decomposed$1.tail()).forall((Function1)new Serializable(this, c){
                        public static final long serialVersionUID = 0L;
                        private final Filter c$1;

                        public final boolean apply(Seq<Filter> x$40) {
                            return x$40.contains((Object)this.c$1);
                        }
                        {
                            this.c$1 = c$1;
                        }
                    });
                }
                {
                    this.decomposed$1 = decomposed$1;
                }
            });
            if (duplicates.isEmpty()) {
                or2 = or3;
            } else {
                Option<Filter> deduplicated = package$.MODULE$.orOption((Seq<Filter>)((Seq)decomposed.flatMap((Function1)new Serializable(duplicates){
                    public static final long serialVersionUID = 0L;
                    public final Seq duplicates$1;

                    public final Iterable<Filter> apply(Seq<Filter> d) {
                        return Option$.MODULE$.option2Iterable(package$.MODULE$.andOption((Seq<Filter>)((Seq)d.filterNot((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun.31 $outer;

                            public final boolean apply(Object elem) {
                                return this.$outer.duplicates$1.contains(elem);
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        })), (FilterFactory)package$.MODULE$.ff()));
                    }
                    {
                        this.duplicates$1 = duplicates$1;
                    }
                }, Buffer$.MODULE$.canBuildFrom())), (FilterFactory)package$.MODULE$.ff());
                or2 = package$.MODULE$.andFilters((Seq<Filter>)((Seq)Option$.MODULE$.option2Iterable(deduplicated).toSeq().$plus$plus((GenTraversableOnce)duplicates, Seq$.MODULE$.canBuildFrom())), (FilterFactory)package$.MODULE$.ff());
            }
            filter = or2;
        } else {
            filter = f;
        }
        return filter;
    }

    private FilterHelper$() {
        MODULE$ = this;
        this.MinDateTime = new DateTime(0, 1, 1, 0, 0, 0, DateTimeZone.UTC);
        this.MaxDateTime = new DateTime(9999, 12, 31, 23, 59, 59, DateTimeZone.UTC);
        this.SafeGeomString = "gm-safe";
    }
}

