/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.filter.function;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Point;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.locationtech.geomesa.filter.function.AxisOrder$;
import org.locationtech.geomesa.filter.function.BasicValues;
import org.locationtech.geomesa.filter.function.BinaryOutputEncoder;
import org.locationtech.geomesa.filter.function.BinaryOutputEncoder$;
import org.locationtech.geomesa.filter.function.BinaryOutputEncoder$GeometryAttribute$;
import org.locationtech.geomesa.filter.function.Convert2ViewerFunction$;
import org.locationtech.geomesa.filter.function.ExtendedValues;
import org.locationtech.geomesa.utils.collection.CloseableIterator;
import org.locationtech.geomesa.utils.collection.SelfClosingIterator$;
import org.locationtech.geomesa.utils.geotools.AttributeSpec;
import org.locationtech.geomesa.utils.geotools.Conversions;
import org.locationtech.geomesa.utils.geotools.Conversions$;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureSpecParser$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes$;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer$;
import scala.math.Ordering;
import scala.math.PartialOrdering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.VolatileByteRef;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class BinaryOutputEncoder$
implements LazyLogging {
    public static final BinaryOutputEncoder$ MODULE$;
    private final SimpleFeatureType BinEncodedSft;
    private final int BIN_ATTRIBUTE_INDEX;
    private final Map<String, BinaryOutputEncoder.EncodingOptions> CollectionEncodingOptions;
    private final Object ordering;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new BinaryOutputEncoder$();
    }

    private Logger logger$lzycompute() {
        BinaryOutputEncoder$ binaryOutputEncoder$ = this;
        synchronized (binaryOutputEncoder$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public SimpleFeatureType BinEncodedSft() {
        return this.BinEncodedSft;
    }

    public int BIN_ATTRIBUTE_INDEX() {
        return this.BIN_ATTRIBUTE_INDEX;
    }

    public Map<String, BinaryOutputEncoder.EncodingOptions> CollectionEncodingOptions() {
        return this.CollectionEncodingOptions;
    }

    public Object ordering() {
        return this.ordering;
    }

    public Function1<SimpleFeature, byte[]> encodeFeatures(SimpleFeatureType sft, BinaryOutputEncoder.EncodingOptions options) {
        Option<String> option;
        block4: {
            Either<Function1<SimpleFeature, Seq<BinaryOutputEncoder.ValuesToEncode>>, Function1<SimpleFeature, BinaryOutputEncoder.ValuesToEncode>> either;
            block7: {
                Object object;
                block6: {
                    Serializable encode;
                    block5: {
                        Object object2;
                        block3: {
                            block2: {
                                option = options.labelField();
                                if (!(option instanceof Some)) break block2;
                                object2 = new Serializable(){
                                    public static final long serialVersionUID = 0L;

                                    public final byte[] apply(BinaryOutputEncoder.ValuesToEncode v) {
                                        ExtendedValues toEncode = new ExtendedValues(v.lat(), v.lon(), v.dtg(), v.track(), v.label());
                                        return Convert2ViewerFunction$.MODULE$.encodeToByteArray(toEncode);
                                    }
                                };
                                break block3;
                            }
                            if (!None$.MODULE$.equals(option)) break block4;
                            object2 = new Serializable(){
                                public static final long serialVersionUID = 0L;

                                public final byte[] apply(BinaryOutputEncoder.ValuesToEncode v) {
                                    BasicValues toEncode = new BasicValues(v.lat(), v.lon(), v.dtg(), v.track());
                                    return Convert2ViewerFunction$.MODULE$.encodeToByteArray(toEncode);
                                }
                            };
                        }
                        encode = object2;
                        either = this.toValues(sft, options);
                        if (!(either instanceof Right)) break block5;
                        Right right = (Right)either;
                        Function1 toValue = (Function1)right.b();
                        object = new Serializable((Function1)encode, toValue){
                            public static final long serialVersionUID = 0L;
                            private final Function1 encode$1;
                            private final Function1 toValue$1;

                            public final byte[] apply(SimpleFeature sf) {
                                return (byte[])this.encode$1.apply(this.toValue$1.apply((Object)sf));
                            }
                            {
                                this.encode$1 = encode$1;
                                this.toValue$1 = toValue$1;
                            }
                        };
                        break block6;
                    }
                    if (!(either instanceof Left)) break block7;
                    Left left = (Left)either;
                    Function1 toValue = (Function1)left.a();
                    object = new Serializable((Function1)encode, toValue){
                        public static final long serialVersionUID = 0L;
                        public final Function1 encode$1;
                        private final Function1 toValue$2;

                        public final byte[] apply(SimpleFeature sf) {
                            return (byte[])((TraversableOnce)((TraversableLike)this.toValue$2.apply((Object)sf)).flatMap((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ anonfun.encodeFeatures.2 $outer;

                                public final ArrayOps<Object> apply(BinaryOutputEncoder.ValuesToEncode x$1) {
                                    return Predef$.MODULE$.byteArrayOps((byte[])this.$outer.encode$1.apply((Object)x$1));
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Byte());
                        }
                        {
                            this.encode$1 = encode$1;
                            this.toValue$2 = toValue$2;
                        }
                    };
                }
                return object;
            }
            throw new MatchError(either);
        }
        throw new MatchError(option);
    }

    public long encodeFeatureCollection(SimpleFeatureCollection fc, OutputStream output, BinaryOutputEncoder.EncodingOptions options, boolean sort) {
        return this.encodeFeatureIterator(fc.features(), (SimpleFeatureType)fc.getSchema(), output, options, sort);
    }

    public boolean encodeFeatureCollection$default$4() {
        return false;
    }

    public long encodeFeatureIterator(SimpleFeatureIterator sfi, SimpleFeatureType sft, OutputStream output, BinaryOutputEncoder.EncodingOptions options, boolean sort) {
        Either<Function1<SimpleFeature, Seq<BinaryOutputEncoder.ValuesToEncode>>, Function1<SimpleFeature, BinaryOutputEncoder.ValuesToEncode>> either;
        block7: {
            Option<String> option;
            block10: {
                Object object;
                CloseableIterator iter;
                block9: {
                    block8: {
                        CloseableIterator closeableIterator;
                        block6: {
                            block5: {
                                either = this.toValues(sft, options);
                                if (!(either instanceof Right)) break block5;
                                Right right = (Right)either;
                                Function1 toValue = (Function1)right.b();
                                closeableIterator = SelfClosingIterator$.MODULE$.apply(sfi).map(toValue);
                                break block6;
                            }
                            if (!(either instanceof Left)) break block7;
                            Left left = (Left)either;
                            Function1 toValue = (Function1)left.a();
                            closeableIterator = SelfClosingIterator$.MODULE$.apply(sfi).flatMap(toValue);
                        }
                        iter = closeableIterator;
                        option = options.labelField();
                        if (!(option instanceof Some)) break block8;
                        object = new Serializable(output){
                            public static final long serialVersionUID = 0L;
                            private final OutputStream output$1;

                            public final void apply(BinaryOutputEncoder.ValuesToEncode v) {
                                ExtendedValues toEncode = new ExtendedValues(v.lat(), v.lon(), v.dtg(), v.track(), v.label());
                                Convert2ViewerFunction$.MODULE$.encode(toEncode, this.output$1);
                            }
                            {
                                this.output$1 = output$1;
                            }
                        };
                        break block9;
                    }
                    if (!None$.MODULE$.equals(option)) break block10;
                    object = new Serializable(output){
                        public static final long serialVersionUID = 0L;
                        private final OutputStream output$1;

                        public final void apply(BinaryOutputEncoder.ValuesToEncode v) {
                            BasicValues toEncode = new BasicValues(v.lat(), v.lon(), v.dtg(), v.track());
                            Convert2ViewerFunction$.MODULE$.encode(toEncode, this.output$1);
                        }
                        {
                            this.output$1 = output$1;
                        }
                    };
                }
                Serializable encode = object;
                LongRef count = LongRef.create((long)0L);
                if (sort) {
                    ((List)iter.toList().sorted(this.ordering())).foreach((Function1)new Serializable((Function1)encode, count){
                        public static final long serialVersionUID = 0L;
                        private final Function1 encode$2;
                        private final LongRef count$1;

                        public final void apply(BinaryOutputEncoder.ValuesToEncode values) {
                            this.encode$2.apply((Object)values);
                            ++this.count$1.elem;
                        }
                        {
                            this.encode$2 = encode$2;
                            this.count$1 = count$1;
                        }
                    });
                } else {
                    iter.foreach((Function1)new Serializable((Function1)encode, count){
                        public static final long serialVersionUID = 0L;
                        private final Function1 encode$2;
                        private final LongRef count$1;

                        public final void apply(BinaryOutputEncoder.ValuesToEncode values) {
                            this.encode$2.apply((Object)values);
                            ++this.count$1.elem;
                        }
                        {
                            this.encode$2 = encode$2;
                            this.count$1 = count$1;
                        }
                    });
                }
                return count.elem;
            }
            throw new MatchError(option);
        }
        throw new MatchError(either);
    }

    public boolean encodeFeatureIterator$default$5() {
        return false;
    }

    private Either<Function1<SimpleFeature, Seq<BinaryOutputEncoder.ValuesToEncode>>, Function1<SimpleFeature, BinaryOutputEncoder.ValuesToEncode>> toValues(SimpleFeatureType sft, BinaryOutputEncoder.EncodingOptions options) {
        BinaryOutputEncoder.GeometrySelector geometrySelector;
        block7: {
            Tuple2.mcZZ.sp sp2;
            block8: {
                BinaryOutputEncoder.GeometrySelector geometrySelector2;
                block11: {
                    Tuple2 tuple2;
                    block16: {
                        Option<String> option;
                        block20: {
                            Option<String> option2;
                            block23: {
                                Object object;
                                Serializable getTrackId;
                                Serializable getLatLon;
                                Serializable getLineDtg;
                                Serializable getDtg;
                                boolean isLineString;
                                BinaryOutputEncoder.GeometrySelector geomField;
                                VolatileByteRef bitmap$0;
                                ObjectRef getLineLatLon$lzy;
                                block22: {
                                    block21: {
                                        Object object2;
                                        block18: {
                                            Some some;
                                            boolean bl;
                                            block19: {
                                                String trackId;
                                                block17: {
                                                    Object object3;
                                                    block10: {
                                                        Object object4;
                                                        block13: {
                                                            int geomIndex;
                                                            block15: {
                                                                block14: {
                                                                    block12: {
                                                                        boolean isPoint;
                                                                        block9: {
                                                                            Object object5;
                                                                            Class binding;
                                                                            Tuple2.mcZZ.sp sp3;
                                                                            Tuple2.mcZZ.sp sp4;
                                                                            String dtgField;
                                                                            block6: {
                                                                                Class binding2;
                                                                                block5: {
                                                                                    getLineLatLon$lzy = ObjectRef.zero();
                                                                                    bitmap$0 = VolatileByteRef.create((byte)0);
                                                                                    geomField = (BinaryOutputEncoder.GeometrySelector)options.geomField().getOrElse((Function0)new Serializable(sft){
                                                                                        public static final long serialVersionUID = 0L;
                                                                                        private final SimpleFeatureType sft$1;

                                                                                        public final BinaryOutputEncoder.GeometryAttribute apply() {
                                                                                            return new BinaryOutputEncoder.GeometryAttribute(this.sft$1.getGeometryDescriptor().getLocalName(), BinaryOutputEncoder$GeometryAttribute$.MODULE$.apply$default$2());
                                                                                        }
                                                                                        {
                                                                                            this.sft$1 = sft$1;
                                                                                        }
                                                                                    });
                                                                                    dtgField = (String)options.dtgField().orElse((Function0)new Serializable(sft){
                                                                                        public static final long serialVersionUID = 0L;
                                                                                        private final SimpleFeatureType sft$1;

                                                                                        public final Option<String> apply() {
                                                                                            return RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getDtgField$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(this.sft$1));
                                                                                        }
                                                                                        {
                                                                                            this.sft$1 = sft$1;
                                                                                        }
                                                                                    }).orNull(Predef$.MODULE$.$conforms());
                                                                                    geometrySelector = geomField;
                                                                                    if (!(geometrySelector instanceof BinaryOutputEncoder.LatLonAttributes)) break block5;
                                                                                    sp4 = new Tuple2.mcZZ.sp(true, false);
                                                                                    break block6;
                                                                                }
                                                                                if (!(geometrySelector instanceof BinaryOutputEncoder.GeometryAttribute)) break block7;
                                                                                BinaryOutputEncoder.GeometryAttribute geometryAttribute = (BinaryOutputEncoder.GeometryAttribute)geometrySelector;
                                                                                String geom = geometryAttribute.geom();
                                                                                Class clazz = binding2 = (Class)Option$.MODULE$.apply((Object)sft.getDescriptor(geom)).map((Function1)new Serializable(){
                                                                                    public static final long serialVersionUID = 0L;

                                                                                    public final Class<?> apply(AttributeDescriptor x$2) {
                                                                                        return x$2.getType().getBinding();
                                                                                    }
                                                                                }).orNull(Predef$.MODULE$.$conforms());
                                                                                Class<Point> clazz2 = Point.class;
                                                                                Class clazz3 = binding2;
                                                                                Class<LineString> clazz4 = LineString.class;
                                                                                sp4 = new Tuple2.mcZZ.sp(!(clazz != null ? !clazz.equals(clazz2) : clazz2 != null), !(clazz3 != null ? !clazz3.equals(clazz4) : clazz4 != null));
                                                                            }
                                                                            sp2 = sp4;
                                                                            if (sp2 == null) break block8;
                                                                            boolean isPoint2 = sp2._1$mcZ$sp();
                                                                            boolean isLineString2 = sp2._2$mcZ$sp();
                                                                            Tuple2.mcZZ.sp sp5 = sp3 = new Tuple2.mcZZ.sp(isPoint2, isLineString2);
                                                                            isPoint = sp5._1$mcZ$sp();
                                                                            isLineString = sp5._2$mcZ$sp();
                                                                            this.validateGeometryAttribute(sft, geomField);
                                                                            this.validateDateAttribute(sft, isLineString, dtgField);
                                                                            this.validateLabels(sft, options.trackIdField(), options.labelField());
                                                                            int dtgIndex = sft.indexOf(dtgField);
                                                                            getDtg = new Serializable(dtgIndex){
                                                                                public static final long serialVersionUID = 0L;
                                                                                private final int dtgIndex$1;

                                                                                public final long apply(SimpleFeature f) {
                                                                                    Date date = (Date)f.getAttribute(this.dtgIndex$1);
                                                                                    return date == null ? 0L : date.getTime();
                                                                                }
                                                                                {
                                                                                    this.dtgIndex$1 = dtgIndex$1;
                                                                                }
                                                                            };
                                                                            getLineDtg = new Serializable(dtgIndex){
                                                                                public static final long serialVersionUID = 0L;
                                                                                private final int dtgIndex$1;

                                                                                public final long[] apply(SimpleFeature f) {
                                                                                    java.util.List dates = (java.util.List)f.getAttribute(this.dtgIndex$1);
                                                                                    return dates == null ? (long[])Array$.MODULE$.empty(ClassTag$.MODULE$.Long()) : (long[])((TraversableOnce)JavaConversions$.MODULE$.asScalaBuffer(dates).map((Function1)new Serializable(this){
                                                                                        public static final long serialVersionUID = 0L;

                                                                                        public final long apply(Date x$4) {
                                                                                            return x$4.getTime();
                                                                                        }
                                                                                    }, Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Long());
                                                                                }
                                                                                {
                                                                                    this.dtgIndex$1 = dtgIndex$1;
                                                                                }
                                                                            };
                                                                            geometrySelector2 = geomField;
                                                                            if (!(geometrySelector2 instanceof BinaryOutputEncoder.LatLonAttributes)) break block9;
                                                                            BinaryOutputEncoder.LatLonAttributes latLonAttributes = (BinaryOutputEncoder.LatLonAttributes)geometrySelector2;
                                                                            String lat = latLonAttributes.lat();
                                                                            String lon = latLonAttributes.lon();
                                                                            int latIndex = sft.indexOf(lat);
                                                                            int lonIndex = sft.indexOf(lon);
                                                                            Class clazz = binding = sft.getType(latIndex).getBinding();
                                                                            Class<Float> clazz5 = Float.class;
                                                                            if (!(clazz != null ? !clazz.equals(clazz5) : clazz5 != null)) {
                                                                                object5 = new Serializable(latIndex, lonIndex){
                                                                                    public static final long serialVersionUID = 0L;
                                                                                    private final int latIndex$1;
                                                                                    private final int lonIndex$1;

                                                                                    public final Tuple2<Object, Object> apply(SimpleFeature f) {
                                                                                        return new Tuple2((Object)BoxesRunTime.boxToFloat((float)BoxesRunTime.unboxToFloat((Object)f.getAttribute(this.latIndex$1))), (Object)BoxesRunTime.boxToFloat((float)BoxesRunTime.unboxToFloat((Object)f.getAttribute(this.lonIndex$1))));
                                                                                    }
                                                                                    {
                                                                                        this.latIndex$1 = latIndex$1;
                                                                                        this.lonIndex$1 = lonIndex$1;
                                                                                    }
                                                                                };
                                                                            } else {
                                                                                Class clazz6 = binding;
                                                                                Class<Double> clazz7 = Double.class;
                                                                                object5 = !(clazz6 != null ? !clazz6.equals(clazz7) : clazz7 != null) ? new Serializable(latIndex, lonIndex){
                                                                                    public static final long serialVersionUID = 0L;
                                                                                    private final int latIndex$1;
                                                                                    private final int lonIndex$1;

                                                                                    public final Tuple2<Object, Object> apply(SimpleFeature f) {
                                                                                        return new Tuple2((Object)BoxesRunTime.boxToFloat((float)((float)BoxesRunTime.unboxToDouble((Object)f.getAttribute(this.latIndex$1)))), (Object)BoxesRunTime.boxToFloat((float)((float)BoxesRunTime.unboxToDouble((Object)f.getAttribute(this.lonIndex$1)))));
                                                                                    }
                                                                                    {
                                                                                        this.latIndex$1 = latIndex$1;
                                                                                        this.lonIndex$1 = lonIndex$1;
                                                                                    }
                                                                                } : new Serializable(latIndex, lonIndex){
                                                                                    public static final long serialVersionUID = 0L;
                                                                                    private final int latIndex$1;
                                                                                    private final int lonIndex$1;

                                                                                    public final Tuple2<Object, Object> apply(SimpleFeature f) {
                                                                                        return new Tuple2((Object)BoxesRunTime.boxToFloat((float)new StringOps(Predef$.MODULE$.augmentString(f.getAttribute(this.latIndex$1).toString())).toFloat()), (Object)BoxesRunTime.boxToFloat((float)new StringOps(Predef$.MODULE$.augmentString(f.getAttribute(this.lonIndex$1).toString())).toFloat()));
                                                                                    }
                                                                                    {
                                                                                        this.latIndex$1 = latIndex$1;
                                                                                        this.lonIndex$1 = lonIndex$1;
                                                                                    }
                                                                                };
                                                                            }
                                                                            object3 = object5;
                                                                            break block10;
                                                                        }
                                                                        if (!(geometrySelector2 instanceof BinaryOutputEncoder.GeometryAttribute)) break block11;
                                                                        BinaryOutputEncoder.GeometryAttribute geometryAttribute = (BinaryOutputEncoder.GeometryAttribute)geometrySelector2;
                                                                        String geom = geometryAttribute.geom();
                                                                        Enumeration.Value axisOrder = geometryAttribute.axisOrder();
                                                                        geomIndex = sft.indexOf(geom);
                                                                        tuple2 = new Tuple2((Object)axisOrder, (Object)BoxesRunTime.boxToBoolean((boolean)isPoint));
                                                                        if (tuple2 == null) break block12;
                                                                        Enumeration.Value value = (Enumeration.Value)tuple2._1();
                                                                        boolean bl2 = tuple2._2$mcZ$sp();
                                                                        Enumeration.Value value2 = AxisOrder$.MODULE$.LatLon();
                                                                        Enumeration.Value value3 = value;
                                                                        if ((value2 != null ? !value2.equals(value3) : value3 != null) || !bl2) break block12;
                                                                        object4 = new Serializable(geomIndex){
                                                                            public static final long serialVersionUID = 0L;
                                                                            private final int geomIndex$1;

                                                                            public final Tuple2<Object, Object> apply(SimpleFeature f) {
                                                                                return BinaryOutputEncoder$.MODULE$.org$locationtech$geomesa$filter$function$BinaryOutputEncoder$$pointToXY((Point)f.getAttribute(this.geomIndex$1));
                                                                            }
                                                                            {
                                                                                this.geomIndex$1 = geomIndex$1;
                                                                            }
                                                                        };
                                                                        break block13;
                                                                    }
                                                                    if (tuple2 == null) break block14;
                                                                    Enumeration.Value value = (Enumeration.Value)tuple2._1();
                                                                    boolean bl3 = tuple2._2$mcZ$sp();
                                                                    Enumeration.Value value4 = AxisOrder$.MODULE$.LatLon();
                                                                    Enumeration.Value value5 = value;
                                                                    if ((value4 != null ? !value4.equals(value5) : value5 != null) || bl3) break block14;
                                                                    object4 = new Serializable(geomIndex){
                                                                        public static final long serialVersionUID = 0L;
                                                                        private final int geomIndex$1;

                                                                        public final Tuple2<Object, Object> apply(SimpleFeature f) {
                                                                            return BinaryOutputEncoder$.MODULE$.org$locationtech$geomesa$filter$function$BinaryOutputEncoder$$pointToXY(Conversions.RichGeometry$.MODULE$.safeCentroid$extension(Conversions$.MODULE$.RichGeometry((Geometry)f.getAttribute(this.geomIndex$1))));
                                                                        }
                                                                        {
                                                                            this.geomIndex$1 = geomIndex$1;
                                                                        }
                                                                    };
                                                                    break block13;
                                                                }
                                                                if (tuple2 == null) break block15;
                                                                Enumeration.Value value = (Enumeration.Value)tuple2._1();
                                                                boolean bl4 = tuple2._2$mcZ$sp();
                                                                Enumeration.Value value6 = AxisOrder$.MODULE$.LonLat();
                                                                Enumeration.Value value7 = value;
                                                                if ((value6 != null ? !value6.equals(value7) : value7 != null) || !bl4) break block15;
                                                                object4 = new Serializable(geomIndex){
                                                                    public static final long serialVersionUID = 0L;
                                                                    private final int geomIndex$1;

                                                                    public final Tuple2<Object, Object> apply(SimpleFeature f) {
                                                                        return BinaryOutputEncoder$.MODULE$.org$locationtech$geomesa$filter$function$BinaryOutputEncoder$$pointToXY((Point)f.getAttribute(this.geomIndex$1)).swap();
                                                                    }
                                                                    {
                                                                        this.geomIndex$1 = geomIndex$1;
                                                                    }
                                                                };
                                                                break block13;
                                                            }
                                                            if (tuple2 == null) break block16;
                                                            Enumeration.Value value = (Enumeration.Value)tuple2._1();
                                                            boolean bl5 = tuple2._2$mcZ$sp();
                                                            Enumeration.Value value8 = AxisOrder$.MODULE$.LonLat();
                                                            Enumeration.Value value9 = value;
                                                            if ((value8 != null ? !value8.equals(value9) : value9 != null) || bl5) break block16;
                                                            object4 = new Serializable(geomIndex){
                                                                public static final long serialVersionUID = 0L;
                                                                private final int geomIndex$1;

                                                                public final Tuple2<Object, Object> apply(SimpleFeature f) {
                                                                    return BinaryOutputEncoder$.MODULE$.org$locationtech$geomesa$filter$function$BinaryOutputEncoder$$pointToXY(Conversions.RichGeometry$.MODULE$.safeCentroid$extension(Conversions$.MODULE$.RichGeometry((Geometry)f.getAttribute(this.geomIndex$1)))).swap();
                                                                }
                                                                {
                                                                    this.geomIndex$1 = geomIndex$1;
                                                                }
                                                            };
                                                        }
                                                        object3 = object4;
                                                    }
                                                    getLatLon = object3;
                                                    bl = false;
                                                    some = null;
                                                    option = options.trackIdField();
                                                    if (!None$.MODULE$.equals(option)) break block17;
                                                    object2 = new Serializable(){
                                                        public static final long serialVersionUID = 0L;

                                                        public final int apply(SimpleFeature f) {
                                                            return f.getID().hashCode();
                                                        }
                                                    };
                                                    break block18;
                                                }
                                                if (!(option instanceof Some)) break block19;
                                                bl = true;
                                                some = (Some)option;
                                                String string = trackId = (String)some.x();
                                                String string2 = "id";
                                                if (string != null ? !string.equals(string2) : string2 != null) break block19;
                                                object2 = new Serializable(){
                                                    public static final long serialVersionUID = 0L;

                                                    public final int apply(SimpleFeature f) {
                                                        return f.getID().hashCode();
                                                    }
                                                };
                                                break block18;
                                            }
                                            if (!bl) break block20;
                                            String trackId = (String)some.x();
                                            int trackIndex = sft.indexOf(trackId);
                                            object2 = new Serializable(trackIndex){
                                                public static final long serialVersionUID = 0L;
                                                private final int trackIndex$1;

                                                public final int apply(SimpleFeature f) {
                                                    Object track = f.getAttribute(this.trackIndex$1);
                                                    return track == null ? 0 : track.hashCode();
                                                }
                                                {
                                                    this.trackIndex$1 = trackIndex$1;
                                                }
                                            };
                                        }
                                        getTrackId = object2;
                                        option2 = options.labelField();
                                        if (!(option2 instanceof Some)) break block21;
                                        Some some = (Some)option2;
                                        String label = (String)some.x();
                                        int labelIndex = sft.indexOf(label);
                                        object = new Serializable(labelIndex){
                                            public static final long serialVersionUID = 0L;
                                            private final int labelIndex$1;

                                            public final long apply(SimpleFeature f) {
                                                Object label = f.getAttribute(this.labelIndex$1);
                                                return label == null ? 0L : Convert2ViewerFunction$.MODULE$.convertToLabel(label.toString());
                                            }
                                            {
                                                this.labelIndex$1 = labelIndex$1;
                                            }
                                        };
                                        break block22;
                                    }
                                    if (!None$.MODULE$.equals(option2)) break block23;
                                    object = new Serializable(){
                                        public static final long serialVersionUID = 0L;

                                        public final long apply(SimpleFeature x$6) {
                                            return 0L;
                                        }
                                    };
                                }
                                Serializable getLabel = object;
                                return isLineString ? package$.MODULE$.Left().apply((Object)new Serializable(sft, geomField, (Function1)getLineDtg, getLineLatLon$lzy, (Function1)getTrackId, (Function1)getLabel, bitmap$0){
                                    public static final long serialVersionUID = 0L;
                                    private final SimpleFeatureType sft$1;
                                    private final BinaryOutputEncoder.GeometrySelector geomField$1;
                                    private final Function1 getLineDtg$1;
                                    private final ObjectRef getLineLatLon$lzy$1;
                                    private final Function1 getTrackId$1;
                                    private final Function1 getLabel$1;
                                    private final VolatileByteRef bitmap$0$1;

                                    public final Seq<BinaryOutputEncoder.ValuesToEncode> apply(SimpleFeature sf) {
                                        Seq seq;
                                        long[] dates;
                                        Tuple2[] points = (Tuple2[])BinaryOutputEncoder$.MODULE$.org$locationtech$geomesa$filter$function$BinaryOutputEncoder$$getLineLatLon$1(this.sft$1, this.geomField$1, this.getLineLatLon$lzy$1, this.bitmap$0$1).apply((Object)sf);
                                        if (points.length != (dates = (long[])this.getLineDtg$1.apply((Object)sf)).length) {
                                            BoxedUnit boxedUnit;
                                            if (BinaryOutputEncoder$.MODULE$.logger().underlying().isWarnEnabled()) {
                                                BinaryOutputEncoder$.MODULE$.logger().underlying().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Mismatched geometries and dates for simple feature ", " - skipping"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sf.getID()})));
                                                boxedUnit = BoxedUnit.UNIT;
                                            } else {
                                                boxedUnit = BoxedUnit.UNIT;
                                            }
                                            seq = (Seq)Seq$.MODULE$.empty();
                                        } else {
                                            int trackId = BoxesRunTime.unboxToInt((Object)this.getTrackId$1.apply((Object)sf));
                                            long label = BoxesRunTime.unboxToLong((Object)this.getLabel$1.apply((Object)sf));
                                            seq = (Seq)Predef$.MODULE$.refArrayOps((Object[])points).indices().map((Function1)new Serializable(this, points, dates, trackId, label){
                                                public static final long serialVersionUID = 0L;
                                                private final Tuple2[] points$1;
                                                private final long[] dates$1;
                                                private final int trackId$1;
                                                private final long label$1;

                                                public final BinaryOutputEncoder.ValuesToEncode apply(int i) {
                                                    Tuple2 tuple2 = this.points$1[i];
                                                    if (tuple2 != null) {
                                                        Tuple2 tuple22;
                                                        float lat = BoxesRunTime.unboxToFloat((Object)tuple2._1());
                                                        float lon = BoxesRunTime.unboxToFloat((Object)tuple2._2());
                                                        Tuple2 tuple23 = tuple22 = new Tuple2((Object)BoxesRunTime.boxToFloat((float)lat), (Object)BoxesRunTime.boxToFloat((float)lon));
                                                        float lat2 = BoxesRunTime.unboxToFloat((Object)tuple23._1());
                                                        float lon2 = BoxesRunTime.unboxToFloat((Object)tuple23._2());
                                                        return new BinaryOutputEncoder.ValuesToEncode(lat2, lon2, this.dates$1[i], this.trackId$1, this.label$1);
                                                    }
                                                    throw new MatchError((Object)tuple2);
                                                }
                                                {
                                                    this.points$1 = points$1;
                                                    this.dates$1 = dates$1;
                                                    this.trackId$1 = trackId$1;
                                                    this.label$1 = label$1;
                                                }
                                            }, IndexedSeq$.MODULE$.canBuildFrom());
                                        }
                                        return seq;
                                    }
                                    {
                                        this.sft$1 = sft$1;
                                        this.geomField$1 = geomField$1;
                                        this.getLineDtg$1 = getLineDtg$1;
                                        this.getLineLatLon$lzy$1 = getLineLatLon$lzy$1;
                                        this.getTrackId$1 = getTrackId$1;
                                        this.getLabel$1 = getLabel$1;
                                        this.bitmap$0$1 = bitmap$0$1;
                                    }
                                }) : package$.MODULE$.Right().apply((Object)new Serializable((Function1)getDtg, (Function1)getLatLon, (Function1)getTrackId, (Function1)getLabel){
                                    public static final long serialVersionUID = 0L;
                                    private final Function1 getDtg$1;
                                    private final Function1 getLatLon$1;
                                    private final Function1 getTrackId$1;
                                    private final Function1 getLabel$1;

                                    public final BinaryOutputEncoder.ValuesToEncode apply(SimpleFeature sf) {
                                        Tuple2 tuple2 = (Tuple2)this.getLatLon$1.apply((Object)sf);
                                        if (tuple2 != null) {
                                            Tuple2 tuple22;
                                            float lat = BoxesRunTime.unboxToFloat((Object)tuple2._1());
                                            float lon = BoxesRunTime.unboxToFloat((Object)tuple2._2());
                                            Tuple2 tuple23 = tuple22 = new Tuple2((Object)BoxesRunTime.boxToFloat((float)lat), (Object)BoxesRunTime.boxToFloat((float)lon));
                                            float lat2 = BoxesRunTime.unboxToFloat((Object)tuple23._1());
                                            float lon2 = BoxesRunTime.unboxToFloat((Object)tuple23._2());
                                            long dtg = BoxesRunTime.unboxToLong((Object)this.getDtg$1.apply((Object)sf));
                                            int trackId = BoxesRunTime.unboxToInt((Object)this.getTrackId$1.apply((Object)sf));
                                            long label = BoxesRunTime.unboxToLong((Object)this.getLabel$1.apply((Object)sf));
                                            return new BinaryOutputEncoder.ValuesToEncode(lat2, lon2, dtg, trackId, label);
                                        }
                                        throw new MatchError((Object)tuple2);
                                    }
                                    {
                                        this.getDtg$1 = getDtg$1;
                                        this.getLatLon$1 = getLatLon$1;
                                        this.getTrackId$1 = getTrackId$1;
                                        this.getLabel$1 = getLabel$1;
                                    }
                                });
                            }
                            throw new MatchError(option2);
                        }
                        throw new MatchError(option);
                    }
                    throw new MatchError((Object)tuple2);
                }
                throw new MatchError((Object)geometrySelector2);
            }
            throw new MatchError((Object)sp2);
        }
        throw new MatchError((Object)geometrySelector);
    }

    public Tuple2<Object, Object> org$locationtech$geomesa$filter$function$BinaryOutputEncoder$$pointToXY(Point p) {
        return new Tuple2((Object)BoxesRunTime.boxToFloat((float)((float)p.getX())), (Object)BoxesRunTime.boxToFloat((float)((float)p.getY())));
    }

    private void validateGeometryAttribute(SimpleFeatureType sft, BinaryOutputEncoder.GeometrySelector selector) {
        BinaryOutputEncoder.GeometrySelector geometrySelector;
        block6: {
            boolean bl;
            block5: {
                block4: {
                    geometrySelector = selector;
                    if (!(geometrySelector instanceof BinaryOutputEncoder.LatLonAttributes)) break block4;
                    BinaryOutputEncoder.LatLonAttributes latLonAttributes = (BinaryOutputEncoder.LatLonAttributes)geometrySelector;
                    String lat = latLonAttributes.lat();
                    String lon = latLonAttributes.lon();
                    bl = sft.indexOf(lat) != -1 && sft.indexOf(lon) != -1;
                    break block5;
                }
                if (!(geometrySelector instanceof BinaryOutputEncoder.GeometryAttribute)) break block6;
                BinaryOutputEncoder.GeometryAttribute geometryAttribute = (BinaryOutputEncoder.GeometryAttribute)geometrySelector;
                String geom = geometryAttribute.geom();
                bl = sft.indexOf(geom) != -1;
            }
            boolean ok = bl;
            if (ok) {
                return;
            }
            throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid geometry fields ", " requested for feature type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{selector, sft})));
        }
        throw new MatchError((Object)geometrySelector);
    }

    private void validateDateAttribute(SimpleFeatureType sft, boolean isLineString, String dtgField) {
        Seq sftAttributes = SimpleFeatureSpecParser$.MODULE$.parse(SimpleFeatureTypes$.MODULE$.encodeType(sft, SimpleFeatureTypes$.MODULE$.encodeType$default$2()), SimpleFeatureSpecParser$.MODULE$.parse$default$2()).attributes();
        Option dateAttribute = sftAttributes.find((Function1)new Serializable(dtgField){
            public static final long serialVersionUID = 0L;
            private final String dtgField$1;

            public final boolean apply(AttributeSpec x$9) {
                String string = x$9.name();
                String string2 = this.dtgField$1;
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
            {
                this.dtgField$1 = dtgField$1;
            }
        });
        boolean ok = dateAttribute.exists((Function1)new Serializable(isLineString){
            public static final long serialVersionUID = 0L;
            private final boolean isLineString$1;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean apply(AttributeSpec spec) {
                if (this.isLineString$1) {
                    if (!(spec instanceof AttributeSpec.ListAttributeSpec)) return false;
                    Class clazz = ((AttributeSpec.ListAttributeSpec)spec).subClass();
                    Class<Date> clazz2 = Date.class;
                    if (clazz != null) {
                        if (!clazz.equals(clazz2)) return false;
                        return true;
                    }
                    if (clazz2 == null) return true;
                    return false;
                }
                Class clazz = spec.clazz();
                Class<Date> clazz3 = Date.class;
                if (clazz != null) {
                    if (!clazz.equals(clazz3)) return false;
                    return true;
                }
                if (clazz3 == null) return true;
                return false;
            }
            {
                this.isLineString$1 = isLineString$1;
            }
        });
        if (ok) {
            return;
        }
        throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid date field ", " requested for feature type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dtgField, sft})));
    }

    private void validateLabels(SimpleFeatureType sft, Option<String> trackId, Option<String> label) {
        boolean ok = ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Option[]{trackId, label})).flatten((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Iterable<String> apply(Option<String> xo) {
                return Option$.MODULE$.option2Iterable(xo);
            }
        })).forall((Function1)new Serializable(sft){
            public static final long serialVersionUID = 0L;
            private final SimpleFeatureType sft$2;

            public final boolean apply(String attr) {
                String string = attr;
                String string2 = "id";
                return !(string == null ? string2 != null : !string.equals(string2)) || this.sft$2.indexOf(attr) != -1;
            }
            {
                this.sft$2 = sft$2;
            }
        });
        if (ok) {
            return;
        }
        throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid fields ", " and/or ", " requested for feature type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{trackId, label, sft})));
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final Function1 getLineLatLon$lzycompute$1(SimpleFeatureType sft$1, BinaryOutputEncoder.GeometrySelector geomField$1, ObjectRef getLineLatLon$lzy$1, VolatileByteRef bitmap$0$1) {
        var5_5 = this;
        synchronized (var5_5) {
            block5: {
                block7: {
                    block6: {
                        if ((byte)(bitmap$0$1.elem & 1) != 0) break block5;
                        var6_6 = false;
                        var7_7 = null;
                        var8_8 = geomField$1;
                        if (!(var8_8 instanceof BinaryOutputEncoder.GeometryAttribute)) break block6;
                        var6_6 = true;
                        var7_7 = (BinaryOutputEncoder.GeometryAttribute)var8_8;
                        geom = var7_7.geom();
                        var10_10 = var7_7.axisOrder();
                        v0 = AxisOrder$.MODULE$.LatLon();
                        var11_11 = var10_10;
                        if (v0 != null ? v0.equals(var11_11) == false : var11_11 != null) break block6;
                        geomIndex = sft$1.indexOf(geom);
                        var12_13 /* !! */  = new Serializable(geomIndex){
                            public static final long serialVersionUID = 0L;
                            private final int geomIndex$2;

                            public final Tuple2<Object, Object>[] apply(SimpleFeature f) {
                                LineString geom = (LineString)f.getAttribute(this.geomIndex$2);
                                IndexedSeq points = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), geom.getNumPoints()).map((Function1)new Serializable(this, geom){
                                    public static final long serialVersionUID = 0L;
                                    private final LineString geom$1;

                                    public final Point apply(int x$1) {
                                        return this.geom$1.getPointN(x$1);
                                    }
                                    {
                                        this.geom$1 = geom$1;
                                    }
                                }, IndexedSeq$.MODULE$.canBuildFrom());
                                return (Tuple2[])((TraversableOnce)points.map((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final Tuple2<Object, Object> apply(Point p) {
                                        return BinaryOutputEncoder$.MODULE$.org$locationtech$geomesa$filter$function$BinaryOutputEncoder$$pointToXY(p);
                                    }
                                }, IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Tuple2.class));
                            }
                            {
                                this.geomIndex$2 = geomIndex$2;
                            }
                        };
                        break block7;
                    }
                    if (!var6_6) ** GOTO lbl-1000
                    geom = var7_7.geom();
                    var15_15 = var7_7.axisOrder();
                    v1 = AxisOrder$.MODULE$.LonLat();
                    var16_16 = var15_15;
                    if (v1 != null ? v1.equals(var16_16) == false : var16_16 != null) lbl-1000:
                    // 2 sources

                    {
                        throw new MatchError((Object)var8_8);
                    }
                    geomIndex = sft$1.indexOf(geom);
                    var12_13 /* !! */  = new Serializable(geomIndex){
                        public static final long serialVersionUID = 0L;
                        private final int geomIndex$3;

                        public final Tuple2<Object, Object>[] apply(SimpleFeature f) {
                            LineString geom = (LineString)f.getAttribute(this.geomIndex$3);
                            IndexedSeq points = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), geom.getNumPoints()).map((Function1)new Serializable(this, geom){
                                public static final long serialVersionUID = 0L;
                                private final LineString geom$2;

                                public final Point apply(int x$1) {
                                    return this.geom$2.getPointN(x$1);
                                }
                                {
                                    this.geom$2 = geom$2;
                                }
                            }, IndexedSeq$.MODULE$.canBuildFrom());
                            return (Tuple2[])((TraversableOnce)points.map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final Tuple2<Object, Object> apply(Point x$5) {
                                    return BinaryOutputEncoder$.MODULE$.org$locationtech$geomesa$filter$function$BinaryOutputEncoder$$pointToXY(x$5).swap();
                                }
                            }, IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Tuple2.class));
                        }
                        {
                            this.geomIndex$3 = geomIndex$3;
                        }
                    };
                }
                getLineLatLon$lzy$1.elem = var12_13 /* !! */ ;
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 1);
            }
            return (Function1)getLineLatLon$lzy$1.elem;
        }
    }

    public final Function1 org$locationtech$geomesa$filter$function$BinaryOutputEncoder$$getLineLatLon$1(SimpleFeatureType sft$1, BinaryOutputEncoder.GeometrySelector geomField$1, ObjectRef getLineLatLon$lzy$1, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 1) == 0 ? this.getLineLatLon$lzycompute$1(sft$1, geomField$1, getLineLatLon$lzy$1, bitmap$0$1) : (Function1)getLineLatLon$lzy$1.elem;
    }

    private BinaryOutputEncoder$() {
        MODULE$ = this;
        LazyLogging.class.$init$((LazyLogging)this);
        this.BinEncodedSft = SimpleFeatureTypes$.MODULE$.createType("bin", "bin:Bytes,*geom:Point:srid=4326");
        this.BIN_ATTRIBUTE_INDEX = 0;
        this.CollectionEncodingOptions = Collections.synchronizedMap(new HashMap());
        this.ordering = new Ordering<BinaryOutputEncoder.ValuesToEncode>(){

            public Some tryCompare(Object x, Object y) {
                return Ordering.class.tryCompare((Ordering)this, (Object)x, (Object)y);
            }

            public boolean lteq(Object x, Object y) {
                return Ordering.class.lteq((Ordering)this, (Object)x, (Object)y);
            }

            public boolean gteq(Object x, Object y) {
                return Ordering.class.gteq((Ordering)this, (Object)x, (Object)y);
            }

            public boolean lt(Object x, Object y) {
                return Ordering.class.lt((Ordering)this, (Object)x, (Object)y);
            }

            public boolean gt(Object x, Object y) {
                return Ordering.class.gt((Ordering)this, (Object)x, (Object)y);
            }

            public boolean equiv(Object x, Object y) {
                return Ordering.class.equiv((Ordering)this, (Object)x, (Object)y);
            }

            public Object max(Object x, Object y) {
                return Ordering.class.max((Ordering)this, (Object)x, (Object)y);
            }

            public Object min(Object x, Object y) {
                return Ordering.class.min((Ordering)this, (Object)x, (Object)y);
            }

            public Ordering<BinaryOutputEncoder.ValuesToEncode> reverse() {
                return Ordering.class.reverse((Ordering)this);
            }

            public <U> Ordering<U> on(Function1<U, BinaryOutputEncoder.ValuesToEncode> f) {
                return Ordering.class.on((Ordering)this, f);
            }

            public Ordering.Ops mkOrderingOps(Object lhs) {
                return Ordering.class.mkOrderingOps((Ordering)this, (Object)lhs);
            }

            public int compare(BinaryOutputEncoder.ValuesToEncode x, BinaryOutputEncoder.ValuesToEncode y) {
                return Predef$.MODULE$.long2Long(x.dtg()).compareTo(Predef$.MODULE$.long2Long(y.dtg()));
            }
            {
                PartialOrdering.class.$init$((PartialOrdering)this);
                Ordering.class.$init$((Ordering)this);
            }
        };
    }
}

