/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.filter.function;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.locationtech.geomesa.filter.function.BasicValues;
import org.locationtech.geomesa.filter.function.EncodedValues;
import org.locationtech.geomesa.filter.function.ExtendedValues;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Tuple2;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class Convert2ViewerFunction$ {
    public static final Convert2ViewerFunction$ MODULE$;
    private final ThreadLocal<ByteBuffer> buffers;
    private final ThreadLocal<ByteArrayOutputStream> byteStreams;

    static {
        new Convert2ViewerFunction$();
    }

    private ThreadLocal<ByteBuffer> buffers() {
        return this.buffers;
    }

    private ThreadLocal<ByteArrayOutputStream> byteStreams() {
        return this.byteStreams;
    }

    public long convertToLabel(String label) {
        return BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.longArrayOps((long[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.byteArrayOps((byte[])Predef$.MODULE$.byteArrayOps(label.getBytes()).take(8)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply(Tuple2<Object, Object> x0$1) {
                Tuple2<Object, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    byte b = BoxesRunTime.unboxToByte((Object)tuple2._1());
                    int i = tuple2._2$mcI$sp();
                    long l = ((long)b & 0xFFL) << 8 * i;
                    return l;
                }
                throw new MatchError(tuple2);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    public void encode(ExtendedValues values, OutputStream out) {
        ByteBuffer buf = this.buffers().get();
        this.put(buf, values.lat(), values.lon(), values.dtg(), values.trackId());
        buf.putLong(values.label());
        out.write(buf.array(), 0, 24);
    }

    public void encode(BasicValues values, OutputStream out) {
        ByteBuffer buf = this.buffers().get();
        this.put(buf, values.lat(), values.lon(), values.dtg(), values.trackId());
        out.write(buf.array(), 0, 16);
    }

    public byte[] encodeToByteArray(ExtendedValues values) {
        ByteArrayOutputStream out = this.byteStreams().get();
        this.encode(values, (OutputStream)out);
        return out.toByteArray();
    }

    public byte[] encodeToByteArray(BasicValues values) {
        ByteArrayOutputStream out = this.byteStreams().get();
        this.encode(values, (OutputStream)out);
        return out.toByteArray();
    }

    private void put(ByteBuffer buffer, float lat, float lon, long dtg, int trackId) {
        buffer.putInt(trackId);
        buffer.putInt((int)(dtg / 1000L));
        buffer.putFloat(lat);
        buffer.putFloat(lon);
    }

    public EncodedValues decode(byte[] encoded) {
        Product product;
        ByteBuffer buf = ByteBuffer.wrap(encoded).order(ByteOrder.LITTLE_ENDIAN);
        int trackId = buf.getInt();
        long time = (long)buf.getInt() * 1000L;
        float lat = buf.getFloat();
        float lon = buf.getFloat();
        if (encoded.length > 16) {
            long label = buf.getLong();
            product = new ExtendedValues(lat, lon, time, trackId, label);
        } else {
            product = new BasicValues(lat, lon, time, trackId);
        }
        return product;
    }

    private Convert2ViewerFunction$() {
        MODULE$ = this;
        this.buffers = new ThreadLocal<ByteBuffer>(){

            public ByteBuffer initialValue() {
                return ByteBuffer.allocate(24).order(ByteOrder.LITTLE_ENDIAN);
            }

            /*
             * WARNING - void declaration
             */
            public ByteBuffer get() {
                void var1_1;
                ByteBuffer out = (ByteBuffer)super.get();
                out.clear();
                return var1_1;
            }
        };
        this.byteStreams = new ThreadLocal<ByteArrayOutputStream>(){

            public ByteArrayOutputStream initialValue() {
                return new ByteArrayOutputStream(24);
            }

            /*
             * WARNING - void declaration
             */
            public ByteArrayOutputStream get() {
                void var1_1;
                ByteArrayOutputStream out = (ByteArrayOutputStream)super.get();
                out.reset();
                return var1_1;
            }
        };
    }
}

