/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.kafka10;

import com.github.benmanes.caffeine.cache.Ticker;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import org.geotools.data.Query;
import org.geotools.data.store.ContentEntry;
import org.geotools.data.store.ContentFeatureSource;
import org.locationtech.geomesa.kafka.ReplayConfig;
import org.locationtech.geomesa.kafka10.KafkaConsumerFeatureSource;
import org.locationtech.geomesa.kafka10.KafkaDataStore$;
import org.locationtech.geomesa.kafka10.KafkaDataStoreFactoryParams$;
import org.locationtech.geomesa.kafka10.KafkaDataStoreSchemaManager;
import org.locationtech.geomesa.kafka10.KafkaFeatureConfig;
import org.locationtech.geomesa.kafka10.LiveKafkaConsumerFeatureSource;
import org.locationtech.geomesa.kafka10.LiveKafkaConsumerFeatureSource$;
import org.locationtech.geomesa.kafka10.ReplayKafkaConsumerFeatureSource;
import org.locationtech.geomesa.kafka10.consumer.KafkaConsumerFactory;
import org.locationtech.geomesa.utils.text.Suffixes;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.VolatileByteRef;

public final class KafkaConsumerFeatureSourceFactory$
implements LazyLogging {
    public static final KafkaConsumerFeatureSourceFactory$ MODULE$;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new KafkaConsumerFeatureSourceFactory$();
    }

    private Logger logger$lzycompute() {
        KafkaConsumerFeatureSourceFactory$ kafkaConsumerFeatureSourceFactory$ = this;
        synchronized (kafkaConsumerFeatureSourceFactory$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public Function3<ContentEntry, Query, KafkaDataStoreSchemaManager, ContentFeatureSource> apply(String brokers, String zk, Map<String, Serializable> params) {
        Option option;
        block4: {
            long l;
            boolean cleanUpCache;
            VolatileByteRef bitmap$0;
            ObjectRef expirationPeriod$lzy;
            block3: {
                block2: {
                    expirationPeriod$lzy = ObjectRef.zero();
                    bitmap$0 = VolatileByteRef.create((byte)0);
                    cleanUpCache = BoxesRunTime.unboxToBoolean((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean((Object)KafkaDataStoreFactoryParams$.MODULE$.CLEANUP_LIVE_CACHE().lookUp(params)))).getOrElse((Function0)new scala.Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply() {
                            return this.apply$mcZ$sp();
                        }

                        public boolean apply$mcZ$sp() {
                            return false;
                        }
                    }));
                    option = Option$.MODULE$.apply((Object)((String)KafkaDataStoreFactoryParams$.MODULE$.CACHE_CLEANUP_PERIOD().lookUp(params)));
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    String duration = (String)some.x();
                    l = BoxesRunTime.unboxToLong((Object)Suffixes.Time$.MODULE$.millis(duration).getOrElse((Function0)new scala.Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final long apply() {
                            return this.apply$mcJ$sp();
                        }

                        public long apply$mcJ$sp() {
                            BoxedUnit boxedUnit;
                            if (KafkaConsumerFeatureSourceFactory$.MODULE$.logger().underlying().isWarnEnabled()) {
                                KafkaConsumerFeatureSourceFactory$.MODULE$.logger().underlying().warn("Unable to parse Cache Cleanup Period. Using default of 10000");
                                boxedUnit = BoxedUnit.UNIT;
                            } else {
                                boxedUnit = BoxedUnit.UNIT;
                            }
                            return 10000L;
                        }
                    }));
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                l = 10000L;
            }
            long cacheCleanUpPeriod = l;
            boolean useCQCache = BoxesRunTime.unboxToBoolean((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean((Object)KafkaDataStoreFactoryParams$.MODULE$.USE_CQ_LIVE_CACHE().lookUp(params)))).getOrElse((Function0)new scala.Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                public boolean apply$mcZ$sp() {
                    return false;
                }
            }));
            boolean monitor = BoxesRunTime.unboxToBoolean((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean((Object)KafkaDataStoreFactoryParams$.MODULE$.COLLECT_QUERY_STAT().lookUp(params)))).getOrElse((Function0)new scala.Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                public boolean apply$mcZ$sp() {
                    return false;
                }
            }));
            String autoOffsetReset = (String)Option$.MODULE$.apply((Object)((String)KafkaDataStoreFactoryParams$.MODULE$.AUTO_OFFSET_RESET().lookUp(params))).getOrElse((Function0)new scala.Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "largest";
                }
            });
            Properties consumerConfig = KafkaDataStore$.MODULE$.parseConfig((Option<String>)Option$.MODULE$.apply((Object)((String)KafkaDataStoreFactoryParams$.MODULE$.CONSUMER_CFG_PARAM().lookUp(params))));
            return new scala.Serializable(brokers, zk, params, expirationPeriod$lzy, cleanUpCache, cacheCleanUpPeriod, useCQCache, monitor, autoOffsetReset, consumerConfig, bitmap$0){
                public static final long serialVersionUID = 0L;
                private final String brokers$1;
                private final String zk$1;
                private final Map params$1;
                private final ObjectRef expirationPeriod$lzy$1;
                private final boolean cleanUpCache$1;
                private final long cacheCleanUpPeriod$1;
                private final boolean useCQCache$1;
                private final boolean monitor$1;
                private final String autoOffsetReset$1;
                private final Properties consumerConfig$1;
                private final VolatileByteRef bitmap$0$1;

                public final ContentFeatureSource apply(ContentEntry entry, Query query, KafkaDataStoreSchemaManager schemaManager) {
                    Option<ReplayConfig> option;
                    block4: {
                        KafkaConsumerFeatureSource kafkaConsumerFeatureSource;
                        block3: {
                            KafkaFeatureConfig fc;
                            KafkaConsumerFactory kf;
                            block2: {
                                kf = new KafkaConsumerFactory(this.brokers$1, this.zk$1, this.autoOffsetReset$1, this.consumerConfig$1);
                                fc = schemaManager.getFeatureConfig(entry.getTypeName());
                                option = fc.replayConfig();
                                if (!None$.MODULE$.equals(option)) break block2;
                                ContentEntry x$3 = entry;
                                SimpleFeatureType x$4 = fc.sft();
                                String x$5 = fc.topic();
                                KafkaConsumerFactory x$6 = kf;
                                Option x$7 = KafkaConsumerFeatureSourceFactory$.MODULE$.org$locationtech$geomesa$kafka10$KafkaConsumerFeatureSourceFactory$$expirationPeriod$1(this.params$1, this.expirationPeriod$lzy$1, this.bitmap$0$1);
                                boolean x$8 = this.cleanUpCache$1;
                                boolean x$9 = this.useCQCache$1;
                                Query x$10 = query;
                                boolean x$11 = this.monitor$1;
                                long x$12 = this.cacheCleanUpPeriod$1;
                                Ticker x$13 = LiveKafkaConsumerFeatureSource$.MODULE$.$lessinit$greater$default$11(x$3, x$4, x$5, x$6, (Option<Object>)x$7, x$8, x$9, x$10, x$11, x$12);
                                kafkaConsumerFeatureSource = new LiveKafkaConsumerFeatureSource(x$3, x$4, x$5, x$6, (Option<Object>)x$7, x$8, x$9, x$10, x$11, x$12, x$13);
                                break block3;
                            }
                            if (!(option instanceof Some)) break block4;
                            Some some = (Some)option;
                            ReplayConfig rc = (ReplayConfig)some.x();
                            SimpleFeatureType replaySFT = fc.sft();
                            SimpleFeatureType liveSFT = (SimpleFeatureType)schemaManager.getLiveFeatureType(replaySFT).getOrElse((Function0)new scala.Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final Nothing$ apply() {
                                    throw new IllegalArgumentException("Cannot create Replay FeatureSource because SFT has not been properly prepared.");
                                }
                            });
                            kafkaConsumerFeatureSource = new ReplayKafkaConsumerFeatureSource(entry, replaySFT, liveSFT, fc.topic(), kf, rc, query);
                        }
                        return kafkaConsumerFeatureSource;
                    }
                    throw new MatchError(option);
                }
                {
                    this.brokers$1 = brokers$1;
                    this.zk$1 = zk$1;
                    this.params$1 = params$1;
                    this.expirationPeriod$lzy$1 = expirationPeriod$lzy$1;
                    this.cleanUpCache$1 = cleanUpCache$1;
                    this.cacheCleanUpPeriod$1 = cacheCleanUpPeriod$1;
                    this.useCQCache$1 = useCQCache$1;
                    this.monitor$1 = monitor$1;
                    this.autoOffsetReset$1 = autoOffsetReset$1;
                    this.consumerConfig$1 = consumerConfig$1;
                    this.bitmap$0$1 = bitmap$0$1;
                }
            };
        }
        throw new MatchError((Object)option);
    }

    private final Option expirationPeriod$lzycompute$1(Map params$1, ObjectRef expirationPeriod$lzy$1, VolatileByteRef bitmap$0$1) {
        KafkaConsumerFeatureSourceFactory$ kafkaConsumerFeatureSourceFactory$ = this;
        synchronized (kafkaConsumerFeatureSourceFactory$) {
            if ((byte)(bitmap$0$1.elem & 1) == 0) {
                expirationPeriod$lzy$1.elem = Option$.MODULE$.apply(KafkaDataStoreFactoryParams$.MODULE$.EXPIRATION_PERIOD().lookUp(params$1)).map((Function1)new scala.Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final long apply(Object x$1) {
                        return new StringOps(Predef$.MODULE$.augmentString(x$1.toString())).toLong();
                    }
                }).filter((Function1)new scala.Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(long x$2) {
                        return this.apply$mcZJ$sp(x$2);
                    }

                    public boolean apply$mcZJ$sp(long x$2) {
                        return x$2 > 0L;
                    }
                });
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 1);
            }
            return (Option)expirationPeriod$lzy$1.elem;
        }
    }

    public final Option org$locationtech$geomesa$kafka10$KafkaConsumerFeatureSourceFactory$$expirationPeriod$1(Map params$1, ObjectRef expirationPeriod$lzy$1, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 1) == 0 ? this.expirationPeriod$lzycompute$1(params$1, expirationPeriod$lzy$1, bitmap$0$1) : (Option)expirationPeriod$lzy$1.elem;
    }

    private KafkaConsumerFeatureSourceFactory$() {
        MODULE$ = this;
        LazyLogging.class.$init$((LazyLogging)this);
    }
}

