/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.kafka10;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Closeable;
import java.util.Arrays;
import kafka.message.Message;
import kafka.message.MessageAndMetadata;
import org.geotools.data.EmptyFeatureReader;
import org.geotools.data.FeatureReader;
import org.geotools.data.Query;
import org.geotools.data.simple.SimpleFeatureReader;
import org.geotools.data.store.ContentEntry;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;
import org.locationtech.geomesa.kafka.Clear;
import org.locationtech.geomesa.kafka.GeoMessage;
import org.locationtech.geomesa.kafka.GeoMessageDecoder;
import org.locationtech.geomesa.kafka.ReplayConfig;
import org.locationtech.geomesa.kafka.ReplaySnapshotFeatureCache;
import org.locationtech.geomesa.kafka.TimestampFilterSplit;
import org.locationtech.geomesa.kafka.TimestampFilterSplit$;
import org.locationtech.geomesa.kafka10.KafkaConsumerFeatureSource;
import org.locationtech.geomesa.kafka10.KafkaGeoMessageDecoder;
import org.locationtech.geomesa.kafka10.consumer.KafkaConsumer;
import org.locationtech.geomesa.kafka10.consumer.KafkaConsumerFactory;
import org.locationtech.geomesa.kafka10.consumer.KafkaStreamLike;
import org.locationtech.geomesa.kafka10.consumer.KafkaStreamLike$;
import org.locationtech.geomesa.kafka10.consumer.offsets.FindOffset;
import org.locationtech.geomesa.utils.stats.MethodProfiling;
import org.locationtech.geomesa.utils.stats.Timing;
import org.locationtech.geomesa.utils.stats.Timings;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.IncludeFilter;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.collection.mutable.IndexedSeqView;
import scala.math.Ordering;
import scala.math.PartialOrdering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015e\u0001B\u0001\u0003\u0001-\u0011\u0001EU3qY\u0006L8*\u00194lC\u000e{gn];nKJ4U-\u0019;ve\u0016\u001cv.\u001e:dK*\u00111\u0001B\u0001\bW\u000647.Y\u00191\u0015\t)a!A\u0004hK>lWm]1\u000b\u0005\u001dA\u0011\u0001\u00047pG\u0006$\u0018n\u001c8uK\u000eD'\"A\u0005\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000b\u0001a\u0001\u0003\u0007\u0011\u0011\u00055qQ\"\u0001\u0002\n\u0005=\u0011!AG&bM.\f7i\u001c8tk6,'OR3biV\u0014XmU8ve\u000e,\u0007CA\t\u0017\u001b\u0005\u0011\"BA\n\u0015\u0003\u0015\u0019H/\u0019;t\u0015\t)B!A\u0003vi&d7/\u0003\u0002\u0018%\tyQ*\u001a;i_\u0012\u0004&o\u001c4jY&tw\r\u0005\u0002\u001a=5\t!D\u0003\u0002\u001c9\u0005\u0011\u0011n\u001c\u0006\u0002;\u0005!!.\u0019<b\u0013\ty\"DA\u0005DY>\u001cX-\u00192mKB\u0011\u0011\u0005K\u0007\u0002E)\u00111\u0005J\u0001\rg\u000e\fG.\u00197pO\u001eLgn\u001a\u0006\u0003K\u0019\n\u0001\u0002^=qKN\fg-\u001a\u0006\u0002O\u0005\u00191m\\7\n\u0005%\u0012#a\u0003'bufdunZ4j]\u001eD\u0001b\u000b\u0001\u0003\u0002\u0003\u0006I\u0001L\u0001\u0006K:$(/\u001f\t\u0003[Qj\u0011A\f\u0006\u0003_A\nQa\u001d;pe\u0016T!!\r\u001a\u0002\t\u0011\fG/\u0019\u0006\u0003g!\t\u0001bZ3pi>|Gn]\u0005\u0003k9\u0012AbQ8oi\u0016tG/\u00128uefD\u0001b\u000e\u0001\u0003\u0002\u0003\u0006I\u0001O\u0001\ne\u0016\u0004H.Y=T\rR\u0003\"!\u000f!\u000e\u0003iR!a\u000f\u001f\u0002\rMLW\u000e\u001d7f\u0015\tid(A\u0004gK\u0006$XO]3\u000b\u0005}B\u0011aB8qK:<\u0017n]\u0005\u0003\u0003j\u0012\u0011cU5na2,g)Z1ukJ,G+\u001f9f\u0011!\u0019\u0005A!A!\u0002\u0013A\u0014a\u00027jm\u0016\u001cf\t\u0016\u0005\t\u000b\u0002\u0011\t\u0011)A\u0005\r\u0006)Ao\u001c9jGB\u0011q)\u0014\b\u0003\u0011.k\u0011!\u0013\u0006\u0002\u0015\u0006)1oY1mC&\u0011A*S\u0001\u0007!J,G-\u001a4\n\u00059{%AB*ue&twM\u0003\u0002M\u0013\"A\u0011\u000b\u0001B\u0001B\u0003%!+\u0001\u0002lMB\u00111KV\u0007\u0002)*\u0011QKA\u0001\tG>t7/^7fe&\u0011q\u000b\u0016\u0002\u0015\u0017\u000647.Y\"p]N,X.\u001a:GC\u000e$xN]=\t\u0011e\u0003!\u0011!Q\u0001\ni\u000bAB]3qY\u0006L8i\u001c8gS\u001e\u0004\"a\u00170\u000e\u0003qS!!\u0018\u0003\u0002\u000b-\fgm[1\n\u0005}c&\u0001\u0004*fa2\f\u0017pQ8oM&<\u0007\u0002C1\u0001\u0005\u0003\u0005\u000b\u0011\u00022\u0002\u000bE,XM]=\u0011\u0005\r$W\"\u0001\u0019\n\u0005\u0015\u0004$!B)vKJL\b\"B4\u0001\t\u0003A\u0017A\u0002\u001fj]&$h\b\u0006\u0005jU.dWN\\8q!\ti\u0001\u0001C\u0003,M\u0002\u0007A\u0006C\u00038M\u0002\u0007\u0001\bC\u0003DM\u0002\u0007\u0001\bC\u0003FM\u0002\u0007a\tC\u0003RM\u0002\u0007!\u000bC\u0003ZM\u0002\u0007!\fC\u0003bM\u0002\u0007!\r\u0003\u0005s\u0001\t\u0007I\u0011\u0001\u0002t\u0003!iWm]:bO\u0016\u001cX#\u0001;\u0011\u0007!+x/\u0003\u0002w\u0013\n)\u0011I\u001d:bsB\u00111\f_\u0005\u0003sr\u0013!bR3p\u001b\u0016\u001c8/Y4f\u0011\u0019Y\b\u0001)A\u0005i\u0006IQ.Z:tC\u001e,7\u000f\t\u0005\u0006{\u0002!\tE`\u0001\u0013O\u0016$(+Z1eKJ4uN\u001d$jYR,'\u000fF\u0002\u0000\u0003S\u0001B!!\u0001\u0002$9!\u00111AA\u000f\u001d\u0011\t)!a\u0007\u000f\t\u0005\u001d\u0011\u0011\u0004\b\u0005\u0003\u0013\t9B\u0004\u0003\u0002\f\u0005Ua\u0002BA\u0007\u0003'i!!a\u0004\u000b\u0007\u0005E!\"\u0001\u0004=e>|GOP\u0005\u0002\u0013%\u0011q\u0001C\u0005\u0003\u000b\u0019I!!\u0006\u0003\n\u0005M\"\u0012\u0002BA\u0010\u0003C\tq\u0001]1dW\u0006<WM\u0003\u00024)%!\u0011QEA\u0014\u0005\t1%K\u0003\u0003\u0002 \u0005\u0005\u0002bBA\u0016y\u0002\u0007\u0011QF\u0001\u0007M&dG/\u001a:\u0011\t\u0005=\u00121G\u0007\u0003\u0003cQ1!a\u000b?\u0013\u0011\t)$!\r\u0003\r\u0019KG\u000e^3s\u0011!\tI\u0004\u0001C\u0001\u0005\u0005m\u0012\u0001C:oCB\u001c\bn\u001c;\u0015\t\u0005u\u0012\u0011\n\t\u0006\u0011\u0006}\u00121I\u0005\u0004\u0003\u0003J%AB(qi&|g\u000eE\u0002\\\u0003\u000bJ1!a\u0012]\u0005i\u0011V\r\u001d7bsNs\u0017\r]:i_R4U-\u0019;ve\u0016\u001c\u0015m\u00195f\u0011!\tY%a\u000eA\u0002\u00055\u0013\u0001\u0002;j[\u0016\u0004R\u0001SA \u0003\u001f\u00022\u0001SA)\u0013\r\t\u0019&\u0013\u0002\u0005\u0019>tw\r\u0003\u0005\u0002X\u0001!\tAAA-\u0003-Ig\u000eZ3y\u0003R$\u0016.\\3\u0015\t\u0005m\u00131\r\t\u0006\u0011\u0006}\u0012Q\f\t\u0004\u0011\u0006}\u0013bAA1\u0013\n\u0019\u0011J\u001c;\t\u0011\u0005-\u0013Q\u000ba\u0001\u0003\u001fBq!!\u000f\u0001\t\u0013\t9\u0007\u0006\u0005\u0002>\u0005%\u00141NA8\u0011!\tY%!\u001aA\u0002\u0005=\u0003\u0002CA7\u0003K\u0002\r!!\u0018\u0002\u0015M$\u0018M\u001d;J]\u0012,\u0007\u0010\u0003\u0005\u0002r\u0005\u0015\u0004\u0019AA(\u0003\u001d)g\u000e\u001a+j[\u0016Dq!!\u001e\u0001\t\u0013\t9(\u0001\u0007sK\u0006$W*Z:tC\u001e,7\u000fF\u0001u\u0011\u001d\tY\b\u0001C!\u0003{\nQa\u00197pg\u0016$\"!a \u0011\u0007!\u000b\t)C\u0002\u0002\u0004&\u0013A!\u00168ji\u0002")
public class ReplayKafkaConsumerFeatureSource
extends KafkaConsumerFeatureSource
implements MethodProfiling,
Closeable,
LazyLogging {
    public final SimpleFeatureType org$locationtech$geomesa$kafka10$ReplayKafkaConsumerFeatureSource$$replaySFT;
    private final SimpleFeatureType liveSFT;
    private final String topic;
    private final KafkaConsumerFactory kf;
    public final ReplayConfig org$locationtech$geomesa$kafka10$ReplayKafkaConsumerFeatureSource$$replayConfig;
    private final GeoMessage[] messages;
    private final Logger logger;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        ReplayKafkaConsumerFeatureSource replayKafkaConsumerFeatureSource = this;
        synchronized (replayKafkaConsumerFeatureSource) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public <R> R profile(Function0<R> code, Timing timing) {
        return (R)MethodProfiling.class.profile((MethodProfiling)this, code, (Timing)timing);
    }

    public <R> R profile(String identifier, Function0<R> code, Timings timings) {
        return (R)MethodProfiling.class.profile((MethodProfiling)this, (String)identifier, code, (Timings)timings);
    }

    public GeoMessage[] messages() {
        return this.messages;
    }

    @Override
    public FeatureReader<SimpleFeatureType, SimpleFeature> getReaderForFilter(Filter filter) {
        None$ reader = Predef$.MODULE$.refArrayOps((Object[])this.messages()).isEmpty() ? None$.MODULE$ : TimestampFilterSplit$.MODULE$.split(filter).flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplayKafkaConsumerFeatureSource $outer;

            public final Option<SimpleFeatureReader> apply(TimestampFilterSplit tfs) {
                Option time = tfs.ts();
                Filter filter = (Filter)tfs.filter().getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final IncludeFilter apply() {
                        return Filter.INCLUDE;
                    }
                });
                return this.$outer.snapshot((Option<Object>)time).map((Function1)new Serializable(this, filter){
                    public static final long serialVersionUID = 0L;
                    private final Filter filter$1;

                    public final SimpleFeatureReader apply(ReplaySnapshotFeatureCache x$1) {
                        return x$1.getReaderForFilter(this.filter$1);
                    }
                    {
                        this.filter$1 = filter$1;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        return (FeatureReader)reader.getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplayKafkaConsumerFeatureSource $outer;

            public final EmptyFeatureReader<SimpleFeatureType, SimpleFeature> apply() {
                return new EmptyFeatureReader((FeatureType)this.$outer.org$locationtech$geomesa$kafka10$ReplayKafkaConsumerFeatureSource$$replaySFT);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public Option<ReplaySnapshotFeatureCache> snapshot(Option<Object> time) {
        Tuple2 tuple2 = (Tuple2)time.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplayKafkaConsumerFeatureSource $outer;

            public final Tuple2<Object, Option<Object>> apply(long ts) {
                return new Tuple2((Object)BoxesRunTime.boxToLong((long)ts), this.$outer.indexAtTime(ts));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplayKafkaConsumerFeatureSource $outer;

            public final Tuple2<Object, Some<Object>> apply() {
                return new Tuple2((Object)BoxesRunTime.boxToLong((long)this.$outer.org$locationtech$geomesa$kafka10$ReplayKafkaConsumerFeatureSource$$replayConfig.end().getMillis()), (Object)new Some((Object)BoxesRunTime.boxToInteger((int)0)));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        if (tuple2 != null) {
            Tuple2 tuple22;
            long startTime = tuple2._1$mcJ$sp();
            Option startIndex = (Option)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)startTime), (Object)startIndex);
            long startTime2 = tuple23._1$mcJ$sp();
            Option startIndex2 = (Option)tuple23._2();
            return (Option)startIndex2.map((Function1)new Serializable(this, startTime2){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ReplayKafkaConsumerFeatureSource $outer;
                private final long startTime$1;

                public final Option<ReplaySnapshotFeatureCache> apply(int si) {
                    long endTime = this.startTime$1 - this.$outer.org$locationtech$geomesa$kafka10$ReplayKafkaConsumerFeatureSource$$replayConfig.readBehind().getMillis();
                    return this.$outer.org$locationtech$geomesa$kafka10$ReplayKafkaConsumerFeatureSource$$snapshot(this.startTime$1, si, endTime);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.startTime$1 = startTime$1;
                }
            }).getOrElse((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final None$ apply() {
                    return None$.MODULE$;
                }
            });
        }
        throw new MatchError((Object)tuple2);
    }

    public Option<Object> indexAtTime(long time) {
        Object object;
        if (this.org$locationtech$geomesa$kafka10$ReplayKafkaConsumerFeatureSource$$replayConfig.isInWindow(time)) {
            Clear key = new Clear(new Instant(time));
            Ordering<GeoMessage> ordering = new Ordering<GeoMessage>(this){

                public Some tryCompare(Object x, Object y) {
                    return Ordering.class.tryCompare((Ordering)this, (Object)x, (Object)y);
                }

                public boolean lteq(Object x, Object y) {
                    return Ordering.class.lteq((Ordering)this, (Object)x, (Object)y);
                }

                public boolean gteq(Object x, Object y) {
                    return Ordering.class.gteq((Ordering)this, (Object)x, (Object)y);
                }

                public boolean lt(Object x, Object y) {
                    return Ordering.class.lt((Ordering)this, (Object)x, (Object)y);
                }

                public boolean gt(Object x, Object y) {
                    return Ordering.class.gt((Ordering)this, (Object)x, (Object)y);
                }

                public boolean equiv(Object x, Object y) {
                    return Ordering.class.equiv((Ordering)this, (Object)x, (Object)y);
                }

                public Object max(Object x, Object y) {
                    return Ordering.class.max((Ordering)this, (Object)x, (Object)y);
                }

                public Object min(Object x, Object y) {
                    return Ordering.class.min((Ordering)this, (Object)x, (Object)y);
                }

                public Ordering<GeoMessage> reverse() {
                    return Ordering.class.reverse((Ordering)this);
                }

                public <U> Ordering<U> on(Function1<U, GeoMessage> f) {
                    return Ordering.class.on((Ordering)this, f);
                }

                public Ordering.Ops mkOrderingOps(Object lhs) {
                    return Ordering.class.mkOrderingOps((Ordering)this, (Object)lhs);
                }

                public int compare(GeoMessage x, GeoMessage y) {
                    return y.timestamp().compareTo((ReadableInstant)x.timestamp());
                }
                {
                    PartialOrdering.class.$init$((PartialOrdering)this);
                    Ordering.class.$init$((Ordering)this);
                }
            };
            int index = Arrays.binarySearch((Object[])this.messages(), key, ordering);
            if (index < 0) {
                index = -index - 1;
            }
            while (index > 0 && this.messages()[index - 1].timestamp().getMillis() <= time) {
                --index;
            }
            object = index < this.messages().length ? new Some((Object)BoxesRunTime.boxToInteger((int)index)) : None$.MODULE$;
        } else {
            object = None$.MODULE$;
        }
        return object;
    }

    public Option<ReplaySnapshotFeatureCache> org$locationtech$geomesa$kafka10$ReplayKafkaConsumerFeatureSource$$snapshot(long time, int startIndex, long endTime) {
        IndexedSeqView snapshot2 = Predef$.MODULE$.refArrayOps((Object[])this.messages()).view().drop(startIndex).takeWhile((Function1)new Serializable(this, endTime){
            public static final long serialVersionUID = 0L;
            private final long endTime$1;

            public final boolean apply(GeoMessage x0$1) {
                GeoMessage geoMessage = x0$1;
                boolean bl = geoMessage instanceof Clear ? false : geoMessage.timestamp().getMillis() >= this.endTime$1;
                return bl;
            }
            {
                this.endTime$1 = endTime$1;
            }
        });
        return snapshot2.isEmpty() ? None$.MODULE$ : new Some((Object)new ReplaySnapshotFeatureCache(this.org$locationtech$geomesa$kafka10$ReplayKafkaConsumerFeatureSource$$replaySFT, time, (Seq)snapshot2));
    }

    /*
     * WARNING - void declaration
     */
    public GeoMessage[] org$locationtech$geomesa$kafka10$ReplayKafkaConsumerFeatureSource$$readMessages() {
        GeoMessage[] geoMessageArray;
        KafkaGeoMessageDecoder msgDecoder = new KafkaGeoMessageDecoder(this.liveSFT);
        Instant startTime = this.org$locationtech$geomesa$kafka10$ReplayKafkaConsumerFeatureSource$$replayConfig.realStartTime().minus(1L);
        FindOffset offsetRequest = new FindOffset((Function1<Message, Object>)new Serializable(this, msgDecoder, startTime){
            public static final long serialVersionUID = 0L;
            private final KafkaGeoMessageDecoder msgDecoder$1;
            private final Instant startTime$2;

            public final int apply(Message msg) {
                GeoMessageDecoder.MsgKey key = this.msgDecoder$1.decodeKey(msg);
                return key.ts().isEqual((ReadableInstant)this.startTime$2) ? 0 : (key.ts().isAfter((ReadableInstant)this.startTime$2) ? 1 : -1);
            }
            {
                this.msgDecoder$1 = msgDecoder$1;
                this.startTime$2 = startTime$2;
            }
        });
        KafkaConsumer<byte[], byte[]> kafkaConsumer = this.kf.kafkaConsumer(this.topic, (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"consumer.timeout.ms"), (Object)"250")}))));
        try {
            KafkaStreamLike stream = (KafkaStreamLike)kafkaConsumer.createMessageStreams(1, offsetRequest).head();
            HashSet msgIds = HashSet$.MODULE$.empty();
            geoMessageArray = (GeoMessage[])((TraversableOnce)KafkaStreamLike$.MODULE$.KafkaStreamLikeIterator(stream.iterator()).stopOnTimeout().filter((Function1)new Serializable(this, msgIds){
                public static final long serialVersionUID = 0L;
                private final HashSet msgIds$1;

                public final boolean apply(MessageAndMetadata<byte[], byte[]> m) {
                    return this.msgIds$1.add((Object)new Tuple2.mcIJ.sp(m.partition(), m.offset()));
                }
                {
                    this.msgIds$1 = msgIds$1;
                }
            }).map((Function1)new Serializable(this, msgDecoder){
                public static final long serialVersionUID = 0L;
                private final KafkaGeoMessageDecoder msgDecoder$1;

                public final GeoMessage apply(MessageAndMetadata<byte[], byte[]> msg) {
                    return this.msgDecoder$1.decode(msg);
                }
                {
                    this.msgDecoder$1 = msgDecoder$1;
                }
            }).dropWhile((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ReplayKafkaConsumerFeatureSource $outer;

                public final boolean apply(GeoMessage msg) {
                    return this.$outer.org$locationtech$geomesa$kafka10$ReplayKafkaConsumerFeatureSource$$replayConfig.isBeforeRealStart(msg);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }).takeWhile((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ReplayKafkaConsumerFeatureSource $outer;

                public final boolean apply(GeoMessage msg) {
                    return this.$outer.org$locationtech$geomesa$kafka10$ReplayKafkaConsumerFeatureSource$$replayConfig.isNotAfterEnd(msg);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }).foldLeft((Object)List$.MODULE$.empty(), (Function2)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final List<GeoMessage> apply(List<GeoMessage> seq, GeoMessage elem) {
                    GeoMessage geoMessage = elem;
                    return seq.$colon$colon((Object)geoMessage);
                }
            })).toArray(ClassTag$.MODULE$.apply(GeoMessage.class));
            kafkaConsumer.shutdown();
        }
        catch (Throwable throwable) {
            void var4_4;
            var4_4.shutdown();
            throw throwable;
        }
        return geoMessageArray;
    }

    @Override
    public void close() {
    }

    public ReplayKafkaConsumerFeatureSource(ContentEntry entry, SimpleFeatureType replaySFT, SimpleFeatureType liveSFT, String topic, KafkaConsumerFactory kf, ReplayConfig replayConfig, Query query) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        this.org$locationtech$geomesa$kafka10$ReplayKafkaConsumerFeatureSource$$replaySFT = replaySFT;
        this.liveSFT = liveSFT;
        this.topic = topic;
        this.kf = kf;
        this.org$locationtech$geomesa$kafka10$ReplayKafkaConsumerFeatureSource$$replayConfig = replayConfig;
        super(entry, replaySFT, query, false);
        MethodProfiling.class.$init$((MethodProfiling)this);
        LazyLogging.class.$init$((LazyLogging)this);
        Timing timing = new Timing();
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Begin reading messages from ", " using ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic, replayConfig})));
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        GeoMessage[] msgs = (GeoMessage[])this.profile((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplayKafkaConsumerFeatureSource $outer;

            public final GeoMessage[] apply() {
                return this.$outer.org$locationtech$geomesa$kafka10$ReplayKafkaConsumerFeatureSource$$readMessages();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, timing);
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Read ", " messages in ", "ms from ", " using ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)msgs.length), BoxesRunTime.boxToLong((long)timing.time()), topic, replayConfig})));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.messages = msgs;
    }
}

