/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.kafka10.consumer;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.IOException;
import kafka.api.PartitionMetadata;
import kafka.api.TopicMetadata;
import kafka.api.TopicMetadataRequest;
import kafka.api.TopicMetadataResponse;
import kafka.cluster.BrokerEndPoint;
import kafka.common.TopicAndPartition;
import kafka.consumer.ConsumerConfig;
import kafka.consumer.SimpleConsumer;
import kafka.serializer.Decoder;
import org.locationtech.geomesa.kafka10.consumer.Broker;
import org.locationtech.geomesa.kafka10.consumer.Brokers$;
import org.locationtech.geomesa.kafka10.consumer.KafkaConsumer;
import org.locationtech.geomesa.kafka10.consumer.KafkaConsumer$;
import org.locationtech.geomesa.utils.geotools.RichIterator;
import org.locationtech.geomesa.utils.geotools.RichIterator$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple4;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;
import scala.util.Try$;

public final class KafkaConsumer$
implements LazyLogging,
Serializable {
    public static final KafkaConsumer$ MODULE$;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new KafkaConsumer$();
    }

    private Logger logger$lzycompute() {
        KafkaConsumer$ kafkaConsumer$ = this;
        synchronized (kafkaConsumer$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public SimpleConsumer createConsumer(String host, int port, ConsumerConfig config, String clientId) {
        return new SimpleConsumer(host, port, config.socketTimeoutMs(), config.socketReceiveBufferBytes(), clientId);
    }

    public SimpleConsumer reCreateConsumer(SimpleConsumer consumer, TopicAndPartition tap, ConsumerConfig config) {
        Some oldLeader = new Some((Object)new Broker(consumer.host(), consumer.port()));
        Broker leader = this.findNewLeader(tap, (Option<Broker>)oldLeader, config);
        return this.createConsumer(leader.host(), leader.port(), config, consumer.clientId());
    }

    public Seq<PartitionMetadata> findPartitions(String topic, ConsumerConfig config) {
        Seq<Broker> brokers = Brokers$.MODULE$.apply(config);
        return (Seq)RichIterator.RichIterator$.MODULE$.headOption$extension(RichIterator$.MODULE$.RichIterator(brokers.iterator().flatMap((Function1)new Serializable(topic, config){
            public static final long serialVersionUID = 0L;
            private final String topic$2;
            private final ConsumerConfig config$1;

            public final Iterable<Seq<PartitionMetadata>> apply(Broker b) {
                return Option$.MODULE$.option2Iterable(KafkaConsumer$.MODULE$.org$locationtech$geomesa$kafka10$consumer$KafkaConsumer$$findPartitions(b, this.topic$2, this.config$1));
            }
            {
                this.topic$2 = topic$2;
                this.config$1 = config$1;
            }
        }))).getOrElse((Function0)new Serializable(topic, brokers){
            public static final long serialVersionUID = 0L;
            private final String topic$2;
            private final Seq brokers$1;

            public final Nothing$ apply() {
                throw new IOException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not determine partitions for [", "] using "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$2}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"brokers ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.brokers$1.mkString(",")}))).toString());
            }
            {
                this.topic$2 = topic$2;
                this.brokers$1 = brokers$1;
            }
        });
    }

    public Option<Seq<PartitionMetadata>> org$locationtech$geomesa$kafka10$consumer$KafkaConsumer$$findPartitions(Broker broker, String topic, ConsumerConfig config) {
        None$ none$;
        SimpleConsumer consumer = null;
        try {
            try {
                int timeout = config.offsetsChannelSocketTimeoutMs();
                int buffer = config.socketReceiveBufferBytes();
                consumer = new SimpleConsumer(broker.host(), broker.port(), timeout, buffer, "leaderLookup");
                TopicMetadataResponse response = consumer.send(new TopicMetadataRequest((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})), 0));
                none$ = response.topicsMetadata().find((Function1)new Serializable(topic){
                    public static final long serialVersionUID = 0L;
                    private final String topic$1;

                    public final boolean apply(TopicMetadata x$4) {
                        String string = x$4.topic();
                        String string2 = this.topic$1;
                        return !(string != null ? !string.equals(string2) : string2 != null);
                    }
                    {
                        this.topic$1 = topic$1;
                    }
                }).map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final Seq<PartitionMetadata> apply(TopicMetadata x$5) {
                        return x$5.partitionsMetadata();
                    }
                }).filter((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Seq<PartitionMetadata> x$6) {
                        return x$6.nonEmpty();
                    }
                });
            }
            catch (Exception exception) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error communicating with broker [", "] to find leader for [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{broker, topic})), (Throwable)exception);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                none$ = None$.MODULE$;
            }
        }
        finally {
            if (consumer != null) {
                consumer.close();
            }
        }
        return none$;
    }

    public Broker findNewLeader(TopicAndPartition tap, Option<Broker> oldLeader, ConsumerConfig config) {
        return this.findNewLeader(tap, oldLeader, config, 1);
    }

    private Broker findNewLeader(TopicAndPartition tap, Option<Broker> oldLeader, ConsumerConfig config, int tries) {
        Option<Broker> option;
        block4: {
            Option option2;
            block5: {
                while (true) {
                    Option option3;
                    Option partitions = Try$.MODULE$.apply((Function0)new Serializable(tap, config){
                        public static final long serialVersionUID = 0L;
                        private final TopicAndPartition tap$2;
                        private final ConsumerConfig config$2;

                        public final Seq<PartitionMetadata> apply() {
                            return KafkaConsumer$.MODULE$.findPartitions(this.tap$2.topic(), this.config$2);
                        }
                        {
                            this.tap$2 = tap$2;
                            this.config$2 = config$2;
                        }
                    }).toOption();
                    Option maybeLeader = partitions.flatMap((Function1)new Serializable(tap){
                        public static final long serialVersionUID = 0L;
                        public final TopicAndPartition tap$2;

                        public final Option<PartitionMetadata> apply(Seq<PartitionMetadata> x$7) {
                            return x$7.find((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ anonfun.8 $outer;

                                public final boolean apply(PartitionMetadata x$8) {
                                    return x$8.partitionId() == this.$outer.tap$2.partition();
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            });
                        }
                        {
                            this.tap$2 = tap$2;
                        }
                    }).flatMap((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final Option<BrokerEndPoint> apply(PartitionMetadata x$9) {
                            return x$9.leader();
                        }
                    });
                    option = oldLeader;
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        Broker old = (Broker)some.x();
                        option3 = maybeLeader.filter((Function1)new Serializable(tries, old){
                            public static final long serialVersionUID = 0L;
                            private final int tries$1;
                            private final Broker old$1;

                            public final boolean apply(BrokerEndPoint m) {
                                String string = m.host();
                                String string2 = this.old$1.host();
                                return (string == null ? string2 != null : !string.equals(string2)) && m.port() != this.old$1.port() || this.tries$1 > 1;
                            }
                            {
                                this.tries$1 = tries$1;
                                this.old$1 = old$1;
                            }
                        });
                    } else {
                        if (!None$.MODULE$.equals(option)) break block4;
                        option3 = maybeLeader;
                    }
                    Option leader = option3;
                    option2 = leader.map((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final Broker apply(BrokerEndPoint l) {
                            return new Broker(l.host(), l.port());
                        }
                    });
                    if (option2 instanceof Some) {
                        Broker l;
                        Some some = (Some)option2;
                        Broker broker = l = (Broker)some.x();
                        return broker;
                    }
                    if (!None$.MODULE$.equals(option2)) break block5;
                    if (tries >= config.rebalanceMaxRetries()) break;
                    Thread.sleep(config.refreshLeaderBackoffMs());
                    ++tries;
                }
                throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not find new leader for topic and partition ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tap})));
            }
            throw new MatchError((Object)option2);
        }
        throw new MatchError(option);
    }

    public <K, V> KafkaConsumer<K, V> apply(String topic, ConsumerConfig config, Decoder<K> keyDecoder, Decoder<V> valueDecoder) {
        return new KafkaConsumer<K, V>(topic, config, keyDecoder, valueDecoder);
    }

    public <K, V> Option<Tuple4<String, ConsumerConfig, Decoder<K>, Decoder<V>>> unapply(KafkaConsumer<K, V> x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple4((Object)x$0.topic(), (Object)x$0.config(), x$0.keyDecoder(), x$0.valueDecoder()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private KafkaConsumer$() {
        MODULE$ = this;
        LazyLogging.class.$init$((LazyLogging)this);
    }
}

