/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.kafka10.consumer.offsets;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.nio.ByteBuffer;
import kafka.api.OffsetFetchRequest;
import kafka.api.OffsetFetchRequest$;
import kafka.api.OffsetFetchResponse;
import kafka.api.OffsetFetchResponse$;
import kafka.api.OffsetRequest;
import kafka.api.OffsetRequest$;
import kafka.api.PartitionMetadata;
import kafka.api.PartitionOffsetRequestInfo;
import kafka.api.PartitionOffsetsResponse;
import kafka.api.RequestOrResponse;
import kafka.cluster.BrokerEndPoint;
import kafka.common.ErrorMapping$;
import kafka.common.OffsetMetadataAndError;
import kafka.common.TopicAndPartition;
import kafka.consumer.ConsumerConfig;
import kafka.consumer.SimpleConsumer;
import kafka.network.BlockingChannel;
import org.locationtech.geomesa.kafka10.KafkaUtils10$;
import org.locationtech.geomesa.kafka10.consumer.Broker;
import org.locationtech.geomesa.kafka10.consumer.KafkaConsumer$;
import org.locationtech.geomesa.kafka10.consumer.offsets.OffsetManager$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

public final class OffsetManager$
implements LazyLogging {
    public static final OffsetManager$ MODULE$;
    private final String org$locationtech$geomesa$kafka10$consumer$offsets$OffsetManager$$clientId;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new OffsetManager$();
    }

    private Logger logger$lzycompute() {
        OffsetManager$ offsetManager$ = this;
        synchronized (offsetManager$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public String org$locationtech$geomesa$kafka10$consumer$offsets$OffsetManager$$clientId() {
        return this.org$locationtech$geomesa$kafka10$consumer$offsets$OffsetManager$$clientId;
    }

    public Map<TopicAndPartition, Object> getGroupOffsets(BlockingChannel channel, Seq<TopicAndPartition> partitions, ConsumerConfig config) {
        short version = OffsetFetchRequest$.MODULE$.CurrentVersion();
        OffsetFetchRequest request = new OffsetFetchRequest(config.groupId(), partitions, version, 0, this.org$locationtech$geomesa$kafka10$consumer$offsets$OffsetManager$$clientId());
        channel.send((RequestOrResponse)request);
        OffsetFetchResponse response = OffsetFetchResponse$.MODULE$.readFrom((ByteBuffer)KafkaUtils10$.MODULE$.channelToPayload().apply((Object)channel));
        this.handleOffsetErrors((Iterable<Object>)((Iterable)response.requestInfo().values().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final short apply(OffsetMetadataAndError x$5) {
                return x$5.error();
            }
        }, Iterable$.MODULE$.canBuildFrom())));
        return (Map)response.requestInfo().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<TopicAndPartition, Object> apply(Tuple2<TopicAndPartition, OffsetMetadataAndError> x0$4) {
                Tuple2<TopicAndPartition, OffsetMetadataAndError> tuple2 = x0$4;
                if (tuple2 != null) {
                    TopicAndPartition topicAndPartion = (TopicAndPartition)tuple2._1();
                    OffsetMetadataAndError metadata = (OffsetMetadataAndError)tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)topicAndPartion, (Object)BoxesRunTime.boxToLong((long)metadata.offset()));
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, Map$.MODULE$.canBuildFrom());
    }

    public Map<TopicAndPartition, Object> getOffsetsBefore(String topic, Seq<PartitionMetadata> partitions, long time, ConsumerConfig config) {
        return ((TraversableOnce)partitions.flatMap((Function1)new Serializable(topic, time, config){
            public static final long serialVersionUID = 0L;
            private final String topic$3;
            private final long time$1;
            public final ConsumerConfig config$1;

            /*
             * WARNING - void declaration
             */
            public final Iterable<Tuple2<TopicAndPartition, Object>> apply(PartitionMetadata partition) {
                Iterable iterable;
                TopicAndPartition tap = new TopicAndPartition(this.topic$3, partition.partitionId());
                Broker leader = (Broker)partition.leader().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Broker apply(BrokerEndPoint l) {
                        return new Broker(l.host(), l.port());
                    }
                }).getOrElse((Function0)new Serializable(this, tap){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.getOffsetsBefore.1 $outer;
                    private final TopicAndPartition tap$2;

                    public final Broker apply() {
                        return KafkaConsumer$.MODULE$.findNewLeader(this.tap$2, (Option<Broker>)None$.MODULE$, this.$outer.config$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.tap$2 = tap$2;
                    }
                });
                SimpleConsumer consumer = KafkaConsumer$.MODULE$.createConsumer(leader.host(), leader.port(), this.config$1, "offsetLookup");
                try {
                    Map requestInfo;
                    Map x$8 = requestInfo = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tap), (Object)new PartitionOffsetRequestInfo(this.time$1, 1))}));
                    String x$9 = consumer.clientId();
                    short x$10 = OffsetRequest$.MODULE$.apply$default$2();
                    int x$11 = OffsetRequest$.MODULE$.apply$default$3();
                    int x$12 = OffsetRequest$.MODULE$.apply$default$5();
                    OffsetRequest request = new OffsetRequest(x$8, x$10, x$11, x$9, x$12);
                    PartitionOffsetsResponse errorAndOffsets = (PartitionOffsetsResponse)consumer.getOffsetsBefore(request).partitionErrorAndOffsets().apply((Object)tap);
                    ErrorMapping$.MODULE$.maybeThrowException(errorAndOffsets.error());
                    iterable = Option$.MODULE$.option2Iterable(errorAndOffsets.offsets().headOption().map((Function1)new Serializable(this, tap){
                        public static final long serialVersionUID = 0L;
                        private final TopicAndPartition tap$2;

                        public final Tuple2<TopicAndPartition, Object> apply(long x$6) {
                            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tap$2), (Object)BoxesRunTime.boxToLong((long)x$6));
                        }
                        {
                            this.tap$2 = tap$2;
                        }
                    }));
                }
                catch (Throwable throwable) {
                    void var4_4;
                    var4_4.close();
                    throw throwable;
                }
                consumer.close();
                return iterable;
            }
            {
                this.topic$3 = topic$3;
                this.time$1 = time$1;
                this.config$1 = config$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    private void handleOffsetErrors(Iterable<Object> codes) {
        ((IterableLike)codes.filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(short x$7) {
                return x$7 != ErrorMapping$.MODULE$.NoError();
            }
        })).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply(short code) {
                BoxedUnit boxedUnit;
                if (code != ErrorMapping$.MODULE$.NotCoordinatorForConsumerCode() && code != ErrorMapping$.MODULE$.OffsetsLoadInProgressCode()) {
                    if (OffsetManager$.MODULE$.logger().underlying().isErrorEnabled()) {
                        OffsetManager$.MODULE$.logger().underlying().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error fetching offsets: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ErrorMapping$.MODULE$.exceptionFor(code)})));
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                throw ErrorMapping$.MODULE$.exceptionFor(code);
            }
        });
    }

    private OffsetManager$() {
        MODULE$ = this;
        LazyLogging.class.$init$((LazyLogging)this);
        this.org$locationtech$geomesa$kafka10$consumer$offsets$OffsetManager$$clientId = "offsetManager";
    }
}

