/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.stats;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.util.Arrays;
import org.locationtech.geomesa.utils.stats.BinnedArray;
import org.locationtech.geomesa.utils.stats.BinnedArray$;
import org.locationtech.geomesa.utils.stats.Histogram$;
import org.locationtech.geomesa.utils.stats.MinMax;
import org.locationtech.geomesa.utils.stats.Stat;
import org.locationtech.geomesa.utils.stats.Stat$;
import org.locationtech.geomesa.utils.stats.Stat$class;
import org.opengis.feature.simple.SimpleFeature;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.ListMap;
import scala.collection.immutable.ListMap$;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\tub\u0001B\u0001\u0003\u00015\u0011\u0011\u0002S5ti><'/Y7\u000b\u0005\r!\u0011!B:uCR\u001c(BA\u0003\u0007\u0003\u0015)H/\u001b7t\u0015\t9\u0001\"A\u0004hK>lWm]1\u000b\u0005%Q\u0011\u0001\u00047pG\u0006$\u0018n\u001c8uK\u000eD'\"A\u0006\u0002\u0007=\u0014xm\u0001\u0001\u0016\u00059!4\u0003\u0002\u0001\u0010+e\u0001\"\u0001E\n\u000e\u0003EQ\u0011AE\u0001\u0006g\u000e\fG.Y\u0005\u0003)E\u0011a!\u00118z%\u00164\u0007C\u0001\f\u0018\u001b\u0005\u0011\u0011B\u0001\r\u0003\u0005\u0011\u0019F/\u0019;\u0011\u0005i\tS\"A\u000e\u000b\u0005qi\u0012\u0001D:dC2\fGn\\4hS:<'B\u0001\u0010 \u0003!!\u0018\u0010]3tC\u001a,'\"\u0001\u0011\u0002\u0007\r|W.\u0003\u0002#7\tYA*\u0019>z\u0019><w-\u001b8h\u0011!!\u0003A!b\u0001\n\u0003)\u0013!C1uiJL'-\u001e;f+\u00051\u0003C\u0001\t(\u0013\tA\u0013CA\u0002J]RD\u0001B\u000b\u0001\u0003\u0002\u0003\u0006IAJ\u0001\u000bCR$(/\u001b2vi\u0016\u0004\u0003\u0002\u0003\u0017\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0014\u0002\u0017%t\u0017\u000e^5bY\nKgn\u001d\u0005\t]\u0001\u0011\t\u0011)A\u0005_\u0005\u0001\u0012N\\5uS\u0006dWI\u001c3q_&tGo\u001d\t\u0005!A\u0012$'\u0003\u00022#\t1A+\u001e9mKJ\u0002\"a\r\u001b\r\u0001\u0011)Q\u0007\u0001b\u0001m\t\tA+\u0005\u00028uA\u0011\u0001\u0003O\u0005\u0003sE\u0011qAT8uQ&tw\r\u0005\u0002\u0011w%\u0011A(\u0005\u0002\u0004\u0003:L\b\u0002\u0003 \u0001\u0005\u000b\u0007I1A \u0002\u0011\u0011,g-Y;miN,\u0012\u0001\u0011\t\u0004\u0003\u0012\u0013dB\u0001\fC\u0013\t\u0019%!\u0001\u0004NS:l\u0015\r_\u0005\u0003\u000b\u001a\u0013a\"T5o\u001b\u0006DH)\u001a4bk2$8O\u0003\u0002D\u0005!A\u0001\n\u0001B\u0001B\u0003%\u0001)A\u0005eK\u001a\fW\u000f\u001c;tA!A!\n\u0001B\u0001B\u0003-1*\u0001\u0002diB\u0019Aj\u0014\u001a\u000e\u00035S!AT\t\u0002\u000fI,g\r\\3di&\u0011\u0001+\u0014\u0002\t\u00072\f7o\u001d+bO\")!\u000b\u0001C\u0001'\u00061A(\u001b8jiz\"B\u0001\u0016-Z5R\u0019QKV,\u0011\u0007Y\u0001!\u0007C\u0003?#\u0002\u000f\u0001\tC\u0003K#\u0002\u000f1\nC\u0003%#\u0002\u0007a\u0005C\u0003-#\u0002\u0007a\u0005C\u0003/#\u0002\u0007q&\u0002\u0003]\u0001\u0001*&!A*\t\u0011y\u0003\u0001\u0019!C\u0001\u0005}\u000bAAY5ogV\t\u0001\rE\u0002\u0017CJJ!A\u0019\u0002\u0003\u0017\tKgN\\3e\u0003J\u0014\u0018-\u001f\u0005\tI\u0002\u0001\r\u0011\"\u0001\u0003K\u0006A!-\u001b8t?\u0012*\u0017\u000f\u0006\u0002gSB\u0011\u0001cZ\u0005\u0003QF\u0011A!\u00168ji\"9!nYA\u0001\u0002\u0004\u0001\u0017a\u0001=%c!1A\u000e\u0001Q!\n\u0001\fQAY5og\u0002B\u0001B\u001c\u0001\t\u0006\u0004%\ta\\\u0001\ngR\u0014\u0018N\\4jMf,\u0012\u0001\u001d\t\u0005!ET4/\u0003\u0002s#\tIa)\u001e8di&|g.\r\t\u0003i^t!\u0001E;\n\u0005Y\f\u0012A\u0002)sK\u0012,g-\u0003\u0002ys\n11\u000b\u001e:j]\u001eT!A^\t\t\u0011m\u0004\u0001\u0012!Q!\nA\f!b\u001d;sS:<\u0017NZ=!\u0011\u0015i\b\u0001\"\u0001&\u0003\u0019aWM\\4uQ\"1q\u0010\u0001C\u0001\u0003\u0003\t1\u0002Z5sK\u000e$\u0018J\u001c3fqR\u0019a%a\u0001\t\u000f\u0005\u0015a\u00101\u0001\u0002\b\u0005)a/\u00197vKB\u0019\u0001#!\u0003\n\u0007\u0005-\u0011C\u0001\u0003M_:<\u0007bBA\b\u0001\u0011\u0005\u0011\u0011C\u0001\bS:$W\r_(g)\r1\u00131\u0003\u0005\b\u0003\u000b\ti\u00011\u00013\u0011\u001d\t9\u0002\u0001C\u0001\u00033\tQaY8v]R$B!a\u0002\u0002\u001c!9\u0011QDA\u000b\u0001\u00041\u0013!A5\t\u000f\u0005\u0005\u0002\u0001\"\u0001\u0002$\u0005\u0019Q.\u001b8\u0016\u0003IBq!a\n\u0001\t\u0003\t\u0019#A\u0002nCbDq!a\u000b\u0001\t\u0003\ti#\u0001\u0004c_VtGm]\u000b\u0002_!9\u00111\u0006\u0001\u0005\u0002\u0005EBcA\u0018\u00024!9\u0011QDA\u0018\u0001\u00041\u0003bBA\u001c\u0001\u0011\u0005\u0011\u0011H\u0001\f[\u0016$\u0017.\u00198WC2,X\rF\u00023\u0003wAq!!\b\u00026\u0001\u0007a\u0005C\u0004\u0002@\u0001!\t!!\u0011\u0002\u001b\u0005$GmQ8v]R\u001chI]8n)\r1\u00171\t\u0005\b\u0003\u000b\ni\u00041\u0001V\u0003\u0015yG\u000f[3s\u0011\u001d\tI\u0005\u0001C!\u0003\u0017\nqa\u001c2tKJ4X\rF\u0002g\u0003\u001bB\u0001\"a\u0014\u0002H\u0001\u0007\u0011\u0011K\u0001\u0003g\u001a\u0004B!a\u0015\u0002b5\u0011\u0011Q\u000b\u0006\u0005\u0003/\nI&\u0001\u0004tS6\u0004H.\u001a\u0006\u0005\u00037\ni&A\u0004gK\u0006$XO]3\u000b\u0007\u0005}#\"A\u0004pa\u0016tw-[:\n\t\u0005\r\u0014Q\u000b\u0002\u000e'&l\u0007\u000f\\3GK\u0006$XO]3\t\u000f\u0005\u001d\u0004\u0001\"\u0011\u0002j\u0005IQO\\8cg\u0016\u0014h/\u001a\u000b\u0004M\u0006-\u0004\u0002CA(\u0003K\u0002\r!!\u0015\t\u000f\u0005=\u0004\u0001\"\u0011\u0002r\u0005)A\u0005\u001d7vgR\u0019Q+a\u001d\t\u000f\u0005\u0015\u0013Q\u000ea\u0001+\"9\u0011q\u000f\u0001\u0005B\u0005e\u0014\u0001\u0003\u0013qYV\u001cH%Z9\u0015\u0007\u0019\fY\bC\u0004\u0002F\u0005U\u0004\u0019A+\t\u000f\u0005}\u0004\u0001\"\u0011\u0002\u0002\u0006aAo\u001c&t_:|%M[3diV\u0011\u00111\u0011\t\b\u0003\u000b\u000by)a%;\u001b\t\t9I\u0003\u0003\u0002\n\u0006-\u0015!C5n[V$\u0018M\u00197f\u0015\r\ti)E\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAI\u0003\u000f\u0013q\u0001T5ti6\u000b\u0007\u000f\u0005\u0003\u0002\u0016\u0006}UBAAL\u0015\u0011\tI*a'\u0002\t1\fgn\u001a\u0006\u0003\u0003;\u000bAA[1wC&\u0019\u00010a&\t\u000f\u0005\r\u0006\u0001\"\u0011\u0002&\u00069\u0011n]#naRLXCAAT!\r\u0001\u0012\u0011V\u0005\u0004\u0003W\u000b\"a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003_\u0003A\u0011IAY\u0003\u0015\u0019G.Z1s)\u00051\u0007bBA[\u0001\u0011\u0005\u0013qW\u0001\rSN,\u0015/^5wC2,g\u000e\u001e\u000b\u0005\u0003O\u000bI\fC\u0004\u0002F\u0005M\u0006\u0019A\u000b\b\u000f\u0005u&\u0001#\u0001\u0002@\u0006I\u0001*[:u_\u001e\u0014\u0018-\u001c\t\u0004-\u0005\u0005gAB\u0001\u0003\u0011\u0003\t\u0019mE\u0002\u0002B>AqAUAa\t\u0003\t9\r\u0006\u0002\u0002@\"A\u00111ZAa\t\u0003\ti-\u0001\u0004ck\u001a4WM]\u000b\u0005\u0003\u001f\f)\u000e\u0006\u0003\u0002R\u0006]\u0007C\u0002\t1\u0003'\f\u0019\u000eE\u00024\u0003+$a!NAe\u0005\u00041\u0004\u0002CA\u0003\u0003\u0013\u0004\r!a5\t\u0011\u0005m\u0017\u0011\u0019C\u0001\u0003;\f!\"\u001a=qC:$')\u001b8t+\u0011\ty.a:\u0015\r\u0005\u0005\u0018\u0011_Az)\u0019\t\u0019/!;\u0002nB!a#YAs!\r\u0019\u0014q\u001d\u0003\u0007k\u0005e'\u0019\u0001\u001c\t\u000fy\nI\u000eq\u0001\u0002lB!\u0011\tRAs\u0011\u001dQ\u0015\u0011\u001ca\u0002\u0003_\u0004B\u0001T(\u0002f\"A\u0011QAAm\u0001\u0004\t)\u000f\u0003\u0005\u0002v\u0006e\u0007\u0019AAr\u0003\ryG\u000e\u001a\u0005\t\u0003s\f\t\r\"\u0001\u0002|\u0006q1\r[3dW\u0016sG\r]8j]R\u001cX\u0003BA\u007f\u0005\u000b!b!a@\u0003\f\tEA\u0003\u0002B\u0001\u0005\u000f\u0001b\u0001\u0005\u0019\u0003\u0004\t\r\u0001cA\u001a\u0003\u0006\u00111Q'a>C\u0002YBqAPA|\u0001\b\u0011I\u0001\u0005\u0003B\t\n\r\u0001\u0002\u0003B\u0007\u0003o\u0004\rAa\u0004\u0002\t1,g\r\u001e\t\u0005-\u0005\u0014\u0019\u0001\u0003\u0005\u0003\u0014\u0005]\b\u0019\u0001B\b\u0003\u0015\u0011\u0018n\u001a5u\u0011!\u00119\"!1\u0005\n\te\u0011aD4fi\u0006\u001bG/^1m\u0005>,h\u000eZ:\u0016\t\tm!\u0011\u0005\u000b\u0005\u0005;\u0011\u0019\u0003\u0005\u0004\u0011a\t}!q\u0004\t\u0004g\t\u0005BAB\u001b\u0003\u0016\t\u0007a\u0007C\u0004_\u0005+\u0001\rA!\n\u0011\tY\t'q\u0004\u0005\t\u0005S\t\t\r\"\u0001\u0003,\u0005A1m\u001c9z\u0013:$x.\u0006\u0003\u0003.\t]B#\u00024\u00030\te\u0002\u0002\u0003B\u0019\u0005O\u0001\rAa\r\u0002\u0005Q|\u0007\u0003\u0002\fb\u0005k\u00012a\rB\u001c\t\u0019)$q\u0005b\u0001m!A!1\bB\u0014\u0001\u0004\u0011\u0019$\u0001\u0003ge>l\u0007")
public class Histogram<T>
implements Stat,
LazyLogging {
    private final int attribute;
    private final MinMax.MinMaxDefaults<T> defaults;
    private final ClassTag<T> ct;
    private BinnedArray<T> bins;
    private Function1<Object, String> stringify;
    private final Logger logger;
    private volatile byte bitmap$0;

    public static <T> void copyInto(BinnedArray<T> binnedArray, BinnedArray<T> binnedArray2) {
        Histogram$.MODULE$.copyInto(binnedArray, binnedArray2);
    }

    public static <T> Tuple2<T, T> checkEndpoints(BinnedArray<T> binnedArray, BinnedArray<T> binnedArray2, MinMax.MinMaxDefaults<T> minMaxDefaults) {
        return Histogram$.MODULE$.checkEndpoints(binnedArray, binnedArray2, minMaxDefaults);
    }

    public static <T> BinnedArray<T> expandBins(T t, BinnedArray<T> binnedArray, MinMax.MinMaxDefaults<T> minMaxDefaults, ClassTag<T> classTag) {
        return Histogram$.MODULE$.expandBins(t, binnedArray, minMaxDefaults, classTag);
    }

    public static <T> Tuple2<T, T> buffer(T t) {
        return Histogram$.MODULE$.buffer(t);
    }

    private Function1 stringify$lzycompute() {
        Histogram histogram2 = this;
        synchronized (histogram2) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.stringify = Stat$.MODULE$.stringifier(this.ct.runtimeClass(), Stat$.MODULE$.stringifier$default$2());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.stringify;
        }
    }

    private Logger logger$lzycompute() {
        Histogram histogram2 = this;
        synchronized (histogram2) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public void $plus$eq(Stat other, Predef.DummyImplicit d) {
        Stat$class.$plus$eq(this, other, d);
    }

    @Override
    public Stat $plus(Stat other, Predef.DummyImplicit d) {
        return Stat$class.$plus(this, other, d);
    }

    @Override
    public String toJson() {
        return Stat$class.toJson(this);
    }

    public int attribute() {
        return this.attribute;
    }

    public MinMax.MinMaxDefaults<T> defaults() {
        return this.defaults;
    }

    public BinnedArray<T> bins() {
        return this.bins;
    }

    public void bins_$eq(BinnedArray<T> x$1) {
        this.bins = x$1;
    }

    public Function1<Object, String> stringify() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.stringify$lzycompute() : this.stringify;
    }

    public int length() {
        return this.bins().length();
    }

    public int directIndex(long value2) {
        return this.bins().directIndex(value2);
    }

    public int indexOf(T value2) {
        return this.bins().indexOf(value2);
    }

    public long count(int i) {
        return this.bins().counts()[i];
    }

    public T min() {
        return (T)this.bins().bounds()._1();
    }

    public T max() {
        return (T)this.bins().bounds()._2();
    }

    public Tuple2<T, T> bounds() {
        return this.bins().bounds();
    }

    public Tuple2<T, T> bounds(int i) {
        return this.bins().bounds(i);
    }

    public T medianValue(int i) {
        return this.bins().medianValue(i);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void addCountsFrom(Histogram<T> other) {
        if (this.length() == other.length()) {
            Tuple2<T, T> tuple2 = this.bounds();
            Tuple2<T, T> tuple22 = other.bounds();
            if (!(tuple2 != null ? !tuple2.equals(tuple22) : tuple22 != null)) {
                this.$plus$eq(other);
                return;
            }
        }
        Histogram$.MODULE$.copyInto(this.bins(), other.bins());
    }

    @Override
    public void observe(SimpleFeature sf) {
        Object value2 = sf.getAttribute(this.attribute());
        if (value2 != null) {
            try {
                int i = this.bins().indexOf(value2);
                if (i == -1) {
                    this.bins_$eq(Histogram$.MODULE$.expandBins(value2, this.bins(), this.defaults(), this.ct));
                    BinnedArray<Object> qual$1 = this.bins();
                    Object x$8 = value2;
                    long x$9 = qual$1.add$default$2();
                    qual$1.add(x$8, x$9);
                } else {
                    long[] lArray = this.bins().counts();
                    lArray[i] = lArray[i] + 1L;
                }
            }
            catch (Exception exception) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error observing value '", "': ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{value2, exception.toString()})));
                    boxedUnit = BoxedUnit.UNIT;
                }
                boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    @Override
    public void unobserve(SimpleFeature sf) {
        Object value2 = sf.getAttribute(this.attribute());
        if (value2 != null) {
            try {
                int i = this.bins().indexOf(value2);
                if (i == -1) {
                    this.bins_$eq(Histogram$.MODULE$.expandBins(value2, this.bins(), this.defaults(), this.ct));
                    this.bins().add(value2, -1L);
                } else {
                    long[] lArray = this.bins().counts();
                    lArray[i] = lArray[i] - 1L;
                }
            }
            catch (Exception exception) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error un-observing value '", "': ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{value2, exception.toString()})));
                    boxedUnit = BoxedUnit.UNIT;
                }
                boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public Histogram<T> $plus(Histogram<T> other) {
        void var2_2;
        Histogram<T> plus2 = new Histogram<T>(this.attribute(), this.length(), this.bounds(), this.defaults(), this.ct);
        plus2.$plus$eq(this);
        plus2.$plus$eq(other);
        return var2_2;
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    public void $plus$eq(Histogram<T> other) {
        if (this.length() == other.length()) {
            Tuple2<T, T> tuple2 = this.bounds();
            Tuple2<T, T> tuple22 = other.bounds();
            if (!(tuple2 != null ? !tuple2.equals(tuple22) : tuple22 != null)) {
                int i = 0;
                while (i < this.bins().length()) {
                    long[] lArray = this.bins().counts();
                    int n = i;
                    lArray[n] = lArray[n] + other.bins().counts()[i];
                    ++i;
                }
                return;
            }
        }
        if (other.isEmpty()) return;
        if (this.isEmpty()) {
            this.bins_$eq(BinnedArray$.MODULE$.apply(other.length(), other.bounds(), this.ct));
            int i = 0;
            while (i < this.bins().length()) {
                this.bins().counts()[i] = other.bins().counts()[i];
                ++i;
            }
            return;
        }
        Tuple2<T, T> newEndpoints = Histogram$.MODULE$.checkEndpoints(this.bins(), other.bins(), this.defaults());
        int newLength = package$.MODULE$.max(this.length(), other.length());
        Tuple2<T, T> tuple2 = newEndpoints;
        Tuple2<T, T> tuple23 = this.bounds();
        if ((tuple2 != null ? !tuple2.equals(tuple23) : tuple23 != null) || newLength != this.length()) {
            BinnedArray<T> newBins = BinnedArray$.MODULE$.apply(newLength, newEndpoints, this.ct);
            Histogram$.MODULE$.copyInto(newBins, this.bins());
            this.bins_$eq(newBins);
        }
        Histogram$.MODULE$.copyInto(this.bins(), other.bins());
    }

    public ListMap<String, Object> toJsonObject() {
        Tuple2[] tuple2Array = new Tuple2[3];
        tuple2Array[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"lower-bound"), this.bounds()._1());
        tuple2Array[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"upper-bound"), this.bounds()._2());
        ListMap listMap = (ListMap)ListMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"index"), (Object)BoxesRunTime.boxToInteger((int)0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"lower-bound"), this.bounds(0)._1()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"upper-bound"), this.bounds(0)._2()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"count"), (Object)BoxesRunTime.boxToLong((long)this.bins().counts()[0]))}));
        tuple2Array[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bins"), ((SeqLike)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), this.bins().length()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Histogram $outer;

            public final ListMap<String, Object> apply(int i) {
                return (ListMap)ListMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"index"), (Object)BoxesRunTime.boxToInteger((int)i)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"upper-bound"), this.$outer.bounds(i)._2()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"count"), (Object)BoxesRunTime.boxToLong((long)this.$outer.bins().counts()[i]))}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).$plus$colon((Object)listMap, IndexedSeq$.MODULE$.canBuildFrom()));
        return (ListMap)ListMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array));
    }

    @Override
    public boolean isEmpty() {
        return Predef$.MODULE$.longArrayOps(this.bins().counts()).forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(long x$2) {
                return this.apply$mcZJ$sp(x$2);
            }

            public boolean apply$mcZJ$sp(long x$2) {
                return x$2 == 0L;
            }
        });
    }

    @Override
    public void clear() {
        this.bins().clear();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isEquivalent(Stat other) {
        Stat stat2 = other;
        if (!(stat2 instanceof Histogram)) return false;
        Histogram histogram2 = (Histogram)stat2;
        if (this.attribute() != histogram2.attribute()) return false;
        Tuple2<T, T> tuple2 = this.bounds();
        Tuple2<T, T> tuple22 = histogram2.bounds();
        if (tuple2 == null) {
            if (tuple22 != null) {
                return false;
            }
        } else if (!tuple2.equals(tuple22)) return false;
        if (!Arrays.equals(this.bins().counts(), histogram2.bins().counts())) return false;
        return true;
    }

    public Histogram(int attribute2, int initialBins, Tuple2<T, T> initialEndpoints, MinMax.MinMaxDefaults<T> defaults, ClassTag<T> ct) {
        this.attribute = attribute2;
        this.defaults = defaults;
        this.ct = ct;
        Stat$class.$init$(this);
        LazyLogging.class.$init$((LazyLogging)this);
        this.bins = BinnedArray$.MODULE$.apply(initialBins, initialEndpoints, ct);
    }
}

