/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.features.kryo;

import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.vividsolutions.jts.geom.Geometry;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.locationtech.geomesa.features.kryo.json.KryoJsonSerialization$;
import org.locationtech.geomesa.features.kryo.serialization.KryoGeometrySerialization$;
import org.locationtech.geomesa.features.serialization.ObjectType$;
import org.locationtech.geomesa.utils.cache.SoftThreadLocal;
import org.locationtech.geomesa.utils.cache.SoftThreadLocalCache;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class KryoFeatureSerializer$ {
    public static final KryoFeatureSerializer$ MODULE$;
    private final int VERSION;
    private final byte NULL_BYTE;
    private final byte NON_NULL_BYTE;
    private final SoftThreadLocal<Input> inputs;
    private final SoftThreadLocal<Output> outputs;
    private final SoftThreadLocalCache<String, Function1<Input, Object>[]> readers;
    private final SoftThreadLocalCache<String, Function2<Output, Object, BoxedUnit>[]> writers;
    private final SoftThreadLocalCache<String, int[]> offsets;

    static {
        new KryoFeatureSerializer$();
    }

    public int VERSION() {
        return this.VERSION;
    }

    public byte NULL_BYTE() {
        return this.NULL_BYTE;
    }

    public byte NON_NULL_BYTE() {
        return this.NON_NULL_BYTE;
    }

    public Input getInput(byte[] bytes, int offset, int count) {
        Input in = (Input)this.inputs.getOrElseUpdate((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Input apply() {
                return new Input();
            }
        });
        in.setBuffer(bytes, offset, offset + count);
        return in;
    }

    /*
     * WARNING - void declaration
     */
    public Input getInput(InputStream stream) {
        void var2_2;
        Input in = (Input)this.inputs.getOrElseUpdate((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Input apply() {
                return new Input();
            }
        });
        in.setBuffer((byte[])Array$.MODULE$.ofDim(1024, ClassTag$.MODULE$.Byte()));
        in.setInputStream(stream);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public Output getOutput(OutputStream stream) {
        void var2_2;
        Output out = (Output)this.outputs.getOrElseUpdate((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Output apply() {
                return new Output(1024, -1);
            }
        });
        out.setOutputStream(stream);
        return var2_2;
    }

    public int[] getOffsets(String sft, int size) {
        return (int[])this.offsets.getOrElseUpdate((Object)sft, (Function0)new Serializable(size){
            public static final long serialVersionUID = 0L;
            private final int size$1;

            public final int[] apply() {
                return (int[])Array$.MODULE$.ofDim(this.size$1, ClassTag$.MODULE$.Int());
            }
            {
                this.size$1 = size$1;
            }
        });
    }

    public Function2<Output, Object, BoxedUnit>[] getWriters(String key, SimpleFeatureType sft) {
        return (Function2[])this.writers.getOrElseUpdate((Object)key, (Function0)new Serializable(sft){
            public static final long serialVersionUID = 0L;
            private final SimpleFeatureType sft$1;

            public final Function2<Output, Object, BoxedUnit>[] apply() {
                return (Function2[])((TraversableOnce)JavaConversions$.MODULE$.asScalaBuffer(this.sft$1.getAttributeDescriptors()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Function2<Output, Object, BoxedUnit> apply(AttributeDescriptor ad) {
                        Tuple2 tuple2 = ObjectType$.MODULE$.selectType(ad.getType().getBinding(), ad.getUserData());
                        if (tuple2 != null) {
                            Tuple2 tuple22;
                            Enumeration.Value otype = (Enumeration.Value)tuple2._1();
                            Seq bindings = (Seq)tuple2._2();
                            Tuple2 tuple23 = tuple22 = new Tuple2((Object)otype, (Object)bindings);
                            Enumeration.Value otype2 = (Enumeration.Value)tuple23._1();
                            Seq bindings2 = (Seq)tuple23._2();
                            return KryoFeatureSerializer$.MODULE$.matchWriter(otype2, (Seq<Enumeration.Value>)bindings2);
                        }
                        throw new MatchError((Object)tuple2);
                    }
                }, Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Function2.class));
            }
            {
                this.sft$1 = sft$1;
            }
        });
    }

    public Function2<Output, Object, BoxedUnit> matchWriter(Enumeration.Value otype, Seq<Enumeration.Value> bindings) {
        Enumeration.Value value;
        block15: {
            Object object;
            block3: {
                block14: {
                    block13: {
                        block12: {
                            block11: {
                                block10: {
                                    block9: {
                                        block8: {
                                            block7: {
                                                block6: {
                                                    block5: {
                                                        block4: {
                                                            block2: {
                                                                value = otype;
                                                                Enumeration.Value value2 = ObjectType$.MODULE$.STRING();
                                                                Enumeration.Value value3 = value;
                                                                if (value2 != null ? !value2.equals(value3) : value3 != null) break block2;
                                                                object = new Serializable(){
                                                                    public static final long serialVersionUID = 0L;

                                                                    public final void apply(Output o, Object v) {
                                                                        o.writeString((String)v);
                                                                    }
                                                                };
                                                                break block3;
                                                            }
                                                            Enumeration.Value value4 = ObjectType$.MODULE$.INT();
                                                            Enumeration.Value value5 = value;
                                                            if (value4 != null ? !value4.equals(value5) : value5 != null) break block4;
                                                            Serializable w = new Serializable(){
                                                                public static final long serialVersionUID = 0L;

                                                                public final void apply(Output o, Object v) {
                                                                    o.writeInt(BoxesRunTime.unboxToInt((Object)v));
                                                                }
                                                            };
                                                            object = this.writeNullable((Function2<Output, Object, BoxedUnit>)w);
                                                            break block3;
                                                        }
                                                        Enumeration.Value value6 = ObjectType$.MODULE$.LONG();
                                                        Enumeration.Value value7 = value;
                                                        if (value6 != null ? !value6.equals(value7) : value7 != null) break block5;
                                                        Serializable w = new Serializable(){
                                                            public static final long serialVersionUID = 0L;

                                                            public final void apply(Output o, Object v) {
                                                                o.writeLong(BoxesRunTime.unboxToLong((Object)v));
                                                            }
                                                        };
                                                        object = this.writeNullable((Function2<Output, Object, BoxedUnit>)w);
                                                        break block3;
                                                    }
                                                    Enumeration.Value value8 = ObjectType$.MODULE$.FLOAT();
                                                    Enumeration.Value value9 = value;
                                                    if (value8 != null ? !value8.equals(value9) : value9 != null) break block6;
                                                    Serializable w = new Serializable(){
                                                        public static final long serialVersionUID = 0L;

                                                        public final void apply(Output o, Object v) {
                                                            o.writeFloat(BoxesRunTime.unboxToFloat((Object)v));
                                                        }
                                                    };
                                                    object = this.writeNullable((Function2<Output, Object, BoxedUnit>)w);
                                                    break block3;
                                                }
                                                Enumeration.Value value10 = ObjectType$.MODULE$.DOUBLE();
                                                Enumeration.Value value11 = value;
                                                if (value10 != null ? !value10.equals(value11) : value11 != null) break block7;
                                                Serializable w = new Serializable(){
                                                    public static final long serialVersionUID = 0L;

                                                    public final void apply(Output o, Object v) {
                                                        o.writeDouble(BoxesRunTime.unboxToDouble((Object)v));
                                                    }
                                                };
                                                object = this.writeNullable((Function2<Output, Object, BoxedUnit>)w);
                                                break block3;
                                            }
                                            Enumeration.Value value12 = ObjectType$.MODULE$.BOOLEAN();
                                            Enumeration.Value value13 = value;
                                            if (value12 != null ? !value12.equals(value13) : value13 != null) break block8;
                                            Serializable w = new Serializable(){
                                                public static final long serialVersionUID = 0L;

                                                public final void apply(Output o, Object v) {
                                                    o.writeBoolean(BoxesRunTime.unboxToBoolean((Object)v));
                                                }
                                            };
                                            object = this.writeNullable((Function2<Output, Object, BoxedUnit>)w);
                                            break block3;
                                        }
                                        Enumeration.Value value14 = ObjectType$.MODULE$.DATE();
                                        Enumeration.Value value15 = value;
                                        if (value14 != null ? !value14.equals(value15) : value15 != null) break block9;
                                        Serializable w = new Serializable(){
                                            public static final long serialVersionUID = 0L;

                                            public final void apply(Output o, Object v) {
                                                o.writeLong(((Date)v).getTime());
                                            }
                                        };
                                        object = this.writeNullable((Function2<Output, Object, BoxedUnit>)w);
                                        break block3;
                                    }
                                    Enumeration.Value value16 = ObjectType$.MODULE$.UUID();
                                    Enumeration.Value value17 = value;
                                    if (value16 != null ? !value16.equals(value17) : value17 != null) break block10;
                                    Serializable w = new Serializable(){
                                        public static final long serialVersionUID = 0L;

                                        public final void apply(Output o, Object v) {
                                            UUID uuid = (UUID)v;
                                            o.writeLong(uuid.getMostSignificantBits());
                                            o.writeLong(uuid.getLeastSignificantBits());
                                        }
                                    };
                                    object = this.writeNullable((Function2<Output, Object, BoxedUnit>)w);
                                    break block3;
                                }
                                Enumeration.Value value18 = ObjectType$.MODULE$.GEOMETRY();
                                Enumeration.Value value19 = value;
                                if (value18 != null ? !value18.equals(value19) : value19 != null) break block11;
                                object = new Serializable(){
                                    public static final long serialVersionUID = 0L;

                                    public final void apply(Output o, Object v) {
                                        KryoGeometrySerialization$.MODULE$.serialize(o, (Geometry)v);
                                    }
                                };
                                break block3;
                            }
                            Enumeration.Value value20 = ObjectType$.MODULE$.JSON();
                            Enumeration.Value value21 = value;
                            if (value20 != null ? !value20.equals(value21) : value21 != null) break block12;
                            object = new Serializable(){
                                public static final long serialVersionUID = 0L;

                                public final void apply(Output o, Object v) {
                                    KryoJsonSerialization$.MODULE$.serialize(o, (String)v);
                                }
                            };
                            break block3;
                        }
                        Enumeration.Value value22 = ObjectType$.MODULE$.LIST();
                        Enumeration.Value value23 = value;
                        if (value22 != null ? !value22.equals(value23) : value23 != null) break block13;
                        Function2<Output, Object, BoxedUnit> valueWriter = this.matchWriter((Enumeration.Value)bindings.head(), this.matchWriter$default$2());
                        object = new Serializable(valueWriter){
                            public static final long serialVersionUID = 0L;
                            private final Function2 valueWriter$1;

                            public final void apply(Output o, Object v) {
                                List list = (List)v;
                                if (list == null) {
                                    o.writeInt(-1, true);
                                } else {
                                    o.writeInt(list.size(), true);
                                    Iterator<E> iter = list.iterator();
                                    while (iter.hasNext()) {
                                        this.valueWriter$1.apply((Object)o, iter.next());
                                    }
                                }
                            }
                            {
                                this.valueWriter$1 = valueWriter$1;
                            }
                        };
                        break block3;
                    }
                    Enumeration.Value value24 = ObjectType$.MODULE$.MAP();
                    Enumeration.Value value25 = value;
                    if (value24 != null ? !value24.equals(value25) : value25 != null) break block14;
                    Function2<Output, Object, BoxedUnit> keyWriter = this.matchWriter((Enumeration.Value)bindings.head(), this.matchWriter$default$2());
                    Function2<Output, Object, BoxedUnit> valueWriter = this.matchWriter((Enumeration.Value)bindings.apply(1), this.matchWriter$default$2());
                    object = new Serializable(keyWriter, valueWriter){
                        public static final long serialVersionUID = 0L;
                        private final Function2 keyWriter$1;
                        private final Function2 valueWriter$2;

                        public final void apply(Output o, Object v) {
                            Map map = (Map)v;
                            if (map == null) {
                                o.writeInt(-1, true);
                            } else {
                                o.writeInt(map.size(), true);
                                for (Map.Entry<K, V> entry : map.entrySet()) {
                                    this.keyWriter$1.apply((Object)o, entry.getKey());
                                    this.valueWriter$2.apply((Object)o, entry.getValue());
                                }
                            }
                        }
                        {
                            this.keyWriter$1 = keyWriter$1;
                            this.valueWriter$2 = valueWriter$2;
                        }
                    };
                    break block3;
                }
                Enumeration.Value value26 = ObjectType$.MODULE$.BYTES();
                Enumeration.Value value27 = value;
                if (value26 != null ? !value26.equals(value27) : value27 != null) break block15;
                object = new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final void apply(Output o, Object v) {
                        byte[] arr = (byte[])v;
                        if (arr == null) {
                            o.writeInt(-1, true);
                        } else {
                            o.writeInt(arr.length, true);
                            o.writeBytes(arr);
                        }
                    }
                };
            }
            return object;
        }
        throw new MatchError((Object)value);
    }

    public Seq<Enumeration.Value> matchWriter$default$2() {
        return (Seq)Seq$.MODULE$.empty();
    }

    public Function2<Output, Object, BoxedUnit> writeNullable(Function2<Output, Object, BoxedUnit> wrapped) {
        return new Serializable(wrapped){
            public static final long serialVersionUID = 0L;
            private final Function2 wrapped$1;

            public final void apply(Output o, Object v) {
                if (v == null) {
                    o.write((int)KryoFeatureSerializer$.MODULE$.NULL_BYTE());
                } else {
                    o.write((int)KryoFeatureSerializer$.MODULE$.NON_NULL_BYTE());
                    this.wrapped$1.apply((Object)o, v);
                }
            }
            {
                this.wrapped$1 = wrapped$1;
            }
        };
    }

    public Function1<Input, Object>[] getReaders(String key, SimpleFeatureType sft) {
        return (Function1[])this.readers.getOrElseUpdate((Object)key, (Function0)new Serializable(sft){
            public static final long serialVersionUID = 0L;
            private final SimpleFeatureType sft$2;

            public final Function1<Input, Object>[] apply() {
                return (Function1[])((TraversableOnce)JavaConversions$.MODULE$.asScalaBuffer(this.sft$2.getAttributeDescriptors()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Function1<Input, Object> apply(AttributeDescriptor ad) {
                        Tuple2 tuple2 = ObjectType$.MODULE$.selectType(ad.getType().getBinding(), ad.getUserData());
                        if (tuple2 != null) {
                            Tuple2 tuple22;
                            Enumeration.Value otype = (Enumeration.Value)tuple2._1();
                            Seq bindings = (Seq)tuple2._2();
                            Tuple2 tuple23 = tuple22 = new Tuple2((Object)otype, (Object)bindings);
                            Enumeration.Value otype2 = (Enumeration.Value)tuple23._1();
                            Seq bindings2 = (Seq)tuple23._2();
                            return KryoFeatureSerializer$.MODULE$.matchReader(otype2, (Seq<Enumeration.Value>)bindings2);
                        }
                        throw new MatchError((Object)tuple2);
                    }
                }, Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Function1.class));
            }
            {
                this.sft$2 = sft$2;
            }
        });
    }

    public Function1<Input, Object> matchReader(Enumeration.Value otype, Seq<Enumeration.Value> bindings) {
        Enumeration.Value value;
        block15: {
            Object object;
            block3: {
                block14: {
                    block13: {
                        block12: {
                            block11: {
                                block10: {
                                    block9: {
                                        block8: {
                                            block7: {
                                                block6: {
                                                    block5: {
                                                        block4: {
                                                            block2: {
                                                                value = otype;
                                                                Enumeration.Value value2 = ObjectType$.MODULE$.STRING();
                                                                Enumeration.Value value3 = value;
                                                                if (value2 != null ? !value2.equals(value3) : value3 != null) break block2;
                                                                object = new Serializable(){
                                                                    public static final long serialVersionUID = 0L;

                                                                    public final String apply(Input i) {
                                                                        return i.readString();
                                                                    }
                                                                };
                                                                break block3;
                                                            }
                                                            Enumeration.Value value4 = ObjectType$.MODULE$.INT();
                                                            Enumeration.Value value5 = value;
                                                            if (value4 != null ? !value4.equals(value5) : value5 != null) break block4;
                                                            object = this.readNullable((Function1<Input, Object>)new Serializable(){
                                                                public static final long serialVersionUID = 0L;

                                                                public final Object apply(Input i) {
                                                                    return BoxesRunTime.boxToInteger((int)i.readInt());
                                                                }
                                                            });
                                                            break block3;
                                                        }
                                                        Enumeration.Value value6 = ObjectType$.MODULE$.LONG();
                                                        Enumeration.Value value7 = value;
                                                        if (value6 != null ? !value6.equals(value7) : value7 != null) break block5;
                                                        object = this.readNullable((Function1<Input, Object>)new Serializable(){
                                                            public static final long serialVersionUID = 0L;

                                                            public final Object apply(Input i) {
                                                                return BoxesRunTime.boxToLong((long)i.readLong());
                                                            }
                                                        });
                                                        break block3;
                                                    }
                                                    Enumeration.Value value8 = ObjectType$.MODULE$.FLOAT();
                                                    Enumeration.Value value9 = value;
                                                    if (value8 != null ? !value8.equals(value9) : value9 != null) break block6;
                                                    object = this.readNullable((Function1<Input, Object>)new Serializable(){
                                                        public static final long serialVersionUID = 0L;

                                                        public final Object apply(Input i) {
                                                            return BoxesRunTime.boxToFloat((float)i.readFloat());
                                                        }
                                                    });
                                                    break block3;
                                                }
                                                Enumeration.Value value10 = ObjectType$.MODULE$.DOUBLE();
                                                Enumeration.Value value11 = value;
                                                if (value10 != null ? !value10.equals(value11) : value11 != null) break block7;
                                                object = this.readNullable((Function1<Input, Object>)new Serializable(){
                                                    public static final long serialVersionUID = 0L;

                                                    public final Object apply(Input i) {
                                                        return BoxesRunTime.boxToDouble((double)i.readDouble());
                                                    }
                                                });
                                                break block3;
                                            }
                                            Enumeration.Value value12 = ObjectType$.MODULE$.BOOLEAN();
                                            Enumeration.Value value13 = value;
                                            if (value12 != null ? !value12.equals(value13) : value13 != null) break block8;
                                            object = this.readNullable((Function1<Input, Object>)new Serializable(){
                                                public static final long serialVersionUID = 0L;

                                                public final Object apply(Input i) {
                                                    return BoxesRunTime.boxToBoolean((boolean)i.readBoolean());
                                                }
                                            });
                                            break block3;
                                        }
                                        Enumeration.Value value14 = ObjectType$.MODULE$.DATE();
                                        Enumeration.Value value15 = value;
                                        if (value14 != null ? !value14.equals(value15) : value15 != null) break block9;
                                        object = this.readNullable((Function1<Input, Object>)new Serializable(){
                                            public static final long serialVersionUID = 0L;

                                            public final Object apply(Input i) {
                                                return new Date(i.readLong());
                                            }
                                        });
                                        break block3;
                                    }
                                    Enumeration.Value value16 = ObjectType$.MODULE$.UUID();
                                    Enumeration.Value value17 = value;
                                    if (value16 != null ? !value16.equals(value17) : value17 != null) break block10;
                                    Serializable w = new Serializable(){
                                        public static final long serialVersionUID = 0L;

                                        public final UUID apply(Input i) {
                                            long mostSignificantBits = i.readLong();
                                            long leastSignificantBits = i.readLong();
                                            return new UUID(mostSignificantBits, leastSignificantBits);
                                        }
                                    };
                                    object = this.readNullable((Function1<Input, Object>)w);
                                    break block3;
                                }
                                Enumeration.Value value18 = ObjectType$.MODULE$.GEOMETRY();
                                Enumeration.Value value19 = value;
                                if (value18 != null ? !value18.equals(value19) : value19 != null) break block11;
                                object = new Serializable(){
                                    public static final long serialVersionUID = 0L;

                                    public final Geometry apply(Input in) {
                                        return KryoGeometrySerialization$.MODULE$.deserialize(in);
                                    }
                                };
                                break block3;
                            }
                            Enumeration.Value value20 = ObjectType$.MODULE$.JSON();
                            Enumeration.Value value21 = value;
                            if (value20 != null ? !value20.equals(value21) : value21 != null) break block12;
                            object = new Serializable(){
                                public static final long serialVersionUID = 0L;

                                public final String apply(Input i) {
                                    return KryoJsonSerialization$.MODULE$.deserializeAndRender(i);
                                }
                            };
                            break block3;
                        }
                        Enumeration.Value value22 = ObjectType$.MODULE$.LIST();
                        Enumeration.Value value23 = value;
                        if (value22 != null ? !value22.equals(value23) : value23 != null) break block13;
                        Function1<Input, Object> valueReader = this.matchReader((Enumeration.Value)bindings.head(), this.matchReader$default$2());
                        object = new Serializable(valueReader){
                            public static final long serialVersionUID = 0L;
                            private final Function1 valueReader$1;

                            /*
                             * WARNING - void declaration
                             */
                            public final Object apply(Input i) {
                                Object v0;
                                int size = i.readInt(true);
                                if (size == -1) {
                                    v0 = null;
                                } else {
                                    void var3_3;
                                    ArrayList<Object> list = new ArrayList<Object>(size);
                                    for (int index = 0; index < size; ++index) {
                                        list.add(this.valueReader$1.apply((Object)i));
                                    }
                                    v0 = var3_3;
                                }
                                return v0;
                            }
                            {
                                this.valueReader$1 = valueReader$1;
                            }
                        };
                        break block3;
                    }
                    Enumeration.Value value24 = ObjectType$.MODULE$.MAP();
                    Enumeration.Value value25 = value;
                    if (value24 != null ? !value24.equals(value25) : value25 != null) break block14;
                    Function1<Input, Object> keyReader = this.matchReader((Enumeration.Value)bindings.head(), this.matchReader$default$2());
                    Function1<Input, Object> valueReader = this.matchReader((Enumeration.Value)bindings.apply(1), this.matchReader$default$2());
                    object = new Serializable(keyReader, valueReader){
                        public static final long serialVersionUID = 0L;
                        private final Function1 keyReader$1;
                        private final Function1 valueReader$2;

                        /*
                         * WARNING - void declaration
                         */
                        public final Object apply(Input i) {
                            Object v0;
                            int size = i.readInt(true);
                            if (size == -1) {
                                v0 = null;
                            } else {
                                void var3_3;
                                HashMap<Object, Object> map = new HashMap<Object, Object>(size);
                                for (int index = 0; index < size; ++index) {
                                    map.put(this.keyReader$1.apply((Object)i), this.valueReader$2.apply((Object)i));
                                }
                                v0 = var3_3;
                            }
                            return v0;
                        }
                        {
                            this.keyReader$1 = keyReader$1;
                            this.valueReader$2 = valueReader$2;
                        }
                    };
                    break block3;
                }
                Enumeration.Value value26 = ObjectType$.MODULE$.BYTES();
                Enumeration.Value value27 = value;
                if (value26 != null ? !value26.equals(value27) : value27 != null) break block15;
                object = new Serializable(){
                    public static final long serialVersionUID = 0L;

                    /*
                     * WARNING - void declaration
                     */
                    public final Object apply(Input i) {
                        Object v0;
                        int size = i.readInt(true);
                        if (size == -1) {
                            v0 = null;
                        } else {
                            void var3_3;
                            byte[] arr = new byte[size];
                            i.read(arr);
                            v0 = var3_3;
                        }
                        return v0;
                    }
                };
            }
            return object;
        }
        throw new MatchError((Object)value);
    }

    public Seq<Enumeration.Value> matchReader$default$2() {
        return (Seq)Seq$.MODULE$.empty();
    }

    public Function1<Input, Object> readNullable(Function1<Input, Object> wrapped) {
        return new Serializable(wrapped){
            public static final long serialVersionUID = 0L;
            private final Function1 wrapped$2;

            public final Object apply(Input i) {
                return i.read() == KryoFeatureSerializer$.MODULE$.NULL_BYTE() ? null : this.wrapped$2.apply((Object)i);
            }
            {
                this.wrapped$2 = wrapped$2;
            }
        };
    }

    public Set<Enumeration.Value> $lessinit$greater$default$2() {
        return Predef$.MODULE$.Set().empty();
    }

    private KryoFeatureSerializer$() {
        MODULE$ = this;
        this.VERSION = 2;
        Predef$.MODULE$.assert(this.VERSION() < 127, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Serialization expects version to be in one byte";
            }
        });
        this.NULL_BYTE = (byte)0;
        this.NON_NULL_BYTE = (byte)1;
        this.inputs = new SoftThreadLocal();
        this.outputs = new SoftThreadLocal();
        this.readers = new SoftThreadLocalCache();
        this.writers = new SoftThreadLocalCache();
        this.offsets = new SoftThreadLocalCache();
    }
}

