/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.csv;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.Reader;
import java.util.Date;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.io.FilenameUtils;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.Transaction;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureStore;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.locationtech.geomesa.utils.TypeSchema;
import org.locationtech.geomesa.utils.csv.CSVParser;
import org.locationtech.geomesa.utils.csv.CSVParser$;
import org.locationtech.geomesa.utils.csv.CSVParser$DoubleParser$;
import org.locationtech.geomesa.utils.csv.CSVParser$GeometryParser$;
import org.locationtech.geomesa.utils.csv.CSVParser$IntParser$;
import org.locationtech.geomesa.utils.csv.CSVParser$LineStringParser$;
import org.locationtech.geomesa.utils.csv.CSVParser$MultiLineStringParser$;
import org.locationtech.geomesa.utils.csv.CSVParser$MultiPointParser$;
import org.locationtech.geomesa.utils.csv.CSVParser$MultiPolygonParser$;
import org.locationtech.geomesa.utils.csv.CSVParser$PointParser$;
import org.locationtech.geomesa.utils.csv.CSVParser$PolygonParser$;
import org.locationtech.geomesa.utils.csv.CSVParser$StringParser$;
import org.locationtech.geomesa.utils.csv.CSVParser$TimeParser$;
import org.locationtech.geomesa.utils.csv.package$;
import org.locationtech.geomesa.utils.geotools.SftBuilder;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes$;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeType;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConversions$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.TraversableOnce$;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Stream$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class package$
implements LazyLogging {
    public static final package$ MODULE$;
    private final GeometryFactory gf;
    private final ShapefileDataStoreFactory dsFactory;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new package$();
    }

    private Logger logger$lzycompute() {
        package$ package$2 = this;
        synchronized (package$2) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public TypeSchema guessTypes(File csvFile, boolean hasHeader) {
        String typename = FilenameUtils.getBaseName((String)csvFile.getName());
        BufferedReader reader2 = Source$.MODULE$.fromFile(csvFile, Codec$.MODULE$.fallbackSystemCodec()).bufferedReader();
        TypeSchema guess = this.guessTypes(typename, reader2, hasHeader, this.guessTypes$default$4(), this.guessTypes$default$5());
        reader2.close();
        return guess;
    }

    public SimpleFeatureCollection csvToFeatures(File csvFile, boolean hasHeader, TypeSchema typeSchema) {
        SimpleFeatureType sft = SimpleFeatureTypes$.MODULE$.createType(typeSchema.name(), typeSchema.schema());
        return this.buildFeatureCollection(csvFile, hasHeader, sft, typeSchema.latLonFields());
    }

    public Seq<CSVParser<?>> tryParsers(TraversableOnce<String> rawData) {
        return TraversableOnce$.MODULE$.MonadOps(rawData).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final CSVParser<?> apply(String datum) {
                return package$.MODULE$.org$locationtech$geomesa$utils$csv$package$$tryAllParsers$1(datum);
            }
        }).toSeq();
    }

    public Seq<String> guessHeaders(CSVRecord record, boolean hasHeader) {
        return hasHeader ? JavaConversions$.MODULE$.iterableAsScalaIterable((Iterable)record).toSeq() : (Seq)Seq$.MODULE$.tabulate(record.size(), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(int n) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"C", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)n)}));
            }
        });
    }

    public boolean guessHeaders$default$2() {
        return true;
    }

    public TypeSchema guessTypes(String name2, Reader csvReader, boolean hasHeader, CSVFormat format, int numSamples) {
        Predef$.MODULE$.assert(numSamples > 0);
        Seq records = JavaConversions$.MODULE$.asScalaIterator(format.parse(csvReader).iterator()).take(numSamples + 1).toSeq();
        Predef$.MODULE$.assert(records.size() > 1 || !hasHeader && records.size() > 0);
        Seq<String> headers = this.guessHeaders((CSVRecord)records.apply(0), hasHeader);
        Seq sample = (Seq)records.drop(1);
        Seq parsers2 = (Seq)((TraversableOnce)sample.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Seq<CSVParser<?>> apply(CSVRecord x$2) {
                return package$.MODULE$.tryParsers((TraversableOnce<String>)JavaConversions$.MODULE$.iterableAsScalaIterable((Iterable)x$2));
            }
        }, Seq$.MODULE$.canBuildFrom())).reduceLeft((Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Seq<CSVParser<?>> apply(Seq<CSVParser<?>> pc1, Seq<CSVParser<?>> pc2) {
                return (Seq)((TraversableLike)pc1.zip(pc2, Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final CSVParser<? super Object> apply(Tuple2<CSVParser<?>, CSVParser<?>> x0$1) {
                        Tuple2<CSVParser<?>, CSVParser<?>> tuple2 = x0$1;
                        if (tuple2 != null) {
                            CSVParser<A> p1 = (CSVParser<A>)tuple2._1();
                            CSVParser p2 = (CSVParser)tuple2._2();
                            CSVParser<A> cSVParser = p1;
                            CSVParser cSVParser2 = p2;
                            CSVParser<A> cSVParser3 = !(cSVParser != null ? !cSVParser.equals(cSVParser2) : cSVParser2 != null) ? p1 : CSVParser$StringParser$.MODULE$;
                            return cSVParser3;
                        }
                        throw new MatchError(tuple2);
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }
        });
        SftBuilder sftb = new SftBuilder();
        BooleanRef defaultGeomSet = BooleanRef.create((boolean)false);
        ((IterableLike)headers.zip((GenIterable)parsers2, Seq$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(sftb, defaultGeomSet){
            public static final long serialVersionUID = 0L;
            private final SftBuilder sftb$1;
            private final BooleanRef defaultGeomSet$1;

            public final void apply(Tuple2<String, CSVParser<?>> x0$2) {
                Tuple2<String, CSVParser<?>> tuple2 = x0$2;
                if (tuple2 != null) {
                    BoxedUnit boxedUnit;
                    String field = (String)tuple2._1();
                    CSVParser parser = (CSVParser)tuple2._2();
                    if (!this.defaultGeomSet$1.elem && parser.isGeom()) {
                        parser.buildSpec(this.sftb$1, field, true);
                        this.defaultGeomSet$1.elem = true;
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        parser.buildSpec(this.sftb$1, field, parser.buildSpec$default$3());
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.sftb$1 = sftb$1;
                this.defaultGeomSet$1 = defaultGeomSet$1;
            }
        });
        return new TypeSchema(name2, sftb.getSpec(), (Option<Tuple2<String, String>>)None$.MODULE$);
    }

    public boolean guessTypes$default$3() {
        return true;
    }

    public CSVFormat guessTypes$default$4() {
        return CSVFormat.DEFAULT;
    }

    public int guessTypes$default$5() {
        return 5;
    }

    public <A> CSVParser<? extends Comparable<? super Integer>> getParser(Class<A> clas) {
        Class<A> clazz = clas;
        CSVParser<Integer> cSVParser = clazz.isAssignableFrom(Integer.class) ? CSVParser$IntParser$.MODULE$ : (clazz.isAssignableFrom(Double.class) ? CSVParser$DoubleParser$.MODULE$ : (clazz.isAssignableFrom(Date.class) ? CSVParser$TimeParser$.MODULE$ : (clazz.isAssignableFrom(Point.class) ? CSVParser$PointParser$.MODULE$ : (clazz.isAssignableFrom(LineString.class) ? CSVParser$LineStringParser$.MODULE$ : (clazz.isAssignableFrom(Polygon.class) ? CSVParser$PolygonParser$.MODULE$ : (clazz.isAssignableFrom(MultiPoint.class) ? CSVParser$MultiPointParser$.MODULE$ : (clazz.isAssignableFrom(MultiLineString.class) ? CSVParser$MultiLineStringParser$.MODULE$ : (clazz.isAssignableFrom(MultiPolygon.class) ? CSVParser$MultiPolygonParser$.MODULE$ : (clazz.isAssignableFrom(Geometry.class) ? CSVParser$GeometryParser$.MODULE$ : (clazz.isAssignableFrom(String.class) ? CSVParser$StringParser$.MODULE$ : CSVParser$StringParser$.MODULE$))))))))));
        return cSVParser;
    }

    public GeometryFactory gf() {
        return this.gf;
    }

    /*
     * WARNING - void declaration
     */
    public SimpleFeatureCollection buildFeatureCollection(File csvFile, boolean hasHeader, SimpleFeatureType sft, Option<Tuple2<String, String>> latlonFields) {
        SimpleFeatureCollection simpleFeatureCollection;
        BufferedReader reader2 = Source$.MODULE$.fromFile(csvFile, Codec$.MODULE$.fallbackSystemCodec()).bufferedReader();
        try {
            simpleFeatureCollection = this.buildFeatureCollection(reader2, hasHeader, sft, latlonFields);
        }
        catch (Throwable throwable) {
            void var5_5;
            var5_5.close();
            throw throwable;
        }
        reader2.close();
        return simpleFeatureCollection;
    }

    public Option<SimpleFeature> buildFeature(CSVRecord record, SimpleFeatureBuilder fb, Seq<CSVParser<?>> parsers2, Option<Tuple2<Object, Object>> lli) {
        None$ none$;
        try {
            Object[] fieldVals = (Object[])((TraversableOnce)((TraversableLike)JavaConversions$.MODULE$.asScalaIterator(record.iterator()).toIterable().zip(parsers2, Iterable$.MODULE$.canBuildFrom())).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Object apply(Tuple2<String, CSVParser<?>> x0$3) {
                    Tuple2<String, CSVParser<?>> tuple2 = x0$3;
                    if (tuple2 != null) {
                        String v = (String)tuple2._1();
                        CSVParser p = (CSVParser)tuple2._2();
                        Object object = p.parse(v).get();
                        return object;
                    }
                    throw new MatchError(tuple2);
                }
            }, Iterable$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.AnyRef());
            fb.addAll(fieldVals);
            lli.withFilter((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<Object, Object> check$ifrefutable$1) {
                    Tuple2<Object, Object> tuple2 = check$ifrefutable$1;
                    boolean bl = tuple2 != null;
                    return bl;
                }
            }).foreach((Function1)new Serializable(fb, fieldVals){
                public static final long serialVersionUID = 0L;
                private final SimpleFeatureBuilder fb$1;
                private final Object[] fieldVals$1;

                public final void apply(Tuple2<Object, Object> x$3) {
                    Tuple2<Object, Object> tuple2 = x$3;
                    if (tuple2 != null) {
                        int lati = tuple2._1$mcI$sp();
                        int loni = tuple2._2$mcI$sp();
                        Double lat = (Double)this.fieldVals$1[lati];
                        Double lon = (Double)this.fieldVals$1[loni];
                        this.fb$1.add((Object)package$.MODULE$.gf().createPoint(new Coordinate(Predef$.MODULE$.Double2double(lon), Predef$.MODULE$.Double2double(lat))));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.fb$1 = fb$1;
                    this.fieldVals$1 = fieldVals$1;
                }
            });
            none$ = new Some((Object)fb.buildFeature(null));
        }
        catch (Exception exception) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to parse CSV record:\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{record})));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public SimpleFeatureCollection buildFeatureCollection(Reader reader2, boolean hasHeader, SimpleFeatureType sft, Option<Tuple2<String, String>> latlonFields) {
        Option latlonIdx = latlonFields.map((Function1)new Serializable(sft){
            public static final long serialVersionUID = 0L;
            private final SimpleFeatureType sft$1;

            public final Tuple2<Object, Object> apply(Tuple2<String, String> x0$4) {
                Tuple2<String, String> tuple2 = x0$4;
                if (tuple2 != null) {
                    String latf = (String)tuple2._1();
                    String lonf = (String)tuple2._2();
                    Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(package$.MODULE$.org$locationtech$geomesa$utils$csv$package$$idxOfField$1(latf, this.sft$1), package$.MODULE$.org$locationtech$geomesa$utils$csv$package$$idxOfField$1(lonf, this.sft$1));
                    return sp2;
                }
                throw new MatchError(tuple2);
            }
            {
                this.sft$1 = sft$1;
            }
        });
        SimpleFeatureBuilder fb = new SimpleFeatureBuilder(sft);
        Buffer parsers2 = (Buffer)JavaConversions$.MODULE$.asScalaBuffer(sft.getTypes()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final CSVParser<? extends Comparable<? super Integer>> apply(AttributeType t) {
                return package$.MODULE$.getParser(t.getBinding());
            }
        }, Buffer$.MODULE$.canBuildFrom());
        DefaultFeatureCollection fc = new DefaultFeatureCollection();
        Iterator records = CSVFormat.DEFAULT.parse(reader2).iterator();
        Object object = hasHeader ? records.next() : BoxedUnit.UNIT;
        JavaConversions$.MODULE$.asScalaIterator(records).foreach((Function1)new Serializable(latlonIdx, fb, parsers2, fc){
            public static final long serialVersionUID = 0L;
            private final Option latlonIdx$1;
            private final SimpleFeatureBuilder fb$2;
            private final Buffer parsers$1;
            public final DefaultFeatureCollection fc$1;

            public final void apply(CSVRecord record) {
                package$.MODULE$.buildFeature(record, this.fb$2, (Seq<CSVParser<?>>)this.parsers$1, (Option<Tuple2<Object, Object>>)this.latlonIdx$1).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.buildFeatureCollection.1 $outer;

                    public final boolean apply(SimpleFeature feature) {
                        return this.$outer.fc$1.add(feature);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.latlonIdx$1 = latlonIdx$1;
                this.fb$2 = fb$2;
                this.parsers$1 = parsers$1;
                this.fc$1 = fc$1;
            }
        });
        return fc;
    }

    private ShapefileDataStoreFactory dsFactory() {
        return this.dsFactory;
    }

    private ShapefileDataStore shpDataStore(File shpFile, SimpleFeatureType sft) {
        scala.collection.immutable.Map params = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"url"), (Object)shpFile.toURI().toURL()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"create spatial index"), (Object)Boolean.FALSE)}));
        ShapefileDataStore shpDS = (ShapefileDataStore)this.dsFactory().createNewDataStore(JavaConversions$.MODULE$.mapAsJavaMap((Map)params));
        shpDS.createSchema(sft);
        return shpDS;
    }

    /*
     * WARNING - void declaration
     */
    private void writeFeatures(SimpleFeatureCollection fc, SimpleFeatureStore shpFS) {
        DefaultTransaction transaction = new DefaultTransaction("create");
        shpFS.setTransaction((Transaction)transaction);
        try {
            shpFS.addFeatures((FeatureCollection)fc);
            transaction.commit();
        }
        catch (Throwable throwable) {
            void var3_3;
            try {
                var3_3.rollback();
                throw throwable;
            }
            catch (Throwable throwable2) {
                var3_3.close();
                throw throwable2;
            }
        }
        transaction.close();
    }

    /*
     * WARNING - void declaration
     */
    private File writeZipFile(File shpFile) {
        String dir = shpFile.getParent();
        String rootName = FilenameUtils.getBaseName((String)shpFile.getName());
        Seq extensions = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"dbf", "fix", "prj", "shp", "shx"}));
        Seq files = (Seq)extensions.map((Function1)new Serializable(dir, rootName){
            public static final long serialVersionUID = 0L;
            private final String dir$1;
            private final String rootName$1;

            public final File apply(String ext) {
                return new File(this.dir$1, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.rootName$1, ext})));
            }
            {
                this.dir$1 = dir$1;
                this.rootName$1 = rootName$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        File zipFile = new File(dir, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".zip"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rootName})));
        ZipOutputStream zip = new ZipOutputStream(new FileOutputStream(zipFile));
        try {
            files.withFilter((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(File file) {
                    return file.exists();
                }
            }).foreach((Function1)new Serializable(zip){
                public static final long serialVersionUID = 0L;
                public final ZipOutputStream zip$1;

                /*
                 * WARNING - void declaration
                 */
                public final void apply(File file) {
                    this.zip$1.putNextEntry(new ZipEntry(file.getName()));
                    FileInputStream in = new FileInputStream(file.getCanonicalFile());
                    try {
                        package$.MODULE$.org$locationtech$geomesa$utils$csv$package$$byteStream$1(in).takeWhile((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(int x$5) {
                                return this.apply$mcZI$sp(x$5);
                            }

                            public boolean apply$mcZI$sp(int x$5) {
                                return x$5 > -1;
                            }
                        }).toList().foreach((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun.writeZipFile.2 $outer;

                            public final void apply(int x$1) {
                                this.apply$mcVI$sp(x$1);
                            }

                            public void apply$mcVI$sp(int x$1) {
                                this.$outer.zip$1.write(x$1);
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        });
                    }
                    catch (Throwable throwable) {
                        void var2_2;
                        var2_2.close();
                        throw throwable;
                    }
                    in.close();
                    this.zip$1.closeEntry();
                }
                {
                    this.zip$1 = zip$1;
                }
            });
        }
        catch (Throwable throwable) {
            void var7_7;
            var7_7.close();
            throw throwable;
        }
        zip.close();
        files.foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(File file) {
                return file.delete();
            }
        });
        return zipFile;
    }

    public File ingestCSV(File csvFile, boolean hasHeader, String name2, String schema, Option<Tuple2<String, String>> latlonFields) {
        SimpleFeatureType sft = SimpleFeatureTypes$.MODULE$.createType(name2, schema);
        SimpleFeatureCollection fc = this.buildFeatureCollection(csvFile, hasHeader, sft, latlonFields);
        File shpFile = new File(csvFile.getParentFile(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".shp"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{FilenameUtils.getBaseName((String)csvFile.getName())})));
        ShapefileDataStore shpDS = this.shpDataStore(shpFile, sft);
        SimpleFeatureStore shpFS = (SimpleFeatureStore)shpDS.getFeatureSource(name2);
        this.writeFeatures(fc, shpFS);
        return this.writeZipFile(shpFile);
    }

    public Option<Tuple2<String, String>> ingestCSV$default$5() {
        return None$.MODULE$;
    }

    public final CSVParser org$locationtech$geomesa$utils$csv$package$$tryAllParsers$1(String datum) {
        return (CSVParser)CSVParser$.MODULE$.parsers().find((Function1)new Serializable(datum){
            public static final long serialVersionUID = 0L;
            private final String datum$1;

            public final boolean apply(CSVParser<?> x$1) {
                return x$1.parse(this.datum$1).isSuccess();
            }
            {
                this.datum$1 = datum$1;
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final CSVParser$StringParser$ apply() {
                return CSVParser$StringParser$.MODULE$;
            }
        });
    }

    public final int org$locationtech$geomesa$utils$csv$package$$idxOfField$1(String fname, SimpleFeatureType sft$1) {
        sft$1.getType(fname);
        int idx = sft$1.indexOf(fname);
        if (idx > -1) {
            AttributeType t = sft$1.getType(idx);
            Class clazz = t.getBinding();
            Class<Double> clazz2 = Double.class;
            if (!(clazz != null ? !clazz.equals(clazz2) : clazz2 != null)) {
                return idx;
            }
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"field ", " is not a Double field"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fname})));
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"could not find field ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fname})));
    }

    public final Stream org$locationtech$geomesa$utils$csv$package$$byteStream$1(InputStream in) {
        int n = in.read();
        return Stream$.MODULE$.consWrapper((Function0)new Serializable(in){
            public static final long serialVersionUID = 0L;
            private final InputStream in$1;

            public final Stream<Object> apply() {
                return package$.MODULE$.org$locationtech$geomesa$utils$csv$package$$byteStream$1(this.in$1);
            }
            {
                this.in$1 = in$1;
            }
        }).$hash$colon$colon((Object)BoxesRunTime.boxToInteger((int)n));
    }

    private package$() {
        MODULE$ = this;
        LazyLogging.class.$init$((LazyLogging)this);
        this.gf = new GeometryFactory();
        this.dsFactory = new ShapefileDataStoreFactory();
    }
}

