/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.stats;

import com.clearspring.analytics.stream.StreamSummary;
import com.clearspring.analytics.stream.cardinality.HyperLogLog;
import com.clearspring.analytics.stream.frequency.CountMinSketch;
import com.clearspring.analytics.stream.frequency.RichCountMinSketch$;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.vividsolutions.jts.geom.Geometry;
import java.util.Date;
import org.locationtech.geomesa.curve.TimePeriod$;
import org.locationtech.geomesa.utils.cache.SoftThreadLocal;
import org.locationtech.geomesa.utils.stats.BinnedArray;
import org.locationtech.geomesa.utils.stats.BinnedLongArray;
import org.locationtech.geomesa.utils.stats.CountStat;
import org.locationtech.geomesa.utils.stats.DescriptiveStats;
import org.locationtech.geomesa.utils.stats.EnumerationStat;
import org.locationtech.geomesa.utils.stats.Frequency;
import org.locationtech.geomesa.utils.stats.GroupBy;
import org.locationtech.geomesa.utils.stats.Histogram;
import org.locationtech.geomesa.utils.stats.ImmutableStat;
import org.locationtech.geomesa.utils.stats.ImmutableStat$class;
import org.locationtech.geomesa.utils.stats.IteratorStackCount;
import org.locationtech.geomesa.utils.stats.MinMax;
import org.locationtech.geomesa.utils.stats.MinMax$MinMaxDefaults$;
import org.locationtech.geomesa.utils.stats.SeqStat;
import org.locationtech.geomesa.utils.stats.Stat;
import org.locationtech.geomesa.utils.stats.TopK;
import org.locationtech.geomesa.utils.stats.Z3Frequency;
import org.locationtech.geomesa.utils.stats.Z3Histogram;
import org.locationtech.geomesa.utils.text.WKBUtils$;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Map;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class KryoStatSerializer$ {
    public static final KryoStatSerializer$ MODULE$;
    private final SoftThreadLocal<Input> inputs;
    private final SoftThreadLocal<Output> outputs;
    private final byte SeqStatByte;
    private final byte CountByte;
    private final byte MinMaxByte;
    private final byte IteratorStackByte;
    private final byte EnumerationByte;
    private final byte HistogramByte;
    private final byte FrequencyByteV1;
    private final byte Z3HistogramByteV1;
    private final byte Z3FrequencyByteV1;
    private final byte TopKByte;
    private final byte FrequencyByte;
    private final byte Z3HistogramByte;
    private final byte Z3FrequencyByte;
    private final byte DescriptiveStatByte;
    private final byte GroupByByte;

    static {
        new KryoStatSerializer$();
    }

    public SoftThreadLocal<Input> inputs() {
        return this.inputs;
    }

    public SoftThreadLocal<Output> outputs() {
        return this.outputs;
    }

    public byte SeqStatByte() {
        return this.SeqStatByte;
    }

    public byte CountByte() {
        return this.CountByte;
    }

    public byte MinMaxByte() {
        return this.MinMaxByte;
    }

    public byte IteratorStackByte() {
        return this.IteratorStackByte;
    }

    public byte EnumerationByte() {
        return this.EnumerationByte;
    }

    public byte HistogramByte() {
        return this.HistogramByte;
    }

    public byte FrequencyByteV1() {
        return this.FrequencyByteV1;
    }

    public byte Z3HistogramByteV1() {
        return this.Z3HistogramByteV1;
    }

    public byte Z3FrequencyByteV1() {
        return this.Z3FrequencyByteV1;
    }

    public byte TopKByte() {
        return this.TopKByte;
    }

    public byte FrequencyByte() {
        return this.FrequencyByte;
    }

    public byte Z3HistogramByte() {
        return this.Z3HistogramByte;
    }

    public byte Z3FrequencyByte() {
        return this.Z3FrequencyByte;
    }

    public byte DescriptiveStatByte() {
        return this.DescriptiveStatByte;
    }

    public byte GroupByByte() {
        return this.GroupByByte;
    }

    public void write(Output output, SimpleFeatureType sft, Stat stat2) {
        Stat stat3;
        block14: {
            block3: {
                block13: {
                    block12: {
                        block11: {
                            block10: {
                                block9: {
                                    block8: {
                                        block7: {
                                            block6: {
                                                block5: {
                                                    block4: {
                                                        block2: {
                                                            stat3 = stat2;
                                                            if (!(stat3 instanceof CountStat)) break block2;
                                                            CountStat countStat = (CountStat)stat3;
                                                            output.writeByte(this.CountByte());
                                                            this.writeCount(output, countStat);
                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                            break block3;
                                                        }
                                                        if (!(stat3 instanceof MinMax)) break block4;
                                                        MinMax minMax2 = (MinMax)stat3;
                                                        output.writeByte(this.MinMaxByte());
                                                        this.writeMinMax(output, sft, minMax2);
                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                        break block3;
                                                    }
                                                    if (!(stat3 instanceof EnumerationStat)) break block5;
                                                    EnumerationStat enumerationStat = (EnumerationStat)stat3;
                                                    output.writeByte(this.EnumerationByte());
                                                    this.writeEnumeration(output, sft, enumerationStat);
                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                    break block3;
                                                }
                                                if (!(stat3 instanceof TopK)) break block6;
                                                TopK topK2 = (TopK)stat3;
                                                output.writeByte(this.TopKByte());
                                                this.writeTopK(output, sft, topK2);
                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                break block3;
                                            }
                                            if (!(stat3 instanceof Histogram)) break block7;
                                            Histogram histogram2 = (Histogram)stat3;
                                            output.writeByte(this.HistogramByte());
                                            this.writeHistogram(output, sft, histogram2);
                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                            break block3;
                                        }
                                        if (!(stat3 instanceof Frequency)) break block8;
                                        Frequency frequency2 = (Frequency)stat3;
                                        output.writeByte(this.FrequencyByte());
                                        this.writeFrequency(output, sft, frequency2);
                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                        break block3;
                                    }
                                    if (!(stat3 instanceof Z3Histogram)) break block9;
                                    Z3Histogram z3Histogram2 = (Z3Histogram)stat3;
                                    output.writeByte(this.Z3HistogramByte());
                                    this.writeZ3Histogram(output, sft, z3Histogram2);
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    break block3;
                                }
                                if (!(stat3 instanceof Z3Frequency)) break block10;
                                Z3Frequency z3Frequency2 = (Z3Frequency)stat3;
                                output.writeByte(this.Z3FrequencyByte());
                                this.writeZ3Frequency(output, sft, z3Frequency2);
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                break block3;
                            }
                            if (!(stat3 instanceof IteratorStackCount)) break block11;
                            IteratorStackCount iteratorStackCount = (IteratorStackCount)stat3;
                            output.writeByte(this.IteratorStackByte());
                            this.writeIteratorStackCount(output, iteratorStackCount);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            break block3;
                        }
                        if (!(stat3 instanceof SeqStat)) break block12;
                        SeqStat seqStat = (SeqStat)stat3;
                        output.writeByte(this.SeqStatByte());
                        this.writeSeqStat(output, sft, seqStat);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block3;
                    }
                    if (!(stat3 instanceof DescriptiveStats)) break block13;
                    DescriptiveStats descriptiveStats2 = (DescriptiveStats)stat3;
                    output.writeByte(this.DescriptiveStatByte());
                    this.writeDescriptiveStats(output, sft, descriptiveStats2);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                if (!(stat3 instanceof GroupBy)) break block14;
                GroupBy groupBy2 = (GroupBy)stat3;
                output.writeByte(this.GroupByByte());
                this.writeGroupBy(output, sft, groupBy2);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError((Object)stat3);
    }

    public Stat read(Input input, SimpleFeatureType sft, boolean immutable) {
        byte by;
        block17: {
            Stat stat2;
            block3: {
                block16: {
                    block15: {
                        block14: {
                            block13: {
                                block12: {
                                    block11: {
                                        block10: {
                                            block9: {
                                                block8: {
                                                    block7: {
                                                        block6: {
                                                            block5: {
                                                                block4: {
                                                                    block2: {
                                                                        by = input.readByte();
                                                                        if (this.CountByte() != by) break block2;
                                                                        stat2 = this.readCount(input, immutable);
                                                                        break block3;
                                                                    }
                                                                    if (this.MinMaxByte() != by) break block4;
                                                                    stat2 = this.readMinMax(input, sft, immutable);
                                                                    break block3;
                                                                }
                                                                if (this.EnumerationByte() != by) break block5;
                                                                stat2 = this.readEnumeration(input, sft, immutable);
                                                                break block3;
                                                            }
                                                            if (this.TopKByte() != by) break block6;
                                                            stat2 = this.readTopK(input, sft, immutable);
                                                            break block3;
                                                        }
                                                        if (this.HistogramByte() != by) break block7;
                                                        stat2 = this.readHistogram(input, sft, immutable);
                                                        break block3;
                                                    }
                                                    if (this.FrequencyByte() != by) break block8;
                                                    stat2 = this.readFrequency(input, sft, immutable, 2);
                                                    break block3;
                                                }
                                                if (this.Z3HistogramByte() != by) break block9;
                                                stat2 = this.readZ3Histogram(input, sft, immutable, 2);
                                                break block3;
                                            }
                                            if (this.Z3FrequencyByte() != by) break block10;
                                            stat2 = this.readZ3Frequency(input, sft, immutable, 2);
                                            break block3;
                                        }
                                        if (this.IteratorStackByte() != by) break block11;
                                        stat2 = this.readIteratorStackCount(input, immutable);
                                        break block3;
                                    }
                                    if (this.SeqStatByte() != by) break block12;
                                    stat2 = this.readSeqStat(input, sft, immutable);
                                    break block3;
                                }
                                if (this.FrequencyByteV1() != by) break block13;
                                stat2 = this.readFrequency(input, sft, immutable, 1);
                                break block3;
                            }
                            if (this.Z3HistogramByteV1() != by) break block14;
                            stat2 = this.readZ3Histogram(input, sft, immutable, 1);
                            break block3;
                        }
                        if (this.Z3FrequencyByteV1() != by) break block15;
                        stat2 = this.readZ3Frequency(input, sft, immutable, 1);
                        break block3;
                    }
                    if (this.DescriptiveStatByte() != by) break block16;
                    stat2 = this.readDescriptiveStat(input, sft, immutable);
                    break block3;
                }
                if (this.GroupByByte() != by) break block17;
                stat2 = this.readGroupBy(input, sft, immutable);
            }
            return stat2;
        }
        throw new MatchError((Object)BoxesRunTime.boxToByte((byte)by));
    }

    public void writeGroupBy(Output output, SimpleFeatureType sft, GroupBy<?> stat2) {
        output.writeInt(stat2.attribute(), true);
        output.writeString(stat2.exampleStat());
        output.writeInt(stat2.groupedStats().keys().size(), true);
        stat2.groupedStats().foreach((Function1)new Serializable(output, sft, stat2){
            public static final long serialVersionUID = 0L;
            private final Output output$7;
            private final SimpleFeatureType sft$3;
            private final GroupBy stat$1;

            public final void apply(Tuple2<Object, Stat> x0$1) {
                Tuple2<Object, Stat> tuple2 = x0$1;
                if (tuple2 != null) {
                    Object key = tuple2._1();
                    Stat groupedStat = (Stat)tuple2._2();
                    KryoStatSerializer$.MODULE$.org$locationtech$geomesa$utils$stats$KryoStatSerializer$$writer(this.output$7, this.sft$3.getDescriptor(this.stat$1.attribute()).getType().getBinding()).apply(key);
                    KryoStatSerializer$.MODULE$.write(this.output$7, this.sft$3, groupedStat);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.output$7 = output$7;
                this.sft$3 = sft$3;
                this.stat$1 = stat$1;
            }
        });
    }

    public GroupBy<?> readGroupBy(Input input, SimpleFeatureType sft, boolean immutable) {
        int attribute2 = input.readInt(true);
        String exampleStat = input.readString();
        int keyLength = input.readInt(true);
        Class binding = sft.getDescriptor(attribute2).getType().getBinding();
        ClassTag classTag = ClassTag$.MODULE$.apply(binding);
        GroupBy stat2 = immutable ? new ImmutableStat(sft, attribute2, exampleStat, classTag){

            public void observe(SimpleFeature sf) {
                ImmutableStat$class.observe(this, sf);
            }

            public void unobserve(SimpleFeature sf) {
                ImmutableStat$class.unobserve(this, sf);
            }

            public void $plus$eq(Stat other) {
                ImmutableStat$class.$plus$eq(this, other);
            }

            public void clear() {
                ImmutableStat$class.clear(this);
            }
            {
                ImmutableStat$class.$init$(this);
            }
        } : new GroupBy(attribute2, exampleStat, sft, classTag);
        for (int i = 0; i < keyLength; ++i) {
            Object key = this.reader(input, sft.getDescriptor(attribute2).getType().getBinding()).apply();
            Stat groupedStat = this.read(input, sft, immutable);
            stat2.groupedStats().put(key, (Object)groupedStat);
        }
        return stat2;
    }

    public void writeDescriptiveStats(Output output, SimpleFeatureType sft, DescriptiveStats stat2) {
        int size2 = stat2.size();
        output.writeInt(size2, true);
        stat2.attributes().foreach((Function1)new Serializable(output){
            public static final long serialVersionUID = 0L;
            private final Output output$6;

            public final int apply(int x$1) {
                return this.apply$mcII$sp(x$1);
            }

            public int apply$mcII$sp(int x$1) {
                return this.output$6.writeInt(x$1, true);
            }
            {
                this.output$6 = output$6;
            }
        });
        this.writeArray$1(stat2._min().getMatrix().data, output);
        this.writeArray$1(stat2._max().getMatrix().data, output);
        this.writeArray$1(stat2._sum().getMatrix().data, output);
        this.writeArray$1(stat2._mean().getMatrix().data, output);
        this.writeArray$1(stat2._m2n().getMatrix().data, output);
        this.writeArray$1(stat2._m3n().getMatrix().data, output);
        this.writeArray$1(stat2._m4n().getMatrix().data, output);
        this.writeArray$1(stat2._c2().getMatrix().data, output);
        output.writeLong(stat2._count(), true);
    }

    public DescriptiveStats readDescriptiveStat(Input input, SimpleFeatureType sft, boolean immutable) {
        int size2 = input.readInt(true);
        IndexedSeq attributes = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), size2).map((Function1)new Serializable(input){
            public static final long serialVersionUID = 0L;
            private final Input input$1;

            public final int apply(int _) {
                return this.apply$mcII$sp(_);
            }

            public int apply$mcII$sp(int _) {
                return this.input$1.readInt(true);
            }
            {
                this.input$1 = input$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        DescriptiveStats stats2 = immutable ? new ImmutableStat(attributes){

            public void observe(SimpleFeature sf) {
                ImmutableStat$class.observe(this, sf);
            }

            public void unobserve(SimpleFeature sf) {
                ImmutableStat$class.unobserve(this, sf);
            }

            public void $plus$eq(Stat other) {
                ImmutableStat$class.$plus$eq(this, other);
            }

            public void clear() {
                ImmutableStat$class.clear(this);
            }
            {
                ImmutableStat$class.$init$(this);
            }
        } : new DescriptiveStats((Seq<Object>)attributes);
        this.readArray$1(stats2._min().getMatrix().data, input);
        this.readArray$1(stats2._max().getMatrix().data, input);
        this.readArray$1(stats2._sum().getMatrix().data, input);
        this.readArray$1(stats2._mean().getMatrix().data, input);
        this.readArray$1(stats2._m2n().getMatrix().data, input);
        this.readArray$1(stats2._m3n().getMatrix().data, input);
        this.readArray$1(stats2._m4n().getMatrix().data, input);
        this.readArray$1(stats2._c2().getMatrix().data, input);
        stats2._count_$eq(input.readLong(true));
        return stats2;
    }

    public void writeSeqStat(Output output, SimpleFeatureType sft, SeqStat stat2) {
        stat2.stats().foreach((Function1)new Serializable(output, sft){
            public static final long serialVersionUID = 0L;
            private final Output output$5;
            private final SimpleFeatureType sft$2;

            public final void apply(Stat x$2) {
                KryoStatSerializer$.MODULE$.write(this.output$5, this.sft$2, x$2);
            }
            {
                this.output$5 = output$5;
                this.sft$2 = sft$2;
            }
        });
    }

    public SeqStat readSeqStat(Input input, SimpleFeatureType sft, boolean immutable) {
        ArrayBuffer stats2 = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        while (input.available() > 0) {
            stats2.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Stat[]{this.read(input, sft, immutable)}));
        }
        return immutable ? new ImmutableStat(stats2){

            public void observe(SimpleFeature sf) {
                ImmutableStat$class.observe(this, sf);
            }

            public void unobserve(SimpleFeature sf) {
                ImmutableStat$class.unobserve(this, sf);
            }

            public void $plus$eq(Stat other) {
                ImmutableStat$class.$plus$eq(this, other);
            }

            public void clear() {
                ImmutableStat$class.clear(this);
            }
            {
                ImmutableStat$class.$init$(this);
            }
        } : new SeqStat((Seq<Stat>)stats2);
    }

    public void writeCount(Output output, CountStat stat2) {
        output.writeLong(stat2.counter(), true);
    }

    /*
     * WARNING - void declaration
     */
    public CountStat readCount(Input input, boolean immutable) {
        void var3_3;
        CountStat stat2 = immutable ? new ImmutableStat(){

            public void observe(SimpleFeature sf) {
                ImmutableStat$class.observe(this, sf);
            }

            public void unobserve(SimpleFeature sf) {
                ImmutableStat$class.unobserve(this, sf);
            }

            public void $plus$eq(Stat other) {
                ImmutableStat$class.$plus$eq(this, other);
            }

            public void clear() {
                ImmutableStat$class.clear(this);
            }
            {
                ImmutableStat$class.$init$(this);
            }
        } : new CountStat();
        stat2.counter_$eq(input.readLong(true));
        return var3_3;
    }

    public void writeMinMax(Output output, SimpleFeatureType sft, MinMax<?> stat2) {
        output.writeInt(stat2.attribute(), true);
        byte[] hpp = stat2.hpp().getBytes();
        output.writeInt(hpp.length, true);
        output.write(hpp);
        Function1<Object, BoxedUnit> write = this.org$locationtech$geomesa$utils$stats$KryoStatSerializer$$writer(output, sft.getDescriptor(stat2.attribute()).getType().getBinding());
        write.apply(stat2.minValue());
        write.apply(stat2.maxValue());
    }

    public MinMax<?> readMinMax(Input input, SimpleFeatureType sft, boolean immutable) {
        int attribute2 = input.readInt(true);
        byte[] hppBytes = (byte[])Array$.MODULE$.ofDim(input.readInt(true), ClassTag$.MODULE$.Byte());
        input.read(hppBytes);
        HyperLogLog hpp = HyperLogLog.Builder.build((byte[])hppBytes);
        Class binding = sft.getDescriptor(attribute2).getType().getBinding();
        Function0<Object> read = this.reader(input, binding);
        Object min = read.apply();
        Object max = read.apply();
        MinMax.MinMaxDefaults defaults = MinMax$MinMaxDefaults$.MODULE$.apply(binding);
        ClassTag classTag = ClassTag$.MODULE$.apply(binding);
        return immutable ? new ImmutableStat(attribute2, hpp, min, max, defaults, classTag){

            public void observe(SimpleFeature sf) {
                ImmutableStat$class.observe(this, sf);
            }

            public void unobserve(SimpleFeature sf) {
                ImmutableStat$class.unobserve(this, sf);
            }

            public void $plus$eq(Stat other) {
                ImmutableStat$class.$plus$eq(this, other);
            }

            public void clear() {
                ImmutableStat$class.clear(this);
            }
            {
                ImmutableStat$class.$init$(this);
            }
        } : new MinMax<Object>(attribute2, min, max, hpp, defaults, classTag);
    }

    public void writeEnumeration(Output output, SimpleFeatureType sft, EnumerationStat<?> stat2) {
        output.writeInt(stat2.attribute(), true);
        output.writeInt(stat2.enumeration().size(), true);
        Function1<Object, BoxedUnit> write = this.org$locationtech$geomesa$utils$stats$KryoStatSerializer$$writer(output, sft.getDescriptor(stat2.attribute()).getType().getBinding());
        stat2.enumeration().foreach((Function1)new Serializable(output, write){
            public static final long serialVersionUID = 0L;
            private final Output output$1;
            private final Function1 write$1;

            public final int apply(Tuple2<Object, Object> x0$2) {
                Tuple2<Object, Object> tuple2 = x0$2;
                if (tuple2 != null) {
                    Object key = tuple2._1();
                    long count2 = tuple2._2$mcJ$sp();
                    this.write$1.apply(key);
                    int n = this.output$1.writeLong(count2, true);
                    return n;
                }
                throw new MatchError(tuple2);
            }
            {
                this.output$1 = output$1;
                this.write$1 = write$1;
            }
        });
    }

    public EnumerationStat<?> readEnumeration(Input input, SimpleFeatureType sft, boolean immutable) {
        int attribute2 = input.readInt(true);
        int size2 = input.readInt(true);
        Class binding = sft.getDescriptor(attribute2).getType().getBinding();
        Function0<Object> read = this.reader(input, binding);
        ClassTag classTag = ClassTag$.MODULE$.apply(binding);
        EnumerationStat stat2 = immutable ? new ImmutableStat(attribute2, classTag){

            public void observe(SimpleFeature sf) {
                ImmutableStat$class.observe(this, sf);
            }

            public void unobserve(SimpleFeature sf) {
                ImmutableStat$class.unobserve(this, sf);
            }

            public void $plus$eq(Stat other) {
                ImmutableStat$class.$plus$eq(this, other);
            }

            public void clear() {
                ImmutableStat$class.clear(this);
            }
            {
                ImmutableStat$class.$init$(this);
            }
        } : new EnumerationStat(attribute2, classTag);
        for (int i = 0; i < size2; ++i) {
            stat2.enumeration().update(read.apply(), (Object)BoxesRunTime.boxToLong((long)input.readLong(true)));
        }
        return stat2;
    }

    public void writeTopK(Output output, SimpleFeatureType sft, TopK<?> stat2) {
        output.writeInt(stat2.attribute(), true);
        byte[] summary = stat2.summary().toBytes();
        output.writeInt(summary.length, true);
        output.write(summary);
    }

    public TopK<?> readTopK(Input input, SimpleFeatureType sft, boolean immutable) {
        int attribute2 = input.readInt(true);
        byte[] summaryBytes = (byte[])Array$.MODULE$.ofDim(input.readInt(true), ClassTag$.MODULE$.Byte());
        input.read(summaryBytes);
        StreamSummary summary = new StreamSummary(summaryBytes);
        Class binding = sft.getDescriptor(attribute2).getType().getBinding();
        ClassTag classTag = ClassTag$.MODULE$.apply(binding);
        return immutable ? new ImmutableStat(attribute2, summary, classTag){

            public void observe(SimpleFeature sf) {
                ImmutableStat$class.observe(this, sf);
            }

            public void unobserve(SimpleFeature sf) {
                ImmutableStat$class.unobserve(this, sf);
            }

            public void $plus$eq(Stat other) {
                ImmutableStat$class.$plus$eq(this, other);
            }

            public void clear() {
                ImmutableStat$class.clear(this);
            }
            {
                ImmutableStat$class.$init$(this);
            }
        } : new TopK(attribute2, summary, classTag);
    }

    public void writeHistogram(Output output, SimpleFeatureType sft, Histogram<?> stat2) {
        output.writeInt(stat2.attribute(), true);
        output.writeInt(stat2.length(), true);
        Function1<Object, BoxedUnit> write = this.org$locationtech$geomesa$utils$stats$KryoStatSerializer$$writer(output, sft.getDescriptor(stat2.attribute()).getType().getBinding());
        write.apply(stat2.bounds()._1());
        write.apply(stat2.bounds()._2());
        this.org$locationtech$geomesa$utils$stats$KryoStatSerializer$$writeCountArray(output, stat2.bins().counts());
    }

    public Histogram<?> readHistogram(Input input, SimpleFeatureType sft, boolean immutable) {
        int attribute2 = input.readInt(true);
        int length = input.readInt(true);
        Class binding = sft.getDescriptor(attribute2).getType().getBinding();
        Function0<Object> read = this.reader(input, binding);
        Object min = read.apply();
        Object max = read.apply();
        MinMax.MinMaxDefaults defaults = MinMax$MinMaxDefaults$.MODULE$.apply(binding);
        ClassTag classTag = ClassTag$.MODULE$.apply(binding);
        Histogram stat2 = immutable ? new ImmutableStat(attribute2, length, min, max, defaults, classTag){

            public void observe(SimpleFeature sf) {
                ImmutableStat$class.observe(this, sf);
            }

            public void unobserve(SimpleFeature sf) {
                ImmutableStat$class.unobserve(this, sf);
            }

            public void $plus$eq(Stat other) {
                ImmutableStat$class.$plus$eq(this, other);
            }

            public void clear() {
                ImmutableStat$class.clear(this);
            }
            {
                ImmutableStat$class.$init$(this);
            }
        } : new Histogram(attribute2, length, new Tuple2(min, max), defaults, classTag);
        this.readCountArray(input, stat2.bins().counts());
        return stat2;
    }

    public void writeZ3Histogram(Output output, SimpleFeatureType sft, Z3Histogram stat2) {
        output.writeInt(stat2.geomIndex(), true);
        output.writeInt(stat2.dtgIndex(), true);
        output.writeAscii(stat2.period().toString());
        output.writeInt(stat2.length(), true);
        Map bins = (Map)stat2.binMap().filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Object, BinnedLongArray> x$3) {
                return Predef$.MODULE$.longArrayOps(((BinnedArray)x$3._2()).counts()).exists((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(long x$4) {
                        return this.apply$mcZJ$sp(x$4);
                    }

                    public boolean apply$mcZJ$sp(long x$4) {
                        return x$4 != 0L;
                    }
                });
            }
        });
        output.writeInt(bins.size(), true);
        bins.foreach((Function1)new Serializable(output){
            public static final long serialVersionUID = 0L;
            private final Output output$3;

            public final void apply(Tuple2<Object, BinnedLongArray> x0$3) {
                Tuple2<Object, BinnedLongArray> tuple2 = x0$3;
                if (tuple2 != null) {
                    short w = BoxesRunTime.unboxToShort((Object)tuple2._1());
                    BinnedLongArray bin = (BinnedLongArray)tuple2._2();
                    this.output$3.writeShort((int)w);
                    KryoStatSerializer$.MODULE$.org$locationtech$geomesa$utils$stats$KryoStatSerializer$$writeCountArray(this.output$3, bin.counts());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.output$3 = output$3;
            }
        });
    }

    public Z3Histogram readZ3Histogram(Input input, SimpleFeatureType sft, boolean immutable, int version) {
        int geomIndex = input.readInt(true);
        int dtgIndex = input.readInt(true);
        Enumeration.Value period = version > 1 ? TimePeriod$.MODULE$.withName(input.readString()) : TimePeriod$.MODULE$.Week();
        int length = input.readInt(true);
        Z3Histogram stat2 = immutable ? new ImmutableStat(geomIndex, dtgIndex, period, length){

            public void observe(SimpleFeature sf) {
                ImmutableStat$class.observe(this, sf);
            }

            public void unobserve(SimpleFeature sf) {
                ImmutableStat$class.unobserve(this, sf);
            }

            public void $plus$eq(Stat other) {
                ImmutableStat$class.$plus$eq(this, other);
            }

            public void clear() {
                ImmutableStat$class.clear(this);
            }
            {
                ImmutableStat$class.$init$(this);
            }
        } : new Z3Histogram(geomIndex, dtgIndex, period, length);
        int numWeeks = input.readInt(true);
        for (int week = 0; week < numWeeks; ++week) {
            BinnedLongArray bins = stat2.newBins();
            stat2.binMap().put((Object)BoxesRunTime.boxToShort((short)input.readShort()), (Object)bins);
            this.readCountArray(input, bins.counts());
        }
        return stat2;
    }

    public void writeFrequency(Output output, SimpleFeatureType sft, Frequency<?> stat2) {
        output.writeInt(stat2.attribute(), true);
        output.writeInt(stat2.dtgIndex(), true);
        output.writeAscii(stat2.period().toString());
        output.writeInt(stat2.precision(), true);
        output.writeDouble(stat2.eps());
        output.writeDouble(stat2.confidence());
        Map sketches = (Map)stat2.sketchMap().filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Object, CountMinSketch> x$5) {
                return ((CountMinSketch)x$5._2()).size() > 0L;
            }
        });
        output.writeInt(sketches.size(), true);
        sketches.foreach((Function1)new Serializable(output){
            public static final long serialVersionUID = 0L;
            private final Output output$2;

            public final int apply(Tuple2<Object, CountMinSketch> x0$4) {
                Tuple2<Object, CountMinSketch> tuple2 = x0$4;
                if (tuple2 != null) {
                    short w = BoxesRunTime.unboxToShort((Object)tuple2._1());
                    CountMinSketch sketch = (CountMinSketch)tuple2._2();
                    this.output$2.writeShort((int)w);
                    long[][] table = RichCountMinSketch$.MODULE$.table$extension(sketch);
                    for (int i = 0; i < table.length; ++i) {
                        KryoStatSerializer$.MODULE$.org$locationtech$geomesa$utils$stats$KryoStatSerializer$$writeCountArray(this.output$2, table[i]);
                    }
                    int n = this.output$2.writeLong(sketch.size(), true);
                    return n;
                }
                throw new MatchError(tuple2);
            }
            {
                this.output$2 = output$2;
            }
        });
    }

    public Frequency<?> readFrequency(Input input, SimpleFeatureType sft, boolean immutable, int version) {
        int attribute2 = input.readInt(true);
        int dtgIndex = input.readInt(true);
        Enumeration.Value period = version > 1 ? TimePeriod$.MODULE$.withName(input.readString()) : TimePeriod$.MODULE$.Week();
        int precision = input.readInt(true);
        double eps = input.readDouble();
        double confidence = input.readDouble();
        Class binding = sft.getDescriptor(attribute2).getType().getBinding();
        Frequency stat2 = immutable ? new ImmutableStat(attribute2, dtgIndex, period, precision, eps, confidence, binding){

            public void observe(SimpleFeature sf) {
                ImmutableStat$class.observe(this, sf);
            }

            public void unobserve(SimpleFeature sf) {
                ImmutableStat$class.unobserve(this, sf);
            }

            public void $plus$eq(Stat other) {
                ImmutableStat$class.$plus$eq(this, other);
            }

            public void clear() {
                ImmutableStat$class.clear(this);
            }
            {
                ImmutableStat$class.$init$(this);
            }
        } : new Frequency(attribute2, dtgIndex, period, precision, eps, confidence, ClassTag$.MODULE$.apply(binding));
        int sketchCount = input.readInt(true);
        for (int c = 0; c < sketchCount; ++c) {
            short week = input.readShort();
            CountMinSketch sketch = stat2.newSketch();
            stat2.sketchMap().put((Object)BoxesRunTime.boxToShort((short)week), (Object)sketch);
            long[][] table = RichCountMinSketch$.MODULE$.table$extension(sketch);
            for (int i = 0; i < table.length; ++i) {
                this.readCountArray(input, table[i]);
            }
            RichCountMinSketch$.MODULE$.setSize$extension(sketch, input.readLong(true));
        }
        return stat2;
    }

    public void writeZ3Frequency(Output output, SimpleFeatureType sft, Z3Frequency stat2) {
        output.writeInt(stat2.geomIndex(), true);
        output.writeInt(stat2.dtgIndex(), true);
        output.writeAscii(stat2.period().toString());
        output.writeInt(stat2.precision(), true);
        output.writeDouble(stat2.eps());
        output.writeDouble(stat2.confidence());
        Map sketches = (Map)stat2.sketches().filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Object, CountMinSketch> x$6) {
                return ((CountMinSketch)x$6._2()).size() > 0L;
            }
        });
        output.writeInt(sketches.size(), true);
        sketches.foreach((Function1)new Serializable(output){
            public static final long serialVersionUID = 0L;
            private final Output output$4;

            public final int apply(Tuple2<Object, CountMinSketch> x0$5) {
                Tuple2<Object, CountMinSketch> tuple2 = x0$5;
                if (tuple2 != null) {
                    short w = BoxesRunTime.unboxToShort((Object)tuple2._1());
                    CountMinSketch sketch = (CountMinSketch)tuple2._2();
                    this.output$4.writeShort((int)w);
                    long[][] table = RichCountMinSketch$.MODULE$.table$extension(sketch);
                    for (int i = 0; i < table.length; ++i) {
                        KryoStatSerializer$.MODULE$.org$locationtech$geomesa$utils$stats$KryoStatSerializer$$writeCountArray(this.output$4, table[i]);
                    }
                    int n = this.output$4.writeLong(sketch.size(), true);
                    return n;
                }
                throw new MatchError(tuple2);
            }
            {
                this.output$4 = output$4;
            }
        });
    }

    public Z3Frequency readZ3Frequency(Input input, SimpleFeatureType sft, boolean immutable, int version) {
        int geomIndex = input.readInt(true);
        int dtgIndex = input.readInt(true);
        Enumeration.Value period = version > 1 ? TimePeriod$.MODULE$.withName(input.readString()) : TimePeriod$.MODULE$.Week();
        int precision = input.readInt(true);
        double eps = input.readDouble();
        double confidence = input.readDouble();
        Z3Frequency stat2 = immutable ? new ImmutableStat(geomIndex, dtgIndex, period, precision, eps, confidence){

            public void observe(SimpleFeature sf) {
                ImmutableStat$class.observe(this, sf);
            }

            public void unobserve(SimpleFeature sf) {
                ImmutableStat$class.unobserve(this, sf);
            }

            public void $plus$eq(Stat other) {
                ImmutableStat$class.$plus$eq(this, other);
            }

            public void clear() {
                ImmutableStat$class.clear(this);
            }
            {
                ImmutableStat$class.$init$(this);
            }
        } : new Z3Frequency(geomIndex, dtgIndex, period, precision, eps, confidence);
        int numSketches = input.readInt(true);
        for (int sketchCount = 0; sketchCount < numSketches; ++sketchCount) {
            CountMinSketch sketch = stat2.newSketch();
            stat2.sketches().put((Object)BoxesRunTime.boxToShort((short)input.readShort()), (Object)sketch);
            long[][] table = RichCountMinSketch$.MODULE$.table$extension(sketch);
            for (int i = 0; i < table.length; ++i) {
                this.readCountArray(input, table[i]);
            }
            RichCountMinSketch$.MODULE$.setSize$extension(sketch, input.readLong(true));
        }
        return stat2;
    }

    public void writeIteratorStackCount(Output output, IteratorStackCount stat2) {
        output.writeLong(stat2.counter(), true);
    }

    /*
     * WARNING - void declaration
     */
    public IteratorStackCount readIteratorStackCount(Input input, boolean immutable) {
        void var3_3;
        IteratorStackCount stat2 = immutable ? new ImmutableStat(){

            public void observe(SimpleFeature sf) {
                ImmutableStat$class.observe(this, sf);
            }

            public void unobserve(SimpleFeature sf) {
                ImmutableStat$class.unobserve(this, sf);
            }

            public void $plus$eq(Stat other) {
                ImmutableStat$class.$plus$eq(this, other);
            }

            public void clear() {
                ImmutableStat$class.clear(this);
            }
            {
                ImmutableStat$class.$init$(this);
            }
        } : new IteratorStackCount();
        stat2.counter_$eq(input.readLong(true));
        return var3_3;
    }

    public void org$locationtech$geomesa$utils$stats$KryoStatSerializer$$writeCountArray(Output output, long[] counts) {
        int i = 0;
        while (i < counts.length) {
            long count2 = counts[i];
            if (count2 == 0L) {
                Object object;
                int nextNonZero;
                for (nextNonZero = i + 1; nextNonZero < counts.length && counts[nextNonZero] == 0L; ++nextNonZero) {
                }
                int numZeros = nextNonZero - i;
                if (numZeros > 4) {
                    output.writeLong(Long.MAX_VALUE, true);
                    object = BoxesRunTime.boxToInteger((int)output.writeInt(numZeros, true));
                } else {
                    if (numZeros > 0) {
                        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numZeros).foreach((Function1)new Serializable(output){
                            public static final long serialVersionUID = 0L;
                            private final Output output$9;

                            public final int apply(int x$7) {
                                return this.apply$mcII$sp(x$7);
                            }

                            public int apply$mcII$sp(int x$7) {
                                return this.output$9.writeLong(0L, true);
                            }
                            {
                                this.output$9 = output$9;
                            }
                        });
                    }
                    object = BoxedUnit.UNIT;
                }
                i = nextNonZero;
                continue;
            }
            output.writeLong(count2, true);
            ++i;
        }
    }

    private void readCountArray(Input input, long[] counts) {
        int i = 0;
        while (i < counts.length) {
            long count2 = input.readLong(true);
            if (count2 == Long.MAX_VALUE) {
                i += input.readInt(true);
                continue;
            }
            counts[i] = count2;
            ++i;
        }
    }

    public Function1<Object, BoxedUnit> org$locationtech$geomesa$utils$stats$KryoStatSerializer$$writer(Output output, Class<?> binding) {
        block9: {
            Object object;
            block3: {
                block8: {
                    block7: {
                        block6: {
                            block5: {
                                block4: {
                                    block2: {
                                        Class<?> clazz = binding;
                                        Class<String> clazz2 = String.class;
                                        if (clazz != null ? !clazz.equals(clazz2) : clazz2 != null) break block2;
                                        object = new Serializable(output){
                                            public static final long serialVersionUID = 0L;
                                            private final Output output$8;

                                            public final void apply(Object value2) {
                                                this.output$8.writeString((String)value2);
                                            }
                                            {
                                                this.output$8 = output$8;
                                            }
                                        };
                                        break block3;
                                    }
                                    Class<?> clazz = binding;
                                    Class<Integer> clazz3 = Integer.class;
                                    if (clazz != null ? !clazz.equals(clazz3) : clazz3 != null) break block4;
                                    object = new Serializable(output){
                                        public static final long serialVersionUID = 0L;
                                        private final Output output$8;

                                        public final void apply(Object value2) {
                                            this.output$8.writeInt(Predef$.MODULE$.Integer2int((Integer)value2), true);
                                        }
                                        {
                                            this.output$8 = output$8;
                                        }
                                    };
                                    break block3;
                                }
                                Class<?> clazz = binding;
                                Class<Long> clazz4 = Long.class;
                                if (clazz != null ? !clazz.equals(clazz4) : clazz4 != null) break block5;
                                object = new Serializable(output){
                                    public static final long serialVersionUID = 0L;
                                    private final Output output$8;

                                    public final void apply(Object value2) {
                                        this.output$8.writeLong(Predef$.MODULE$.Long2long((Long)value2), true);
                                    }
                                    {
                                        this.output$8 = output$8;
                                    }
                                };
                                break block3;
                            }
                            Class<?> clazz = binding;
                            Class<Float> clazz5 = Float.class;
                            if (clazz != null ? !clazz.equals(clazz5) : clazz5 != null) break block6;
                            object = new Serializable(output){
                                public static final long serialVersionUID = 0L;
                                private final Output output$8;

                                public final void apply(Object value2) {
                                    this.output$8.writeFloat(Predef$.MODULE$.Float2float((Float)value2));
                                }
                                {
                                    this.output$8 = output$8;
                                }
                            };
                            break block3;
                        }
                        Class<?> clazz = binding;
                        Class<Double> clazz6 = Double.class;
                        if (clazz != null ? !clazz.equals(clazz6) : clazz6 != null) break block7;
                        object = new Serializable(output){
                            public static final long serialVersionUID = 0L;
                            private final Output output$8;

                            public final void apply(Object value2) {
                                this.output$8.writeDouble(Predef$.MODULE$.Double2double((Double)value2));
                            }
                            {
                                this.output$8 = output$8;
                            }
                        };
                        break block3;
                    }
                    if (!Date.class.isAssignableFrom(binding)) break block8;
                    object = new Serializable(output){
                        public static final long serialVersionUID = 0L;
                        private final Output output$8;

                        public final void apply(Object value2) {
                            this.output$8.writeLong(((Date)value2).getTime(), true);
                        }
                        {
                            this.output$8 = output$8;
                        }
                    };
                    break block3;
                }
                if (!Geometry.class.isAssignableFrom(binding)) break block9;
                object = new Serializable(output){
                    public static final long serialVersionUID = 0L;
                    private final Output output$8;

                    public final void apply(Object value2) {
                        byte[] b1 = WKBUtils$.MODULE$.write((Geometry)value2);
                        this.output$8.writeInt(b1.length, true);
                        this.output$8.write(b1);
                    }
                    {
                        this.output$8 = output$8;
                    }
                };
            }
            return object;
        }
        throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot serialize stat due to invalid type: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{binding})));
    }

    private Function0<Object> reader(Input input, Class<?> binding) {
        block9: {
            Serializable serializable;
            block3: {
                block8: {
                    block7: {
                        block6: {
                            block5: {
                                block4: {
                                    block2: {
                                        Class<?> clazz = binding;
                                        Class<String> clazz2 = String.class;
                                        if (clazz != null ? !clazz.equals(clazz2) : clazz2 != null) break block2;
                                        serializable = new Serializable(input){
                                            public static final long serialVersionUID = 0L;
                                            private final Input input$2;

                                            public final String apply() {
                                                return this.input$2.readString();
                                            }
                                            {
                                                this.input$2 = input$2;
                                            }
                                        };
                                        break block3;
                                    }
                                    Class<?> clazz = binding;
                                    Class<Integer> clazz3 = Integer.class;
                                    if (clazz != null ? !clazz.equals(clazz3) : clazz3 != null) break block4;
                                    serializable = new Serializable(input){
                                        public static final long serialVersionUID = 0L;
                                        private final Input input$2;

                                        public final int apply() {
                                            return this.apply$mcI$sp();
                                        }

                                        public int apply$mcI$sp() {
                                            return this.input$2.readInt(true);
                                        }
                                        {
                                            this.input$2 = input$2;
                                        }
                                    };
                                    break block3;
                                }
                                Class<?> clazz = binding;
                                Class<Long> clazz4 = Long.class;
                                if (clazz != null ? !clazz.equals(clazz4) : clazz4 != null) break block5;
                                serializable = new Serializable(input){
                                    public static final long serialVersionUID = 0L;
                                    private final Input input$2;

                                    public final long apply() {
                                        return this.apply$mcJ$sp();
                                    }

                                    public long apply$mcJ$sp() {
                                        return this.input$2.readLong(true);
                                    }
                                    {
                                        this.input$2 = input$2;
                                    }
                                };
                                break block3;
                            }
                            Class<?> clazz = binding;
                            Class<Float> clazz5 = Float.class;
                            if (clazz != null ? !clazz.equals(clazz5) : clazz5 != null) break block6;
                            serializable = new Serializable(input){
                                public static final long serialVersionUID = 0L;
                                private final Input input$2;

                                public final float apply() {
                                    return this.apply$mcF$sp();
                                }

                                public float apply$mcF$sp() {
                                    return this.input$2.readFloat();
                                }
                                {
                                    this.input$2 = input$2;
                                }
                            };
                            break block3;
                        }
                        Class<?> clazz = binding;
                        Class<Double> clazz6 = Double.class;
                        if (clazz != null ? !clazz.equals(clazz6) : clazz6 != null) break block7;
                        serializable = new Serializable(input){
                            public static final long serialVersionUID = 0L;
                            private final Input input$2;

                            public final double apply() {
                                return this.apply$mcD$sp();
                            }

                            public double apply$mcD$sp() {
                                return this.input$2.readDouble();
                            }
                            {
                                this.input$2 = input$2;
                            }
                        };
                        break block3;
                    }
                    if (!Date.class.isAssignableFrom(binding)) break block8;
                    serializable = new Serializable(input){
                        public static final long serialVersionUID = 0L;
                        private final Input input$2;

                        public final Date apply() {
                            return new Date(this.input$2.readLong(true));
                        }
                        {
                            this.input$2 = input$2;
                        }
                    };
                    break block3;
                }
                if (!Geometry.class.isAssignableFrom(binding)) break block9;
                serializable = new Serializable(input){
                    public static final long serialVersionUID = 0L;
                    private final Input input$2;

                    public final Geometry apply() {
                        byte[] b = (byte[])Array$.MODULE$.ofDim(this.input$2.readInt(true), ClassTag$.MODULE$.Byte());
                        this.input$2.read(b);
                        return WKBUtils$.MODULE$.read(b);
                    }
                    {
                        this.input$2 = input$2;
                    }
                };
            }
            return serializable;
        }
        throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot deserialize stat due to invalid type: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{binding})));
    }

    private final void writeArray$1(double[] array, Output output$6) {
        Predef$.MODULE$.doubleArrayOps(array).foreach((Function1)new Serializable(output$6){
            public static final long serialVersionUID = 0L;
            private final Output output$6;

            public final void apply(double v) {
                this.apply$mcVD$sp(v);
            }

            public void apply$mcVD$sp(double v) {
                this.output$6.writeDouble(v);
            }
            {
                this.output$6 = output$6;
            }
        });
    }

    private final void readArray$1(double[] array, Input input$1) {
        Predef$.MODULE$.doubleArrayOps(array).indices().foreach$mVc$sp((Function1)new Serializable(input$1, array){
            public static final long serialVersionUID = 0L;
            private final Input input$1;
            private final double[] array$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.array$1[i] = this.input$1.readDouble();
            }
            {
                this.input$1 = input$1;
                this.array$1 = array$1;
            }
        });
    }

    private KryoStatSerializer$() {
        MODULE$ = this;
        this.inputs = new SoftThreadLocal();
        this.outputs = new SoftThreadLocal();
        this.SeqStatByte = 0;
        this.CountByte = 1;
        this.MinMaxByte = (byte)2;
        this.IteratorStackByte = (byte)3;
        this.EnumerationByte = (byte)4;
        this.HistogramByte = (byte)5;
        this.FrequencyByteV1 = (byte)6;
        this.Z3HistogramByteV1 = (byte)7;
        this.Z3FrequencyByteV1 = (byte)8;
        this.TopKByte = (byte)9;
        this.FrequencyByte = (byte)10;
        this.Z3HistogramByte = (byte)11;
        this.Z3FrequencyByte = (byte)12;
        this.DescriptiveStatByte = (byte)13;
        this.GroupByByte = (byte)14;
    }
}

