/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.kafka;

import java.util.UUID;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.locationtech.geomesa.kafka.ReplayConfig;
import org.locationtech.geomesa.kafka.ReplayConfig$;
import org.locationtech.geomesa.kafka.ReplayTimeHelper$;
import org.locationtech.geomesa.utils.geotools.FeatureUtils$;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;

public final class KafkaDataStoreHelper$ {
    public static final KafkaDataStoreHelper$ MODULE$;
    private final String TopicKey;
    private final String ReplayConfigKey;
    private final String DefaultZkPath;
    private final String replayIdentifier;

    static {
        new KafkaDataStoreHelper$();
    }

    public String TopicKey() {
        return this.TopicKey;
    }

    public String ReplayConfigKey() {
        return this.ReplayConfigKey;
    }

    /*
     * WARNING - void declaration
     */
    public SimpleFeatureType createStreamingSFT(SimpleFeatureType sft, String zkPath) {
        void var3_3;
        SimpleFeatureType streamingSft = FeatureUtils$.MODULE$.builder(sft).buildFeatureType();
        this.insertTopic(streamingSft, this.buildTopicName(zkPath, sft));
        return var3_3;
    }

    public SimpleFeatureType createReplaySFT(SimpleFeatureType sft, ReplayConfig rConfig) {
        Predef$.MODULE$.require(this.isStreamingSFT(sft), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Only \"Streaming SFTs\" created by 'createStreamingSFT' can be used with 'createReplaySFT'.";
            }
        });
        SimpleFeatureTypeBuilder builder = FeatureUtils$.MODULE$.builder(sft);
        builder.setName(this.buildReplayTypeName(sft.getTypeName()));
        ReplayTimeHelper$.MODULE$.addReplayTimeAttribute(builder);
        SimpleFeatureType replaySft = builder.buildFeatureType();
        replaySft.getUserData().put(this.ReplayConfigKey(), ReplayConfig$.MODULE$.encode(rConfig));
        return replaySft;
    }

    public void insertTopic(SimpleFeatureType sft, String topic) {
        sft.getUserData().put(this.TopicKey(), topic);
    }

    public Option<String> extractTopic(SimpleFeatureType sft) {
        return RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.userData$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft), (Object)this.TopicKey());
    }

    public void insertReplayConfig(SimpleFeatureType sft, String configString) {
        sft.getUserData().put(this.ReplayConfigKey(), configString);
    }

    public Option<ReplayConfig> extractReplayConfig(SimpleFeatureType sft) {
        return RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.userData$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft), (Object)this.ReplayConfigKey()).flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Option<ReplayConfig> apply(String rcString) {
                return ReplayConfig$.MODULE$.decode(rcString);
            }
        });
    }

    public Option<String> extractStreamingTypeName(SimpleFeatureType replaySFT) {
        String replayName = replaySFT.getTypeName();
        int index = replayName.indexOf(this.replayIdentifier());
        return index > 0 ? new Some((Object)replayName.substring(0, index)) : None$.MODULE$;
    }

    public boolean isStreamingSFT(SimpleFeatureType sft) {
        return sft.getUserData().containsKey(this.TopicKey()) && !sft.getUserData().containsKey(this.ReplayConfigKey());
    }

    public boolean isPreparedForReplay(SimpleFeatureType sft) {
        return sft.getUserData().containsKey(this.TopicKey()) && sft.getUserData().containsKey(this.ReplayConfigKey());
    }

    public String DefaultZkPath() {
        return this.DefaultZkPath;
    }

    public String cleanZkPath(String rawPath, String string) {
        return (String)Option$.MODULE$.apply((Object)rawPath).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String x$1) {
                return x$1.trim();
            }
        }).filterNot((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$2) {
                return x$2.isEmpty();
            }
        }).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String p) {
                return p.startsWith("/") ? p : new StringBuilder().append((Object)"/").append((Object)p).toString();
            }
        }).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String p) {
                return p.endsWith("/") && p.length() > 1 ? p.substring(0, p.length() - 1) : p;
            }
        }).getOrElse((Function0)new Serializable(string){
            public static final long serialVersionUID = 0L;
            private final String default$1;

            public final String apply() {
                return this.default$1;
            }
            {
                this.default$1 = default$1;
            }
        });
    }

    public String cleanZkPath$default$2() {
        return this.DefaultZkPath();
    }

    public String buildTopicName(String zkPath, SimpleFeatureType sft) {
        String prefix = (zkPath.startsWith("/") ? zkPath.substring(1) : zkPath).replaceAll("/", "-");
        return new StringBuilder().append((Object)prefix).append((Object)"-").append((Object)sft.getTypeName()).toString();
    }

    private String replayIdentifier() {
        return this.replayIdentifier;
    }

    private String buildReplayTypeName(String name) {
        UUID uuid = UUID.randomUUID();
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, this.replayIdentifier(), uuid}));
    }

    private KafkaDataStoreHelper$() {
        MODULE$ = this;
        this.TopicKey = "Topic";
        this.ReplayConfigKey = "ReplayConfig";
        this.DefaultZkPath = "/geomesa/ds/kafka";
        this.replayIdentifier = "-REPLAY-";
    }
}

