/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.kafka;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.RemovalCause;
import com.github.benmanes.caffeine.cache.RemovalListener;
import com.github.benmanes.caffeine.cache.Ticker;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import com.vividsolutions.jts.geom.Envelope;
import java.util.concurrent.TimeUnit;
import org.geotools.data.simple.SimpleFeatureReader;
import org.locationtech.geomesa.filter.index.SpatialIndexSupport;
import org.locationtech.geomesa.kafka.CreateOrUpdate;
import org.locationtech.geomesa.kafka.Delete;
import org.locationtech.geomesa.kafka.FeatureHolder;
import org.locationtech.geomesa.kafka.KafkaConsumerFeatureCache;
import org.locationtech.geomesa.kafka.KafkaConsumerFeatureCache$class;
import org.locationtech.geomesa.kafka.LiveFeatureCache;
import org.locationtech.geomesa.kafka.LiveFeatureCacheGuava$;
import org.locationtech.geomesa.utils.geotools.Conversions;
import org.locationtech.geomesa.utils.geotools.Conversions$;
import org.locationtech.geomesa.utils.index.BucketIndex;
import org.locationtech.geomesa.utils.index.BucketIndex$;
import org.locationtech.geomesa.utils.index.SpatialIndex;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.And;
import org.opengis.filter.Filter;
import org.opengis.filter.Id;
import org.opengis.filter.Or;
import org.opengis.filter.spatial.BinarySpatialOperator;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.mutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00055c\u0001B\u0001\u0003\u0001-\u0011Q\u0003T5wK\u001a+\u0017\r^;sK\u000e\u000b7\r[3Hk\u00064\u0018M\u0003\u0002\u0004\t\u0005)1.\u00194lC*\u0011QAB\u0001\bO\u0016|W.Z:b\u0015\t9\u0001\"\u0001\u0007m_\u000e\fG/[8oi\u0016\u001c\u0007NC\u0001\n\u0003\ry'oZ\u0002\u0001'\u0015\u0001AB\u0005\f\u001a!\ti\u0001#D\u0001\u000f\u0015\u0005y\u0011!B:dC2\f\u0017BA\t\u000f\u0005\u0019\te.\u001f*fMB\u00111\u0003F\u0007\u0002\u0005%\u0011QC\u0001\u0002\u001a\u0017\u000647.Y\"p]N,X.\u001a:GK\u0006$XO]3DC\u000eDW\r\u0005\u0002\u0014/%\u0011\u0001D\u0001\u0002\u0011\u0019&4XMR3biV\u0014XmQ1dQ\u0016\u0004\"AG\u0011\u000e\u0003mQ!\u0001H\u000f\u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\u0005yy\u0012\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0003\u0001\n1aY8n\u0013\t\u00113DA\u0006MCjLHj\\4hS:<\u0007\u0002\u0003\u0013\u0001\u0005\u000b\u0007I\u0011I\u0013\u0002\u0007M4G/F\u0001'!\t9c&D\u0001)\u0015\tI#&\u0001\u0004tS6\u0004H.\u001a\u0006\u0003W1\nqAZ3biV\u0014XM\u0003\u0002.\u0011\u00059q\u000e]3oO&\u001c\u0018BA\u0018)\u0005E\u0019\u0016.\u001c9mK\u001a+\u0017\r^;sKRK\b/\u001a\u0005\tc\u0001\u0011\t\u0011)A\u0005M\u0005!1O\u001a;!\u0011!\u0019\u0004A!A!\u0002\u0013!\u0014\u0001E3ya&\u0014\u0018\r^5p]B+'/[8e!\riQgN\u0005\u0003m9\u0011aa\u00149uS>t\u0007CA\u00079\u0013\tIdB\u0001\u0003M_:<\u0007\u0002C\u001e\u0001\u0005\u0003\u0005\u000b1\u0002\u001f\u0002\rQL7m[3s!\tid)D\u0001?\u0015\ty\u0004)A\u0003dC\u000eDWM\u0003\u0002B\u0005\u0006A1-\u00194gK&tWM\u0003\u0002D\t\u0006A!-\u001a8nC:,7O\u0003\u0002F?\u00051q-\u001b;ik\nL!a\u0012 \u0003\rQK7m[3s\u0011\u0015I\u0005\u0001\"\u0001K\u0003\u0019a\u0014N\\5u}Q\u00191JT(\u0015\u00051k\u0005CA\n\u0001\u0011\u0015Y\u0004\nq\u0001=\u0011\u0015!\u0003\n1\u0001'\u0011\u0015\u0019\u0004\n1\u00015\u0011\u001d\t\u0006\u00011A\u0005\u0002I\u000bAb\u001d9bi&\fG.\u00138eKb,\u0012a\u0015\t\u0004)f[V\"A+\u000b\u0005Y;\u0016!B5oI\u0016D(B\u0001-\u0005\u0003\u0015)H/\u001b7t\u0013\tQVK\u0001\u0007Ta\u0006$\u0018.\u00197J]\u0012,\u0007\u0010\u0005\u0002(9&\u0011Q\f\u000b\u0002\u000e'&l\u0007\u000f\\3GK\u0006$XO]3\t\u000f}\u0003\u0001\u0019!C\u0001A\u0006\u00012\u000f]1uS\u0006d\u0017J\u001c3fq~#S-\u001d\u000b\u0003C\u0012\u0004\"!\u00042\n\u0005\rt!\u0001B+oSRDq!\u001a0\u0002\u0002\u0003\u00071+A\u0002yIEBaa\u001a\u0001!B\u0013\u0019\u0016!D:qCRL\u0017\r\\%oI\u0016D\b\u0005C\u0004@\u0001\t\u0007I\u0011B5\u0016\u0003)\u0004B!P6ni&\u0011AN\u0010\u0002\u0006\u0007\u0006\u001c\u0007.\u001a\t\u0003]Ft!!D8\n\u0005At\u0011A\u0002)sK\u0012,g-\u0003\u0002sg\n11\u000b\u001e:j]\u001eT!\u0001\u001d\b\u0011\u0005M)\u0018B\u0001<\u0003\u000551U-\u0019;ve\u0016Du\u000e\u001c3fe\"1\u0001\u0010\u0001Q\u0001\n)\faaY1dQ\u0016\u0004\u0003b\u0002>\u0001\u0005\u0004%\te_\u0001\tM\u0016\fG/\u001e:fgV\tA\u0010E\u0003~\u0003\u000biG/D\u0001\u007f\u0015\ry\u0018\u0011A\u0001\b[V$\u0018M\u00197f\u0015\r\t\u0019AD\u0001\u000bG>dG.Z2uS>t\u0017bAA\u0004}\n\u0019Q*\u00199\t\u000f\u0005-\u0001\u0001)A\u0005y\u0006Ia-Z1ukJ,7\u000f\t\u0005\b\u0003\u001f\u0001A\u0011IA\t\u0003\u001d\u0019G.Z1o+B$\u0012!\u0019\u0005\b\u0003+\u0001A\u0011IA\f\u0003U\u0019'/Z1uK>\u0013X\u000b\u001d3bi\u00164U-\u0019;ve\u0016$2!YA\r\u0011!\tY\"a\u0005A\u0002\u0005u\u0011AB;qI\u0006$X\rE\u0002\u0014\u0003?I1!!\t\u0003\u00059\u0019%/Z1uK>\u0013X\u000b\u001d3bi\u0016Dq!!\n\u0001\t\u0003\n9#A\u0007sK6|g/\u001a$fCR,(/\u001a\u000b\u0004C\u0006%\u0002\u0002CA\u0016\u0003G\u0001\r!!\f\u0002\u0011Q|G)\u001a7fi\u0016\u00042aEA\u0018\u0013\r\t\tD\u0001\u0002\u0007\t\u0016dW\r^3\t\u000f\u0005U\u0002\u0001\"\u0011\u0002\u0012\u0005)1\r\\3be\"9\u0011\u0011\b\u0001\u0005B\u0005m\u0012AD4fi\u001a+\u0017\r^;sK\nK\u0018\n\u001a\u000b\u0004i\u0006u\u0002bBA \u0003o\u0001\r!\\\u0001\u0003S\u0012Dq!a\u0011\u0001\t\u0013\t)%A\boK^\u001c\u0006/\u0019;jC2Le\u000eZ3y)\t\t9\u0005\u0005\u0003U\u0003\u0013Z\u0016bAA&+\nY!)^2lKRLe\u000eZ3y\u0001")
public class LiveFeatureCacheGuava
implements KafkaConsumerFeatureCache,
LiveFeatureCache,
LazyLogging {
    private final SimpleFeatureType sft;
    private SpatialIndex<SimpleFeature> spatialIndex;
    private final Cache<String, FeatureHolder> cache;
    private final Map<String, FeatureHolder> features;
    private final Logger logger;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        LiveFeatureCacheGuava liveFeatureCacheGuava = this;
        synchronized (liveFeatureCacheGuava) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public /* synthetic */ SimpleFeatureReader org$locationtech$geomesa$kafka$KafkaConsumerFeatureCache$$super$getReaderForFilter(Filter filter) {
        return SpatialIndexSupport.class.getReaderForFilter((SpatialIndexSupport)this, (Filter)filter);
    }

    @Override
    public Iterator<SimpleFeature> allFeatures() {
        return KafkaConsumerFeatureCache$class.allFeatures(this);
    }

    @Override
    public int size() {
        return KafkaConsumerFeatureCache$class.size(this);
    }

    @Override
    public int size(Filter f) {
        return KafkaConsumerFeatureCache$class.size(this, f);
    }

    @Override
    public SimpleFeatureReader getReaderForFilter(Filter filter) {
        return KafkaConsumerFeatureCache$class.getReaderForFilter(this, filter);
    }

    @Override
    public SimpleFeatureReader fid(Id ids) {
        return KafkaConsumerFeatureCache$class.fid(this, ids);
    }

    public SimpleFeatureReader include() {
        return SpatialIndexSupport.class.include((SpatialIndexSupport)this);
    }

    public SimpleFeatureReader spatial(BinarySpatialOperator f) {
        return SpatialIndexSupport.class.spatial((SpatialIndexSupport)this, (BinarySpatialOperator)f);
    }

    public SimpleFeatureReader and(And a) {
        return SpatialIndexSupport.class.and((SpatialIndexSupport)this, (And)a);
    }

    public SimpleFeatureReader or(Or o) {
        return SpatialIndexSupport.class.or((SpatialIndexSupport)this, (Or)o);
    }

    public SimpleFeatureReader unoptimized(Filter f) {
        return SpatialIndexSupport.class.unoptimized((SpatialIndexSupport)this, (Filter)f);
    }

    public SimpleFeatureReader reader(Iterator<SimpleFeature> iter) {
        return SpatialIndexSupport.class.reader((SpatialIndexSupport)this, iter);
    }

    public SimpleFeatureType sft() {
        return this.sft;
    }

    public SpatialIndex<SimpleFeature> spatialIndex() {
        return this.spatialIndex;
    }

    public void spatialIndex_$eq(SpatialIndex<SimpleFeature> x$1) {
        this.spatialIndex = x$1;
    }

    private Cache<String, FeatureHolder> cache() {
        return this.cache;
    }

    @Override
    public Map<String, FeatureHolder> features() {
        return this.features;
    }

    @Override
    public void cleanUp() {
        this.cache().cleanUp();
    }

    @Override
    public void createOrUpdateFeature(CreateOrUpdate update) {
        SimpleFeature sf = update.feature();
        String id = sf.getID();
        FeatureHolder old = (FeatureHolder)this.cache().getIfPresent((Object)id);
        Object object = old == null ? BoxedUnit.UNIT : BoxesRunTime.boxToBoolean((boolean)this.spatialIndex().remove(old.env(), (Object)old.sf()));
        Envelope env = Conversions.RichSimpleFeature$.MODULE$.geometry$extension(Conversions$.MODULE$.RichSimpleFeature(sf)).getEnvelopeInternal();
        this.spatialIndex().insert(env, (Object)sf);
        this.cache().put((Object)id, (Object)new FeatureHolder(sf, env));
    }

    @Override
    public void removeFeature(Delete toDelete) {
        String id = toDelete.id();
        FeatureHolder old = (FeatureHolder)this.cache().getIfPresent((Object)id);
        if (old != null) {
            this.spatialIndex().remove(old.env(), (Object)old.sf());
            this.cache().invalidate((Object)id);
        }
    }

    @Override
    public void clear() {
        this.cache().invalidateAll();
        this.spatialIndex_$eq((SpatialIndex<SimpleFeature>)this.newSpatialIndex());
    }

    @Override
    public FeatureHolder getFeatureById(String id) {
        return (FeatureHolder)this.cache().getIfPresent((Object)id);
    }

    private BucketIndex<SimpleFeature> newSpatialIndex() {
        return new BucketIndex(BucketIndex$.MODULE$.$lessinit$greater$default$1(), BucketIndex$.MODULE$.$lessinit$greater$default$2(), BucketIndex$.MODULE$.$lessinit$greater$default$3());
    }

    public LiveFeatureCacheGuava(SimpleFeatureType sft, Option<Object> expirationPeriod, Ticker ticker) {
        this.sft = sft;
        SpatialIndexSupport.class.$init$((SpatialIndexSupport)this);
        KafkaConsumerFeatureCache$class.$init$(this);
        LazyLogging.class.$init$((LazyLogging)this);
        this.spatialIndex = this.newSpatialIndex();
        Caffeine cb = Caffeine.newBuilder().ticker(ticker);
        expirationPeriod.foreach((Function1)new Serializable(this, cb){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LiveFeatureCacheGuava $outer;
            private final Caffeine cb$1;

            public final Caffeine<String, FeatureHolder> apply(long ep) {
                return this.cb$1.expireAfterWrite(ep, TimeUnit.MILLISECONDS).removalListener((RemovalListener)new RemovalListener<String, FeatureHolder>(this, ep){
                    private final /* synthetic */ $anonfun$1 $outer;
                    private final long ep$1;

                    public void onRemoval(String key, FeatureHolder value, RemovalCause cause) {
                        RemovalCause removalCause = cause;
                        RemovalCause removalCause2 = RemovalCause.EXPIRED;
                        if (!(removalCause != null ? !removalCause.equals(removalCause2) : removalCause2 != null)) {
                            BoxedUnit boxedUnit;
                            if (this.$outer.org$locationtech$geomesa$kafka$LiveFeatureCacheGuava$$anonfun$$$outer().logger().underlying().isDebugEnabled()) {
                                this.$outer.org$locationtech$geomesa$kafka$LiveFeatureCacheGuava$$anonfun$$$outer().logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Removing feature ", " due to expiration after ", "ms"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key, BoxesRunTime.boxToLong((long)this.ep$1)})));
                                boxedUnit = BoxedUnit.UNIT;
                            } else {
                                boxedUnit = BoxedUnit.UNIT;
                            }
                            this.$outer.org$locationtech$geomesa$kafka$LiveFeatureCacheGuava$$anonfun$$$outer().spatialIndex().remove(value.env(), (Object)value.sf());
                        }
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.ep$1 = ep$1;
                    }
                });
            }

            public /* synthetic */ LiveFeatureCacheGuava org$locationtech$geomesa$kafka$LiveFeatureCacheGuava$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.cb$1 = cb$1;
            }
        });
        this.cache = cb.build();
        this.features = (Map)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.cache().asMap()).asScala();
    }
}

