/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.kafka;

import com.typesafe.scalalogging.Logger;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.locationtech.geomesa.kafka.GeoMessage;
import org.locationtech.geomesa.kafka.ReplayConfig$;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u0005Uf\u0001B\u0001\u0003\u0001.\u0011ABU3qY\u0006L8i\u001c8gS\u001eT!a\u0001\u0003\u0002\u000b-\fgm[1\u000b\u0005\u00151\u0011aB4f_6,7/\u0019\u0006\u0003\u000f!\tA\u0002\\8dCRLwN\u001c;fG\"T\u0011!C\u0001\u0004_J<7\u0001A\n\u0005\u00011\u0011R\u0003\u0005\u0002\u000e!5\taBC\u0001\u0010\u0003\u0015\u00198-\u00197b\u0013\t\tbB\u0001\u0004B]f\u0014VM\u001a\t\u0003\u001bMI!\u0001\u0006\b\u0003\u000fA\u0013x\u000eZ;diB\u0011QBF\u0005\u0003/9\u0011AbU3sS\u0006d\u0017N_1cY\u0016D\u0001\"\u0007\u0001\u0003\u0016\u0004%\tAG\u0001\u0006gR\f'\u000f^\u000b\u00027A\u0011A$I\u0007\u0002;)\u0011adH\u0001\u0005i&lWM\u0003\u0002!\u0011\u0005!!n\u001c3b\u0013\t\u0011SDA\u0004J]N$\u0018M\u001c;\t\u0011\u0011\u0002!\u0011#Q\u0001\nm\taa\u001d;beR\u0004\u0003\u0002\u0003\u0014\u0001\u0005+\u0007I\u0011\u0001\u000e\u0002\u0007\u0015tG\r\u0003\u0005)\u0001\tE\t\u0015!\u0003\u001c\u0003\u0011)g\u000e\u001a\u0011\t\u0011)\u0002!Q3A\u0005\u0002-\n!B]3bI\n+\u0007.\u001b8e+\u0005a\u0003C\u0001\u000f.\u0013\tqSD\u0001\u0005EkJ\fG/[8o\u0011!\u0001\u0004A!E!\u0002\u0013a\u0013a\u0003:fC\u0012\u0014U\r[5oI\u0002BQA\r\u0001\u0005\u0002M\na\u0001P5oSRtD\u0003\u0002\u001b7oa\u0002\"!\u000e\u0001\u000e\u0003\tAQ!G\u0019A\u0002mAQAJ\u0019A\u0002mAQAK\u0019A\u00021BqA\u000f\u0001C\u0002\u0013\u0005!$A\u0007sK\u0006d7\u000b^1siRKW.\u001a\u0005\u0007y\u0001\u0001\u000b\u0011B\u000e\u0002\u001dI,\u0017\r\\*uCJ$H+[7fA!)a\b\u0001C\u0001\u007f\u0005\t\u0012n\u001d\"fM>\u0014XMU3bYN#\u0018M\u001d;\u0015\u0005\u0001\u001b\u0005CA\u0007B\u0013\t\u0011eBA\u0004C_>dW-\u00198\t\u000b\u0011k\u0004\u0019A#\u0002\u00075\u001cx\r\u0005\u00026\r&\u0011qI\u0001\u0002\u000b\u000f\u0016|W*Z:tC\u001e,\u0007\"B%\u0001\t\u0003Q\u0015!D5t\u001d>$\u0018I\u001a;fe\u0016sG\r\u0006\u0002A\u0017\")A\t\u0013a\u0001\u000b\")Q\n\u0001C\u0001\u001d\u0006Q\u0011n]%o/&tGm\\<\u0015\u0005\u0001{\u0005\"\u0002\u0010M\u0001\u0004\u0001\u0006CA\u0007R\u0013\t\u0011fB\u0001\u0003M_:<\u0007b\u0002+\u0001\u0003\u0003%\t!V\u0001\u0005G>\u0004\u0018\u0010\u0006\u00035-^C\u0006bB\rT!\u0003\u0005\ra\u0007\u0005\bMM\u0003\n\u00111\u0001\u001c\u0011\u001dQ3\u000b%AA\u00021BqA\u0017\u0001\u0012\u0002\u0013\u00051,\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0003qS#aG/,\u0003y\u0003\"a\u00183\u000e\u0003\u0001T!!\u00192\u0002\u0013Ut7\r[3dW\u0016$'BA2\u000f\u0003)\tgN\\8uCRLwN\\\u0005\u0003K\u0002\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011\u001d9\u0007!%A\u0005\u0002m\u000babY8qs\u0012\"WMZ1vYR$#\u0007C\u0004j\u0001E\u0005I\u0011\u00016\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%gU\t1N\u000b\u0002-;\"9Q\u000eAA\u0001\n\u0003r\u0017!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070F\u0001p!\t\u0001X/D\u0001r\u0015\t\u00118/\u0001\u0003mC:<'\"\u0001;\u0002\t)\fg/Y\u0005\u0003mF\u0014aa\u0015;sS:<\u0007b\u0002=\u0001\u0003\u0003%\t!_\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0002uB\u0011Qb_\u0005\u0003y:\u00111!\u00138u\u0011\u001dq\b!!A\u0005\u0002}\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002\u0002\u0005\u001d\u0001cA\u0007\u0002\u0004%\u0019\u0011Q\u0001\b\u0003\u0007\u0005s\u0017\u0010\u0003\u0005\u0002\nu\f\t\u00111\u0001{\u0003\rAH%\r\u0005\n\u0003\u001b\u0001\u0011\u0011!C!\u0003\u001f\tq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003#\u0001b!a\u0005\u0002\u001a\u0005\u0005QBAA\u000b\u0015\r\t9BD\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA\u000e\u0003+\u0011\u0001\"\u0013;fe\u0006$xN\u001d\u0005\n\u0003?\u0001\u0011\u0011!C\u0001\u0003C\t\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0004\u0001\u0006\r\u0002BCA\u0005\u0003;\t\t\u00111\u0001\u0002\u0002!I\u0011q\u0005\u0001\u0002\u0002\u0013\u0005\u0013\u0011F\u0001\tQ\u0006\u001c\bnQ8eKR\t!\u0010C\u0005\u0002.\u0001\t\t\u0011\"\u0011\u00020\u0005AAo\\*ue&tw\rF\u0001p\u0011%\t\u0019\u0004AA\u0001\n\u0003\n)$\u0001\u0004fcV\fGn\u001d\u000b\u0004\u0001\u0006]\u0002BCA\u0005\u0003c\t\t\u00111\u0001\u0002\u0002\u001d9\u00111\b\u0002\t\u0002\u0005u\u0012\u0001\u0004*fa2\f\u0017pQ8oM&<\u0007cA\u001b\u0002@\u00191\u0011A\u0001E\u0001\u0003\u0003\u001ab!a\u0010\r\u0003\u0007*\u0002\u0003BA#\u0003'j!!a\u0012\u000b\t\u0005%\u00131J\u0001\rg\u000e\fG.\u00197pO\u001eLgn\u001a\u0006\u0005\u0003\u001b\ny%\u0001\u0005usB,7/\u00194f\u0015\t\t\t&A\u0002d_6LA!!\u0016\u0002H\tYA*\u0019>z\u0019><w-\u001b8h\u0011\u001d\u0011\u0014q\bC\u0001\u00033\"\"!!\u0010\t\u0011\u0005u\u0013q\bC\u0001\u0003?\nQ!\u00199qYf$r\u0001NA1\u0003G\n)\u0007\u0003\u0004\u001a\u00037\u0002\r\u0001\u0015\u0005\u0007M\u0005m\u0003\u0019\u0001)\t\r)\nY\u00061\u0001Q\u0011!\tI'a\u0010\u0005\u0002\u0005-\u0014AB3oG>$W\r\u0006\u0003\u0002n\u0005e\u0004\u0003BA8\u0003kr1!DA9\u0013\r\t\u0019HD\u0001\u0007!J,G-\u001a4\n\u0007Y\f9HC\u0002\u0002t9Aq!a\u001f\u0002h\u0001\u0007A'\u0001\u0003d_:4\u0007\u0002CA@\u0003\u007f!\t!!!\u0002\r\u0011,7m\u001c3f)\u0011\t\u0019)!#\u0011\t5\t)\tN\u0005\u0004\u0003\u000fs!AB(qi&|g\u000e\u0003\u0005\u0002\f\u0006u\u0004\u0019AA7\u0003!\u00118m\u0015;sS:<\u0007BCA/\u0003\u007f\t\t\u0011\"!\u0002\u0010R9A'!%\u0002\u0014\u0006U\u0005BB\r\u0002\u000e\u0002\u00071\u0004\u0003\u0004'\u0003\u001b\u0003\ra\u0007\u0005\u0007U\u00055\u0005\u0019\u0001\u0017\t\u0015\u0005e\u0015qHA\u0001\n\u0003\u000bY*A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005u\u0015Q\u0015\t\u0006\u001b\u0005\u0015\u0015q\u0014\t\u0007\u001b\u0005\u00056d\u0007\u0017\n\u0007\u0005\rfB\u0001\u0004UkBdWm\r\u0005\n\u0003O\u000b9*!AA\u0002Q\n1\u0001\u001f\u00131\u0011)\tY+a\u0010\u0002\u0002\u0013%\u0011QV\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u00020B\u0019\u0001/!-\n\u0007\u0005M\u0016O\u0001\u0004PE*,7\r\u001e")
public class ReplayConfig
implements Product,
Serializable {
    private final Instant start;
    private final Instant end;
    private final Duration readBehind;
    private final Instant realStartTime;

    public static Logger logger() {
        return ReplayConfig$.MODULE$.logger();
    }

    public static Option<Tuple3<Instant, Instant, Duration>> unapply(ReplayConfig replayConfig) {
        return ReplayConfig$.MODULE$.unapply(replayConfig);
    }

    public static ReplayConfig apply(Instant instant, Instant instant2, Duration duration) {
        return ReplayConfig$.MODULE$.apply(instant, instant2, duration);
    }

    public static Option<ReplayConfig> decode(String string) {
        return ReplayConfig$.MODULE$.decode(string);
    }

    public static String encode(ReplayConfig replayConfig) {
        return ReplayConfig$.MODULE$.encode(replayConfig);
    }

    public static ReplayConfig apply(long l, long l2, long l3) {
        return ReplayConfig$.MODULE$.apply(l, l2, l3);
    }

    public Instant start() {
        return this.start;
    }

    public Instant end() {
        return this.end;
    }

    public Duration readBehind() {
        return this.readBehind;
    }

    public Instant realStartTime() {
        return this.realStartTime;
    }

    public boolean isBeforeRealStart(GeoMessage msg) {
        return msg.timestamp().isBefore((ReadableInstant)this.realStartTime());
    }

    public boolean isNotAfterEnd(GeoMessage msg) {
        return !msg.timestamp().isAfter((ReadableInstant)this.end());
    }

    public boolean isInWindow(long time) {
        return !this.start().isAfter(time) && !this.end().isBefore(time);
    }

    public ReplayConfig copy(Instant start, Instant end, Duration readBehind) {
        return new ReplayConfig(start, end, readBehind);
    }

    public Instant copy$default$1() {
        return this.start();
    }

    public Instant copy$default$2() {
        return this.end();
    }

    public Duration copy$default$3() {
        return this.readBehind();
    }

    public String productPrefix() {
        return "ReplayConfig";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Duration duration;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 2: {
                duration = this.readBehind();
                break;
            }
            case 1: {
                duration = this.end();
                break;
            }
            case 0: {
                duration = this.start();
            }
        }
        return duration;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ReplayConfig;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ReplayConfig)) return false;
        boolean bl = true;
        if (!bl) return false;
        ReplayConfig replayConfig = (ReplayConfig)x$1;
        Instant instant = this.start();
        Instant instant2 = replayConfig.start();
        if (instant == null) {
            if (instant2 != null) {
                return false;
            }
        } else if (!instant.equals(instant2)) return false;
        Instant instant3 = this.end();
        Instant instant4 = replayConfig.end();
        if (instant3 == null) {
            if (instant4 != null) {
                return false;
            }
        } else if (!instant3.equals(instant4)) return false;
        Duration duration = this.readBehind();
        Duration duration2 = replayConfig.readBehind();
        if (duration == null) {
            if (duration2 != null) {
                return false;
            }
        } else if (!duration.equals(duration2)) return false;
        if (!replayConfig.canEqual(this)) return false;
        return true;
    }

    public ReplayConfig(Instant start, Instant end, Duration readBehind) {
        this.start = start;
        this.end = end;
        this.readBehind = readBehind;
        Product.class.$init$((Product)this);
        Predef$.MODULE$.require(start.getMillis() <= end.getMillis(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "The start time must not be after the end time.";
            }
        });
        this.realStartTime = start.minus((ReadableDuration)readBehind);
    }
}

