/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.cqengine.persistence.offheap;

import com.googlecode.cqengine.attribute.SimpleAttribute;
import com.googlecode.cqengine.index.Index;
import com.googlecode.cqengine.index.sqlite.ConnectionManager;
import com.googlecode.cqengine.index.sqlite.RequestScopeConnectionManager;
import com.googlecode.cqengine.index.sqlite.SQLitePersistence;
import com.googlecode.cqengine.index.sqlite.support.DBQueries;
import com.googlecode.cqengine.index.sqlite.support.DBUtils;
import com.googlecode.cqengine.index.support.indextype.OffHeapTypeIndex;
import com.googlecode.cqengine.persistence.support.PersistenceFlags;
import com.googlecode.cqengine.persistence.support.sqlite.SQLiteObjectStore;
import com.googlecode.cqengine.persistence.support.sqlite.SQLiteOffHeapIdentityIndex;
import com.googlecode.cqengine.query.QueryFactory;
import com.googlecode.cqengine.query.option.FlagsEnabled;
import com.googlecode.cqengine.query.option.QueryOptions;
import java.io.Closeable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.sqlite.SQLiteConfig;
import org.sqlite.SQLiteDataSource;

public class OffHeapPersistence<O, A extends Comparable<A>>
implements SQLitePersistence<O, A>,
Closeable {
    static final AtomicInteger INSTANCE_ID_GENERATOR = new AtomicInteger();
    final SimpleAttribute<O, A> primaryKeyAttribute;
    final String instanceName;
    final SQLiteDataSource sqLiteDataSource;
    static final Properties DEFAULT_PROPERTIES = new Properties();
    volatile Connection persistentConnection;
    volatile boolean closed = false;
    final ReadWriteLock readWriteLock = new ReentrantReadWriteLock(true);

    protected OffHeapPersistence(SimpleAttribute<O, A> primaryKeyAttribute, Properties overrideProperties) {
        Properties effectiveProperties = new Properties(DEFAULT_PROPERTIES);
        effectiveProperties.putAll((Map<?, ?>)overrideProperties);
        SQLiteConfig sqLiteConfig = new SQLiteConfig(effectiveProperties);
        SQLiteDataSource sqLiteDataSource = new SQLiteDataSource(sqLiteConfig);
        String instanceName = "cqengine_" + INSTANCE_ID_GENERATOR.incrementAndGet();
        sqLiteDataSource.setUrl("jdbc:sqlite:file:" + instanceName + "?mode=memory&cache=shared");
        this.primaryKeyAttribute = primaryKeyAttribute;
        this.instanceName = instanceName;
        this.sqLiteDataSource = sqLiteDataSource;
        this.persistentConnection = this.getConnectionInternal(null, QueryFactory.noQueryOptions());
    }

    @Override
    public SimpleAttribute<O, A> getPrimaryKeyAttribute() {
        return this.primaryKeyAttribute;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    @Override
    public Connection getConnection(Index<?> index, QueryOptions queryOptions) {
        Connection connection;
        Lock connectionLock = FlagsEnabled.isFlagEnabled(queryOptions, PersistenceFlags.READ_REQUEST) ? this.readWriteLock.readLock() : this.readWriteLock.writeLock();
        connectionLock.lock();
        try {
            connection = this.getConnectionInternal(index, queryOptions);
        }
        catch (RuntimeException e) {
            connectionLock.unlock();
            throw e;
        }
        return LockReleasingConnection.wrap(connection, connectionLock);
    }

    protected Connection getConnectionInternal(Index<?> index, QueryOptions queryOptions) {
        if (this.closed) {
            throw new IllegalStateException("OffHeapPersistence has been closed: " + this.toString());
        }
        try {
            return this.sqLiteDataSource.getConnection();
        }
        catch (SQLException e) {
            throw new IllegalStateException("Failed to open SQLite connection for memory instance: " + this.instanceName, e);
        }
    }

    @Override
    public boolean supportsIndex(Index<O> index) {
        return index instanceof OffHeapTypeIndex;
    }

    @Override
    public void close() {
        DBUtils.closeQuietly(this.persistentConnection);
        this.persistentConnection = null;
        this.closed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getBytesUsed() {
        long l;
        Connection connection = null;
        try {
            connection = this.getConnectionInternal(null, QueryFactory.noQueryOptions());
            l = DBQueries.getDatabaseSize(connection);
        }
        catch (Throwable throwable) {
            DBUtils.closeQuietly(connection);
            throw throwable;
        }
        DBUtils.closeQuietly(connection);
        return l;
    }

    @Override
    public void compact() {
        Connection connection = null;
        try {
            connection = this.getConnectionInternal(null, QueryFactory.noQueryOptions());
            DBQueries.compactDatabase(connection);
        }
        catch (Throwable throwable) {
            DBUtils.closeQuietly(connection);
            throw throwable;
        }
        DBUtils.closeQuietly(connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void expand(long numBytes) {
        Connection connection = null;
        try {
            connection = this.getConnectionInternal(null, QueryFactory.noQueryOptions());
            DBQueries.expandDatabase(connection, numBytes);
        }
        catch (Throwable throwable) {
            DBUtils.closeQuietly(connection);
            throw throwable;
        }
        DBUtils.closeQuietly(connection);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OffHeapPersistence)) {
            return false;
        }
        OffHeapPersistence that = (OffHeapPersistence)o;
        return this.primaryKeyAttribute.equals(that.primaryKeyAttribute) && this.instanceName.equals(that.instanceName);
    }

    public int hashCode() {
        int result = this.primaryKeyAttribute.hashCode();
        result = 31 * result + this.instanceName.hashCode();
        return result;
    }

    public String toString() {
        return "OffHeapPersistence{primaryKeyAttribute=" + this.primaryKeyAttribute + ", instanceName='" + this.instanceName + '\'' + '}';
    }

    public SQLiteObjectStore<O, A> createObjectStore() {
        return new SQLiteObjectStore(this);
    }

    @Override
    public SQLiteOffHeapIdentityIndex<A, O> createIdentityIndex() {
        return SQLiteOffHeapIdentityIndex.onAttribute(this.primaryKeyAttribute);
    }

    @Override
    public void openRequestScopeResources(QueryOptions queryOptions) {
        if (queryOptions.get(ConnectionManager.class) == null) {
            queryOptions.put(ConnectionManager.class, new RequestScopeConnectionManager(this));
        }
    }

    @Override
    public void closeRequestScopeResources(QueryOptions queryOptions) {
        ConnectionManager connectionManager = queryOptions.get(ConnectionManager.class);
        if (connectionManager instanceof RequestScopeConnectionManager) {
            ((RequestScopeConnectionManager)connectionManager).close();
            queryOptions.remove(ConnectionManager.class);
        }
    }

    public static <O, A extends Comparable<A>> OffHeapPersistence<O, A> onPrimaryKey(SimpleAttribute<O, A> primaryKeyAttribute) {
        return OffHeapPersistence.onPrimaryKeyWithProperties(primaryKeyAttribute, new Properties());
    }

    public static <O, A extends Comparable<A>> OffHeapPersistence<O, A> onPrimaryKeyWithProperties(SimpleAttribute<O, A> primaryKeyAttribute, Properties overrideProperties) {
        return new OffHeapPersistence<O, A>(primaryKeyAttribute, overrideProperties);
    }

    static class LockReleasingConnection
    implements InvocationHandler {
        final Connection targetConnection;
        final Lock lockToUnlock;
        boolean unlockedAlready = false;

        LockReleasingConnection(Connection targetConnection, Lock lockToUnlock) {
            this.targetConnection = targetConnection;
            this.lockToUnlock = lockToUnlock;
        }

        @Override
        public Object invoke(Object proxy, Method m, Object[] args) throws Throwable {
            Object result = m.invoke((Object)this.targetConnection, args);
            if (m.getName().equals("close") && !this.unlockedAlready) {
                this.lockToUnlock.unlock();
                this.unlockedAlready = true;
            }
            return result;
        }

        static Connection wrap(Connection targetConnection, Lock lockToUnlock) {
            return (Connection)Proxy.newProxyInstance(targetConnection.getClass().getClassLoader(), new Class[]{Connection.class}, (InvocationHandler)new LockReleasingConnection(targetConnection, lockToUnlock));
        }
    }
}

