/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.cqengine.query.logical;

import com.googlecode.cqengine.query.Query;
import com.googlecode.cqengine.query.logical.LogicalQuery;
import com.googlecode.cqengine.query.option.QueryOptions;
import java.util.Collection;
import java.util.Iterator;

public class Or<O>
extends LogicalQuery<O> {
    private final Collection<Query<O>> childQueries;
    private final boolean disjoint;

    public Or(Collection<Query<O>> childQueries) {
        this(childQueries, false);
    }

    public Or(Collection<Query<O>> childQueries, boolean disjoint) {
        super(childQueries);
        if (this.size() < 2) {
            throw new IllegalStateException("An 'Or' query cannot have fewer than 2 child queries, " + childQueries.size() + " were supplied");
        }
        this.disjoint = disjoint;
        this.childQueries = childQueries;
    }

    @Override
    public boolean matches(O object, QueryOptions queryOptions) {
        for (Query query : super.getSimpleQueries()) {
            if (!query.matches(object, queryOptions)) continue;
            return true;
        }
        for (Query<O> query : super.getLogicalQueries()) {
            if (!query.matches(object, queryOptions)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Or)) {
            return false;
        }
        Or or = (Or)o;
        if (this.disjoint != or.disjoint) {
            return false;
        }
        return this.childQueries.equals(or.childQueries);
    }

    public boolean isDisjoint() {
        return this.disjoint;
    }

    @Override
    protected int calcHashCode() {
        int result = this.childQueries.hashCode();
        result = 31 * result + (this.disjoint ? 1 : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("or(");
        Iterator<Query<O>> iterator = this.childQueries.iterator();
        while (iterator.hasNext()) {
            Query<O> childQuery = iterator.next();
            sb.append(childQuery);
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append(")");
        return sb.toString();
    }
}

