/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.kafka10.consumer;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.net.InetAddress;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import kafka.api.PartitionMetadata;
import kafka.cluster.BrokerEndPoint;
import kafka.common.OffsetAndMetadata;
import kafka.common.OffsetAndMetadata$;
import kafka.common.TopicAndPartition;
import kafka.consumer.ConsumerConfig;
import kafka.consumer.ConsumerConfig$;
import kafka.consumer.FetchedDataChunk;
import kafka.consumer.PartitionTopicInfo;
import kafka.consumer.SimpleConsumer;
import kafka.message.ByteBufferMessageSet;
import kafka.message.MessageAndOffset;
import kafka.serializer.Decoder;
import kafka.utils.ZKGroupDirs;
import org.I0Itec.zkclient.ZkClient;
import org.I0Itec.zkclient.exception.ZkNodeExistsException;
import org.locationtech.geomesa.kafka10.consumer.Broker;
import org.locationtech.geomesa.kafka10.consumer.ConsumerRebalancer;
import org.locationtech.geomesa.kafka10.consumer.Fetcher;
import org.locationtech.geomesa.kafka10.consumer.Fetcher$class;
import org.locationtech.geomesa.kafka10.consumer.KafkaConsumer$;
import org.locationtech.geomesa.kafka10.consumer.KafkaConsumer$$anonfun$initializeFetchers$2$;
import org.locationtech.geomesa.kafka10.consumer.KafkaStreamLike;
import org.locationtech.geomesa.kafka10.consumer.WrappedConsumer;
import org.locationtech.geomesa.kafka10.consumer.offsets.GroupOffset$;
import org.locationtech.geomesa.kafka10.consumer.offsets.OffsetManager;
import org.locationtech.geomesa.kafka10.consumer.offsets.RequestedOffset;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0011=c\u0001B\u0001\u0003\u00016\u0011QbS1gW\u0006\u001cuN\\:v[\u0016\u0014(BA\u0002\u0005\u0003!\u0019wN\\:v[\u0016\u0014(BA\u0003\u0007\u0003\u001dY\u0017MZ6bcAR!a\u0002\u0005\u0002\u000f\u001d,w.\\3tC*\u0011\u0011BC\u0001\rY>\u001c\u0017\r^5p]R,7\r\u001b\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001U\u0019a\u0002\u0013-\u0014\u000b\u0001yQc\b\u0012\u0011\u0005A\u0019R\"A\t\u000b\u0003I\tQa]2bY\u0006L!\u0001F\t\u0003\r\u0005s\u0017PU3g!\t1R$D\u0001\u0018\u0015\tA\u0012$\u0001\u0007tG\u0006d\u0017\r\\8hO&twM\u0003\u0002\u001b7\u0005AA/\u001f9fg\u00064WMC\u0001\u001d\u0003\r\u0019w.\\\u0005\u0003=]\u00111\u0002T1{s2{wmZ5oOB\u0011\u0001\u0003I\u0005\u0003CE\u0011q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002\u0011G%\u0011A%\u0005\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\tM\u0001\u0011)\u001a!C\u0001O\u0005)Ao\u001c9jGV\t\u0001\u0006\u0005\u0002*Y9\u0011\u0001CK\u0005\u0003WE\ta\u0001\u0015:fI\u00164\u0017BA\u0017/\u0005\u0019\u0019FO]5oO*\u00111&\u0005\u0005\ta\u0001\u0011\t\u0012)A\u0005Q\u00051Ao\u001c9jG\u0002B\u0001B\r\u0001\u0003\u0016\u0004%\taM\u0001\u0007G>tg-[4\u0016\u0003Q\u0002\"!N\u001d\u000e\u0003YR!aA\u001c\u000b\u0003a\nQa[1gW\u0006L!A\u000f\u001c\u0003\u001d\r{gn];nKJ\u001cuN\u001c4jO\"AA\b\u0001B\tB\u0003%A'A\u0004d_:4\u0017n\u001a\u0011\t\u0011y\u0002!Q3A\u0005\u0002}\n!b[3z\t\u0016\u001cw\u000eZ3s+\u0005\u0001\u0005cA!E\r6\t!I\u0003\u0002Do\u0005Q1/\u001a:jC2L'0\u001a:\n\u0005\u0015\u0013%a\u0002#fG>$WM\u001d\t\u0003\u000f\"c\u0001\u0001B\u0003J\u0001\t\u0007!JA\u0001L#\tYe\n\u0005\u0002\u0011\u0019&\u0011Q*\u0005\u0002\b\u001d>$\b.\u001b8h!\t\u0001r*\u0003\u0002Q#\t\u0019\u0011I\\=\t\u0011I\u0003!\u0011#Q\u0001\n\u0001\u000b1b[3z\t\u0016\u001cw\u000eZ3sA!AA\u000b\u0001BK\u0002\u0013\u0005Q+\u0001\u0007wC2,X\rR3d_\u0012,'/F\u0001W!\r\tEi\u0016\t\u0003\u000fb#Q!\u0017\u0001C\u0002)\u0013\u0011A\u0016\u0005\t7\u0002\u0011\t\u0012)A\u0005-\u0006ia/\u00197vK\u0012+7m\u001c3fe\u0002BQ!\u0018\u0001\u0005\u0002y\u000ba\u0001P5oSRtD#B0bE\u000e$\u0007\u0003\u00021\u0001\r^k\u0011A\u0001\u0005\u0006Mq\u0003\r\u0001\u000b\u0005\u0006eq\u0003\r\u0001\u000e\u0005\u0006}q\u0003\r\u0001\u0011\u0005\u0006)r\u0003\rA\u0016\u0005\bM\u0002\u0011\r\u0011\"\u0003h\u00031!x\u000e]5d\u0013:4w.T1q+\u0005A\u0007\u0003B5oaZl\u0011A\u001b\u0006\u0003W2\fq!\\;uC\ndWM\u0003\u0002n#\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005=T'aA'baB\u0011\u0011\u000f^\u0007\u0002e*\u00111oN\u0001\u0007G>lWn\u001c8\n\u0005U\u0014(!\u0005+pa&\u001c\u0017I\u001c3QCJ$\u0018\u000e^5p]B!qO`A\u0001\u001b\u0005A(BA={\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003wr\fA!\u001e;jY*\tQ0\u0001\u0003kCZ\f\u0017BA@y\u0005U\u0019uN\\2veJ,g\u000e\u001e'j].,G-U;fk\u0016\u00042!NA\u0002\u0013\r\t)A\u000e\u0002\u0013!\u0006\u0014H/\u001b;j_:$v\u000e]5d\u0013:4w\u000eC\u0004\u0002\n\u0001\u0001\u000b\u0011\u00025\u0002\u001bQ|\u0007/[2J]\u001a|W*\u00199!\u0011%\ti\u0001\u0001b\u0001\n\u0013\ty!\u0001\u0007d_:\u001cX/\\3DQ\u0016\u001c7.\u0006\u0002\u0002\u0012A1q/a\u0005q\u0003/I1!!\u0006y\u0005E\u0019uN\\2veJ,g\u000e\u001e%bg\"l\u0015\r\u001d\t\u0004!\u0005e\u0011bAA\u000e#\t!Aj\u001c8h\u0011!\ty\u0002\u0001Q\u0001\n\u0005E\u0011!D2p]N,X.Z\"iK\u000e\\\u0007\u0005C\u0005\u0002$\u0001\u0011\r\u0011\"\u0003\u0002&\u0005I1m\u001c8tk6,'o]\u000b\u0003\u0003O\u0001R![A\u0015\u0003[I1!a\u000bk\u0005\u001dA\u0015m\u001d5TKR\u00042\u0001YA\u0018\u0013\r\t\tD\u0001\u0002\u0010/J\f\u0007\u000f]3e\u0007>t7/^7fe\"A\u0011Q\u0007\u0001!\u0002\u0013\t9#\u0001\u0006d_:\u001cX/\\3sg\u0002B\u0011\"!\u000f\u0001\u0005\u0004%I!a\u000f\u0002\u0011\u0019,Go\u00195feN,\"!!\u0010\u0011\u000b%\fI#a\u0010\u0011\t\u0005\u0005\u00131I\u0007\u0002\u0001\u00191\u0011Q\t\u0001\u0001\u0003\u000f\u0012QBR3uG\"\u0014VO\u001c8bE2,7\u0003CA\"\u001f\u0005%\u0013qJ\u000b\u0011\u0007\u0001\fY%C\u0002\u0002N\t\u0011qAR3uG\",'\u000f\u0005\u0003\u0002R\u0005]SBAA*\u0015\r\t)\u0006`\u0001\u0005Y\u0006tw-\u0003\u0003\u0002Z\u0005M#\u0001\u0003*v]:\f'\r\\3\t\u0015\r\t\u0019E!A!\u0002\u0013\ti\u0003\u0003\u0006\u0002`\u0005\r#\u0011!Q\u0001\nA\f1\u0001^1q\u0011-\t\u0019'a\u0011\u0003\u0002\u0004%\t!!\u001a\u0002\r=4gm]3u+\t\t9\u0002C\u0006\u0002j\u0005\r#\u00111A\u0005\u0002\u0005-\u0014AC8gMN,Go\u0018\u0013fcR!\u0011QNA:!\r\u0001\u0012qN\u0005\u0004\u0003c\n\"\u0001B+oSRD!\"!\u001e\u0002h\u0005\u0005\t\u0019AA\f\u0003\rAH%\r\u0005\f\u0003s\n\u0019E!A!B\u0013\t9\"A\u0004pM\u001a\u001cX\r\u001e\u0011\t\u0017\u0005u\u00141\tBC\u0002\u0013\u0005\u0011qP\u0001\u0006cV,W/Z\u000b\u0003\u0003\u0003\u0003Ra^AB\u0003\u000fK1!!\"y\u00055\u0011En\\2lS:<\u0017+^3vKB\u0019Q'!#\n\u0007\u0005-eG\u0001\tGKR\u001c\u0007.\u001a3ECR\f7\t[;oW\"Y\u0011qRA\"\u0005\u0003\u0005\u000b\u0011BAA\u0003\u0019\tX/Z;fA!9Q,a\u0011\u0005\u0002\u0005MECCA \u0003+\u000b9*!'\u0002\u001c\"91!!%A\u0002\u00055\u0002bBA0\u0003#\u0003\r\u0001\u001d\u0005\t\u0003G\n\t\n1\u0001\u0002\u0018!A\u0011QPAI\u0001\u0004\t\t\t\u0003\u0005'\u0003\u0007\u0012\r\u0011\"\u0003(\u0011\u001d\u0001\u00141\tQ\u0001\n!B!\"a)\u0002D\t\u0007I\u0011BAS\u0003%\u0001\u0018M\u001d;ji&|g.\u0006\u0002\u0002(B\u0019\u0001#!+\n\u0007\u0005-\u0016CA\u0002J]RD\u0011\"a,\u0002D\u0001\u0006I!a*\u0002\u0015A\f'\u000f^5uS>t\u0007\u0005\u0003\u0006\u00024\u0006\r#\u0019!C\u0005\u0003k\u000bqa\u001d;paB,G-\u0006\u0002\u00028B!\u0011\u0011XA`\u001b\t\tYLC\u0002\u0002>b\fa!\u0019;p[&\u001c\u0017\u0002BAa\u0003w\u0013Q\"\u0011;p[&\u001c'i\\8mK\u0006t\u0007\"CAc\u0003\u0007\u0002\u000b\u0011BA\\\u0003!\u0019Ho\u001c9qK\u0012\u0004\u0003\u0002CAe\u0003\u0007\"I!a3\u0002\u0017M\u001c\u0007.\u001a3vY\u0016\u0014VO\u001c\u000b\u0003\u0003[B\u0001\"a4\u0002D\u0011\u0005\u00111Z\u0001\u0005gR|\u0007\u000f\u0003\u0005\u0002T\u0006\rC\u0011IAf\u0003\r\u0011XO\u001c\u0005\t\u0003/\u0004\u0001\u0015!\u0003\u0002>\u0005Ia-\u001a;dQ\u0016\u00148\u000f\t\u0005\n\u00037\u0004!\u0019!C\u0005\u0003;\fqa\u001d;sK\u0006l7/\u0006\u0002\u0002`B)\u0011.!9\u0002f&\u0019\u00111\u001d6\u0003\u0017\u0005\u0013(/Y=Ck\u001a4WM\u001d\t\u0006A\u0006\u001dhiV\u0005\u0004\u0003S\u0014!aD&bM.\f7\u000b\u001e:fC6d\u0015n[3\t\u0011\u00055\b\u0001)A\u0005\u0003?\f\u0001b\u001d;sK\u0006l7\u000f\t\u0005\n\u0003c\u0004!\u0019!C\u0005\u0003k\u000b\u0011\"[:De\u0016\fG/\u001a3\t\u0011\u0005U\b\u0001)A\u0005\u0003o\u000b!\"[:De\u0016\fG/\u001a3!\u0011%\tI\u0010\u0001b\u0001\n\u0013\t),\u0001\u0006jgNCW\u000f\u001e3po:D\u0001\"!@\u0001A\u0003%\u0011qW\u0001\fSN\u001c\u0006.\u001e;e_^t\u0007\u0005C\u0005\u0003\u0002\u0001\u0011\r\u0011\"\u0005\u0003O\u0005Q1m\u001c8tk6,'/\u00133\t\u000f\t\u0015\u0001\u0001)A\u0005Q\u0005Y1m\u001c8tk6,'/\u00133!\u0011%\u0011I\u0001\u0001b\u0001\n\u0013\t)+\u0001\u0007gKR\u001c\u0007NQ1dW>4g\r\u0003\u0005\u0003\u000e\u0001\u0001\u000b\u0011BAT\u000351W\r^2i\u0005\u0006\u001c7n\u001c4gA!I!\u0011\u0003\u0001C\u0002\u0013%!1C\u0001\tKb,7-\u001e;peV\u0011!Q\u0003\t\u0004o\n]\u0011b\u0001B\rq\nA2k\u00195fIVdW\rZ#yK\u000e,Ho\u001c:TKJ4\u0018nY3\t\u0011\tu\u0001\u0001)A\u0005\u0005+\t\u0011\"\u001a=fGV$xN\u001d\u0011\t\u0013\t\u0005\u0002A1A\u0005\n\t\r\u0012!D8gMN,G/T1oC\u001e,'/\u0006\u0002\u0003&A!!q\u0005B\u0017\u001b\t\u0011ICC\u0002\u0003,\t\tqa\u001c4gg\u0016$8/\u0003\u0003\u00030\t%\"!D(gMN,G/T1oC\u001e,'\u000f\u0003\u0005\u00034\u0001\u0001\u000b\u0011\u0002B\u0013\u00039ygMZ:fi6\u000bg.Y4fe\u0002B\u0011Ba\u000e\u0001\u0005\u0004%IA!\u000f\u0002\u0015I,'-\u00197b]\u000e,'/\u0006\u0002\u0003<A)\u0001M!\u0010G/&\u0019!q\b\u0002\u0003%\r{gn];nKJ\u0014VMY1mC:\u001cWM\u001d\u0005\t\u0005\u0007\u0002\u0001\u0015!\u0003\u0003<\u0005Y!/\u001a2bY\u0006t7-\u001a:!\u0011\u001d\u00119\u0005\u0001C\u0001\u0005\u0013\nAc\u0019:fCR,W*Z:tC\u001e,7\u000b\u001e:fC6\u001cHC\u0002B&\u0005G\u00129\u0007\u0005\u0004\u0003N\tu\u0013Q\u001d\b\u0005\u0005\u001f\u0012IF\u0004\u0003\u0003R\t]SB\u0001B*\u0015\r\u0011)\u0006D\u0001\u0007yI|w\u000e\u001e \n\u0003II1Aa\u0017\u0012\u0003\u001d\u0001\u0018mY6bO\u0016LAAa\u0018\u0003b\t!A*[:u\u0015\r\u0011Y&\u0005\u0005\t\u0005K\u0012)\u00051\u0001\u0002(\u0006Qa.^7TiJ,\u0017-\\:\t\u0011\u0005\r$Q\ta\u0001\u0005S\u0002BAa\n\u0003l%!!Q\u000eB\u0015\u0005=\u0011V-];fgR,Gm\u00144gg\u0016$\b\u0002\u0003B9\u0001\u0011E!Aa\u001d\u0002#%t\u0017\u000e^5bY&TXm\u00144gg\u0016$8\u000f\u0006\u0005\u0002n\tU$\u0011\u0012BM\u0011!\u00119Ha\u001cA\u0002\te\u0014\u0001\u0003>l\u00072LWM\u001c;\u0011\t\tm$QQ\u0007\u0003\u0005{RAAa \u0003\u0002\u0006A!p[2mS\u0016tGOC\u0002\u0003\u0004*\ta!\u0013\u0019Ji\u0016\u001c\u0017\u0002\u0002BD\u0005{\u0012\u0001BW6DY&,g\u000e\u001e\u0005\t\u0005\u0017\u0013y\u00071\u0001\u0003\u000e\u0006!A-\u001b:t!\u0011\u0011yI!&\u000e\u0005\tE%b\u0001BJo\u0005)Q\u000f^5mg&!!q\u0013BI\u0005-Q6j\u0012:pkB$\u0015N]:\t\u0011\u0005\r$q\u000ea\u0001\u0005SB\u0001B!(\u0001\t#\u0011\u00111Z\u0001\u000eG2|7/\u001a$fi\u000eDWM]:\t\u0011\t\u0005\u0006\u0001\"\u0005\u0003\u0005G\u000b!#\u001b8ji&\fG.\u001b>f\r\u0016$8\r[3sgR!\u0011Q\u000eBS\u0011!\u00119Ka(A\u0002\t%\u0016A\u00039beRLG/[8ogB)\u0011Fa+\u0002(&\u0019!Q\u0016\u0018\u0003\u0007M+G\u000fC\u0004\u00032\u0002!\t!a3\u0002\u001b\r|W.\\5u\u001f\u001a47/\u001a;t\u0011\u001d\u0011)\f\u0001C\u0005\u0003\u0017\f\u0011#Y;u_\u000e{W.\\5u\u001f\u001a47/\u001a;t\u0011\u001d\u0011I\f\u0001C\u0005\u0005w\u000bq\u0002Z8D_6l\u0017\u000e^(gMN,Go\u001d\u000b\u0005\u0003[\u0012i\f\u0003\u0005\u0003@\n]\u0006\u0019\u0001Ba\u00031I7/Q;u_\u000e{W.\\5u!\r\u0001\"1Y\u0005\u0004\u0005\u000b\f\"a\u0002\"p_2,\u0017M\u001c\u0005\b\u0005\u0013\u0004A\u0011AAf\u0003!\u0019\b.\u001e;e_^t\u0007\"\u0003Bg\u0001\u0005\u0005I\u0011\u0001Bh\u0003\u0011\u0019w\u000e]=\u0016\r\tE'q\u001bBn))\u0011\u0019N!8\u0003`\n\u0005(Q\u001d\t\u0007A\u0002\u0011)N!7\u0011\u0007\u001d\u00139\u000e\u0002\u0004J\u0005\u0017\u0014\rA\u0013\t\u0004\u000f\nmGAB-\u0003L\n\u0007!\n\u0003\u0005'\u0005\u0017\u0004\n\u00111\u0001)\u0011!\u0011$1\u001aI\u0001\u0002\u0004!\u0004\"\u0003 \u0003LB\u0005\t\u0019\u0001Br!\u0011\tEI!6\t\u0013Q\u0013Y\r%AA\u0002\t\u001d\b\u0003B!E\u00053D\u0011Ba;\u0001#\u0003%\tA!<\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU1!q^B\u0003\u0007\u000f)\"A!=+\u0007!\u0012\u0019p\u000b\u0002\u0003vB!!q_B\u0001\u001b\t\u0011IP\u0003\u0003\u0003|\nu\u0018!C;oG\",7m[3e\u0015\r\u0011y0E\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BB\u0002\u0005s\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\t\u0019I%\u0011\u001eb\u0001\u0015\u00121\u0011L!;C\u0002)C\u0011ba\u0003\u0001#\u0003%\ta!\u0004\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU11qBB\n\u0007+)\"a!\u0005+\u0007Q\u0012\u0019\u0010\u0002\u0004J\u0007\u0013\u0011\rA\u0013\u0003\u00073\u000e%!\u0019\u0001&\t\u0013\re\u0001!%A\u0005\u0002\rm\u0011AD2paf$C-\u001a4bk2$HeM\u000b\u0007\u0007;\u0019\tca\t\u0016\u0005\r}!f\u0001!\u0003t\u00121\u0011ja\u0006C\u0002)#a!WB\f\u0005\u0004Q\u0005\"CB\u0014\u0001E\u0005I\u0011AB\u0015\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIQ*baa\u000b\u00040\rERCAB\u0017U\r1&1\u001f\u0003\u0007\u0013\u000e\u0015\"\u0019\u0001&\u0005\re\u001b)C1\u0001K\u0011%\u0019)\u0004AA\u0001\n\u0003\u001a9$A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0007s\u0001B!!\u0015\u0004<%\u0019Q&a\u0015\t\u0013\r}\u0002!!A\u0005\u0002\u0005\u0015\u0016\u0001\u00049s_\u0012,8\r^!sSRL\b\"CB\"\u0001\u0005\u0005I\u0011AB#\u00039\u0001(o\u001c3vGR,E.Z7f]R$2ATB$\u0011)\t)h!\u0011\u0002\u0002\u0003\u0007\u0011q\u0015\u0005\n\u0007\u0017\u0002\u0011\u0011!C!\u0007\u001b\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0007\u001f\u0002Ra!\u0015\u0004T9k\u0011\u0001\\\u0005\u0004\u0007+b'\u0001C%uKJ\fGo\u001c:\t\u0013\re\u0003!!A\u0005\u0002\rm\u0013\u0001C2b]\u0016\u000bX/\u00197\u0015\t\t\u00057Q\f\u0005\n\u0003k\u001a9&!AA\u00029C\u0011b!\u0019\u0001\u0003\u0003%\tea\u0019\u0002\u0011!\f7\u000f[\"pI\u0016$\"!a*\t\u0013\r\u001d\u0004!!A\u0005B\r%\u0014\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\re\u0002\"CB7\u0001\u0005\u0005I\u0011IB8\u0003\u0019)\u0017/^1mgR!!\u0011YB9\u0011%\t)ha\u001b\u0002\u0002\u0003\u0007ajB\u0004\u0004v\tA\taa\u001e\u0002\u001b-\u000bgm[1D_:\u001cX/\\3s!\r\u00017\u0011\u0010\u0004\u0007\u0003\tA\taa\u001f\u0014\u000b\ret\"\u0006\u0012\t\u000fu\u001bI\b\"\u0001\u0004\u0000Q\u00111q\u000f\u0005\t\u0007\u0007\u001bI\b\"\u0001\u0004\u0006\u0006q1M]3bi\u0016\u001cuN\\:v[\u0016\u0014HCCBD\u0007\u001b\u001b\tj!&\u0004\u0018B\u0019Qg!#\n\u0007\r-eG\u0001\bTS6\u0004H.Z\"p]N,X.\u001a:\t\u000f\r=5\u0011\u0011a\u0001Q\u0005!\u0001n\\:u\u0011!\u0019\u0019j!!A\u0002\u0005\u001d\u0016\u0001\u00029peRDaAMBA\u0001\u0004!\u0004bBBM\u0007\u0003\u0003\r\u0001K\u0001\tG2LWM\u001c;JI\"A1QTB=\t\u0003\u0019y*\u0001\tsK\u000e\u0013X-\u0019;f\u0007>t7/^7feRA1qQBQ\u0007G\u001b)\u000bC\u0004\u0004\u00077\u0003\raa\"\t\u000f\u0005}31\u0014a\u0001a\"1!ga'A\u0002QB\u0001b!+\u0004z\u0011\u000511V\u0001\u000fM&tG\rU1si&$\u0018n\u001c8t)\u0019\u0019ika0\u0004BB1!QJBX\u0007gKAa!-\u0003b\t\u00191+Z9\u0011\t\rU61X\u0007\u0003\u0007oS1a!/8\u0003\r\t\u0007/[\u0005\u0005\u0007{\u001b9LA\tQCJ$\u0018\u000e^5p]6+G/\u00193bi\u0006DaAJBT\u0001\u0004A\u0003B\u0002\u001a\u0004(\u0002\u0007A\u0007\u0003\u0005\u0004*\u000eeD\u0011BBc)!\u00199m!4\u0004X\u000ee\u0007#\u0002\t\u0004J\u000e5\u0016bABf#\t1q\n\u001d;j_:D\u0001ba4\u0004D\u0002\u00071\u0011[\u0001\u0007EJ|7.\u001a:\u0011\u0007\u0001\u001c\u0019.C\u0002\u0004V\n\u0011aA\u0011:pW\u0016\u0014\bB\u0002\u0014\u0004D\u0002\u0007\u0001\u0006\u0003\u00043\u0007\u0007\u0004\r\u0001\u000e\u0005\t\u0007;\u001cI\b\"\u0001\u0004`\u0006ia-\u001b8e\u001d\u0016<H*Z1eKJ$\u0002b!5\u0004b\u000e\r8\u0011\u001e\u0005\b\u0003?\u001aY\u000e1\u0001q\u0011!\u0019)oa7A\u0002\r\u001d\u0018!C8mI2+\u0017\rZ3s!\u0015\u00012\u0011ZBi\u0011\u0019\u001141\u001ca\u0001i!A1Q\\B=\t\u0013\u0019i\u000f\u0006\u0006\u0004R\u000e=8\u0011_Bz\u0007kDq!a\u0018\u0004l\u0002\u0007\u0001\u000f\u0003\u0005\u0004f\u000e-\b\u0019ABt\u0011\u0019\u001141\u001ea\u0001i!A1q_Bv\u0001\u0004\t9+A\u0003ue&,7\u000f\u000b\u0003\u0004l\u000em\b\u0003BB\u007f\u0007\u007fl!A!@\n\t\u0011\u0005!Q \u0002\bi\u0006LGN]3d\u0011)!)a!\u001f\u0002\u0002\u0013\u0005EqA\u0001\u0006CB\u0004H._\u000b\u0007\t\u0013!y\u0001b\u0005\u0015\u0015\u0011-AQ\u0003C\f\t3!i\u0002\u0005\u0004a\u0001\u00115A\u0011\u0003\t\u0004\u000f\u0012=AAB%\u0005\u0004\t\u0007!\nE\u0002H\t'!a!\u0017C\u0002\u0005\u0004Q\u0005B\u0002\u0014\u0005\u0004\u0001\u0007\u0001\u0006\u0003\u00043\t\u0007\u0001\r\u0001\u000e\u0005\b}\u0011\r\u0001\u0019\u0001C\u000e!\u0011\tE\t\"\u0004\t\u000fQ#\u0019\u00011\u0001\u0005 A!\u0011\t\u0012C\t\u0011)!\u0019c!\u001f\u0002\u0002\u0013\u0005EQE\u0001\bk:\f\u0007\u000f\u001d7z+\u0019!9\u0003\"\u000e\u0005<Q!A\u0011\u0006C\u001f!\u0015\u00012\u0011\u001aC\u0016!%\u0001BQ\u0006\u00155\tc!9$C\u0002\u00050E\u0011a\u0001V;qY\u0016$\u0004\u0003B!E\tg\u00012a\u0012C\u001b\t\u0019IE\u0011\u0005b\u0001\u0015B!\u0011\t\u0012C\u001d!\r9E1\b\u0003\u00073\u0012\u0005\"\u0019\u0001&\t\u0015\u0011}B\u0011EA\u0001\u0002\u0004!\t%A\u0002yIA\u0002b\u0001\u0019\u0001\u00054\u0011e\u0002B\u0003C#\u0007s\n\t\u0011\"\u0003\u0005H\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t!I\u0005\u0005\u0003\u0002R\u0011-\u0013\u0002\u0002C'\u0003'\u0012aa\u00142kK\u000e$\b")
public class KafkaConsumer<K, V>
implements LazyLogging,
Product,
Serializable {
    private final String topic;
    private final ConsumerConfig config;
    private final Decoder<K> keyDecoder;
    private final Decoder<V> valueDecoder;
    private final Map<TopicAndPartition, ConcurrentLinkedQueue<PartitionTopicInfo>> org$locationtech$geomesa$kafka10$consumer$KafkaConsumer$$topicInfoMap;
    private final ConcurrentHashMap<TopicAndPartition, Object> org$locationtech$geomesa$kafka10$consumer$KafkaConsumer$$consumeCheck;
    private final HashSet<WrappedConsumer> org$locationtech$geomesa$kafka10$consumer$KafkaConsumer$$consumers;
    private final HashSet<FetchRunnable> org$locationtech$geomesa$kafka10$consumer$KafkaConsumer$$fetchers;
    private final ArrayBuffer<KafkaStreamLike<K, V>> org$locationtech$geomesa$kafka10$consumer$KafkaConsumer$$streams;
    private final AtomicBoolean isCreated;
    private final AtomicBoolean isShutdown;
    private final String consumerId;
    private final int org$locationtech$geomesa$kafka10$consumer$KafkaConsumer$$fetchBackoff;
    private final ScheduledExecutorService org$locationtech$geomesa$kafka10$consumer$KafkaConsumer$$executor;
    private final OffsetManager offsetManager;
    private final ConsumerRebalancer<K, V> rebalancer;
    private final Logger logger;
    private volatile boolean bitmap$0;

    public static <K, V> Option<Tuple4<String, ConsumerConfig, Decoder<K>, Decoder<V>>> unapply(KafkaConsumer<K, V> kafkaConsumer) {
        return KafkaConsumer$.MODULE$.unapply(kafkaConsumer);
    }

    public static <K, V> KafkaConsumer<K, V> apply(String string, ConsumerConfig consumerConfig, Decoder<K> decoder, Decoder<V> decoder2) {
        return KafkaConsumer$.MODULE$.apply(string, consumerConfig, decoder, decoder2);
    }

    public static Broker findNewLeader(TopicAndPartition topicAndPartition, Option<Broker> option, ConsumerConfig consumerConfig) {
        return KafkaConsumer$.MODULE$.findNewLeader(topicAndPartition, option, consumerConfig);
    }

    public static Seq<PartitionMetadata> findPartitions(String string, ConsumerConfig consumerConfig) {
        return KafkaConsumer$.MODULE$.findPartitions(string, consumerConfig);
    }

    public static SimpleConsumer reCreateConsumer(SimpleConsumer simpleConsumer, TopicAndPartition topicAndPartition, ConsumerConfig consumerConfig) {
        return KafkaConsumer$.MODULE$.reCreateConsumer(simpleConsumer, topicAndPartition, consumerConfig);
    }

    public static SimpleConsumer createConsumer(String string, int n, ConsumerConfig consumerConfig, String string2) {
        return KafkaConsumer$.MODULE$.createConsumer(string, n, consumerConfig, string2);
    }

    private Logger logger$lzycompute() {
        KafkaConsumer kafkaConsumer = this;
        synchronized (kafkaConsumer) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public String topic() {
        return this.topic;
    }

    public ConsumerConfig config() {
        return this.config;
    }

    public Decoder<K> keyDecoder() {
        return this.keyDecoder;
    }

    public Decoder<V> valueDecoder() {
        return this.valueDecoder;
    }

    public Map<TopicAndPartition, ConcurrentLinkedQueue<PartitionTopicInfo>> org$locationtech$geomesa$kafka10$consumer$KafkaConsumer$$topicInfoMap() {
        return this.org$locationtech$geomesa$kafka10$consumer$KafkaConsumer$$topicInfoMap;
    }

    public ConcurrentHashMap<TopicAndPartition, Object> org$locationtech$geomesa$kafka10$consumer$KafkaConsumer$$consumeCheck() {
        return this.org$locationtech$geomesa$kafka10$consumer$KafkaConsumer$$consumeCheck;
    }

    public HashSet<WrappedConsumer> org$locationtech$geomesa$kafka10$consumer$KafkaConsumer$$consumers() {
        return this.org$locationtech$geomesa$kafka10$consumer$KafkaConsumer$$consumers;
    }

    public HashSet<FetchRunnable> org$locationtech$geomesa$kafka10$consumer$KafkaConsumer$$fetchers() {
        return this.org$locationtech$geomesa$kafka10$consumer$KafkaConsumer$$fetchers;
    }

    public ArrayBuffer<KafkaStreamLike<K, V>> org$locationtech$geomesa$kafka10$consumer$KafkaConsumer$$streams() {
        return this.org$locationtech$geomesa$kafka10$consumer$KafkaConsumer$$streams;
    }

    private AtomicBoolean isCreated() {
        return this.isCreated;
    }

    private AtomicBoolean isShutdown() {
        return this.isShutdown;
    }

    public String consumerId() {
        return this.consumerId;
    }

    public int org$locationtech$geomesa$kafka10$consumer$KafkaConsumer$$fetchBackoff() {
        return this.org$locationtech$geomesa$kafka10$consumer$KafkaConsumer$$fetchBackoff;
    }

    public ScheduledExecutorService org$locationtech$geomesa$kafka10$consumer$KafkaConsumer$$executor() {
        return this.org$locationtech$geomesa$kafka10$consumer$KafkaConsumer$$executor;
    }

    private OffsetManager offsetManager() {
        return this.offsetManager;
    }

    private ConsumerRebalancer<K, V> rebalancer() {
        return this.rebalancer;
    }

    public List<KafkaStreamLike<K, V>> createMessageStreams(int numStreams, RequestedOffset offset) {
        Object object;
        Predef$.MODULE$.assert(numStreams > 0, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Invalid number of streams requested";
            }
        });
        if (this.isCreated().getAndSet(true)) {
            throw new IllegalStateException("Can only create message streams once");
        }
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numStreams).foreach$mVc$sp((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaConsumer $outer;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                LinkedBlockingQueue<FetchedDataChunk> queue = new LinkedBlockingQueue<FetchedDataChunk>(this.$outer.config().queuedMaxMessages());
                this.$outer.org$locationtech$geomesa$kafka10$consumer$KafkaConsumer$$streams().append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaStreamLike[]{new KafkaStreamLike<K, V>(queue, this.$outer.config().consumerTimeoutMs(), this.$outer.keyDecoder(), this.$outer.valueDecoder())}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        if (this.config().autoCommitEnable()) {
            int interval = this.config().autoCommitIntervalMs();
            Runnable autoCommit = new Runnable(this){
                private final /* synthetic */ KafkaConsumer $outer;

                public void run() {
                    this.$outer.org$locationtech$geomesa$kafka10$consumer$KafkaConsumer$$autoCommitOffsets();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            };
            object = this.org$locationtech$geomesa$kafka10$consumer$KafkaConsumer$$executor().scheduleWithFixedDelay(autoCommit, interval, interval, TimeUnit.MILLISECONDS);
        } else {
            object = BoxedUnit.UNIT;
        }
        this.rebalancer().start(numStreams, offset);
        return this.org$locationtech$geomesa$kafka10$consumer$KafkaConsumer$$streams().toList();
    }

    public void initializeOffsets(ZkClient zkClient, ZKGroupDirs dirs, RequestedOffset offset) {
        RequestedOffset requestedOffset = offset;
        GroupOffset$ groupOffset$ = GroupOffset$.MODULE$;
        if (!(requestedOffset != null ? !requestedOffset.equals(groupOffset$) : groupOffset$ != null)) {
            return;
        }
        try {
            BoxedUnit boxedUnit;
            BoxedUnit boxedUnit2;
            String offsetPath = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/start"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dirs.consumerGroupDir()}));
            zkClient.createEphemeral(offsetPath, (Object)offset.toString());
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Setting up initial offsets for ", " with consumer ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.config().groupId(), this.consumerId()})));
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            Seq<PartitionMetadata> partitionMetadata = KafkaConsumer$.MODULE$.findPartitions(this.topic(), this.config());
            if (partitionMetadata.isEmpty()) {
                throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"There are no partitions assigned to topic [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic()})));
            }
            scala.collection.immutable.Map<TopicAndPartition, Object> offsets = this.offsetManager().getOffsets(this.topic(), partitionMetadata, offset);
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Starting offsets for topic [", "] "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)offsets.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Tuple2<TopicAndPartition, Object> o) {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "->", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)((TopicAndPartition)o._1()).partition()), BoxesRunTime.boxToLong((long)o._2$mcJ$sp())}));
                    }
                }, Iterable$.MODULE$.canBuildFrom())).mkString(",")}))).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            long time = System.currentTimeMillis();
            scala.collection.immutable.Map commits = (scala.collection.immutable.Map)offsets.map((Function1)new Serializable(this, time){
                public static final long serialVersionUID = 0L;
                private final long time$1;

                public final Tuple2<TopicAndPartition, OffsetAndMetadata> apply(Tuple2<TopicAndPartition, Object> x0$1) {
                    Tuple2<TopicAndPartition, Object> tuple2 = x0$1;
                    if (tuple2 != null) {
                        TopicAndPartition tap = (TopicAndPartition)tuple2._1();
                        long o = tuple2._2$mcJ$sp();
                        Tuple2 tuple22 = new Tuple2((Object)tap, (Object)OffsetAndMetadata$.MODULE$.apply(o, "", this.time$1));
                        return tuple22;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.time$1 = time$1;
                }
            }, scala.collection.immutable.Map$.MODULE$.canBuildFrom());
            this.offsetManager().commitOffsets((scala.collection.immutable.Map<TopicAndPartition, OffsetAndMetadata>)commits, false);
            commits.foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ KafkaConsumer $outer;

                public final long apply(Tuple2<TopicAndPartition, OffsetAndMetadata> x0$2) {
                    Tuple2<TopicAndPartition, OffsetAndMetadata> tuple2 = x0$2;
                    if (tuple2 != null) {
                        TopicAndPartition tap = (TopicAndPartition)tuple2._1();
                        OffsetAndMetadata o = (OffsetAndMetadata)tuple2._2();
                        long l = BoxesRunTime.unboxToLong((Object)this.$outer.org$locationtech$geomesa$kafka10$consumer$KafkaConsumer$$consumeCheck().put(tap, BoxesRunTime.boxToLong((long)o.offset())));
                        return l;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        }
        catch (Throwable throwable) {
            BoxedUnit boxedUnit;
            Throwable throwable2 = throwable;
            if (throwable2 instanceof ZkNodeExistsException) {
                BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
            }
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error("Error committing initial offsets - consumers will fall back to group offsets", e);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit4 = boxedUnit;
        }
    }

    public synchronized void closeFetchers() {
        this.org$locationtech$geomesa$kafka10$consumer$KafkaConsumer$$fetchers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(FetchRunnable fetcher) {
                fetcher.stop();
                fetcher.queue().clear();
            }
        });
        this.org$locationtech$geomesa$kafka10$consumer$KafkaConsumer$$fetchers().clear();
        this.org$locationtech$geomesa$kafka10$consumer$KafkaConsumer$$consumers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(WrappedConsumer x$1) {
                x$1.disconnect();
            }
        });
        this.org$locationtech$geomesa$kafka10$consumer$KafkaConsumer$$consumers().clear();
        this.org$locationtech$geomesa$kafka10$consumer$KafkaConsumer$$autoCommitOffsets();
        this.org$locationtech$geomesa$kafka10$consumer$KafkaConsumer$$topicInfoMap().clear();
        this.org$locationtech$geomesa$kafka10$consumer$KafkaConsumer$$consumeCheck().clear();
    }

    public synchronized void initializeFetchers(Set<Object> partitions) {
        BoxedUnit boxedUnit;
        if (this.isShutdown().get()) {
            return;
        }
        Seq partitionMetadata = (Seq)KafkaConsumer$.MODULE$.findPartitions(this.topic(), this.config()).filter((Function1)new Serializable(this, partitions){
            public static final long serialVersionUID = 0L;
            private final Set partitions$1;

            public final boolean apply(PartitionMetadata pm) {
                return this.partitions$1.contains((Object)BoxesRunTime.boxToInteger((int)pm.partitionId()));
            }
            {
                this.partitions$1 = partitions$1;
            }
        });
        if (partitionMetadata.isEmpty()) {
            BoxedUnit boxedUnit2;
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No partitions assigned to consumer ", " - you should only have "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.consumerId()}))).append((Object)"one consumer per topic partition").toString());
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            return;
        }
        scala.collection.immutable.Map<TopicAndPartition, Object> offsets = this.offsetManager().getOffsets(this.topic(), (Seq<PartitionMetadata>)partitionMetadata, GroupOffset$.MODULE$);
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"found partitions and offsets for topic [", "] "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)offsets.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(Tuple2<TopicAndPartition, Object> o) {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "->", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)((TopicAndPartition)o._1()).partition()), BoxesRunTime.boxToLong((long)o._2$mcJ$sp())}));
                }
            }, Iterable$.MODULE$.canBuildFrom())).mkString(",")}))).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        int base = partitionMetadata.length() / this.org$locationtech$geomesa$kafka10$consumer$KafkaConsumer$$streams().length();
        int partitionsPerStream = partitionMetadata.length() % this.org$locationtech$geomesa$kafka10$consumer$KafkaConsumer$$streams().length() == 0 ? base : base + 1;
        Iterator groupedPartitions = partitionMetadata.grouped(partitionsPerStream).zip(this.org$locationtech$geomesa$kafka10$consumer$KafkaConsumer$$streams().iterator().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final BlockingQueue<FetchedDataChunk> apply(KafkaStreamLike<K, V> x$2) {
                return x$2.queue();
            }
        }));
        groupedPartitions.foreach((Function1)new Serializable(this, offsets){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaConsumer $outer;
            public final scala.collection.immutable.Map offsets$1;

            public final void apply(Tuple2<Seq<PartitionMetadata>, BlockingQueue<FetchedDataChunk>> x0$3) {
                Tuple2<Seq<PartitionMetadata>, BlockingQueue<FetchedDataChunk>> tuple2 = x0$3;
                if (tuple2 != null) {
                    Seq partitionsForQueue = (Seq)tuple2._1();
                    BlockingQueue queue = (BlockingQueue)tuple2._2();
                    partitionsForQueue.foreach((Function1)new Serializable(this, queue){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$initializeFetchers$2 $outer;
                        private final BlockingQueue queue$1;

                        public final Future<?> apply(PartitionMetadata partition) {
                            TopicAndPartition tap = new TopicAndPartition(this.$outer.org$locationtech$geomesa$kafka10$consumer$KafkaConsumer$$anonfun$$$outer().topic(), partition.partitionId());
                            String clientId = this.$outer.org$locationtech$geomesa$kafka10$consumer$KafkaConsumer$$anonfun$$$outer().config().clientId();
                            Broker leader = (Broker)partition.leader().map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final Broker apply(BrokerEndPoint l) {
                                    return new Broker(l.host(), l.port());
                                }
                            }).getOrElse((Function0)new Serializable(this, tap){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$initializeFetchers$2$$anonfun$apply$1 $outer;
                                private final TopicAndPartition tap$1;

                                public final Broker apply() {
                                    return KafkaConsumer$.MODULE$.findNewLeader(this.tap$1, (Option<Broker>)None$.MODULE$, this.$outer.org$locationtech$geomesa$kafka10$consumer$KafkaConsumer$$anonfun$$anonfun$$$outer().org$locationtech$geomesa$kafka10$consumer$KafkaConsumer$$anonfun$$$outer().config());
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.tap$1 = tap$1;
                                }
                            });
                            SimpleConsumer connection = KafkaConsumer$.MODULE$.createConsumer(leader.host(), leader.port(), this.$outer.org$locationtech$geomesa$kafka10$consumer$KafkaConsumer$$anonfun$$$outer().config(), clientId);
                            WrappedConsumer consumer = new WrappedConsumer(connection, tap, this.$outer.org$locationtech$geomesa$kafka10$consumer$KafkaConsumer$$anonfun$$$outer().config());
                            FetchRunnable fetcher = new FetchRunnable(this.$outer.org$locationtech$geomesa$kafka10$consumer$KafkaConsumer$$anonfun$$$outer(), consumer, tap, BoxesRunTime.unboxToLong((Object)this.$outer.offsets$1.apply((Object)tap)), this.queue$1);
                            this.$outer.org$locationtech$geomesa$kafka10$consumer$KafkaConsumer$$anonfun$$$outer().org$locationtech$geomesa$kafka10$consumer$KafkaConsumer$$consumers().add((Object)consumer);
                            this.$outer.org$locationtech$geomesa$kafka10$consumer$KafkaConsumer$$anonfun$$$outer().org$locationtech$geomesa$kafka10$consumer$KafkaConsumer$$fetchers().add((Object)fetcher);
                            this.$outer.org$locationtech$geomesa$kafka10$consumer$KafkaConsumer$$anonfun$$$outer().org$locationtech$geomesa$kafka10$consumer$KafkaConsumer$$topicInfoMap().put((Object)tap, new ConcurrentLinkedQueue<E>());
                            this.$outer.org$locationtech$geomesa$kafka10$consumer$KafkaConsumer$$anonfun$$$outer().org$locationtech$geomesa$kafka10$consumer$KafkaConsumer$$consumeCheck().put(tap, BoxesRunTime.boxToLong((long)-1L));
                            return this.$outer.org$locationtech$geomesa$kafka10$consumer$KafkaConsumer$$anonfun$$$outer().org$locationtech$geomesa$kafka10$consumer$KafkaConsumer$$executor().submit(fetcher);
                        }

                        public /* synthetic */ $anonfun$initializeFetchers$2 org$locationtech$geomesa$kafka10$consumer$KafkaConsumer$$anonfun$$anonfun$$$outer() {
                            return this.$outer;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.queue$1 = queue$1;
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }

            public /* synthetic */ KafkaConsumer org$locationtech$geomesa$kafka10$consumer$KafkaConsumer$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.offsets$1 = offsets$1;
            }
        });
    }

    public void commitOffsets() {
        this.doCommitOffsets(false);
    }

    public void org$locationtech$geomesa$kafka10$consumer$KafkaConsumer$$autoCommitOffsets() {
        if (this.config().autoCommitEnable()) {
            this.doCommitOffsets(true);
        }
    }

    private void doCommitOffsets(boolean isAutoCommit) {
        scala.collection.immutable.Map commits = ((TraversableOnce)this.org$locationtech$geomesa$kafka10$consumer$KafkaConsumer$$topicInfoMap().flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaConsumer $outer;

            public final Iterable<Tuple2<TopicAndPartition, OffsetAndMetadata>> apply(Tuple2<TopicAndPartition, ConcurrentLinkedQueue<PartitionTopicInfo>> x0$4) {
                Tuple2<TopicAndPartition, ConcurrentLinkedQueue<PartitionTopicInfo>> tuple2 = x0$4;
                if (tuple2 != null) {
                    TopicAndPartition tap = (TopicAndPartition)tuple2._1();
                    ConcurrentLinkedQueue topicInfos = (ConcurrentLinkedQueue)tuple2._2();
                    long maxToConsume = -1L;
                    java.util.Iterator<E> iter = topicInfos.iterator();
                    while (iter.hasNext()) {
                        PartitionTopicInfo topicInfo = (PartitionTopicInfo)iter.next();
                        long nextToConsume = topicInfo.getConsumeOffset();
                        if (nextToConsume > topicInfo.getFetchOffset()) {
                            iter.remove();
                        }
                        maxToConsume = Math.max(nextToConsume, maxToConsume);
                    }
                    Iterable iterable = maxToConsume > BoxesRunTime.unboxToLong((Object)this.$outer.org$locationtech$geomesa$kafka10$consumer$KafkaConsumer$$consumeCheck().get(tap)) ? Option$.MODULE$.option2Iterable((Option)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tap), (Object)OffsetAndMetadata$.MODULE$.apply(maxToConsume, "", System.currentTimeMillis())))) : Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                    return iterable;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        if (commits.nonEmpty()) {
            try {
                this.offsetManager().commitOffsets((scala.collection.immutable.Map<TopicAndPartition, OffsetAndMetadata>)commits, isAutoCommit);
                commits.foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ KafkaConsumer $outer;

                    public final long apply(Tuple2<TopicAndPartition, OffsetAndMetadata> x0$5) {
                        Tuple2<TopicAndPartition, OffsetAndMetadata> tuple2 = x0$5;
                        if (tuple2 != null) {
                            TopicAndPartition tap = (TopicAndPartition)tuple2._1();
                            OffsetAndMetadata o = (OffsetAndMetadata)tuple2._2();
                            long l = BoxesRunTime.unboxToLong((Object)this.$outer.org$locationtech$geomesa$kafka10$consumer$KafkaConsumer$$consumeCheck().put(tap, BoxesRunTime.boxToLong((long)o.offset())));
                            return l;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            catch (Exception exception) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error committing offset for topic ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic()})), (Throwable)exception);
                    boxedUnit = BoxedUnit.UNIT;
                }
                boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    public void shutdown() {
        this.isShutdown().set(true);
        this.org$locationtech$geomesa$kafka10$consumer$KafkaConsumer$$executor().shutdown();
        this.rebalancer().shutdown();
        this.closeFetchers();
        this.org$locationtech$geomesa$kafka10$consumer$KafkaConsumer$$streams().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaStreamLike<K, V> x$3) {
                x$3.shutdown();
            }
        });
        this.org$locationtech$geomesa$kafka10$consumer$KafkaConsumer$$autoCommitOffsets();
        this.offsetManager().close();
        this.org$locationtech$geomesa$kafka10$consumer$KafkaConsumer$$streams().clear();
    }

    public <K, V> KafkaConsumer<K, V> copy(String topic, ConsumerConfig config, Decoder<K> keyDecoder, Decoder<V> valueDecoder) {
        return new KafkaConsumer<K, V>(topic, config, keyDecoder, valueDecoder);
    }

    public <K, V> String copy$default$1() {
        return this.topic();
    }

    public <K, V> ConsumerConfig copy$default$2() {
        return this.config();
    }

    public <K, V> Decoder<K> copy$default$3() {
        return this.keyDecoder();
    }

    public <K, V> Decoder<V> copy$default$4() {
        return this.valueDecoder();
    }

    public String productPrefix() {
        return "KafkaConsumer";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 3: {
                object = this.valueDecoder();
                break;
            }
            case 2: {
                object = this.keyDecoder();
                break;
            }
            case 1: {
                object = this.config();
                break;
            }
            case 0: {
                object = this.topic();
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof KafkaConsumer;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof KafkaConsumer)) return false;
        boolean bl = true;
        if (!bl) return false;
        KafkaConsumer kafkaConsumer = (KafkaConsumer)x$1;
        String string = this.topic();
        String string2 = kafkaConsumer.topic();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        ConsumerConfig consumerConfig = this.config();
        ConsumerConfig consumerConfig2 = kafkaConsumer.config();
        if (consumerConfig == null) {
            if (consumerConfig2 != null) {
                return false;
            }
        } else if (!consumerConfig.equals(consumerConfig2)) return false;
        Decoder<K> decoder = this.keyDecoder();
        Decoder<K> decoder2 = kafkaConsumer.keyDecoder();
        if (decoder == null) {
            if (decoder2 != null) {
                return false;
            }
        } else if (!decoder.equals(decoder2)) return false;
        Decoder<V> decoder3 = this.valueDecoder();
        Decoder<V> decoder4 = kafkaConsumer.valueDecoder();
        if (decoder3 == null) {
            if (decoder4 != null) {
                return false;
            }
        } else if (!decoder3.equals(decoder4)) return false;
        if (!kafkaConsumer.canEqual(this)) return false;
        return true;
    }

    public KafkaConsumer(String topic, ConsumerConfig config, Decoder<K> keyDecoder, Decoder<V> valueDecoder) {
        this.topic = topic;
        this.config = config;
        this.keyDecoder = keyDecoder;
        this.valueDecoder = valueDecoder;
        LazyLogging.class.$init$((LazyLogging)this);
        Product.class.$init$((Product)this);
        this.org$locationtech$geomesa$kafka10$consumer$KafkaConsumer$$topicInfoMap = Map$.MODULE$.empty();
        this.org$locationtech$geomesa$kafka10$consumer$KafkaConsumer$$consumeCheck = new ConcurrentHashMap();
        this.org$locationtech$geomesa$kafka10$consumer$KafkaConsumer$$consumers = HashSet$.MODULE$.empty();
        this.org$locationtech$geomesa$kafka10$consumer$KafkaConsumer$$fetchers = HashSet$.MODULE$.empty();
        this.org$locationtech$geomesa$kafka10$consumer$KafkaConsumer$$streams = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        this.isCreated = new AtomicBoolean(false);
        this.isShutdown = new AtomicBoolean(false);
        String host = InetAddress.getLocalHost().getHostName();
        long time = System.currentTimeMillis();
        String uuid = RichLong$.MODULE$.toHexString$extension(Predef$.MODULE$.longWrapper(UUID.randomUUID().getMostSignificantBits())).substring(0, 8);
        this.consumerId = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "_%s-%d-%s"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{config.groupId()})))).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{host, BoxesRunTime.boxToLong((long)time), uuid}));
        this.org$locationtech$geomesa$kafka10$consumer$KafkaConsumer$$fetchBackoff = config.props().getInt("fetch.backoff.ms", ConsumerConfig$.MODULE$.DefaultFetcherBackoffMs());
        this.org$locationtech$geomesa$kafka10$consumer$KafkaConsumer$$executor = Executors.newScheduledThreadPool(config.numConsumerFetchers());
        this.offsetManager = new OffsetManager(config);
        this.rebalancer = new ConsumerRebalancer(this, config);
    }

    public class FetchRunnable
    implements Fetcher,
    Runnable {
        private final WrappedConsumer consumer;
        private final TopicAndPartition tap;
        private long offset;
        private final BlockingQueue<FetchedDataChunk> queue;
        private final String topic;
        private final int partition;
        private final AtomicBoolean stopped;
        public final /* synthetic */ KafkaConsumer $outer;
        private final Logger logger;
        private volatile boolean bitmap$0;

        @Override
        public Try<ByteBufferMessageSet> fetch(SimpleConsumer consumer, String topic, int partition, long offset, int maxBytes) {
            return Fetcher$class.fetch(this, consumer, topic, partition, offset, maxBytes);
        }

        private Logger logger$lzycompute() {
            FetchRunnable fetchRunnable = this;
            synchronized (fetchRunnable) {
                if (!this.bitmap$0) {
                    this.logger = LazyLogging.class.logger((LazyLogging)this);
                    this.bitmap$0 = true;
                }
                return this.logger;
            }
        }

        public Logger logger() {
            return this.bitmap$0 ? this.logger : this.logger$lzycompute();
        }

        public long offset() {
            return this.offset;
        }

        public void offset_$eq(long x$1) {
            this.offset = x$1;
        }

        public BlockingQueue<FetchedDataChunk> queue() {
            return this.queue;
        }

        private String topic() {
            return this.topic;
        }

        private int partition() {
            return this.partition;
        }

        private AtomicBoolean stopped() {
            return this.stopped;
        }

        private void scheduleRun() {
            this.org$locationtech$geomesa$kafka10$consumer$KafkaConsumer$FetchRunnable$$$outer().org$locationtech$geomesa$kafka10$consumer$KafkaConsumer$$executor().schedule(this, (long)this.org$locationtech$geomesa$kafka10$consumer$KafkaConsumer$FetchRunnable$$$outer().org$locationtech$geomesa$kafka10$consumer$KafkaConsumer$$fetchBackoff(), TimeUnit.MILLISECONDS);
        }

        public void stop() {
            this.stopped().set(true);
        }

        @Override
        public void run() {
            block14: {
                try {
                    Try<ByteBufferMessageSet> response;
                    if (this.stopped().get()) {
                        return;
                    }
                    this.consumer.connect();
                    Try<ByteBufferMessageSet> try_ = response = this.fetch(this.consumer.consumer(), this.topic(), this.partition(), this.offset(), this.org$locationtech$geomesa$kafka10$consumer$KafkaConsumer$FetchRunnable$$$outer().config().fetchMessageMaxBytes());
                    if (try_ instanceof Success) {
                        BoxedUnit boxedUnit;
                        Success success = (Success)try_;
                        ByteBufferMessageSet messages = (ByteBufferMessageSet)success.value();
                        if (messages.isEmpty()) {
                            this.scheduleRun();
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            AtomicLong consumed = new AtomicLong(-1L);
                            AtomicLong fetched = new AtomicLong(((MessageAndOffset)messages.last()).offset());
                            String clientId = this.consumer.consumer().clientId();
                            PartitionTopicInfo pti = new PartitionTopicInfo(this.topic(), this.partition(), this.queue(), consumed, fetched, null, clientId);
                            this.queue().put(new FetchedDataChunk(messages, pti, this.offset()));
                            ((ConcurrentLinkedQueue)this.org$locationtech$geomesa$kafka10$consumer$KafkaConsumer$FetchRunnable$$$outer().org$locationtech$geomesa$kafka10$consumer$KafkaConsumer$$topicInfoMap().apply((Object)this.tap)).add(pti);
                            this.offset_$eq(((MessageAndOffset)messages.last()).nextOffset());
                            this.org$locationtech$geomesa$kafka10$consumer$KafkaConsumer$FetchRunnable$$$outer().org$locationtech$geomesa$kafka10$consumer$KafkaConsumer$$executor().submit(this);
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit2 = boxedUnit;
                        break block14;
                    }
                    if (try_ instanceof Failure) {
                        BoxedUnit boxedUnit;
                        Failure failure = (Failure)try_;
                        Throwable e = failure.exception();
                        if (this.logger().underlying().isWarnEnabled()) {
                            this.logger().underlying().warn("Fetching thread received error", e);
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        this.consumer.disconnect();
                        this.scheduleRun();
                        BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
                        break block14;
                    }
                    throw new MatchError(try_);
                }
                catch (Exception exception) {
                    block15: {
                        BoxedUnit boxedUnit;
                        BoxedUnit boxedUnit4;
                        if (this.logger().underlying().isWarnEnabled()) {
                            this.logger().underlying().warn("Fetching thread threw exception", (Throwable)exception);
                            boxedUnit4 = BoxedUnit.UNIT;
                        } else {
                            boxedUnit4 = BoxedUnit.UNIT;
                        }
                        try {
                            this.consumer.disconnect();
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        catch (Exception exception2) {
                            if (this.logger().underlying().isWarnEnabled()) {
                                this.logger().underlying().warn("Fetching thread threw exception trying to disconnect from consumer", (Throwable)exception2);
                                boxedUnit = BoxedUnit.UNIT;
                                break block15;
                            }
                            boxedUnit = BoxedUnit.UNIT;
                        }
                    }
                    this.scheduleRun();
                }
            }
        }

        public /* synthetic */ KafkaConsumer org$locationtech$geomesa$kafka10$consumer$KafkaConsumer$FetchRunnable$$$outer() {
            return this.$outer;
        }

        public FetchRunnable(KafkaConsumer<K, V> $outer, WrappedConsumer consumer, TopicAndPartition tap, long offset, BlockingQueue<FetchedDataChunk> queue) {
            this.consumer = consumer;
            this.tap = tap;
            this.offset = offset;
            this.queue = queue;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            LazyLogging.class.$init$((LazyLogging)this);
            Fetcher$class.$init$(this);
            this.topic = tap.topic();
            this.partition = tap.partition();
            this.stopped = new AtomicBoolean(false);
        }
    }
}

