/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.kafka;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Point;
import java.util.HashSet;
import org.geotools.data.FeatureEvent;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.identity.FeatureIdImpl;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.locationtech.geomesa.kafka.KafkaFeatureEvent;
import org.locationtech.geomesa.utils.geotools.package$;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import scala.Serializable;

public final class KafkaFeatureEvent$
implements Serializable {
    public static final KafkaFeatureEvent$ MODULE$;
    private final FilterFactory2 ff;

    static {
        new KafkaFeatureEvent$();
    }

    public FilterFactory2 ff() {
        return this.ff;
    }

    public Filter buildId(String id) {
        FeatureIdImpl fid2 = new FeatureIdImpl(id);
        HashSet<FeatureIdImpl> set = new HashSet<FeatureIdImpl>();
        set.add(fid2);
        return this.ff().id(set);
    }

    public ReferencedEnvelope buildBounds(SimpleFeature feature) {
        ReferencedEnvelope referencedEnvelope;
        try {
            Point geom = (Point)feature.getDefaultGeometry();
            double lon = geom.getX();
            double lat = geom.getY();
            referencedEnvelope = ReferencedEnvelope.create((Envelope)new Envelope(lon, lon, lat, lat), (CoordinateReferenceSystem)package$.MODULE$.CRS_EPSG_4326());
        }
        catch (Throwable throwable) {
            referencedEnvelope = package$.MODULE$.wholeWorldEnvelope();
        }
        return referencedEnvelope;
    }

    public FeatureEvent changed(SimpleFeatureSource src, SimpleFeature feature) {
        return new KafkaFeatureEvent(src, FeatureEvent.Type.CHANGED, this.buildBounds(feature), feature);
    }

    public FeatureEvent removed(SimpleFeatureSource src, SimpleFeature feature) {
        return new FeatureEvent((Object)src, FeatureEvent.Type.REMOVED, this.buildBounds(feature), this.buildId(feature.getID()));
    }

    public FeatureEvent cleared(SimpleFeatureSource src) {
        return new FeatureEvent((Object)src, FeatureEvent.Type.REMOVED, package$.MODULE$.wholeWorldEnvelope(), (Filter)Filter.INCLUDE);
    }

    private Object readResolve() {
        return MODULE$;
    }

    private KafkaFeatureEvent$() {
        MODULE$ = this;
        this.ff = CommonFactoryFinder.getFilterFactory2();
    }
}

