/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.geotools;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.awt.geom.Point2D;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.geotools.referencing.GeodeticCalculator;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;

public final class GeometryUtils$ {
    public static final GeometryUtils$ MODULE$;
    private final GeometryFactory geoFactory;
    private final Point zeroPoint;

    static {
        new GeometryUtils$();
    }

    public GeometryFactory geoFactory() {
        return this.geoFactory;
    }

    public Point zeroPoint() {
        return this.zeroPoint;
    }

    public double distanceDegrees(Geometry geometry, double meters) {
        double d;
        Geometry geometry2 = geometry;
        if (geometry2 instanceof Point) {
            Point point = (Point)geometry2;
            d = geometry.distance((Geometry)this.farthestPoint(point, meters));
        } else {
            d = this.distanceDegrees(geometry.getEnvelopeInternal(), meters);
        }
        return d;
    }

    public double distanceDegrees(Envelope env, double meters) {
        return BoxesRunTime.unboxToDouble((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{this.distanceDegrees((Geometry)this.geoFactory().createPoint(new Coordinate(env.getMaxX(), env.getMaxY())), meters), this.distanceDegrees((Geometry)this.geoFactory().createPoint(new Coordinate(env.getMaxX(), env.getMinY())), meters), this.distanceDegrees((Geometry)this.geoFactory().createPoint(new Coordinate(env.getMinX(), env.getMinY())), meters), this.distanceDegrees((Geometry)this.geoFactory().createPoint(new Coordinate(env.getMinX(), env.getMaxY())), meters)})).max((Ordering)Ordering.Double$.MODULE$));
    }

    public Point farthestPoint(Point startPoint, double meters) {
        GeodeticCalculator calc = new GeodeticCalculator();
        calc.setStartingGeographicPoint(startPoint.getX(), startPoint.getY());
        calc.setDirection(90.0, meters);
        Point2D dest2D = calc.getDestinationGeographicPoint();
        return this.geoFactory().createPoint(new Coordinate(dest2D.getX(), dest2D.getY()));
    }

    public <A, B> List<A> unfoldRight(B seed, Function1<B, Option<Tuple2<A, B>>> f) {
        Option option;
        block4: {
            Nil$ nil$;
            block3: {
                Some some;
                Tuple2 tuple2;
                block2: {
                    option = (Option)f.apply(seed);
                    if (!None$.MODULE$.equals(option)) break block2;
                    nil$ = Nil$.MODULE$;
                    break block3;
                }
                if (!(option instanceof Some) || (tuple2 = (Tuple2)(some = (Some)option).x()) == null) break block4;
                Object a = tuple2._1();
                Object b = tuple2._2();
                Object object = a;
                nil$ = this.unfoldRight(b, f).$colon$colon(object);
            }
            return nil$;
        }
        throw new MatchError((Object)option);
    }

    public List<Coordinate> addWayPoints(Seq<Coordinate> coords) {
        return this.unfoldRight((Object)coords, (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Option<Tuple2<Coordinate, Seq<Coordinate>>> apply(Seq<Coordinate> x0$1) {
                Seq<Coordinate> seq;
                block10: {
                    None$ none$;
                    block8: {
                        Some some;
                        block9: {
                            block7: {
                                seq = x0$1;
                                Some some2 = Seq$.MODULE$.unapplySeq(seq);
                                if (some2.isEmpty() || some2.get() == null || ((SeqLike)some2.get()).lengthCompare(0) != 0) break block7;
                                none$ = None$.MODULE$;
                                break block8;
                            }
                            Some some3 = Seq$.MODULE$.unapplySeq(seq);
                            if (some3.isEmpty() || some3.get() == null || ((SeqLike)some3.get()).lengthCompare(1) != 0) break block9;
                            Coordinate pt = (Coordinate)((SeqLike)some3.get()).apply(0);
                            none$ = new Some((Object)new Tuple2((Object)pt, (Object)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)));
                            break block8;
                        }
                        Some some4 = Seq$.MODULE$.unapplySeq(seq);
                        if (some4.isEmpty() || some4.get() == null || ((SeqLike)some4.get()).lengthCompare(2) < 0) break block10;
                        Coordinate first = (Coordinate)((SeqLike)some4.get()).apply(0);
                        Coordinate second = (Coordinate)((SeqLike)some4.get()).apply(1);
                        Seq rest = (Seq)((IterableLike)some4.get()).drop(2);
                        double d = second.x - first.x;
                        if (d > (double)120) {
                            Coordinate coordinate = new Coordinate(first.x + (double)120, first.y);
                            Coordinate coordinate2 = second;
                            some = new Some((Object)new Tuple2((Object)first, ((SeqLike)rest.$plus$colon((Object)coordinate2, Seq$.MODULE$.canBuildFrom())).$plus$colon((Object)coordinate, Seq$.MODULE$.canBuildFrom())));
                        } else if (d < (double)-120) {
                            Coordinate coordinate = new Coordinate(first.x - (double)120, first.y);
                            Coordinate coordinate3 = second;
                            some = new Some((Object)new Tuple2((Object)first, ((SeqLike)rest.$plus$colon((Object)coordinate3, Seq$.MODULE$.canBuildFrom())).$plus$colon((Object)coordinate, Seq$.MODULE$.canBuildFrom())));
                        } else {
                            Coordinate coordinate = second;
                            some = new Some((Object)new Tuple2((Object)first, rest.$plus$colon((Object)coordinate, Seq$.MODULE$.canBuildFrom())));
                        }
                        none$ = some;
                    }
                    return none$;
                }
                throw new MatchError(seq);
            }
        });
    }

    public Tuple4<Object, Object, Object, Object> bounds(Geometry geometry) {
        Envelope env = geometry.getEnvelopeInternal();
        return new Tuple4((Object)BoxesRunTime.boxToDouble((double)env.getMinX()), (Object)BoxesRunTime.boxToDouble((double)env.getMinY()), (Object)BoxesRunTime.boxToDouble((double)env.getMaxX()), (Object)BoxesRunTime.boxToDouble((double)env.getMaxY()));
    }

    public boolean isRectangular(Geometry geometry) {
        Polygon polygon;
        Geometry geometry2 = geometry;
        boolean bl = geometry2 instanceof Point ? true : (geometry2 instanceof Polygon ? this.noInteriorRings(polygon = (Polygon)geometry2) && this.noCutouts(polygon) && this.allRightAngles(polygon) : false);
        return bl;
    }

    private boolean noInteriorRings(Polygon p) {
        return p.getNumInteriorRing() == 0;
    }

    private boolean noCutouts(Polygon p) {
        Envelope env = p.getEnvelopeInternal();
        Tuple4 tuple4 = new Tuple4((Object)BoxesRunTime.boxToDouble((double)env.getMinX()), (Object)BoxesRunTime.boxToDouble((double)env.getMinY()), (Object)BoxesRunTime.boxToDouble((double)env.getMaxX()), (Object)BoxesRunTime.boxToDouble((double)env.getMaxY()));
        if (tuple4 != null) {
            Tuple4 tuple42;
            double xmin = BoxesRunTime.unboxToDouble((Object)tuple4._1());
            double ymin = BoxesRunTime.unboxToDouble((Object)tuple4._2());
            double xmax = BoxesRunTime.unboxToDouble((Object)tuple4._3());
            double ymax = BoxesRunTime.unboxToDouble((Object)tuple4._4());
            Tuple4 tuple43 = tuple42 = new Tuple4((Object)BoxesRunTime.boxToDouble((double)xmin), (Object)BoxesRunTime.boxToDouble((double)ymin), (Object)BoxesRunTime.boxToDouble((double)xmax), (Object)BoxesRunTime.boxToDouble((double)ymax));
            double xmin2 = BoxesRunTime.unboxToDouble((Object)tuple43._1());
            double ymin2 = BoxesRunTime.unboxToDouble((Object)tuple43._2());
            double xmax2 = BoxesRunTime.unboxToDouble((Object)tuple43._3());
            double ymax2 = BoxesRunTime.unboxToDouble((Object)tuple43._4());
            return Predef$.MODULE$.refArrayOps((Object[])p.getCoordinates()).forall((Function1)new Serializable(xmin2, ymin2, xmax2, ymax2){
                public static final long serialVersionUID = 0L;
                private final double xmin$1;
                private final double ymin$1;
                private final double xmax$1;
                private final double ymax$1;

                public final boolean apply(Coordinate c) {
                    return c.x == this.xmin$1 || c.x == this.xmax$1 || c.y == this.ymin$1 || c.y == this.ymax$1;
                }
                {
                    this.xmin$1 = xmin$1;
                    this.ymin$1 = ymin$1;
                    this.xmax$1 = xmax$1;
                    this.ymax$1 = ymax$1;
                }
            });
        }
        throw new MatchError((Object)tuple4);
    }

    private boolean allRightAngles(Polygon p) {
        return Predef$.MODULE$.refArrayOps((Object[])p.getCoordinates()).sliding(2).forall((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Coordinate[] x0$2) {
                Coordinate[] coordinateArray = x0$2;
                Option option = Array$.MODULE$.unapplySeq((Object)coordinateArray);
                if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(2) == 0) {
                    Coordinate left = (Coordinate)((SeqLike)option.get()).apply(0);
                    Coordinate right = (Coordinate)((SeqLike)option.get()).apply(1);
                    boolean bl = left.x == right.x || left.y == right.y;
                    return bl;
                }
                throw new MatchError((Object)coordinateArray);
            }
        });
    }

    private GeometryUtils$() {
        MODULE$ = this;
        this.geoFactory = JTSFactoryFinder.getGeometryFactory();
        this.zeroPoint = this.geoFactory().createPoint(new Coordinate(0.0, 0.0));
    }
}

