/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.geotools;

import com.typesafe.config.Config;
import java.util.Date;
import org.apache.commons.lang.StringEscapeUtils;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.locationtech.geomesa.utils.geotools.AttributeSpec;
import org.locationtech.geomesa.utils.geotools.AttributeSpec$;
import org.locationtech.geomesa.utils.geotools.RichAttributeDescriptors$;
import org.locationtech.geomesa.utils.geotools.RichAttributeDescriptors$RichAttributeDescriptor$;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$RichSimpleFeatureType$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureSpec;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureSpecConfig$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureSpecParser$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes$AttributeOptions$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes$Configs$;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;
import org.parboiled.errors.ParsingException;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.Map;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.VolatileByteRef;

public final class SimpleFeatureTypes$ {
    public static final SimpleFeatureTypes$ MODULE$;

    static {
        new SimpleFeatureTypes$();
    }

    public SimpleFeatureType createType(String typeName, String spec2) {
        Tuple2<String, String> tuple2 = this.parseTypeName(typeName);
        if (tuple2 != null) {
            Tuple2 tuple22;
            String namespace = (String)tuple2._1();
            String name2 = (String)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)namespace, (Object)name2);
            String namespace2 = (String)tuple23._1();
            String name3 = (String)tuple23._2();
            return this.createType(namespace2, name3, spec2);
        }
        throw new MatchError(tuple2);
    }

    public SimpleFeatureType createType(String namespace, String name2, String spec2) {
        try {
            SimpleFeatureSpec parsed = SimpleFeatureSpecParser$.MODULE$.parse(spec2, SimpleFeatureSpecParser$.MODULE$.parse$default$2());
            return this.createType(namespace, name2, parsed);
        }
        catch (ParsingException parsingException) {
            throw new IllegalArgumentException(parsingException.getMessage(), parsingException);
        }
    }

    public SimpleFeatureType createType(Config conf, Option<String> typeName, Option<String> path) {
        Tuple2<Option<String>, SimpleFeatureSpec> tuple2 = SimpleFeatureSpecConfig$.MODULE$.parse(conf, path);
        if (tuple2 != null) {
            Tuple2 tuple22;
            Option nameFromConf = (Option)tuple2._1();
            SimpleFeatureSpec spec2 = (SimpleFeatureSpec)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)nameFromConf, (Object)spec2);
            Option nameFromConf2 = (Option)tuple23._1();
            SimpleFeatureSpec spec3 = (SimpleFeatureSpec)tuple23._2();
            Tuple2<String, String> tuple24 = this.parseTypeName((String)nameFromConf2.orElse((Function0)new Serializable(typeName){
                public static final long serialVersionUID = 0L;
                private final Option typeName$1;

                public final Option<String> apply() {
                    return this.typeName$1;
                }
                {
                    this.typeName$1 = typeName$1;
                }
            }).getOrElse((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Nothing$ apply() {
                    throw new IllegalArgumentException("Unable to parse type name from provided argument or config");
                }
            }));
            if (tuple24 != null) {
                Tuple2 tuple25;
                String namespace = (String)tuple24._1();
                String name2 = (String)tuple24._2();
                Tuple2 tuple26 = tuple25 = new Tuple2((Object)namespace, (Object)name2);
                String namespace2 = (String)tuple26._1();
                String name3 = (String)tuple26._2();
                return this.createType(namespace2, name3, spec3);
            }
            throw new MatchError(tuple24);
        }
        throw new MatchError(tuple2);
    }

    public String encodeType(SimpleFeatureType sft, boolean includeUserData) {
        ObjectRef userData$lzy = ObjectRef.zero();
        VolatileByteRef bitmap$0 = VolatileByteRef.create((byte)0);
        String suffix = includeUserData && !this.userData$1(sft, userData$lzy, bitmap$0).isEmpty() ? ((TraversableOnce)this.userData$1(sft, userData$lzy, bitmap$0).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<Object, Object> x0$2) {
                Tuple2<Object, Object> tuple2 = x0$2;
                if (tuple2 != null) {
                    Object k = tuple2._1();
                    Object v = tuple2._2();
                    String string2 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "='", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{k, StringEscapeUtils.escapeJava((String)v.toString())}));
                    return string2;
                }
                throw new MatchError(tuple2);
            }
        }, Iterable$.MODULE$.canBuildFrom())).mkString(";", ",", "") : "";
        return ((TraversableOnce)JavaConversions$.MODULE$.asScalaBuffer(sft.getAttributeDescriptors()).map((Function1)new Serializable(sft){
            public static final long serialVersionUID = 0L;
            private final SimpleFeatureType sft$1;

            public final String apply(AttributeDescriptor x$4) {
                return SimpleFeatureTypes$.MODULE$.encodeDescriptor(this.sft$1, x$4);
            }
            {
                this.sft$1 = sft$1;
            }
        }, Buffer$.MODULE$.canBuildFrom())).mkString("", ",", suffix);
    }

    public boolean encodeType$default$2() {
        return false;
    }

    public String encodeDescriptor(SimpleFeatureType sft, AttributeDescriptor descriptor) {
        return AttributeSpec$.MODULE$.apply(sft, descriptor).toSpec();
    }

    public Config toConfig(SimpleFeatureType sft, boolean includeUserData, boolean includePrefix) {
        return SimpleFeatureSpecConfig$.MODULE$.toConfig(sft, includeUserData, includePrefix);
    }

    public boolean toConfig$default$2() {
        return true;
    }

    public boolean toConfig$default$3() {
        return true;
    }

    public String toConfigString(SimpleFeatureType sft, boolean includeUserData, boolean concise, boolean includePrefix) {
        return SimpleFeatureSpecConfig$.MODULE$.toConfigString(sft, includeUserData, concise, includePrefix);
    }

    public boolean toConfigString$default$2() {
        return true;
    }

    public boolean toConfigString$default$3() {
        return false;
    }

    public boolean toConfigString$default$4() {
        return true;
    }

    public SimpleFeatureType renameSft(SimpleFeatureType sft, String newName) {
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.init(sft);
        builder.setName(newName);
        SimpleFeatureType renamed = builder.buildFeatureType();
        renamed.getUserData().putAll(sft.getUserData());
        return renamed;
    }

    private SimpleFeatureType createType(String namespace, String name2, SimpleFeatureSpec spec2) {
        None$ none$;
        Seq geomAttributes = (Seq)spec2.attributes().collect((PartialFunction)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends AttributeSpec, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof AttributeSpec.GeomAttributeSpec) {
                    AttributeSpec.GeomAttributeSpec geomAttributeSpec = (AttributeSpec.GeomAttributeSpec)A1;
                    object = geomAttributeSpec;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(AttributeSpec x1) {
                AttributeSpec attributeSpec = x1;
                boolean bl = attributeSpec instanceof AttributeSpec.GeomAttributeSpec;
                return bl;
            }
        }, Seq$.MODULE$.canBuildFrom());
        Option defaultGeom = geomAttributes.find((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(AttributeSpec.GeomAttributeSpec x$5) {
                return x$5.options().get((Object)SimpleFeatureTypes$AttributeOptions$.MODULE$.OPT_DEFAULT()).exists((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(String x$6) {
                        return new StringOps(Predef$.MODULE$.augmentString(x$6)).toBoolean();
                    }
                });
            }
        }).orElse((Function0)new Serializable(geomAttributes){
            public static final long serialVersionUID = 0L;
            private final Seq geomAttributes$1;

            public final Option<AttributeSpec.GeomAttributeSpec> apply() {
                return this.geomAttributes$1.headOption();
            }
            {
                this.geomAttributes$1 = geomAttributes$1;
            }
        }).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(AttributeSpec.GeomAttributeSpec x$7) {
                return x$7.name();
            }
        });
        if (spec2.options().get((Object)SimpleFeatureTypes$Configs$.MODULE$.IGNORE_INDEX_DTG()).exists((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Object value2) {
                return SimpleFeatureTypes$.MODULE$.toBoolean(value2);
            }
        })) {
            none$ = None$.MODULE$;
        } else {
            Seq dateAttributes = (Seq)spec2.attributes().filter((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(AttributeSpec x$8) {
                    return x$8.clazz().isAssignableFrom(Date.class);
                }
            });
            none$ = spec2.options().get((Object)SimpleFeatureTypes$Configs$.MODULE$.DEFAULT_DATE_KEY()).flatMap((Function1)new Serializable(dateAttributes){
                public static final long serialVersionUID = 0L;
                private final Seq dateAttributes$1;

                public final Option<AttributeSpec> apply(Object dtg) {
                    return this.dateAttributes$1.find((Function1)new Serializable(this, dtg){
                        public static final long serialVersionUID = 0L;
                        private final Object dtg$1;

                        public final boolean apply(AttributeSpec x$9) {
                            String string2 = x$9.name();
                            Object object = this.dtg$1;
                            return !(string2 != null ? !string2.equals(object) : object != null);
                        }
                        {
                            this.dtg$1 = dtg$1;
                        }
                    });
                }
                {
                    this.dateAttributes$1 = dateAttributes$1;
                }
            }).orElse((Function0)new Serializable(dateAttributes){
                public static final long serialVersionUID = 0L;
                private final Seq dateAttributes$1;

                public final Option<AttributeSpec> apply() {
                    return this.dateAttributes$1.find((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(AttributeSpec x$10) {
                            return x$10.options().get((Object)SimpleFeatureTypes$AttributeOptions$.MODULE$.OPT_DEFAULT()).exists((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final boolean apply(String x$11) {
                                    return new StringOps(Predef$.MODULE$.augmentString(x$11)).toBoolean();
                                }
                            });
                        }
                    });
                }
                {
                    this.dateAttributes$1 = dateAttributes$1;
                }
            }).orElse((Function0)new Serializable(dateAttributes){
                public static final long serialVersionUID = 0L;
                private final Seq dateAttributes$1;

                public final Option<AttributeSpec> apply() {
                    return this.dateAttributes$1.headOption();
                }
                {
                    this.dateAttributes$1 = dateAttributes$1;
                }
            }).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(AttributeSpec x$12) {
                    return x$12.name();
                }
            });
        }
        None$ defaultDate = none$;
        SimpleFeatureTypeBuilder b = new SimpleFeatureTypeBuilder();
        b.setNamespaceURI(namespace);
        b.setName(name2);
        b.addAll(JavaConversions$.MODULE$.seqAsJavaList((Seq)spec2.attributes().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final AttributeDescriptor apply(AttributeSpec x$13) {
                return x$13.toDescriptor();
            }
        }, Seq$.MODULE$.canBuildFrom())));
        defaultGeom.foreach((Function1)new Serializable(b){
            public static final long serialVersionUID = 0L;
            private final SimpleFeatureTypeBuilder b$1;

            public final void apply(String x$1) {
                this.b$1.setDefaultGeometry(x$1);
            }
            {
                this.b$1 = b$1;
            }
        });
        SimpleFeatureType sft = b.buildFeatureType();
        sft.getUserData().putAll(JavaConversions$.MODULE$.mapAsJavaMap(spec2.options()));
        SimpleFeatureType simpleFeatureType = RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft);
        defaultDate.foreach((Function1)new Serializable(simpleFeatureType){
            public static final long serialVersionUID = 0L;
            private final SimpleFeatureType eta$0$2$1;

            public final void apply(String dtg) {
                RichSimpleFeatureType$RichSimpleFeatureType$.MODULE$.setDtgField$extension(this.eta$0$2$1, dtg);
            }
            {
                this.eta$0$2$1 = eta$0$2$1;
            }
        });
        return sft;
    }

    public Option<String> createType$default$2() {
        return None$.MODULE$;
    }

    public Option<String> createType$default$3() {
        return new Some((Object)"sft");
    }

    private Tuple2<String, String> parseTypeName(String name2) {
        Tuple2 tuple2;
        int nsIndex = name2.lastIndexOf(58);
        Tuple2 tuple22 = tuple2 = nsIndex == -1 || nsIndex == name2.length() - 1 ? new Tuple2(null, (Object)name2) : new Tuple2((Object)name2.substring(0, nsIndex), (Object)name2.substring(nsIndex + 1));
        if (tuple2 != null) {
            Tuple2 tuple23;
            String namespace = (String)tuple2._1();
            String local = (String)tuple2._2();
            Tuple2 tuple24 = tuple23 = new Tuple2((Object)namespace, (Object)local);
            String namespace2 = (String)tuple24._1();
            String local2 = (String)tuple24._2();
            return new Tuple2((Object)namespace2, (Object)local2);
        }
        throw new MatchError((Object)tuple2);
    }

    public Seq<AttributeDescriptor> getSecondaryIndexedAttributes(SimpleFeatureType sft) {
        return (Seq)JavaConversions$.MODULE$.asScalaBuffer(sft.getAttributeDescriptors()).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(AttributeDescriptor ad) {
                return RichAttributeDescriptors$RichAttributeDescriptor$.MODULE$.isIndexed$extension(RichAttributeDescriptors$.MODULE$.RichAttributeDescriptor(ad)) && !(ad instanceof GeometryDescriptor);
            }
        });
    }

    public boolean toBoolean(Object value2) {
        boolean bl;
        Object object = value2;
        if (object == null) {
            bl = false;
        } else if (object instanceof Boolean) {
            Boolean bl2 = (Boolean)object;
            bl = bl2;
        } else if (object instanceof String) {
            String string2 = (String)object;
            bl = Boolean.valueOf(string2);
        } else {
            bl = Boolean.valueOf(object.toString());
        }
        return bl;
    }

    private final Map userData$lzycompute$1(SimpleFeatureType sft$1, ObjectRef userData$lzy$1, VolatileByteRef bitmap$0$1) {
        SimpleFeatureTypes$ simpleFeatureTypes$ = this;
        synchronized (simpleFeatureTypes$) {
            if ((byte)(bitmap$0$1.elem & 1) == 0) {
                Seq<String> prefixes = RichSimpleFeatureType$RichSimpleFeatureType$.MODULE$.getUserDataPrefixes$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft$1));
                userData$lzy$1.elem = (Map)JavaConversions$.MODULE$.mapAsScalaMap(sft$1.getUserData()).filter((Function1)new Serializable(prefixes){
                    public static final long serialVersionUID = 0L;
                    private final Seq prefixes$1;

                    public final boolean apply(Tuple2<Object, Object> x0$1) {
                        Tuple2<Object, Object> tuple2 = x0$1;
                        if (tuple2 != null) {
                            String string2;
                            Object k = tuple2._1();
                            Object v = tuple2._2();
                            boolean bl = v != null && this.prefixes$1.exists((Function1)new Serializable(this, string2 = k.toString()){
                                public static final long serialVersionUID = 0L;
                                private final String eta$0$1$1;

                                public final boolean apply(String x$1) {
                                    return this.eta$0$1$1.startsWith(x$1);
                                }
                                {
                                    this.eta$0$1$1 = eta$0$1$1;
                                }
                            });
                            return bl;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        this.prefixes$1 = prefixes$1;
                    }
                });
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 1);
            }
            return (Map)userData$lzy$1.elem;
        }
    }

    private final Map userData$1(SimpleFeatureType sft$1, ObjectRef userData$lzy$1, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 1) == 0 ? this.userData$lzycompute$1(sft$1, userData$lzy$1, bitmap$0$1) : (Map)userData$lzy$1.elem;
    }

    private SimpleFeatureTypes$() {
        MODULE$ = this;
    }
}

