/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.stats;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import java.util.Arrays;
import java.util.Date;
import org.joda.time.DateTime;
import org.joda.time.base.AbstractInstant;
import org.locationtech.geomesa.curve.BinnedTime;
import org.locationtech.geomesa.curve.BinnedTime$;
import org.locationtech.geomesa.curve.TimePeriod$;
import org.locationtech.geomesa.curve.Z3SFC;
import org.locationtech.geomesa.curve.Z3SFC$;
import org.locationtech.geomesa.utils.geotools.Conversions$;
import org.locationtech.geomesa.utils.geotools.Conversions$RichGeometry$;
import org.locationtech.geomesa.utils.stats.BinnedArray;
import org.locationtech.geomesa.utils.stats.BinnedLongArray;
import org.locationtech.geomesa.utils.stats.Stat;
import org.locationtech.geomesa.utils.stats.Stat$class;
import org.locationtech.geomesa.utils.stats.WholeNumberBinnedArray;
import org.locationtech.geomesa.utils.stats.Z3Histogram$;
import org.opengis.feature.simple.SimpleFeature;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.NotImplementedError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t=d\u0001B\u0001\u0003\u00015\u00111BW\u001aISN$xn\u001a:b[*\u00111\u0001B\u0001\u0006gR\fGo\u001d\u0006\u0003\u000b\u0019\tQ!\u001e;jYNT!a\u0002\u0005\u0002\u000f\u001d,w.\\3tC*\u0011\u0011BC\u0001\rY>\u001c\u0017\r^5p]R,7\r\u001b\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M!\u0001A\u0004\u000b\u0019!\ty!#D\u0001\u0011\u0015\u0005\t\u0012!B:dC2\f\u0017BA\n\u0011\u0005\u0019\te.\u001f*fMB\u0011QCF\u0007\u0002\u0005%\u0011qC\u0001\u0002\u0005'R\fG\u000f\u0005\u0002\u001aA5\t!D\u0003\u0002\u001c9\u0005a1oY1mC2|wmZ5oO*\u0011QDH\u0001\tif\u0004Xm]1gK*\tq$A\u0002d_6L!!\t\u000e\u0003\u00171\u000b'0\u001f'pO\u001eLgn\u001a\u0005\tG\u0001\u0011)\u0019!C\u0001I\u0005Iq-Z8n\u0013:$W\r_\u000b\u0002KA\u0011qBJ\u0005\u0003OA\u00111!\u00138u\u0011!I\u0003A!A!\u0002\u0013)\u0013AC4f_6Le\u000eZ3yA!A1\u0006\u0001BC\u0002\u0013\u0005A%\u0001\u0005ei\u001eLe\u000eZ3y\u0011!i\u0003A!A!\u0002\u0013)\u0013!\u00033uO&sG-\u001a=!\u0011!y\u0003A!b\u0001\n\u0003\u0001\u0014A\u00029fe&|G-F\u00012!\t\u0011$I\u0004\u00024\u007f9\u0011A'\u0010\b\u0003kqr!AN\u001e\u000f\u0005]RT\"\u0001\u001d\u000b\u0005eb\u0011A\u0002\u001fs_>$h(C\u0001\f\u0013\tI!\"\u0003\u0002\b\u0011%\u0011aHB\u0001\u0006GV\u0014h/Z\u0005\u0003\u0001\u0006\u000b!\u0002V5nKB+'/[8e\u0015\tqd!\u0003\u0002D\t\nQA+[7f!\u0016\u0014\u0018n\u001c3\u000b\u0005\u0001\u000b\u0005\u0002\u0003$\u0001\u0005\u0003\u0005\u000b\u0011B\u0019\u0002\u000fA,'/[8eA!A\u0001\n\u0001BC\u0002\u0013\u0005A%\u0001\u0004mK:<G\u000f\u001b\u0005\t\u0015\u0002\u0011\t\u0011)A\u0005K\u00059A.\u001a8hi\"\u0004\u0003\"\u0002'\u0001\t\u0003i\u0015A\u0002\u001fj]&$h\bF\u0003O\u001fB\u000b&\u000b\u0005\u0002\u0016\u0001!)1e\u0013a\u0001K!)1f\u0013a\u0001K!)qf\u0013a\u0001c!)\u0001j\u0013a\u0001K\u0015!A\u000b\u0001\u0011O\u0005\u0005\u0019\u0006b\u0002,\u0001\u0005\u0004%IaV\u0001\u0004g\u001a\u001cW#\u0001-\u0011\u0005eSV\"A!\n\u0005m\u000b%!\u0002.4'\u001a\u001b\u0005BB/\u0001A\u0003%\u0001,\u0001\u0003tM\u000e\u0004\u0003bB0\u0001\u0005\u0004%I\u0001Y\u0001\ni&lW\rV8CS:,\u0012!\u0019\t\u0003E\u0016t!!W2\n\u0005\u0011\f\u0015A\u0003\"j]:,G\rV5nK&\u0011am\u001a\u0002\u0011)&lW\rV8CS:tW\r\u001a+j[\u0016T!\u0001Z!\t\r%\u0004\u0001\u0015!\u0003b\u0003)!\u0018.\\3U_\nKg\u000e\t\u0005\bW\u0002\u0011\r\u0011\"\u0003m\u0003%\u0011\u0017N\u001c+p\t\u0006$X-F\u0001n!\t\u0011g.\u0003\u0002pO\n\u0001\")\u001b8oK\u0012$\u0016.\\3U_\u0012\u000bG/\u001a\u0005\u0007c\u0002\u0001\u000b\u0011B7\u0002\u0015\tLg\u000eV8ECR,\u0007\u0005C\u0004t\u0001\t\u0007I\u0011\u0002;\u0002\t5LgNW\u000b\u0002kB\u0011qB^\u0005\u0003oB\u0011A\u0001T8oO\"1\u0011\u0010\u0001Q\u0001\nU\fQ!\\5o5\u0002Bqa\u001f\u0001C\u0002\u0013%A/\u0001\u0003nCbT\u0006BB?\u0001A\u0003%Q/A\u0003nCbT\u0006\u0005C\u0005\u0000\u0001!\u0015\r\u0011\"\u0003\u0002\u0002\u0005Q!n]8o\r>\u0014X.\u0019;\u0016\u0005\u0005\r\u0001\u0003BA\u0003\u0003\u0017q1aDA\u0004\u0013\r\tI\u0001E\u0001\u0007!J,G-\u001a4\n\t\u00055\u0011q\u0002\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005%\u0001\u0003\u0003\u0006\u0002\u0014\u0001A\t\u0011)Q\u0005\u0003\u0007\t1B[:p]\u001a{'/\\1uA!Q\u0011q\u0003\u0001C\u0002\u0013\u0005!!!\u0007\u0002\r\tLg.T1q+\t\tY\u0002\u0005\u0005\u0002\u001e\u0005\u001d\u00121FA\u0019\u001b\t\tyB\u0003\u0003\u0002\"\u0005\r\u0012aB7vi\u0006\u0014G.\u001a\u0006\u0004\u0003K\u0001\u0012AC2pY2,7\r^5p]&!\u0011\u0011FA\u0010\u0005\ri\u0015\r\u001d\t\u0004\u001f\u00055\u0012bAA\u0018!\t)1\u000b[8siB\u0019Q#a\r\n\u0007\u0005U\"AA\bCS:tW\r\u001a'p]\u001e\f%O]1z\u0011!\tI\u0004\u0001Q\u0001\n\u0005m\u0011a\u00022j]6\u000b\u0007\u000f\t\u0005\t\u0003{\u0001A\u0011\u0001\u0002\u0002@\u00059a.Z<CS:\u001cXCAA\u0019\u0011\u001d\t\u0019\u0005\u0001C\u0001\u0003\u000b\n\u0001\u0002^5nK\nKgn]\u000b\u0003\u0003\u000f\u0002b!!\u0013\u0002T\u0005-b\u0002BA&\u0003\u001fr1aNA'\u0013\u0005\t\u0012bAA)!\u00059\u0001/Y2lC\u001e,\u0017\u0002BA+\u0003/\u00121aU3r\u0015\r\t\t\u0006\u0005\u0005\b\u00037\u0002A\u0011AA/\u0003\u0015\u0019w.\u001e8u)\u0015)\u0018qLA2\u0011!\t\t'!\u0017A\u0002\u0005-\u0012a\u0002;j[\u0016\u0014\u0015N\u001c\u0005\b\u0003K\nI\u00061\u0001&\u0003\u0005I\u0007bBA5\u0001\u0011\u0005\u00111N\u0001\fI&\u0014Xm\u0019;J]\u0012,\u0007\u0010F\u0003&\u0003[\ny\u0007\u0003\u0005\u0002b\u0005\u001d\u0004\u0019AA\u0016\u0011\u001d\t\t(a\u001aA\u0002U\fQA^1mk\u0016Dq!!\u001e\u0001\t\u0003\t9(A\u0004j]\u0012,\u0007p\u00144\u0015\t\u0005e\u0014q\u0010\t\u0007\u001f\u0005m\u00141F\u0013\n\u0007\u0005u\u0004C\u0001\u0004UkBdWM\r\u0005\t\u0003c\n\u0019\b1\u0001\u0002\u0002B9q\"a\u001f\u0002\u0004\u0006]\u0005\u0003BAC\u0003'k!!a\"\u000b\t\u0005%\u00151R\u0001\u0005O\u0016|WN\u0003\u0003\u0002\u000e\u0006=\u0015a\u00016ug*\u0019\u0011\u0011\u0013\u0010\u0002\u001dYLg/\u001b3t_2,H/[8og&!\u0011QSAD\u0005!9Um\\7fiJL\b\u0003BAM\u0003Gk!!a'\u000b\t\u0005u\u0015qT\u0001\u0005kRLGN\u0003\u0002\u0002\"\u0006!!.\u0019<b\u0013\u0011\t)+a'\u0003\t\u0011\u000bG/\u001a\u0005\b\u0003S\u0003A\u0011AAV\u0003-iW\rZ5b]Z\u000bG.^3\u0015\r\u0005\u0005\u0015QVAX\u0011!\t\t'a*A\u0002\u0005-\u0002bBA3\u0003O\u0003\r!\n\u0005\b\u0003g\u0003A\u0011BA[\u0003\u0015!xnS3z)\u0019\t9,!/\u0002<B1q\"a\u001f\u0002,UD\u0001\"!#\u00022\u0002\u0007\u00111\u0011\u0005\t\u0003{\u000b\t\f1\u0001\u0002\u0018\u0006\u0019A\r^4\t\u000f\u0005\u0005\u0007\u0001\"\u0003\u0002D\u00069aM]8n\u0017\u0016LHCBAA\u0003\u000b\f9\r\u0003\u0005\u0002b\u0005}\u0006\u0019AA\u0016\u0011\u001d\tI-a0A\u0002U\f\u0011A\u001f\u0005\b\u0003\u001b\u0004A\u0011AAh\u0003-\u0019\b\u000f\\5u\u0005f$\u0016.\\3\u0016\u0005\u0005E\u0007CBA%\u0003'\n\u0019\u000e\u0005\u0004\u0010\u0003w\nYC\u0014\u0005\b\u0003/\u0004A\u0011IAm\u0003\u001dy'm]3sm\u0016$B!a7\u0002bB\u0019q\"!8\n\u0007\u0005}\u0007C\u0001\u0003V]&$\b\u0002CAr\u0003+\u0004\r!!:\u0002\u0005M4\u0007\u0003BAt\u0003kl!!!;\u000b\t\u0005-\u0018Q^\u0001\u0007g&l\u0007\u000f\\3\u000b\t\u0005=\u0018\u0011_\u0001\bM\u0016\fG/\u001e:f\u0015\r\t\u0019PC\u0001\b_B,gnZ5t\u0013\u0011\t90!;\u0003\u001bMKW\u000e\u001d7f\r\u0016\fG/\u001e:f\u0011\u001d\tY\u0010\u0001C!\u0003{\f\u0011\"\u001e8pEN,'O^3\u0015\t\u0005m\u0017q \u0005\t\u0003G\fI\u00101\u0001\u0002f\"9!1\u0001\u0001\u0005B\t\u0015\u0011!\u0002\u0013qYV\u001cHc\u0001(\u0003\b!9!\u0011\u0002B\u0001\u0001\u0004q\u0015!B8uQ\u0016\u0014\bb\u0002B\u0007\u0001\u0011\u0005#qB\u0001\tIAdWo\u001d\u0013fcR!\u00111\u001cB\t\u0011\u001d\u0011IAa\u0003A\u00029CqA!\u0006\u0001\t\u0003\u00129\"\u0001\u0007u_*\u001bxN\\(cU\u0016\u001cG/\u0006\u0002\u0003\u001aA\u0019qBa\u0007\n\u0007\tu\u0001CA\u0002B]fDqA!\t\u0001\t\u0003\u0012\u0019#A\u0004jg\u0016k\u0007\u000f^=\u0016\u0005\t\u0015\u0002cA\b\u0003(%\u0019!\u0011\u0006\t\u0003\u000f\t{w\u000e\\3b]\"9!Q\u0006\u0001\u0005B\t=\u0012!B2mK\u0006\u0014HCAAn\u0011\u001d\u0011\u0019\u0004\u0001C!\u0005k\tA\"[:FcVLg/\u00197f]R$BA!\n\u00038!9!\u0011\u0002B\u0019\u0001\u0004!ra\u0002B\u001e\u0005!\u0005!QH\u0001\f5NB\u0015n\u001d;pOJ\fW\u000eE\u0002\u0016\u0005\u007f1a!\u0001\u0002\t\u0002\t\u00053c\u0001B \u001d!9AJa\u0010\u0005\u0002\t\u0015CC\u0001B\u001f\u0011)\u0011IEa\u0010C\u0002\u0013\u0005!1J\u0001\u0003O\u001a,\"A!\u0014\u0011\t\u0005\u0015%qJ\u0005\u0005\u0005#\n9IA\bHK>lW\r\u001e:z\r\u0006\u001cGo\u001c:z\u0011%\u0011)Fa\u0010!\u0002\u0013\u0011i%A\u0002hM\u0002B!B!\u0017\u0003@\t\u0007I\u0011\u0001B.\u0003\u001di\u0017N\\$f_6,\"A!\u0018\u0011\t\u0005\u0015%qL\u0005\u0005\u0005C\n9IA\u0003Q_&tG\u000fC\u0005\u0003f\t}\u0002\u0015!\u0003\u0003^\u0005AQ.\u001b8HK>l\u0007\u0005\u0003\u0006\u0003j\t}\"\u0019!C\u0001\u00057\nq!\\1y\u000f\u0016|W\u000eC\u0005\u0003n\t}\u0002\u0015!\u0003\u0003^\u0005AQ.\u0019=HK>l\u0007\u0005")
public class Z3Histogram
implements Stat,
LazyLogging {
    private final int geomIndex;
    private final int dtgIndex;
    private final Enumeration.Value period;
    private final int length;
    private final Z3SFC sfc;
    private final Function1<Object, BinnedTime> timeToBin;
    private final Function1<BinnedTime, DateTime> binToDate;
    private final long minZ;
    private final long maxZ;
    private String org$locationtech$geomesa$utils$stats$Z3Histogram$$jsonFormat;
    private final Map<Object, BinnedLongArray> binMap;
    private final Logger logger;
    private volatile byte bitmap$0;

    public static Point maxGeom() {
        return Z3Histogram$.MODULE$.maxGeom();
    }

    public static Point minGeom() {
        return Z3Histogram$.MODULE$.minGeom();
    }

    public static GeometryFactory gf() {
        return Z3Histogram$.MODULE$.gf();
    }

    private String org$locationtech$geomesa$utils$stats$Z3Histogram$$jsonFormat$lzycompute() {
        Z3Histogram z3Histogram2 = this;
        synchronized (z3Histogram2) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                String string2;
                Enumeration.Value value2 = this.period();
                Enumeration.Value value3 = TimePeriod$.MODULE$.Day();
                Enumeration.Value value4 = value2;
                if (!(value3 != null ? !value3.equals(value4) : value4 != null)) {
                    string2 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-%05d"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.period()}));
                } else {
                    Enumeration.Value value5 = TimePeriod$.MODULE$.Week();
                    Enumeration.Value value6 = value2;
                    if (!(value5 != null ? !value5.equals(value6) : value6 != null)) {
                        string2 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-%04d"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.period()}));
                    } else {
                        Enumeration.Value value7 = TimePeriod$.MODULE$.Month();
                        Enumeration.Value value8 = value2;
                        if (!(value7 != null ? !value7.equals(value8) : value8 != null)) {
                            string2 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-%03d"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.period()}));
                        } else {
                            Enumeration.Value value9 = TimePeriod$.MODULE$.Year();
                            Enumeration.Value value10 = value2;
                            if (value9 != null ? !value9.equals(value10) : value10 != null) {
                                throw new MatchError((Object)value2);
                            }
                            string2 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-%02d"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.period()}));
                        }
                    }
                }
                this.org$locationtech$geomesa$utils$stats$Z3Histogram$$jsonFormat = string2;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.org$locationtech$geomesa$utils$stats$Z3Histogram$$jsonFormat;
        }
    }

    private Logger logger$lzycompute() {
        Z3Histogram z3Histogram2 = this;
        synchronized (z3Histogram2) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public void $plus$eq(Stat other, Predef.DummyImplicit d) {
        Stat$class.$plus$eq(this, other, d);
    }

    @Override
    public Stat $plus(Stat other, Predef.DummyImplicit d) {
        return Stat$class.$plus(this, other, d);
    }

    @Override
    public String toJson() {
        return Stat$class.toJson(this);
    }

    public int geomIndex() {
        return this.geomIndex;
    }

    public int dtgIndex() {
        return this.dtgIndex;
    }

    public Enumeration.Value period() {
        return this.period;
    }

    public int length() {
        return this.length;
    }

    private Z3SFC sfc() {
        return this.sfc;
    }

    private Function1<Object, BinnedTime> timeToBin() {
        return this.timeToBin;
    }

    private Function1<BinnedTime, DateTime> binToDate() {
        return this.binToDate;
    }

    private long minZ() {
        return this.minZ;
    }

    private long maxZ() {
        return this.maxZ;
    }

    public String org$locationtech$geomesa$utils$stats$Z3Histogram$$jsonFormat() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.org$locationtech$geomesa$utils$stats$Z3Histogram$$jsonFormat$lzycompute() : this.org$locationtech$geomesa$utils$stats$Z3Histogram$$jsonFormat;
    }

    public Map<Object, BinnedLongArray> binMap() {
        return this.binMap;
    }

    public BinnedLongArray newBins() {
        return new BinnedLongArray(this.length(), (Tuple2<Long, Long>)new Tuple2((Object)Predef$.MODULE$.long2Long(this.minZ()), (Object)Predef$.MODULE$.long2Long(this.maxZ())));
    }

    public Seq<Object> timeBins() {
        return (Seq)this.binMap().keys().toSeq().sorted((Ordering)Ordering.Short$.MODULE$);
    }

    public long count(short timeBin, int i) {
        return BoxesRunTime.unboxToLong((Object)this.binMap().get((Object)BoxesRunTime.boxToShort((short)timeBin)).map((Function1)new Serializable(this, i){
            public static final long serialVersionUID = 0L;
            private final int i$1;

            public final long apply(BinnedLongArray x$1) {
                return x$1.counts()[this.i$1];
            }
            {
                this.i$1 = i$1;
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        }));
    }

    public int directIndex(short timeBin, long value2) {
        return BoxesRunTime.unboxToInt((Object)this.binMap().get((Object)BoxesRunTime.boxToShort((short)timeBin)).map((Function1)new Serializable(this, value2){
            public static final long serialVersionUID = 0L;
            private final long value$1;

            public final int apply(BinnedLongArray x$2) {
                return x$2.indexOf(Predef$.MODULE$.long2Long(this.value$1));
            }
            {
                this.value$1 = value$1;
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return -1;
            }
        }));
    }

    public Tuple2<Object, Object> indexOf(Tuple2<Geometry, Date> value2) {
        Tuple2<Object, Object> tuple2 = this.toKey((Geometry)value2._1(), (Date)value2._2());
        if (tuple2 != null) {
            Tuple2 tuple22;
            short timeBin = BoxesRunTime.unboxToShort((Object)tuple2._1());
            long z = tuple2._2$mcJ$sp();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)BoxesRunTime.boxToShort((short)timeBin), (Object)BoxesRunTime.boxToLong((long)z));
            short timeBin2 = BoxesRunTime.unboxToShort((Object)tuple23._1());
            long z2 = tuple23._2$mcJ$sp();
            return new Tuple2((Object)BoxesRunTime.boxToShort((short)timeBin2), (Object)BoxesRunTime.boxToInteger((int)this.directIndex(timeBin2, z2)));
        }
        throw new MatchError(tuple2);
    }

    public Tuple2<Geometry, Date> medianValue(short timeBin, int i) {
        return this.fromKey(timeBin, Predef$.MODULE$.Long2long((Long)((WholeNumberBinnedArray)this.binMap().apply((Object)BoxesRunTime.boxToShort((short)timeBin))).medianValue(i)));
    }

    private Tuple2<Object, Object> toKey(Geometry geom, Date dtg) {
        BinnedTime binnedTime = (BinnedTime)this.timeToBin().apply((Object)BoxesRunTime.boxToLong((long)dtg.getTime()));
        if (binnedTime != null) {
            Tuple2 tuple2;
            short bin = binnedTime.bin();
            long offset = binnedTime.offset();
            Tuple2 tuple22 = tuple2 = new Tuple2((Object)BoxesRunTime.boxToShort((short)bin), (Object)BoxesRunTime.boxToLong((long)offset));
            short bin2 = BoxesRunTime.unboxToShort((Object)tuple22._1());
            long offset2 = tuple22._2$mcJ$sp();
            Point centroid = Conversions$RichGeometry$.MODULE$.safeCentroid$extension(Conversions$.MODULE$.RichGeometry(geom));
            long z = this.sfc().index(centroid.getX(), centroid.getY(), offset2);
            return new Tuple2((Object)BoxesRunTime.boxToShort((short)bin2), (Object)BoxesRunTime.boxToLong((long)z));
        }
        throw new MatchError((Object)binnedTime);
    }

    private Tuple2<Geometry, Date> fromKey(short timeBin, long z) {
        Tuple3 tuple3 = this.sfc().invert(z);
        if (tuple3 != null) {
            Tuple3 tuple32;
            double x = BoxesRunTime.unboxToDouble((Object)tuple3._1());
            double y = BoxesRunTime.unboxToDouble((Object)tuple3._2());
            long t = BoxesRunTime.unboxToLong((Object)tuple3._3());
            Tuple3 tuple33 = tuple32 = new Tuple3((Object)BoxesRunTime.boxToDouble((double)x), (Object)BoxesRunTime.boxToDouble((double)y), (Object)BoxesRunTime.boxToLong((long)t));
            double x2 = BoxesRunTime.unboxToDouble((Object)tuple33._1());
            double y2 = BoxesRunTime.unboxToDouble((Object)tuple33._2());
            long t2 = BoxesRunTime.unboxToLong((Object)tuple33._3());
            Date dtg = ((AbstractInstant)this.binToDate().apply((Object)new BinnedTime(timeBin, t2))).toDate();
            Point geom = Z3Histogram$.MODULE$.gf().createPoint(new Coordinate(x2, y2));
            return new Tuple2((Object)geom, (Object)dtg);
        }
        throw new MatchError((Object)tuple3);
    }

    public Seq<Tuple2<Object, Z3Histogram>> splitByTime() {
        return (Seq)this.binMap().toSeq().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Z3Histogram $outer;

            public final Tuple2<Object, Z3Histogram> apply(Tuple2<Object, BinnedLongArray> x0$1) {
                Tuple2<Object, BinnedLongArray> tuple2 = x0$1;
                if (tuple2 != null) {
                    short w = BoxesRunTime.unboxToShort((Object)tuple2._1());
                    BinnedLongArray bins = (BinnedLongArray)tuple2._2();
                    Z3Histogram hist = new Z3Histogram(this.$outer.geomIndex(), this.$outer.dtgIndex(), this.$outer.period(), this.$outer.length());
                    hist.binMap().put((Object)BoxesRunTime.boxToShort((short)w), (Object)bins);
                    Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToShort((short)w), (Object)hist);
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    @Override
    public void observe(SimpleFeature sf) {
        Geometry geom = (Geometry)sf.getAttribute(this.geomIndex());
        Date dtg = (Date)sf.getAttribute(this.dtgIndex());
        if (geom != null && dtg != null) {
            try {
                Tuple2 tuple2;
                Tuple2<Object, Object> tuple22 = this.toKey(geom, dtg);
                if (tuple22 == null) {
                    throw new MatchError(tuple22);
                }
                short timeBin = BoxesRunTime.unboxToShort((Object)tuple22._1());
                long z3 = tuple22._2$mcJ$sp();
                Tuple2 tuple23 = tuple2 = new Tuple2((Object)BoxesRunTime.boxToShort((short)timeBin), (Object)BoxesRunTime.boxToLong((long)z3));
                short timeBin2 = BoxesRunTime.unboxToShort((Object)tuple23._1());
                long z32 = tuple23._2$mcJ$sp();
                ((BinnedArray)this.binMap().getOrElseUpdate((Object)BoxesRunTime.boxToShort((short)timeBin2), (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ Z3Histogram $outer;

                    public final BinnedLongArray apply() {
                        return this.$outer.newBins();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                })).add(Predef$.MODULE$.long2Long(z32), 1L);
            }
            catch (Exception exception) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error observing geom '", "' and date '", "': ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{geom, dtg, exception.toString()})));
                    boxedUnit = BoxedUnit.UNIT;
                }
                boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    @Override
    public void unobserve(SimpleFeature sf) {
        Geometry geom = (Geometry)sf.getAttribute(this.geomIndex());
        Date dtg = (Date)sf.getAttribute(this.dtgIndex());
        if (geom != null && dtg != null) {
            try {
                Tuple2 tuple2;
                Tuple2<Object, Object> tuple22 = this.toKey(geom, dtg);
                if (tuple22 == null) {
                    throw new MatchError(tuple22);
                }
                short timeBin = BoxesRunTime.unboxToShort((Object)tuple22._1());
                long z3 = tuple22._2$mcJ$sp();
                Tuple2 tuple23 = tuple2 = new Tuple2((Object)BoxesRunTime.boxToShort((short)timeBin), (Object)BoxesRunTime.boxToLong((long)z3));
                short timeBin2 = BoxesRunTime.unboxToShort((Object)tuple23._1());
                long z32 = tuple23._2$mcJ$sp();
                this.binMap().get((Object)BoxesRunTime.boxToShort((short)timeBin2)).foreach((Function1)new Serializable(this, z32){
                    public static final long serialVersionUID = 0L;
                    private final long z3$1;

                    public final void apply(BinnedLongArray x$8) {
                        x$8.add(Predef$.MODULE$.long2Long(this.z3$1), -1L);
                    }
                    {
                        this.z3$1 = z3$1;
                    }
                });
            }
            catch (Exception exception) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error un-observing geom '", "' and date '", "': ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{geom, dtg, exception.toString()})));
                    boxedUnit = BoxedUnit.UNIT;
                }
                boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public Z3Histogram $plus(Z3Histogram other) {
        void var2_2;
        Z3Histogram plus2 = new Z3Histogram(this.geomIndex(), this.dtgIndex(), this.period(), this.length());
        plus2.$plus$eq(this);
        plus2.$plus$eq(other);
        return var2_2;
    }

    public void $plus$eq(Z3Histogram other) {
        if (this.length() != other.length()) {
            throw new NotImplementedError("Can only add z3 histograms with the same length");
        }
        other.binMap().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Z3Histogram $outer;

            public final Object apply(Tuple2<Object, BinnedLongArray> x0$2) {
                Tuple2<Object, BinnedLongArray> tuple2;
                block3: {
                    Option option;
                    block6: {
                        Option option2;
                        block5: {
                            BinnedLongArray bins;
                            block4: {
                                tuple2 = x0$2;
                                if (tuple2 == null) break block3;
                                short w = BoxesRunTime.unboxToShort((Object)tuple2._1());
                                bins = (BinnedLongArray)tuple2._2();
                                option = this.$outer.binMap().get((Object)BoxesRunTime.boxToShort((short)w));
                                if (!None$.MODULE$.equals(option)) break block4;
                                option2 = this.$outer.binMap().put((Object)BoxesRunTime.boxToShort((short)w), (Object)bins);
                                break block5;
                            }
                            if (!(option instanceof Some)) break block6;
                            Some some = (Some)option;
                            BinnedLongArray b = (BinnedLongArray)some.x();
                            for (int i = 0; i < b.length(); ++i) {
                                int n = i;
                                b.counts()[n] = b.counts()[n] + bins.counts()[i];
                            }
                            option2 = BoxedUnit.UNIT;
                        }
                        Option option3 = option2;
                        return option3;
                    }
                    throw new MatchError((Object)option);
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    @Override
    public Object toJsonObject() {
        return ((TraversableLike)((TraversableLike)this.binMap().toSeq().sortBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final short apply(Tuple2<Object, BinnedLongArray> x$9) {
                return BoxesRunTime.unboxToShort((Object)x$9._1());
            }
        }, (Ordering)Ordering.Short$.MODULE$)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Z3Histogram $outer;

            public final Tuple2<String, BinnedLongArray> apply(Tuple2<Object, BinnedLongArray> x0$3) {
                Tuple2<Object, BinnedLongArray> tuple2 = x0$3;
                if (tuple2 != null) {
                    short p = BoxesRunTime.unboxToShort((Object)tuple2._1());
                    BinnedLongArray bins = (BinnedLongArray)tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)String.format(this.$outer.org$locationtech$geomesa$utils$stats$Z3Histogram$$jsonFormat(), BoxesRunTime.boxToShort((short)p)), (Object)bins);
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final scala.collection.immutable.Map<String, scala.collection.immutable.Map<String, long[]>> apply(Tuple2<String, BinnedLongArray> x0$4) {
                Tuple2<String, BinnedLongArray> tuple2 = x0$4;
                if (tuple2 != null) {
                    String label = (String)tuple2._1();
                    BinnedLongArray bins = (BinnedLongArray)tuple2._2();
                    scala.collection.immutable.Map map2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)label), (Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bins"), (Object)bins.counts())})))}));
                    return map2;
                }
                throw new MatchError(tuple2);
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    @Override
    public boolean isEmpty() {
        return this.binMap().values().forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(BinnedLongArray x$10) {
                return Predef$.MODULE$.longArrayOps(x$10.counts()).forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(long x$11) {
                        return this.apply$mcZJ$sp(x$11);
                    }

                    public boolean apply$mcZJ$sp(long x$11) {
                        return x$11 == 0L;
                    }
                });
            }
        });
    }

    @Override
    public void clear() {
        this.binMap().values().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(BinnedLongArray x$12) {
                x$12.clear();
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isEquivalent(Stat other) {
        Stat stat2 = other;
        if (!(stat2 instanceof Z3Histogram)) return false;
        Z3Histogram z3Histogram2 = (Z3Histogram)stat2;
        if (this.geomIndex() != z3Histogram2.geomIndex()) return false;
        if (this.dtgIndex() != z3Histogram2.dtgIndex()) return false;
        Enumeration.Value value2 = this.period();
        Enumeration.Value value3 = z3Histogram2.period();
        if (value2 == null) {
            if (value3 != null) {
                return false;
            }
        } else if (!value2.equals(value3)) return false;
        if (this.length() != z3Histogram2.length()) return false;
        Set set = this.binMap().keySet();
        Set set2 = z3Histogram2.binMap().keySet();
        if (set == null) {
            if (set2 != null) {
                return false;
            }
        } else if (!set.equals(set2)) return false;
        if (!this.binMap().forall((Function1)new Serializable(this, z3Histogram2){
            public static final long serialVersionUID = 0L;
            private final Z3Histogram x2$1;

            public final boolean apply(Tuple2<Object, BinnedLongArray> x0$5) {
                Tuple2<Object, BinnedLongArray> tuple2 = x0$5;
                if (tuple2 != null) {
                    short w = BoxesRunTime.unboxToShort((Object)tuple2._1());
                    BinnedLongArray bins = (BinnedLongArray)tuple2._2();
                    boolean bl = Arrays.equals(bins.counts(), ((BinnedArray)this.x2$1.binMap().apply((Object)BoxesRunTime.boxToShort((short)w))).counts());
                    return bl;
                }
                throw new MatchError(tuple2);
            }
            {
                this.x2$1 = x2$1;
            }
        })) return false;
        return true;
    }

    public Z3Histogram(int geomIndex, int dtgIndex, Enumeration.Value period, int length) {
        this.geomIndex = geomIndex;
        this.dtgIndex = dtgIndex;
        this.period = period;
        this.length = length;
        Stat$class.$init$(this);
        LazyLogging.class.$init$((LazyLogging)this);
        this.sfc = Z3SFC$.MODULE$.apply(period);
        this.timeToBin = BinnedTime$.MODULE$.timeToBinnedTime(period);
        this.binToDate = BinnedTime$.MODULE$.binnedTimeToDate(period);
        this.minZ = this.sfc().index(Z3Histogram$.MODULE$.minGeom().getX(), Z3Histogram$.MODULE$.minGeom().getY(), (long)this.sfc().time().min());
        this.maxZ = this.sfc().index(Z3Histogram$.MODULE$.maxGeom().getX(), Z3Histogram$.MODULE$.maxGeom().getY(), (long)this.sfc().time().max());
        this.binMap = Map$.MODULE$.empty();
    }
}

