/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.cqengine.persistence.support;

import com.googlecode.cqengine.index.support.CloseableIterator;
import com.googlecode.cqengine.persistence.support.ObjectStore;
import com.googlecode.cqengine.query.Query;
import com.googlecode.cqengine.query.option.QueryOptions;
import com.googlecode.cqengine.resultset.filter.FilteringIterator;
import java.util.Collection;

public class FilteredObjectStore<O>
implements ObjectStore<O> {
    final ObjectStore<O> backingObjectStore;
    final Query<O> filterQuery;

    public FilteredObjectStore(ObjectStore<O> backingObjectStore, Query<O> filterQuery) {
        this.backingObjectStore = backingObjectStore;
        this.filterQuery = filterQuery;
    }

    @Override
    public CloseableIterator<O> iterator(QueryOptions queryOptions) {
        final CloseableIterator<O> backingIterator = this.backingObjectStore.iterator(queryOptions);
        final FilteringIterator filteringIterator = new FilteringIterator<O>(backingIterator, queryOptions){

            @Override
            public boolean isValid(O object, QueryOptions queryOptions) {
                return FilteredObjectStore.this.filterQuery.matches(object, queryOptions);
            }
        };
        return new CloseableIterator<O>(){

            @Override
            public void close() {
                backingIterator.close();
            }

            @Override
            public boolean hasNext() {
                return filteringIterator.hasNext();
            }

            @Override
            public O next() {
                return filteringIterator.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Modification not supported");
            }
        };
    }

    @Override
    public int size(QueryOptions queryOptions) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(Object o, QueryOptions queryOptions) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty(QueryOptions queryOptions) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(O object, QueryOptions queryOptions) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o, QueryOptions queryOptions) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> c, QueryOptions queryOptions) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends O> c, QueryOptions queryOptions) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c, QueryOptions queryOptions) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c, QueryOptions queryOptions) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear(QueryOptions queryOptions) {
        throw new UnsupportedOperationException();
    }
}

