/*
 * Decompiled with CFR 0.152.
 */
package org.geomesa.gs.wps.kafka10;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.util.Date;
import org.geomesa.gs.wps.kafka10.GeoServerUtils$;
import org.geomesa.gs.wps.kafka10.GeomesaKafkaProcess;
import org.geomesa.gs.wps.kafka10.VolatileLayer$;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geotools.data.DataStore;
import org.geotools.process.ProcessException;
import org.geotools.process.factory.DescribeParameter;
import org.geotools.process.factory.DescribeProcess;
import org.geotools.process.factory.DescribeResult;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.locationtech.geomesa.kafka.KafkaDataStoreHelper$;
import org.locationtech.geomesa.kafka.ReplayConfig;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.Name;
import scala.Function0;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.Nothing$;

@DescribeProcess(title="GeoMesa Build Replay From KafkaDataStore", description="Builds a replay layer from a defined window of time on a KafkaDataStore", version="1.0.0")
@ScalaSignature(bytes="\u0006\u0001\u0005Mf\u0001B\u0001\u0003\u00015\u00111DU3qY\u0006L8*\u00194lC\u0012\u000bG/Y*u_J,\u0007K]8dKN\u001c(BA\u0002\u0005\u0003\u001dY\u0017MZ6bcAR!!\u0002\u0004\u0002\u0007]\u00048O\u0003\u0002\b\u0011\u0005\u0011qm\u001d\u0006\u0003\u0013)\tqaZ3p[\u0016\u001c\u0018MC\u0001\f\u0003\ry'oZ\u0002\u0001'\u0011\u0001aB\u0006\u000e\u0011\u0005=!R\"\u0001\t\u000b\u0005E\u0011\u0012\u0001\u00027b]\u001eT\u0011aE\u0001\u0005U\u00064\u0018-\u0003\u0002\u0016!\t1qJ\u00196fGR\u0004\"a\u0006\r\u000e\u0003\tI!!\u0007\u0002\u0003'\u001d+w.\\3tC.\u000bgm[1Qe>\u001cWm]:\u0011\u0005m\u0011S\"\u0001\u000f\u000b\u0005uq\u0012\u0001D:dC2\fGn\\4hS:<'BA\u0010!\u0003!!\u0018\u0010]3tC\u001a,'\"A\u0011\u0002\u0007\r|W.\u0003\u0002$9\tYA*\u0019>z\u0019><w-\u001b8h\u0011!)\u0003A!b\u0001\n\u00031\u0013aB2bi\u0006dwnZ\u000b\u0002OA\u0011\u0001\u0006L\u0007\u0002S)\u0011QE\u000b\u0006\u0003W)\t\u0011bZ3pg\u0016\u0014h/\u001a:\n\u00055J#aB\"bi\u0006dwn\u001a\u0005\t_\u0001\u0011\t\u0011)A\u0005O\u0005A1-\u0019;bY><\u0007\u0005C\u00032\u0001\u0011\u0005!'\u0001\u0004=S:LGO\u0010\u000b\u0003gQ\u0002\"a\u0006\u0001\t\u000b\u0015\u0002\u0004\u0019A\u0014\t\u000bY\u0002A\u0011A\u001c\u0002\u000f\u0015DXmY;uKR1\u0001H\u0011+[M2\u0004\"!O \u000f\u0005ijT\"A\u001e\u000b\u0003q\nQa]2bY\u0006L!AP\u001e\u0002\rA\u0013X\rZ3g\u0013\t\u0001\u0015I\u0001\u0004TiJLgn\u001a\u0006\u0003}mBQaQ\u001bA\u0002a\n\u0011b^8sWN\u0004\u0018mY3)\r\t+u\nU)S!\t1U*D\u0001H\u0015\tA\u0015*A\u0004gC\u000e$xN]=\u000b\u0005)[\u0015a\u00029s_\u000e,7o\u001d\u0006\u0003\u0019*\t\u0001bZ3pi>|Gn]\u0005\u0003\u001d\u001e\u0013\u0011\u0003R3tGJL'-\u001a)be\u0006lW\r^3s\u0003\u0011q\u0017-\\3\"\u0003\r\u000b1\u0002Z3tGJL\u0007\u000f^5p]\u0006\n1+\u0001&X_J\\7\u000f]1dK\u0002\u001awN\u001c;bS:Lgn\u001a\u0011uQ\u0016\u0004C.\u001b<fA1\f\u00170\u001a:/A\u0001\"\u0006.\u001a\u0011sKBd\u0017-\u001f\u0011mCf,'\u000fI<jY2\u0004#-\u001a\u0011bI\u0012,G\r\t5fe\u0016t\u0003\"B+6\u0001\u0004A\u0014!\u00027bs\u0016\u0014\bF\u0002+F\u001f^\u000b\u0006,I\u0001VC\u0005I\u0016AE*pkJ\u001cW\r\t7jm\u0016\u0004C.Y=fe:BQaW\u001bA\u0002q\u000b\u0011b\u001d;beR$\u0016.\\3\u0011\u0005u\u0003W\"\u00010\u000b\u0005}\u0013\u0012\u0001B;uS2L!!\u00190\u0003\t\u0011\u000bG/\u001a\u0015\u00075\u0016{5-\u00153\"\u0003m\u000b\u0013!Z\u0001''R\f'\u000f\u001e\u0011US6,\u0007e\u001c4!i\",\u0007E]3qY\u0006L\be^5oI><\b\u0005K+U\u0007&r\u0003\"B46\u0001\u0004a\u0016aB3oIRKW.\u001a\u0015\u0007M\u0016{\u0015.\u00156\"\u0003\u001d\f\u0013a[\u0001%\u000b:$\u0007\u0005V5nK\u0002zg\r\t;iK\u0002\u0012X\r\u001d7bs\u0002:\u0018N\u001c3po\u0002BS\u000bV\"*]!)Q.\u000ea\u0001]\u0006Q!/Z1e\u0005\u0016D\u0017N\u001c3\u0011\u0005=y\u0017B\u00019\u0011\u0005\u0011auN\\4)\r1,uJ])tC\u0005i\u0017%\u0001;\u0002_QCW\rI1n_VtG\u000fI8gAQLW.\u001a\u0011u_\u0002\u0002(/Z\u0017sK\u0006$\u0007%\u001b8![&dG.[:fG>tGm\u001d\u0018)\rU2x*_)|!\t1u/\u0003\u0002y\u000f\nqA)Z:de&\u0014WMU3tk2$\u0018%\u0001>\u0002\rI,7/\u001e7uC\u0005a\u0018A\f(b[\u0016\u0004sN\u001a\u0011uQ\u0016\u0004C*Y=fe\u0002\u001a'/Z1uK\u0012\u0004cm\u001c:!i\",\u0007eS1gW\u0006\u0004s+\u001b8e_^DQA\u000e\u0001\u0005\u0002y$b\u0001O@\u0002\n\u0005M\u0001bBA\u0001{\u0002\u0007\u00111A\u0001\u000eo>\u00148n\u001d9bG\u0016LeNZ8\u0011\u0007!\n)!C\u0002\u0002\b%\u0012QbV8sWN\u0004\u0018mY3J]\u001a|\u0007bBA\u0006{\u0002\u0007\u0011QB\u0001\nY\u0006LXM]%oM>\u00042\u0001KA\b\u0013\r\t\t\"\u000b\u0002\n\u0019\u0006LXM]%oM>Dq!!\u0006~\u0001\u0004\t9\"\u0001\u0007sKBd\u0017-_\"p]\u001aLw\r\u0005\u0003\u0002\u001a\u0005\u0015RBAA\u000e\u0015\u0011\ti\"a\b\u0002\u000b-\fgm[1\u000b\u0007%\t\tCC\u0002\u0002$)\tA\u0002\\8dCRLwN\u001c;fG\"LA!a\n\u0002\u001c\ta!+\u001a9mCf\u001cuN\u001c4jO\"9\u00111\u0006\u0001\u0005\n\u00055\u0012\u0001E4fi^{'o[:qC\u000e,\u0017J\u001c4p)\u0011\t\u0019!a\f\t\u000f\u0005E\u0012\u0011\u0006a\u0001q\u0005iqo\u001c:lgB\f7-\u001a(b[\u0016Dq!!\u000e\u0001\t\u0013\t9$\u0001\u0007hKRd\u0015-_3s\u0013:4w\u000e\u0006\u0004\u0002\u000e\u0005e\u0012Q\b\u0005\t\u0003w\t\u0019\u00041\u0001\u0002\u0004\u0005\u0011q/\u001b\u0005\b\u0003\u007f\t\u0019\u00041\u00019\u0003%a\u0017-_3s\u001d\u0006lW\rC\u0004\u0002D\u0001!I!!\u0012\u0002\u001d\u001d,GOR3biV\u0014X-\u00138g_R!\u0011qIA'!\rA\u0013\u0011J\u0005\u0004\u0003\u0017J#a\u0004$fCR,(/\u001a+za\u0016LeNZ8\t\u0011\u0005=\u0013\u0011\ta\u0001\u0003\u001b\t!\u0001\\5\t\u000f\u0005M\u0003\u0001\"\u0003\u0002V\u0005y1M]3bi\u0016\u0014V\r\u001d7bsN3E\u000b\u0006\u0005\u0002X\u0005-\u0014QOAC!\u0011\tI&a\u001a\u000e\u0005\u0005m#\u0002BA/\u0003?\naa]5na2,'\u0002BA1\u0003G\nqAZ3biV\u0014XMC\u0002\u0002f)\tqa\u001c9f]\u001eL7/\u0003\u0003\u0002j\u0005m#!E*j[BdWMR3biV\u0014X\rV=qK\"A\u0011QNA)\u0001\u0004\ty'A\u0005ti>\u0014X-\u00138g_B\u0019\u0001&!\u001d\n\u0007\u0005M\u0014FA\u0007ECR\f7\u000b^8sK&sgm\u001c\u0005\t\u0003o\n\t\u00061\u0001\u0002z\u0005YA.\u001b<f'\u001a$h*Y7f!\u0011\tY(!!\u000e\u0005\u0005u$\u0002BA@\u0003?\nA\u0001^=qK&!\u00111QA?\u0005\u0011q\u0015-\\3\t\u0011\u0005\u001d\u0015\u0011\u000ba\u0001\u0003/\taaY8oM&<\u0007bBAF\u0001\u0011%\u0011QR\u0001\u000eG\",7m\u001b$pe2\u000b\u00170\u001a:\u0015\r\u0005=\u0015QSAL!\rQ\u0014\u0011S\u0005\u0004\u0003'[$a\u0002\"p_2,\u0017M\u001c\u0005\u0007\u0007\u0006%\u0005\u0019\u0001\u001d\t\u000f\u0005e\u0015\u0011\u0012a\u0001q\u0005Y1O\u001a;UsB,g*Y7fQ9\u0001\u0011QTAR\u0003K\u000b\u0016\u0011VAW\u0003_\u00032ARAP\u0013\r\t\tk\u0012\u0002\u0010\t\u0016\u001c8M]5cKB\u0013xnY3tg\u0006)A/\u001b;mK\u0006\u0012\u0011qU\u0001)\u000f\u0016|W*Z:bA\t+\u0018\u000e\u001c3!%\u0016\u0004H.Y=!\rJ|W\u000eI&bM.\fG)\u0019;b'R|'/Z\u0011\u0003\u0003W\u000bqIQ;jY\u0012\u001c\b%\u0019\u0011sKBd\u0017-\u001f\u0011mCf,'\u000f\t4s_6\u0004\u0013\r\t3fM&tW\r\u001a\u0011xS:$wn\u001e\u0011pM\u0002\"\u0018.\\3!_:\u0004\u0013\rI&bM.\fG)\u0019;b'R|'/Z\u0001\bm\u0016\u00148/[8oC\t\t\t,A\u00032]Ar\u0003\u0007")
public class ReplayKafkaDataStoreProcess
implements GeomesaKafkaProcess,
LazyLogging {
    private final Catalog catalog;
    private final Logger logger;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        ReplayKafkaDataStoreProcess replayKafkaDataStoreProcess = this;
        synchronized (replayKafkaDataStoreProcess) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public Catalog catalog() {
        return this.catalog;
    }

    @DescribeResult(name="result", description="Name of the Layer created for the Kafka Window")
    public String execute(@DescribeParameter(name="workspace", description="Workspace containing the live layer.  The replay layer will be added here.") String workspace, @DescribeParameter(name="layer", description="Source live layer.") String layer, @DescribeParameter(name="startTime", description="Start Time of the replay window (UTC).") Date startTime, @DescribeParameter(name="endTime", description="End Time of the replay window (UTC).") Date endTime, @DescribeParameter(name="readBehind", description="The amount of time to pre-read in milliseconds.") Long readBehind) {
        WorkspaceInfo workspaceInfo = this.getWorkspaceInfo(workspace);
        LayerInfo layerInfo = this.getLayerInfo(workspaceInfo, layer);
        ReplayConfig replayConfig = new ReplayConfig(new Instant(startTime.getTime()), new Instant(endTime.getTime()), Duration.millis((long)Predef$.MODULE$.Long2long(readBehind)));
        return this.execute(workspaceInfo, layerInfo, replayConfig);
    }

    public String execute(WorkspaceInfo workspaceInfo, LayerInfo layerInfo, ReplayConfig replayConfig) {
        FeatureTypeInfo featureInfo = this.getFeatureInfo(layerInfo);
        DataStoreInfo storeInfo = featureInfo.getStore();
        Name sftName = featureInfo.getQualifiedNativeName();
        SimpleFeatureType replaySFT = this.createReplaySFT(storeInfo, sftName, replayConfig);
        CatalogBuilder catalogBuilder = new CatalogBuilder(this.catalog());
        catalogBuilder.setWorkspace(workspaceInfo);
        catalogBuilder.setStore((StoreInfo)storeInfo);
        FeatureTypeInfo replayFeatureInfo = catalogBuilder.buildFeatureType(replaySFT.getName());
        catalogBuilder.setupBounds((ResourceInfo)replayFeatureInfo);
        LayerInfo replayLayerInfo = catalogBuilder.buildLayer(replayFeatureInfo);
        VolatileLayer$.MODULE$.injectMetadata(replayLayerInfo, replaySFT);
        this.catalog().add((ResourceInfo)replayFeatureInfo);
        this.catalog().add(replayLayerInfo);
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"created layer: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{replayLayerInfo.getName()}));
    }

    private WorkspaceInfo getWorkspaceInfo(String workspaceName) {
        return (WorkspaceInfo)Option$.MODULE$.apply((Object)this.catalog().getWorkspaceByName(workspaceName)).getOrElse((Function0)new Serializable(this, workspaceName){
            public static final long serialVersionUID = 0L;
            private final String workspaceName$1;

            public final Nothing$ apply() {
                throw new ProcessException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to find workspace ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.workspaceName$1})));
            }
            {
                this.workspaceName$1 = workspaceName$1;
            }
        });
    }

    private LayerInfo getLayerInfo(WorkspaceInfo wi, String layerName) {
        String workspaceName = wi.getName();
        return (LayerInfo)Option$.MODULE$.apply((Object)this.catalog().getLayerByName(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{workspaceName, layerName})))).getOrElse((Function0)new Serializable(this, layerName, workspaceName){
            public static final long serialVersionUID = 0L;
            private final String layerName$1;
            private final String workspaceName$2;

            public final Nothing$ apply() {
                throw new ProcessException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to find layer ", " in workspace ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.layerName$1, this.workspaceName$2})));
            }
            {
                this.layerName$1 = layerName$1;
                this.workspaceName$2 = workspaceName$2;
            }
        });
    }

    private FeatureTypeInfo getFeatureInfo(LayerInfo li) {
        return (FeatureTypeInfo)GeoServerUtils$.MODULE$.getFeatureTypeInfo(li).getOrElse((Function0)new Serializable(this, li){
            public static final long serialVersionUID = 0L;
            private final LayerInfo li$1;

            public final Nothing$ apply() {
                throw new ProcessException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to get feature info from layer ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.li$1.getName()})));
            }
            {
                this.li$1 = li$1;
            }
        });
    }

    private SimpleFeatureType createReplaySFT(DataStoreInfo storeInfo, Name liveSftName, ReplayConfig config) {
        DataStore ds = (DataStore)GeoServerUtils$.MODULE$.getDataStore(storeInfo).getOrElse((Function0)new Serializable(this, storeInfo){
            public static final long serialVersionUID = 0L;
            private final DataStoreInfo storeInfo$1;

            public final Nothing$ apply() {
                throw new ProcessException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Store '", "' is not a DataStore."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.storeInfo$1.getName()})));
            }
            {
                this.storeInfo$1 = storeInfo$1;
            }
        });
        SimpleFeatureType liveSFT = (SimpleFeatureType)ds.getSchema(liveSftName);
        SimpleFeatureType replaySFT = KafkaDataStoreHelper$.MODULE$.createReplaySFT(liveSFT, config);
        if (this.checkForLayer(storeInfo.getWorkspace().getName(), replaySFT.getTypeName())) {
            throw new ProcessException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Target layer already exists for SFT: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{replaySFT.getTypeName()})));
        }
        ds.createSchema((FeatureType)replaySFT);
        return (SimpleFeatureType)ds.getSchema(replaySFT.getName());
    }

    private boolean checkForLayer(String workspace, String sftTypeName) {
        String layerName = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{workspace, sftTypeName}));
        return this.catalog().getLayerByName(layerName) != null;
    }

    public ReplayKafkaDataStoreProcess(Catalog catalog) {
        this.catalog = catalog;
        LazyLogging.class.$init$((LazyLogging)this);
    }
}

