/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.cqengine.index.sqlite;

import com.googlecode.concurrenttrees.common.LazyIterator;
import com.googlecode.cqengine.attribute.Attribute;
import com.googlecode.cqengine.attribute.SimpleAttribute;
import com.googlecode.cqengine.attribute.SimpleNullableAttribute;
import com.googlecode.cqengine.index.Index;
import com.googlecode.cqengine.index.sqlite.ConnectionManager;
import com.googlecode.cqengine.index.sqlite.support.DBQueries;
import com.googlecode.cqengine.index.sqlite.support.DBUtils;
import com.googlecode.cqengine.index.sqlite.support.SQLiteIndexFlags;
import com.googlecode.cqengine.index.support.AbstractAttributeIndex;
import com.googlecode.cqengine.index.support.CloseableIterable;
import com.googlecode.cqengine.index.support.CloseableIterator;
import com.googlecode.cqengine.index.support.CloseableRequestResources;
import com.googlecode.cqengine.index.support.KeyStatistics;
import com.googlecode.cqengine.index.support.KeyValue;
import com.googlecode.cqengine.index.support.KeyValueMaterialized;
import com.googlecode.cqengine.index.support.LazyCloseableIterator;
import com.googlecode.cqengine.index.support.SortedKeyStatisticsAttributeIndex;
import com.googlecode.cqengine.index.support.indextype.NonHeapTypeIndex;
import com.googlecode.cqengine.persistence.support.ObjectSet;
import com.googlecode.cqengine.persistence.support.ObjectStore;
import com.googlecode.cqengine.query.Query;
import com.googlecode.cqengine.query.QueryFactory;
import com.googlecode.cqengine.query.option.FlagsEnabled;
import com.googlecode.cqengine.query.option.QueryOptions;
import com.googlecode.cqengine.query.simple.Between;
import com.googlecode.cqengine.query.simple.Equal;
import com.googlecode.cqengine.query.simple.FilterQuery;
import com.googlecode.cqengine.query.simple.GreaterThan;
import com.googlecode.cqengine.query.simple.Has;
import com.googlecode.cqengine.query.simple.In;
import com.googlecode.cqengine.query.simple.LessThan;
import com.googlecode.cqengine.query.simple.SimpleQuery;
import com.googlecode.cqengine.query.simple.StringStartsWith;
import com.googlecode.cqengine.resultset.ResultSet;
import com.googlecode.cqengine.resultset.iterator.IteratorUtil;
import com.googlecode.cqengine.resultset.iterator.UnmodifiableIterator;
import java.sql.Connection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.sqlite.SQLiteConfig;

public class SQLiteIndex<A extends Comparable<A>, O, K>
extends AbstractAttributeIndex<A, O>
implements SortedKeyStatisticsAttributeIndex<A, O>,
NonHeapTypeIndex {
    static final int INDEX_RETRIEVAL_COST = 80;
    static final int INDEX_RETRIEVAL_COST_FILTERING = 81;
    final String tableName;
    final SimpleAttribute<O, K> primaryKeyAttribute;
    final SimpleAttribute<K, O> foreignKeyAttribute;
    SQLiteConfig.SynchronousMode pragmaSynchronous;
    SQLiteConfig.JournalMode pragmaJournalMode;
    boolean canSuspendSyncAndJournaling;

    public SQLiteIndex(Attribute<O, A> attribute, SimpleAttribute<O, K> primaryKeyAttribute, SimpleAttribute<K, O> foreignKeyAttribute, String tableNameSuffix) {
        super(attribute, (Set<Class<? extends Query>>)new HashSet<Class<? extends Query>>(){
            {
                this.add(Equal.class);
                this.add(In.class);
                this.add(LessThan.class);
                this.add(GreaterThan.class);
                this.add(Between.class);
                this.add(StringStartsWith.class);
                this.add(Has.class);
            }
        });
        this.tableName = DBUtils.sanitizeForTableName(attribute.getAttributeName()) + tableNameSuffix;
        this.primaryKeyAttribute = primaryKeyAttribute;
        this.foreignKeyAttribute = foreignKeyAttribute;
    }

    @Override
    public boolean supportsQuery(Query<O> query, QueryOptions queryOptions) {
        return query instanceof FilterQuery || super.supportsQuery(query, queryOptions);
    }

    @Override
    public boolean isMutable() {
        return true;
    }

    @Override
    public boolean isQuantized() {
        return false;
    }

    @Override
    public Index<O> getEffectiveIndex() {
        return this;
    }

    @Override
    public ResultSet<O> retrieve(final Query<O> query, final QueryOptions queryOptions) {
        final ConnectionManager connectionManager = this.getConnectionManager(queryOptions);
        final CloseableRequestResources.CloseableResourceGroup closeableResourceGroup = CloseableRequestResources.forQueryOptions(queryOptions).addGroup();
        if (query instanceof FilterQuery) {
            final FilterQuery filterQuery = (FilterQuery)query;
            return new ResultSet<O>(){

                @Override
                public Iterator<O> iterator() {
                    Connection searchConnection = connectionManager.getConnection(SQLiteIndex.this, queryOptions);
                    final java.sql.ResultSet searchResultSet = DBQueries.getAllIndexEntries(SQLiteIndex.this.tableName, searchConnection);
                    closeableResourceGroup.add(DBUtils.wrapAsCloseable(searchResultSet));
                    return new LazyIterator<O>(){

                        protected O computeNext() {
                            try {
                                Object objectKey;
                                Comparable objectValue;
                                do {
                                    if (!searchResultSet.next()) {
                                        this.close();
                                        return this.endOfData();
                                    }
                                    objectKey = DBUtils.getValueFromResultSet(1, searchResultSet, SQLiteIndex.this.primaryKeyAttribute.getAttributeType());
                                } while (!filterQuery.matchesValue(objectValue = (Comparable)DBUtils.getValueFromResultSet(2, searchResultSet, SQLiteIndex.this.attribute.getAttributeType()), queryOptions));
                                return SQLiteIndex.this.foreignKeyAttribute.getValue(objectKey, queryOptions);
                            }
                            catch (Exception e) {
                                this.endOfData();
                                this.close();
                                throw new IllegalStateException("Unable to retrieve the ResultSet item.", e);
                            }
                        }
                    };
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public boolean contains(O object) {
                    boolean bl;
                    Connection connection = null;
                    java.sql.ResultSet searchResultSet = null;
                    try {
                        connection = connectionManager.getConnection(SQLiteIndex.this, queryOptions);
                        searchResultSet = DBQueries.getIndexEntryByObjectKey(SQLiteIndex.this.primaryKeyAttribute.getValue(object, queryOptions), SQLiteIndex.this.tableName, connection);
                        bl = this.lazyMatchingValuesIterable(searchResultSet).iterator().hasNext();
                    }
                    catch (Throwable throwable) {
                        DBUtils.closeQuietly(searchResultSet);
                        throw throwable;
                    }
                    DBUtils.closeQuietly(searchResultSet);
                    return bl;
                }

                @Override
                public boolean matches(O object) {
                    return query.matches(object, queryOptions);
                }

                @Override
                public Query<O> getQuery() {
                    return query;
                }

                @Override
                public QueryOptions getQueryOptions() {
                    return queryOptions;
                }

                @Override
                public int getRetrievalCost() {
                    return 81;
                }

                @Override
                public int getMergeCost() {
                    Connection connection = connectionManager.getConnection(SQLiteIndex.this, queryOptions);
                    return DBQueries.count(QueryFactory.has(SQLiteIndex.this.primaryKeyAttribute), SQLiteIndex.this.tableName, connection);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public int size() {
                    int n;
                    Connection connection = null;
                    java.sql.ResultSet searchResultSet = null;
                    try {
                        connection = connectionManager.getConnection(SQLiteIndex.this, queryOptions);
                        searchResultSet = DBQueries.getAllIndexEntries(SQLiteIndex.this.tableName, connection);
                        Iterable iterator = this.lazyMatchingValuesIterable(searchResultSet);
                        n = IteratorUtil.countElements(iterator);
                    }
                    catch (Throwable throwable) {
                        DBUtils.closeQuietly(searchResultSet);
                        throw throwable;
                    }
                    DBUtils.closeQuietly(searchResultSet);
                    return n;
                }

                @Override
                public void close() {
                    closeableResourceGroup.close();
                }

                Iterable<K> lazyMatchingValuesIterable(final java.sql.ResultSet searchResultSet) {
                    return new Iterable<K>(){

                        @Override
                        public Iterator<K> iterator() {
                            return new LazyIterator<K>(){
                                K currentKey = null;

                                protected K computeNext() {
                                    try {
                                        Comparable objectValue;
                                        Object objectKey;
                                        do {
                                            if (!searchResultSet.next()) {
                                                this.close();
                                                return this.endOfData();
                                            }
                                            objectKey = DBUtils.getValueFromResultSet(1, searchResultSet, SQLiteIndex.this.primaryKeyAttribute.getAttributeType());
                                        } while (this.currentKey != null && this.currentKey.equals(objectKey) || !filterQuery.matchesValue(objectValue = (Comparable)DBUtils.getValueFromResultSet(2, searchResultSet, SQLiteIndex.this.attribute.getAttributeType()), queryOptions));
                                        this.currentKey = objectKey;
                                        return objectKey;
                                    }
                                    catch (Exception e) {
                                        this.endOfData();
                                        this.close();
                                        throw new IllegalStateException("Unable to retrieve the ResultSet item.", e);
                                    }
                                }
                            };
                        }
                    };
                }
            };
        }
        return new ResultSet<O>(){

            @Override
            public Iterator<O> iterator() {
                Connection searchConnection = connectionManager.getConnection(SQLiteIndex.this, queryOptions);
                final java.sql.ResultSet searchResultSet = DBQueries.search(query, SQLiteIndex.this.tableName, searchConnection);
                closeableResourceGroup.add(DBUtils.wrapAsCloseable(searchResultSet));
                return new LazyIterator<O>(){

                    protected O computeNext() {
                        try {
                            if (!searchResultSet.next()) {
                                this.close();
                                return this.endOfData();
                            }
                            Object objectKey = DBUtils.getValueFromResultSet(1, searchResultSet, SQLiteIndex.this.primaryKeyAttribute.getAttributeType());
                            return SQLiteIndex.this.foreignKeyAttribute.getValue(objectKey, queryOptions);
                        }
                        catch (Exception e) {
                            this.endOfData();
                            this.close();
                            throw new IllegalStateException("Unable to retrieve the ResultSet item.", e);
                        }
                    }
                };
            }

            @Override
            public int getRetrievalCost() {
                return 80;
            }

            @Override
            public int getMergeCost() {
                Connection connection = connectionManager.getConnection(SQLiteIndex.this, queryOptions);
                return DBQueries.count(query, SQLiteIndex.this.tableName, connection);
            }

            @Override
            public boolean contains(O object) {
                Object objectKey = SQLiteIndex.this.primaryKeyAttribute.getValue(object, queryOptions);
                Connection connection = connectionManager.getConnection(SQLiteIndex.this, queryOptions);
                return DBQueries.contains(objectKey, query, SQLiteIndex.this.tableName, connection);
            }

            @Override
            public boolean matches(O object) {
                return query.matches(object, queryOptions);
            }

            @Override
            public int size() {
                boolean queryIsADisjointInQuery;
                Connection connection = connectionManager.getConnection(SQLiteIndex.this, queryOptions);
                boolean attributeHasAtMostOneValue = SQLiteIndex.this.attribute instanceof SimpleAttribute || SQLiteIndex.this.attribute instanceof SimpleNullableAttribute;
                boolean bl = queryIsADisjointInQuery = query instanceof In && ((In)query).isDisjoint();
                if (queryIsADisjointInQuery || attributeHasAtMostOneValue) {
                    return DBQueries.count(query, SQLiteIndex.this.tableName, connection);
                }
                return DBQueries.countDistinct(query, SQLiteIndex.this.tableName, connection);
            }

            @Override
            public void close() {
                closeableResourceGroup.close();
            }

            @Override
            public Query<O> getQuery() {
                return query;
            }

            @Override
            public QueryOptions getQueryOptions() {
                return queryOptions;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(ObjectSet<O> objectSet, QueryOptions queryOptions) {
        try {
            ConnectionManager connectionManager = this.getConnectionManager(queryOptions);
            if (!connectionManager.isApplyUpdateForIndexEnabled(this)) {
                boolean bl = false;
                return bl;
            }
            Connection connection = connectionManager.getConnection(this, queryOptions);
            DBQueries.createIndexTable(this.tableName, this.primaryKeyAttribute.getAttributeType(), this.getAttribute().getAttributeType(), connection);
            SQLiteIndexFlags.BulkImportExternallyManged bulkImportExternallyManged = queryOptions.get(SQLiteIndexFlags.BulkImportExternallyManged.class);
            boolean isBulkImport = bulkImportExternallyManged == null && FlagsEnabled.isFlagEnabled(queryOptions, SQLiteIndexFlags.BULK_IMPORT);
            boolean isSuspendSyncAndJournaling = FlagsEnabled.isFlagEnabled(queryOptions, SQLiteIndexFlags.BULK_IMPORT_SUSPEND_SYNC_AND_JOURNALING);
            if ((bulkImportExternallyManged != null || isBulkImport) && !objectSet.isEmpty()) {
                DBQueries.dropIndexOnTable(this.tableName, connection);
                if (isSuspendSyncAndJournaling) {
                    if (!this.canSuspendSyncAndJournaling) {
                        throw new IllegalStateException("Cannot suspend sync and journaling because it was not possible to read the original 'synchronous' and 'journal_mode' pragmas during the index initialization.");
                    }
                    DBQueries.suspendSyncAndJournaling(connection);
                }
            } else {
                DBQueries.createIndexOnTable(this.tableName, connection);
            }
            Iterable rows = SQLiteIndex.rowIterable(objectSet, this.primaryKeyAttribute, this.getAttribute(), queryOptions);
            int rowsModified = DBQueries.bulkAdd(rows, this.tableName, connection);
            if (isBulkImport || bulkImportExternallyManged != null && SQLiteIndexFlags.BulkImportExternallyManged.LAST.equals((Object)bulkImportExternallyManged)) {
                DBQueries.createIndexOnTable(this.tableName, connection);
                if (isSuspendSyncAndJournaling) {
                    DBQueries.setSyncAndJournaling(connection, this.pragmaSynchronous, this.pragmaJournalMode);
                }
            }
            boolean bl = rowsModified > 0;
            return bl;
        }
        finally {
            objectSet.close();
        }
    }

    static <O, K, A> Iterable<DBQueries.Row<K, A>> rowIterable(final Iterable<O> objects, final SimpleAttribute<O, K> primaryKeyAttribute, final Attribute<O, A> indexAttribute, final QueryOptions queryOptions) {
        return new Iterable<DBQueries.Row<K, A>>(){

            @Override
            public Iterator<DBQueries.Row<K, A>> iterator() {
                return new LazyIterator<DBQueries.Row<K, A>>(){
                    final Iterator<O> objectIterator;
                    Iterator<A> valuesIterator;
                    K currentObjectKey;
                    DBQueries.Row<K, A> next;
                    {
                        this.objectIterator = objects.iterator();
                        this.valuesIterator = null;
                    }

                    protected DBQueries.Row<K, A> computeNext() {
                        while (this.computeNextOrNull()) {
                            if (this.next == null) continue;
                            return this.next;
                        }
                        return (DBQueries.Row)this.endOfData();
                    }

                    boolean computeNextOrNull() {
                        if (this.valuesIterator == null || !this.valuesIterator.hasNext()) {
                            if (this.objectIterator.hasNext()) {
                                Object next = this.objectIterator.next();
                                this.currentObjectKey = primaryKeyAttribute.getValue(next, queryOptions);
                                this.valuesIterator = indexAttribute.getValues(next, queryOptions).iterator();
                            } else {
                                return false;
                            }
                        }
                        if (this.valuesIterator.hasNext()) {
                            this.next = new DBQueries.Row(this.currentObjectKey, this.valuesIterator.next());
                            return true;
                        }
                        this.next = null;
                        return true;
                    }
                };
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAll(ObjectSet<O> objectSet, QueryOptions queryOptions) {
        try {
            boolean isBulkImport;
            ConnectionManager connectionManager = this.getConnectionManager(queryOptions);
            if (!connectionManager.isApplyUpdateForIndexEnabled(this)) {
                boolean bl = false;
                return bl;
            }
            Connection connection = connectionManager.getConnection(this, queryOptions);
            boolean bl = isBulkImport = queryOptions.get(SQLiteIndexFlags.BulkImportExternallyManged.class) != null || FlagsEnabled.isFlagEnabled(queryOptions, SQLiteIndexFlags.BULK_IMPORT);
            if (isBulkImport) {
                DBQueries.createIndexTable(this.tableName, this.primaryKeyAttribute.getAttributeType(), this.getAttribute().getAttributeType(), connection);
            } else {
                this.createTableIndexIfNeeded(connection);
            }
            Iterable<K> objectKeys = SQLiteIndex.objectKeyIterable(objectSet, this.primaryKeyAttribute, queryOptions);
            int rowsModified = DBQueries.bulkRemove(objectKeys, this.tableName, connection);
            boolean bl2 = rowsModified > 0;
            return bl2;
        }
        finally {
            objectSet.close();
        }
    }

    static <O, K> Iterable<K> objectKeyIterable(final Iterable<O> objects, final SimpleAttribute<O, K> primaryKeyAttribute, final QueryOptions queryOptions) {
        return new Iterable<K>(){

            @Override
            public Iterator<K> iterator() {
                return new UnmodifiableIterator<K>(){
                    final Iterator<O> iterator;
                    {
                        this.iterator = objects.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iterator.hasNext();
                    }

                    @Override
                    public K next() {
                        Object next = this.iterator.next();
                        return primaryKeyAttribute.getValue(next, queryOptions);
                    }
                };
            }
        };
    }

    @Override
    public void clear(QueryOptions queryOptions) {
        ConnectionManager connectionManager = this.getConnectionManager(queryOptions);
        if (!connectionManager.isApplyUpdateForIndexEnabled(this)) {
            return;
        }
        Connection connection = connectionManager.getConnection(this, queryOptions);
        this.createTableIndexIfNeeded(connection);
        DBQueries.clearIndexTable(this.tableName, connection);
    }

    @Override
    public void init(ObjectStore<O> objectStore, QueryOptions queryOptions) {
        ConnectionManager connectionManager = this.getConnectionManager(queryOptions);
        Connection connection = connectionManager.getConnection(this, queryOptions);
        this.pragmaJournalMode = DBQueries.getPragmaJournalModeOrNull(connection);
        this.pragmaSynchronous = DBQueries.getPragmaSynchronousOrNull(connection);
        this.canSuspendSyncAndJournaling = this.pragmaJournalMode != null && this.pragmaSynchronous != null;
        this.addAll(ObjectSet.fromObjectStore(objectStore, queryOptions), queryOptions);
    }

    void createTableIndexIfNeeded(Connection connection) {
        DBQueries.createIndexTable(this.tableName, this.primaryKeyAttribute.getAttributeType(), this.getAttribute().getAttributeType(), connection);
        DBQueries.createIndexOnTable(this.tableName, connection);
    }

    ConnectionManager getConnectionManager(QueryOptions queryOptions) {
        ConnectionManager connectionManager = queryOptions.get(ConnectionManager.class);
        if (connectionManager == null) {
            throw new IllegalStateException("A ConnectionManager is required but was not provided in the QueryOptions.");
        }
        return connectionManager;
    }

    @Override
    public CloseableIterable<A> getDistinctKeys(QueryOptions queryOptions) {
        return this.getDistinctKeys(null, true, null, true, queryOptions);
    }

    @Override
    public CloseableIterable<A> getDistinctKeys(A lowerBound, boolean lowerInclusive, A upperBound, boolean upperInclusive, QueryOptions queryOptions) {
        return this.getDistinctKeysInRange(lowerBound, lowerInclusive, upperBound, upperInclusive, false, queryOptions);
    }

    @Override
    public CloseableIterable<A> getDistinctKeysDescending(QueryOptions queryOptions) {
        return this.getDistinctKeysDescending(null, true, null, true, queryOptions);
    }

    @Override
    public CloseableIterable<A> getDistinctKeysDescending(A lowerBound, boolean lowerInclusive, A upperBound, boolean upperInclusive, QueryOptions queryOptions) {
        return this.getDistinctKeysInRange(lowerBound, lowerInclusive, upperBound, upperInclusive, true, queryOptions);
    }

    @Override
    public Integer getCountOfDistinctKeys(QueryOptions queryOptions) {
        ConnectionManager connectionManager = this.getConnectionManager(queryOptions);
        Connection connection = connectionManager.getConnection(this, queryOptions);
        return DBQueries.getCountOfDistinctKeys(this.tableName, connection);
    }

    @Override
    public CloseableIterable<KeyStatistics<A>> getStatisticsForDistinctKeysDescending(QueryOptions queryOptions) {
        return this.getStatisticsForDistinctKeys(queryOptions, true);
    }

    @Override
    public CloseableIterable<KeyStatistics<A>> getStatisticsForDistinctKeys(QueryOptions queryOptions) {
        return this.getStatisticsForDistinctKeys(queryOptions, false);
    }

    CloseableIterable<KeyStatistics<A>> getStatisticsForDistinctKeys(final QueryOptions queryOptions, final boolean sortByKeyDescending) {
        final CloseableRequestResources.CloseableResourceGroup closeableResourceGroup = CloseableRequestResources.forQueryOptions(queryOptions).addGroup();
        return new CloseableIterable<KeyStatistics<A>>(){

            @Override
            public CloseableIterator<KeyStatistics<A>> iterator() {
                ConnectionManager connectionManager = SQLiteIndex.this.getConnectionManager(queryOptions);
                Connection connection = connectionManager.getConnection(SQLiteIndex.this, queryOptions);
                final java.sql.ResultSet resultSet = DBQueries.getDistinctKeysAndCounts(sortByKeyDescending, SQLiteIndex.this.tableName, connection);
                closeableResourceGroup.add(DBUtils.wrapAsCloseable(resultSet));
                return new LazyCloseableIterator<KeyStatistics<A>>(){

                    protected KeyStatistics<A> computeNext() {
                        try {
                            if (!resultSet.next()) {
                                this.close();
                                return (KeyStatistics)this.endOfData();
                            }
                            Comparable key = (Comparable)DBUtils.getValueFromResultSet(1, resultSet, SQLiteIndex.this.attribute.getAttributeType());
                            Integer count = DBUtils.getValueFromResultSet(2, resultSet, Integer.class);
                            return new KeyStatistics<Comparable>(key, count);
                        }
                        catch (Exception e) {
                            this.endOfData();
                            this.close();
                            throw new IllegalStateException("Unable to retrieve the ResultSet item.", e);
                        }
                    }

                    @Override
                    public void close() {
                        closeableResourceGroup.close();
                    }
                };
            }
        };
    }

    CloseableIterable<A> getDistinctKeysInRange(A lowerBound, boolean lowerInclusive, A upperBound, boolean upperInclusive, final boolean descending, final QueryOptions queryOptions) {
        final Query<O> query = this.getKeyRangeRestriction(lowerBound, lowerInclusive, upperBound, upperInclusive);
        final CloseableRequestResources.CloseableResourceGroup closeableResourceGroup = CloseableRequestResources.forQueryOptions(queryOptions).addGroup();
        return new CloseableIterable<A>(){

            @Override
            public CloseableIterator<A> iterator() {
                ConnectionManager connectionManager = SQLiteIndex.this.getConnectionManager(queryOptions);
                Connection searchConnection = connectionManager.getConnection(SQLiteIndex.this, queryOptions);
                final java.sql.ResultSet searchResultSet = DBQueries.getDistinctKeys(query, descending, SQLiteIndex.this.tableName, searchConnection);
                closeableResourceGroup.add(DBUtils.wrapAsCloseable(searchResultSet));
                return new LazyCloseableIterator<A>(){

                    protected A computeNext() {
                        try {
                            if (!searchResultSet.next()) {
                                this.close();
                                return (Comparable)this.endOfData();
                            }
                            return (Comparable)DBUtils.getValueFromResultSet(1, searchResultSet, SQLiteIndex.this.attribute.getAttributeType());
                        }
                        catch (Exception e) {
                            this.endOfData();
                            this.close();
                            throw new IllegalStateException("Unable to retrieve the ResultSet item.", e);
                        }
                    }

                    @Override
                    public void close() {
                        closeableResourceGroup.close();
                    }
                };
            }
        };
    }

    @Override
    public CloseableIterable<KeyValue<A, O>> getKeysAndValues(QueryOptions queryOptions) {
        return this.getKeysAndValues(null, true, null, true, queryOptions);
    }

    @Override
    public CloseableIterable<KeyValue<A, O>> getKeysAndValues(A lowerBound, boolean lowerInclusive, A upperBound, boolean upperInclusive, QueryOptions queryOptions) {
        return this.getKeysAndValuesInRange(lowerBound, lowerInclusive, upperBound, upperInclusive, false, queryOptions);
    }

    @Override
    public CloseableIterable<KeyValue<A, O>> getKeysAndValuesDescending(QueryOptions queryOptions) {
        return this.getKeysAndValuesDescending(null, true, null, true, queryOptions);
    }

    @Override
    public CloseableIterable<KeyValue<A, O>> getKeysAndValuesDescending(A lowerBound, boolean lowerInclusive, A upperBound, boolean upperInclusive, QueryOptions queryOptions) {
        return this.getKeysAndValuesInRange(lowerBound, lowerInclusive, upperBound, upperInclusive, true, queryOptions);
    }

    CloseableIterable<KeyValue<A, O>> getKeysAndValuesInRange(A lowerBound, boolean lowerInclusive, A upperBound, boolean upperInclusive, final boolean descending, final QueryOptions queryOptions) {
        final Query<O> query = this.getKeyRangeRestriction(lowerBound, lowerInclusive, upperBound, upperInclusive);
        final CloseableRequestResources.CloseableResourceGroup closeableResourceGroup = CloseableRequestResources.forQueryOptions(queryOptions).addGroup();
        return new CloseableIterable<KeyValue<A, O>>(){

            @Override
            public CloseableIterator<KeyValue<A, O>> iterator() {
                ConnectionManager connectionManager = SQLiteIndex.this.getConnectionManager(queryOptions);
                Connection searchConnection = connectionManager.getConnection(SQLiteIndex.this, queryOptions);
                final java.sql.ResultSet searchResultSet = DBQueries.getKeysAndValues(query, descending, SQLiteIndex.this.tableName, searchConnection);
                closeableResourceGroup.add(DBUtils.wrapAsCloseable(searchResultSet));
                return new LazyCloseableIterator<KeyValue<A, O>>(){

                    protected KeyValue<A, O> computeNext() {
                        try {
                            if (!searchResultSet.next()) {
                                this.close();
                                return (KeyValue)this.endOfData();
                            }
                            Object objectKey = DBUtils.getValueFromResultSet(1, searchResultSet, SQLiteIndex.this.primaryKeyAttribute.getAttributeType());
                            Comparable objectValue = (Comparable)DBUtils.getValueFromResultSet(2, searchResultSet, SQLiteIndex.this.attribute.getAttributeType());
                            Object object = SQLiteIndex.this.foreignKeyAttribute.getValue(objectKey, queryOptions);
                            return new KeyValueMaterialized(objectValue, object);
                        }
                        catch (Exception e) {
                            this.endOfData();
                            this.close();
                            throw new IllegalStateException("Unable to retrieve the ResultSet item.", e);
                        }
                    }

                    @Override
                    public void close() {
                        closeableResourceGroup.close();
                    }
                };
            }
        };
    }

    Query<O> getKeyRangeRestriction(A lowerBound, boolean lowerInclusive, A upperBound, boolean upperInclusive) {
        SimpleQuery query = lowerBound != null && upperBound != null ? QueryFactory.between(this.attribute, lowerBound, lowerInclusive, upperBound, upperInclusive) : (lowerBound != null ? (lowerInclusive ? QueryFactory.greaterThanOrEqualTo(this.attribute, lowerBound) : QueryFactory.greaterThan(this.attribute, lowerBound)) : (upperBound != null ? (upperInclusive ? QueryFactory.lessThanOrEqualTo(this.attribute, upperBound) : QueryFactory.lessThan(this.attribute, upperBound)) : QueryFactory.has(this.attribute)));
        return query;
    }

    @Override
    public Integer getCountForKey(A key, QueryOptions queryOptions) {
        return this.retrieve(QueryFactory.equal(this.attribute, key), queryOptions).size();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SQLiteIndex that = (SQLiteIndex)o;
        return this.attribute.equals(that.attribute);
    }

    @Override
    public int hashCode() {
        int result = this.getClass().hashCode();
        result = 31 * result + this.attribute.hashCode();
        return result;
    }

    public static <A extends Comparable<A>, O, K> SQLiteIndex<A, O, K> onAttribute(Attribute<O, A> attribute, SimpleAttribute<O, K> objectKeyAttribute, SimpleAttribute<K, O> foreignKeyAttribute) {
        return new SQLiteIndex<A, O, K>(attribute, objectKeyAttribute, foreignKeyAttribute, "");
    }
}

