/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.cqengine.index.sqlite.support;

import com.googlecode.concurrenttrees.common.CharSequences;
import com.googlecode.cqengine.index.sqlite.support.DBUtils;
import com.googlecode.cqengine.query.Query;
import com.googlecode.cqengine.query.simple.Between;
import com.googlecode.cqengine.query.simple.Equal;
import com.googlecode.cqengine.query.simple.GreaterThan;
import com.googlecode.cqengine.query.simple.Has;
import com.googlecode.cqengine.query.simple.In;
import com.googlecode.cqengine.query.simple.LessThan;
import com.googlecode.cqengine.query.simple.StringStartsWith;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.sqlite.SQLiteConfig;

public class DBQueries {
    public static <K, A> void createIndexTable(String tableName, Class<K> objectKeyClass, Class<A> valueClass, Connection connection) {
        String objectKeySQLiteType = DBUtils.getDBTypeForClass(objectKeyClass);
        String objectValueSQLiteType = DBUtils.getDBTypeForClass(valueClass);
        String sqlCreateTable = String.format("CREATE TABLE IF NOT EXISTS cqtbl_%s (objectKey %s, value %s, PRIMARY KEY (objectKey, value)) WITHOUT ROWID;", tableName, objectKeySQLiteType, objectValueSQLiteType);
        Statement statement = null;
        try {
            statement = connection.createStatement();
            statement.executeUpdate(sqlCreateTable);
        }
        catch (SQLException e) {
            throw new IllegalStateException("Unable to create index table: " + tableName, e);
        }
        finally {
            DBUtils.closeQuietly(statement);
        }
    }

    public static void createIndexOnTable(String tableName, Connection connection) {
        String sqlCreateIndex = String.format("CREATE INDEX IF NOT EXISTS cqidx_%s_value ON cqtbl_%s (value);", tableName, tableName);
        Statement statement = null;
        try {
            statement = connection.createStatement();
            statement.executeUpdate(sqlCreateIndex);
        }
        catch (SQLException e) {
            throw new IllegalStateException("Unable to add index on table: " + tableName, e);
        }
        finally {
            DBUtils.closeQuietly(statement);
        }
    }

    public static void suspendSyncAndJournaling(Connection connection) {
        DBQueries.setSyncAndJournaling(connection, SQLiteConfig.SynchronousMode.OFF, SQLiteConfig.JournalMode.OFF);
    }

    public static void setSyncAndJournaling(Connection connection, SQLiteConfig.SynchronousMode pragmaSynchronous, SQLiteConfig.JournalMode pragmaJournalMode) {
        Statement statement = null;
        try {
            boolean autoCommit = DBUtils.setAutoCommit(connection, true);
            statement = connection.createStatement();
            statement.execute("PRAGMA synchronous = " + pragmaSynchronous.getValue());
            statement.execute("PRAGMA journal_mode = " + pragmaJournalMode.getValue());
            DBUtils.setAutoCommit(connection, autoCommit);
        }
        catch (SQLException e) {
            try {
                throw new IllegalStateException("Unable to set the 'synchronous' and 'journal_mode' pragmas", e);
            }
            catch (Throwable throwable) {
                DBUtils.closeQuietly(statement);
                throw throwable;
            }
        }
        DBUtils.closeQuietly(statement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SQLiteConfig.SynchronousMode getPragmaSynchronousOrNull(Connection connection) {
        Statement statement = null;
        try {
            statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery("PRAGMA synchronous;");
            if (resultSet.next()) {
                int syncPragmaId = resultSet.getInt(1);
                if (!resultSet.wasNull()) {
                    switch (syncPragmaId) {
                        case 0: {
                            SQLiteConfig.SynchronousMode synchronousMode = SQLiteConfig.SynchronousMode.OFF;
                            return synchronousMode;
                        }
                        case 1: {
                            SQLiteConfig.SynchronousMode synchronousMode = SQLiteConfig.SynchronousMode.NORMAL;
                            return synchronousMode;
                        }
                        case 2: {
                            SQLiteConfig.SynchronousMode synchronousMode = SQLiteConfig.SynchronousMode.FULL;
                            return synchronousMode;
                        }
                    }
                    SQLiteConfig.SynchronousMode synchronousMode = null;
                    return synchronousMode;
                }
            }
            SQLiteConfig.SynchronousMode synchronousMode = null;
            return synchronousMode;
        }
        catch (Exception e) {
            SQLiteConfig.SynchronousMode synchronousMode = null;
            return synchronousMode;
        }
        finally {
            DBUtils.closeQuietly(statement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SQLiteConfig.JournalMode getPragmaJournalModeOrNull(Connection connection) {
        Statement statement = null;
        try {
            statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery("PRAGMA journal_mode;");
            if (resultSet.next()) {
                String journalMode = resultSet.getString(1);
                SQLiteConfig.JournalMode journalMode2 = journalMode != null ? SQLiteConfig.JournalMode.valueOf((String)journalMode.toUpperCase()) : null;
                return journalMode2;
            }
            SQLiteConfig.JournalMode journalMode = null;
            return journalMode;
        }
        catch (Exception e) {
            SQLiteConfig.JournalMode journalMode = null;
            return journalMode;
        }
        finally {
            DBUtils.closeQuietly(statement);
        }
    }

    public static void dropIndexOnTable(String tableName, Connection connection) {
        String sqlDropIndex = String.format("DROP INDEX IF EXISTS cqidx_%s_value;", tableName);
        Statement statement = null;
        try {
            statement = connection.createStatement();
            statement.executeUpdate(sqlDropIndex);
        }
        catch (SQLException e) {
            throw new IllegalStateException("Unable to drop index on table: " + tableName, e);
        }
        finally {
            DBUtils.closeQuietly(statement);
        }
    }

    public static void dropIndexTable(String tableName, Connection connection) {
        String sqlDropIndex = String.format("DROP INDEX IF EXISTS cqidx_%s_value;", tableName);
        String sqlDropTable = String.format("DROP TABLE IF EXISTS cqtbl_%s;", tableName);
        Statement statement = null;
        try {
            statement = connection.createStatement();
            statement.executeUpdate(sqlDropIndex);
            statement.executeUpdate(sqlDropTable);
        }
        catch (SQLException e) {
            throw new IllegalStateException("Unable to drop index table: " + tableName, e);
        }
        finally {
            DBUtils.closeQuietly(statement);
        }
    }

    public static void clearIndexTable(String tableName, Connection connection) {
        String clearTable = String.format("DELETE FROM cqtbl_%s;", tableName);
        Statement statement = null;
        try {
            statement = connection.createStatement();
            statement.executeUpdate(clearTable);
        }
        catch (SQLException e) {
            throw new IllegalStateException("Unable to clear index table: " + tableName, e);
        }
        finally {
            DBUtils.closeQuietly(statement);
        }
    }

    public static void compactDatabase(Connection connection) {
        Statement statement = null;
        try {
            statement = connection.createStatement();
            statement.execute("VACUUM;");
        }
        catch (SQLException e) {
            throw new IllegalStateException("Unable to compact database", e);
        }
        finally {
            DBUtils.closeQuietly(statement);
        }
    }

    public static void expandDatabase(Connection connection, long numBytes) {
        Statement statement = null;
        try {
            statement = connection.createStatement();
            statement.execute("CREATE TABLE IF NOT EXISTS cq_expansion (val);");
            statement.execute("INSERT INTO cq_expansion VALUES (zeroblob(" + numBytes + "));");
            statement.execute("DROP TABLE cq_expansion;");
        }
        catch (SQLException e) {
            throw new IllegalStateException("Unable to expand database by bytes: " + numBytes, e);
        }
        finally {
            DBUtils.closeQuietly(statement);
        }
    }

    public static long getDatabaseSize(Connection connection) {
        long pageCount = DBQueries.readPragmaLong(connection, "PRAGMA page_count;");
        long pageSize = DBQueries.readPragmaLong(connection, "PRAGMA page_size;");
        return pageCount * pageSize;
    }

    static long readPragmaLong(Connection connection, String query) {
        Statement statement = null;
        try {
            statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery(query);
            if (!resultSet.next()) {
                throw new IllegalStateException("Unable to read long from pragma query. The ResultSet returned no row. Query: " + query);
            }
            long l = resultSet.getLong(1);
            return l;
        }
        catch (SQLException e) {
            throw new IllegalStateException("Unable to read long from pragma query", e);
        }
        finally {
            DBUtils.closeQuietly(statement);
        }
    }

    public static <K, A> int bulkAdd(Iterable<Row<K, A>> rows, String tableName, Connection connection) {
        String sql = String.format("INSERT OR IGNORE INTO cqtbl_%s values(?, ?);", tableName);
        PreparedStatement statement = null;
        int totalRowsModified = 0;
        try {
            int[] rowsModified;
            statement = connection.prepareStatement(sql);
            for (Row<K, A> row : rows) {
                statement.setObject(1, row.getObjectKey());
                statement.setObject(2, row.getValue());
                statement.addBatch();
            }
            for (int m : rowsModified = statement.executeBatch()) {
                DBQueries.ensureNotNegative(m);
                totalRowsModified += m;
            }
            int n = totalRowsModified;
            return n;
        }
        catch (NullPointerException e) {
            boolean bl = DBUtils.rollback(connection);
            NullPointerException npe = new NullPointerException("Unable to bulk add rows containing a null object to the index table: " + tableName + ". Rolled back: " + bl);
            npe.initCause(e);
            throw npe;
        }
        catch (Exception e) {
            boolean bl = DBUtils.rollback(connection);
            throw new IllegalStateException("Unable to bulk add rows to the index table: " + tableName + ". Rolled back: " + bl, e);
        }
        finally {
            DBUtils.closeQuietly(statement);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <K> int bulkRemove(Iterable<K> objectKeys, String tableName, Connection connection) {
        int n;
        String sql = String.format("DELETE FROM cqtbl_%s WHERE objectKey = ?;", tableName);
        PreparedStatement statement = null;
        Boolean previousAutocommit = null;
        int totalRowsModified = 0;
        try {
            int m;
            int[] rowsModified;
            previousAutocommit = DBUtils.setAutoCommit(connection, false);
            statement = connection.prepareStatement(sql);
            for (K k : objectKeys) {
                statement.setObject(1, k);
                statement.addBatch();
            }
            int[] nArray = rowsModified = statement.executeBatch();
            int n2 = nArray.length;
            for (int i = 0; i < n2; totalRowsModified += m, ++i) {
                m = nArray[i];
                DBQueries.ensureNotNegative(m);
            }
            DBUtils.commit(connection);
            n = totalRowsModified;
        }
        catch (NullPointerException e) {
            try {
                boolean bl = DBUtils.rollback(connection);
                NullPointerException npe = new NullPointerException("Unable to bulk remove rows containing a null object from the index table: " + tableName + ". Rolled back: " + bl);
                npe.initCause(e);
                throw npe;
                catch (Exception e2) {
                    boolean bl2 = DBUtils.rollback(connection);
                    throw new IllegalStateException("Unable to remove rows from the index table: " + tableName + ". Rolled back: " + bl2, e2);
                }
            }
            catch (Throwable throwable) {
                DBUtils.closeQuietly(statement);
                if (previousAutocommit != null) {
                    DBUtils.setAutoCommit(connection, previousAutocommit);
                }
                throw throwable;
            }
        }
        DBUtils.closeQuietly(statement);
        if (previousAutocommit != null) {
            DBUtils.setAutoCommit(connection, previousAutocommit);
        }
        return n;
    }

    static <O, A> PreparedStatement createAndBindSelectPreparedStatement(String selectPrefix, String groupingAndSorting, List<WhereClause> additionalWhereClauses, Query<O> query, Connection connection) throws SQLException {
        PreparedStatement statement;
        int bindingIndex = 1;
        StringBuilder stringBuilder = new StringBuilder(selectPrefix).append(' ');
        StringBuilder suffix = new StringBuilder();
        Class<?> queryClass = query.getClass();
        if (queryClass == Has.class) {
            if (additionalWhereClauses.isEmpty()) {
                suffix.append(groupingAndSorting);
                suffix.append(';');
            } else {
                stringBuilder.append("WHERE ");
                Iterator<WhereClause> iterator = additionalWhereClauses.iterator();
                while (iterator.hasNext()) {
                    WhereClause additionalWhereClause = iterator.next();
                    suffix.append(additionalWhereClause.whereClause);
                    if (!iterator.hasNext()) continue;
                    suffix.append(" AND ");
                }
                suffix.append(groupingAndSorting);
                suffix.append(';');
            }
            stringBuilder.append((CharSequence)suffix);
            statement = connection.prepareStatement(stringBuilder.toString());
        } else {
            if (additionalWhereClauses.isEmpty()) {
                suffix.append(groupingAndSorting);
                suffix.append(';');
            } else {
                for (WhereClause additionalWhereClause : additionalWhereClauses) {
                    suffix.append(" AND ").append(additionalWhereClause.whereClause);
                }
                suffix.append(groupingAndSorting);
                suffix.append(';');
            }
            if (queryClass == Equal.class) {
                Equal equal = (Equal)query;
                stringBuilder.append("WHERE value = ?").append((CharSequence)suffix);
                statement = connection.prepareStatement(stringBuilder.toString());
                DBUtils.setValueToPreparedStatement(bindingIndex++, statement, equal.getValue());
            } else if (queryClass == In.class) {
                In in = (In)query;
                Set values = in.getValues();
                stringBuilder.append("WHERE value IN ( ");
                for (int i = 0; i < values.size(); ++i) {
                    if (i > 0) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append("?");
                }
                stringBuilder.append(")").append((CharSequence)suffix);
                statement = connection.prepareStatement(stringBuilder.toString());
                bindingIndex = DBUtils.setValuesToPreparedStatement(bindingIndex, statement, values);
            } else if (queryClass == LessThan.class) {
                LessThan lessThan = (LessThan)query;
                boolean isValueInclusive = lessThan.isValueInclusive();
                if (isValueInclusive) {
                    stringBuilder.append("WHERE value <= ?").append((CharSequence)suffix);
                } else {
                    stringBuilder.append("WHERE value < ?").append((CharSequence)suffix);
                }
                statement = connection.prepareStatement(stringBuilder.toString());
                DBUtils.setValueToPreparedStatement(bindingIndex++, statement, lessThan.getValue());
            } else if (queryClass == StringStartsWith.class) {
                StringStartsWith stringStartsWith = (StringStartsWith)query;
                stringBuilder.append("WHERE value >= ? AND value < ?").append((CharSequence)suffix);
                String lowerBoundInclusive = CharSequences.toString(stringStartsWith.getValue());
                int len = lowerBoundInclusive.length();
                String allButLast = lowerBoundInclusive.substring(0, len - 1);
                String upperBoundExclusive = allButLast + Character.toChars(lowerBoundInclusive.charAt(len - 1) + '\u0001')[0];
                statement = connection.prepareStatement(stringBuilder.toString());
                DBUtils.setValueToPreparedStatement(bindingIndex++, statement, lowerBoundInclusive);
                DBUtils.setValueToPreparedStatement(bindingIndex++, statement, upperBoundExclusive);
            } else if (queryClass == GreaterThan.class) {
                GreaterThan greaterThan = (GreaterThan)query;
                boolean isValueInclusive = greaterThan.isValueInclusive();
                if (isValueInclusive) {
                    stringBuilder.append("WHERE value >= ?").append((CharSequence)suffix);
                } else {
                    stringBuilder.append("WHERE value > ?").append((CharSequence)suffix);
                }
                statement = connection.prepareStatement(stringBuilder.toString());
                DBUtils.setValueToPreparedStatement(bindingIndex++, statement, greaterThan.getValue());
            } else if (queryClass == Between.class) {
                Between between = (Between)query;
                if (between.isLowerInclusive()) {
                    stringBuilder.append("WHERE value >= ?");
                } else {
                    stringBuilder.append("WHERE value > ?");
                }
                if (between.isUpperInclusive()) {
                    stringBuilder.append(" AND value <= ?");
                } else {
                    stringBuilder.append(" AND value < ?");
                }
                stringBuilder.append((CharSequence)suffix);
                statement = connection.prepareStatement(stringBuilder.toString());
                DBUtils.setValueToPreparedStatement(bindingIndex++, statement, between.getLowerValue());
                DBUtils.setValueToPreparedStatement(bindingIndex++, statement, between.getUpperValue());
            } else {
                throw new IllegalStateException("Query " + queryClass + " not supported.");
            }
        }
        for (WhereClause additionalWhereClause : additionalWhereClauses) {
            DBUtils.setValueToPreparedStatement(bindingIndex++, statement, additionalWhereClause.objectToBind);
        }
        return statement;
    }

    public static <O> int count(Query<O> query, String tableName, Connection connection) {
        int n;
        String selectSql = String.format("SELECT COUNT(objectKey) FROM cqtbl_%s", tableName);
        PreparedStatement statement = null;
        try {
            statement = DBQueries.createAndBindSelectPreparedStatement(selectSql, "", Collections.<WhereClause>emptyList(), query, connection);
            ResultSet resultSet = statement.executeQuery();
            if (!resultSet.next()) {
                throw new IllegalStateException("Unable to execute count. The ResultSet returned no row. Query: " + query);
            }
            n = resultSet.getInt(1);
        }
        catch (Exception e) {
            try {
                throw new IllegalStateException("Unable to execute count. Query: " + query, e);
            }
            catch (Throwable throwable) {
                DBUtils.closeQuietly(statement);
                throw throwable;
            }
        }
        DBUtils.closeQuietly(statement);
        return n;
    }

    public static <O> int countDistinct(Query<O> query, String tableName, Connection connection) {
        int n;
        String selectSql = String.format("SELECT COUNT(1) AS countDistinct FROM (SELECT objectKey FROM cqtbl_%s", tableName);
        PreparedStatement statement = null;
        try {
            statement = DBQueries.createAndBindSelectPreparedStatement(selectSql, " GROUP BY objectKey)", Collections.<WhereClause>emptyList(), query, connection);
            ResultSet resultSet = statement.executeQuery();
            if (!resultSet.next()) {
                throw new IllegalStateException("Unable to execute count. The ResultSet returned no row. Query: " + query);
            }
            n = resultSet.getInt(1);
        }
        catch (Exception e) {
            try {
                throw new IllegalStateException("Unable to execute count. Query: " + query, e);
            }
            catch (Throwable throwable) {
                DBUtils.closeQuietly(statement);
                throw throwable;
            }
        }
        DBUtils.closeQuietly(statement);
        return n;
    }

    public static <O> ResultSet search(Query<O> query, String tableName, Connection connection) {
        String selectSql = String.format("SELECT DISTINCT objectKey FROM cqtbl_%s", tableName);
        PreparedStatement statement = null;
        try {
            statement = DBQueries.createAndBindSelectPreparedStatement(selectSql, "", Collections.<WhereClause>emptyList(), query, connection);
            return statement.executeQuery();
        }
        catch (Exception e) {
            DBUtils.closeQuietly(statement);
            throw new IllegalStateException("Unable to execute search. Query: " + query, e);
        }
    }

    public static <O> ResultSet getDistinctKeys(Query<O> query, boolean descending, String tableName, Connection connection) {
        String selectSql = String.format("SELECT DISTINCT value FROM cqtbl_%s", tableName);
        PreparedStatement statement = null;
        try {
            String orderByClause = descending ? " ORDER BY value DESC" : " ORDER BY value ASC";
            statement = DBQueries.createAndBindSelectPreparedStatement(selectSql, orderByClause, Collections.<WhereClause>emptyList(), query, connection);
            return statement.executeQuery();
        }
        catch (Exception e) {
            DBUtils.closeQuietly(statement);
            throw new IllegalStateException("Unable to look up keys. Query: " + query, e);
        }
    }

    public static <O> ResultSet getKeysAndValues(Query<O> query, boolean descending, String tableName, Connection connection) {
        String selectSql = String.format("SELECT objectKey, value FROM cqtbl_%s", tableName);
        PreparedStatement statement = null;
        try {
            String orderByClause = descending ? " ORDER BY value DESC" : " ORDER BY value ASC";
            statement = DBQueries.createAndBindSelectPreparedStatement(selectSql, orderByClause, Collections.<WhereClause>emptyList(), query, connection);
            return statement.executeQuery();
        }
        catch (Exception e) {
            DBUtils.closeQuietly(statement);
            throw new IllegalStateException("Unable to look up keys and values. Query: " + query, e);
        }
    }

    public static int getCountOfDistinctKeys(String tableName, Connection connection) {
        String selectSql = String.format("SELECT COUNT(DISTINCT value) FROM cqtbl_%s", tableName);
        Statement statement = null;
        try {
            statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery(selectSql);
            if (!resultSet.next()) {
                throw new IllegalStateException("Unable to execute count. The ResultSet returned no row. Query: " + selectSql);
            }
            return resultSet.getInt(1);
        }
        catch (Exception e) {
            DBUtils.closeQuietly(statement);
            throw new IllegalStateException("Unable to count distinct keys.", e);
        }
    }

    public static ResultSet getDistinctKeysAndCounts(boolean sortByKeyDescending, String tableName, Connection connection) {
        String selectSql = String.format("SELECT DISTINCT value, COUNT(value) AS valueCount FROM cqtbl_%s GROUP BY (value) %s", tableName, sortByKeyDescending ? "ORDER BY value DESC" : "");
        Statement statement = null;
        try {
            statement = connection.createStatement();
            return statement.executeQuery(selectSql);
        }
        catch (Exception e) {
            DBUtils.closeQuietly(statement);
            throw new IllegalStateException("Unable to look up index entries and counts.", e);
        }
    }

    public static ResultSet getAllIndexEntries(String tableName, Connection connection) {
        String selectSql = String.format("SELECT objectKey, value FROM cqtbl_%s ORDER BY objectKey;", tableName);
        Statement statement = null;
        try {
            statement = connection.createStatement();
            return statement.executeQuery(selectSql);
        }
        catch (Exception e) {
            DBUtils.closeQuietly(statement);
            throw new IllegalStateException("Unable to look up index entries.", e);
        }
    }

    public static <K> ResultSet getIndexEntryByObjectKey(K key, String tableName, Connection connection) {
        String selectSql = String.format("SELECT objectKey, value FROM cqtbl_%s WHERE objectKey = ?", tableName);
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement(selectSql);
            DBUtils.setValueToPreparedStatement(1, statement, key);
            return statement.executeQuery();
        }
        catch (Exception e) {
            DBUtils.closeQuietly(statement);
            throw new IllegalStateException("Unable to look up index entries.", e);
        }
    }

    public static <K, O> boolean contains(K objectKey, Query<O> query, String tableName, Connection connection) {
        boolean bl;
        String selectSql = String.format("SELECT objectKey FROM cqtbl_%s", tableName);
        PreparedStatement statement = null;
        try {
            List<WhereClause> additionalWhereClauses = Collections.singletonList(new WhereClause("objectKey = ?", objectKey));
            statement = DBQueries.createAndBindSelectPreparedStatement(selectSql, " LIMIT 1", additionalWhereClauses, query, connection);
            ResultSet resultSet = statement.executeQuery();
            bl = resultSet.next();
        }
        catch (SQLException e) {
            try {
                throw new IllegalStateException("Unable to execute contains. Query: " + query, e);
            }
            catch (Throwable throwable) {
                DBUtils.closeQuietly(statement);
                throw throwable;
            }
        }
        DBUtils.closeQuietly(statement);
        return bl;
    }

    static void ensureNotNegative(int value) {
        if (value < 0) {
            throw new IllegalStateException("Update returned error code: " + value);
        }
    }

    static class WhereClause {
        final String whereClause;
        final Object objectToBind;

        WhereClause(String whereClause, Object objectToBind) {
            this.whereClause = whereClause;
            this.objectToBind = objectToBind;
        }
    }

    public static class Row<K, A> {
        private final K objectKey;
        private final A value;

        public Row(K objectKey, A value) {
            this.objectKey = objectKey;
            this.value = value;
        }

        public K getObjectKey() {
            return this.objectKey;
        }

        public A getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Row row = (Row)o;
            if (!this.objectKey.equals(row.objectKey)) {
                return false;
            }
            return this.value.equals(row.value);
        }

        public int hashCode() {
            int result = this.objectKey.hashCode();
            result = 31 * result + this.value.hashCode();
            return result;
        }
    }
}

