/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.cqengine.index.standingquery;

import com.googlecode.cqengine.index.Index;
import com.googlecode.cqengine.index.support.indextype.OnHeapTypeIndex;
import com.googlecode.cqengine.persistence.support.ObjectSet;
import com.googlecode.cqengine.persistence.support.ObjectStore;
import com.googlecode.cqengine.query.Query;
import com.googlecode.cqengine.query.option.QueryOptions;
import com.googlecode.cqengine.resultset.ResultSet;
import com.googlecode.cqengine.resultset.stored.StoredResultSet;
import com.googlecode.cqengine.resultset.stored.StoredSetBasedResultSet;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;

public class StandingQueryIndex<O>
implements Index<O>,
OnHeapTypeIndex {
    private static final int INDEX_RETRIEVAL_COST = 10;
    private final Query<O> standingQuery;
    private final StoredResultSet<O> storedResultSet = new StoredSetBasedResultSet(Collections.newSetFromMap(new ConcurrentHashMap()), 10);

    public StandingQueryIndex(Query<O> standingQuery) {
        this.standingQuery = standingQuery;
    }

    @Override
    public boolean isMutable() {
        return true;
    }

    @Override
    public Index<O> getEffectiveIndex() {
        return this;
    }

    public Query<O> getStandingQuery() {
        return this.standingQuery;
    }

    @Override
    public boolean supportsQuery(Query<O> query, QueryOptions queryOptions) {
        return this.standingQuery.equals(query);
    }

    @Override
    public boolean isQuantized() {
        return false;
    }

    @Override
    public ResultSet<O> retrieve(Query<O> query, QueryOptions queryOptions) {
        if (!this.supportsQuery(query, queryOptions)) {
            throw new IllegalArgumentException("Unsupported query: " + query);
        }
        return this.storedResultSet;
    }

    @Override
    public void init(ObjectStore<O> objectStore, QueryOptions queryOptions) {
        this.storedResultSet.clear();
        this.addAll(ObjectSet.fromObjectStore(objectStore, queryOptions), queryOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(ObjectSet<O> objectSet, QueryOptions queryOptions) {
        try {
            boolean modified = false;
            for (Object object : objectSet) {
                if (!this.standingQuery.matches(object, queryOptions)) continue;
                modified |= this.storedResultSet.add(object);
            }
            boolean bl = modified;
            return bl;
        }
        finally {
            objectSet.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAll(ObjectSet<O> objectSet, QueryOptions queryOptions) {
        try {
            boolean modified = false;
            for (Object object : objectSet) {
                if (!this.standingQuery.matches(object, queryOptions)) continue;
                modified |= this.storedResultSet.remove(object);
            }
            boolean bl = modified;
            return bl;
        }
        finally {
            objectSet.close();
        }
    }

    @Override
    public void clear(QueryOptions queryOptions) {
        this.storedResultSet.clear();
    }

    public String toString() {
        return "StandingQueryIndex{standingQuery=" + this.standingQuery + '}';
    }

    public static <O> StandingQueryIndex<O> onQuery(Query<O> standingQuery) {
        return new StandingQueryIndex<O>(standingQuery);
    }
}

