/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.cqengine.persistence.support;

import com.googlecode.cqengine.index.support.CloseableIterator;
import com.googlecode.cqengine.persistence.support.ObjectStore;
import com.googlecode.cqengine.query.option.QueryOptions;
import java.util.Collection;
import java.util.Iterator;

public class CollectionWrappingObjectStore<O>
implements ObjectStore<O> {
    final Collection<O> backingCollection;

    public CollectionWrappingObjectStore(Collection<O> backingCollection) {
        this.backingCollection = backingCollection;
    }

    public Collection<O> getBackingCollection() {
        return this.backingCollection;
    }

    @Override
    public int size(QueryOptions queryOptions) {
        return this.backingCollection.size();
    }

    @Override
    public boolean contains(Object o, QueryOptions queryOptions) {
        return this.backingCollection.contains(o);
    }

    @Override
    public CloseableIterator<O> iterator(QueryOptions queryOptions) {
        final Iterator<O> i = this.backingCollection.iterator();
        return new CloseableIterator<O>(){

            @Override
            public void close() {
            }

            @Override
            public boolean hasNext() {
                return i.hasNext();
            }

            @Override
            public O next() {
                return i.next();
            }

            @Override
            public void remove() {
                i.remove();
            }
        };
    }

    @Override
    public boolean isEmpty(QueryOptions queryOptions) {
        return this.backingCollection.isEmpty();
    }

    @Override
    public boolean add(O object, QueryOptions queryOptions) {
        return this.backingCollection.add(object);
    }

    @Override
    public boolean remove(Object o, QueryOptions queryOptions) {
        return this.backingCollection.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c, QueryOptions queryOptions) {
        return this.backingCollection.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends O> c, QueryOptions queryOptions) {
        return this.backingCollection.addAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c, QueryOptions queryOptions) {
        return this.backingCollection.retainAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c, QueryOptions queryOptions) {
        return this.backingCollection.removeAll(c);
    }

    @Override
    public void clear(QueryOptions queryOptions) {
        this.backingCollection.clear();
    }
}

