/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.cqengine.persistence.support;

import com.googlecode.cqengine.index.support.CloseableIterable;
import com.googlecode.cqengine.index.support.CloseableIterator;
import com.googlecode.cqengine.persistence.support.ObjectStore;
import com.googlecode.cqengine.query.option.QueryOptions;
import java.io.Closeable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public abstract class ObjectSet<O>
implements CloseableIterable<O>,
Closeable {
    @Override
    public abstract void close();

    public abstract boolean isEmpty();

    public static <O> ObjectSet<O> fromObjectStore(ObjectStore<O> objectStore, QueryOptions queryOptions) {
        return new ObjectStoreAsObjectSet<O>(objectStore, queryOptions);
    }

    public static <O> ObjectSet<O> fromCollection(Collection<O> collection) {
        return new CollectionAsObjectSet<O>(collection);
    }

    static class ObjectStoreAsObjectSet<O>
    extends ObjectSet<O> {
        final ObjectStore<O> objectStore;
        final QueryOptions queryOptions;
        final Set<CloseableIterator<O>> openIterators = new HashSet<CloseableIterator<O>>();

        public ObjectStoreAsObjectSet(ObjectStore<O> objectStore, QueryOptions queryOptions) {
            this.objectStore = objectStore;
            this.queryOptions = queryOptions;
        }

        @Override
        public CloseableIterator<O> iterator() {
            final CloseableIterator<O> iterator = this.objectStore.iterator(this.queryOptions);
            this.openIterators.add(iterator);
            return new CloseableIterator<O>(){

                @Override
                public void close() {
                    ObjectStoreAsObjectSet.this.openIterators.remove(this);
                    iterator.close();
                }

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }

                @Override
                public O next() {
                    return iterator.next();
                }

                @Override
                public void remove() {
                    iterator.remove();
                }
            };
        }

        @Override
        public boolean isEmpty() {
            CloseableIterator<O> iterator = this.objectStore.iterator(this.queryOptions);
            try {
                boolean bl = !iterator.hasNext();
                return bl;
            }
            finally {
                iterator.close();
            }
        }

        @Override
        public void close() {
            for (CloseableIterator<O> openIterator : this.openIterators) {
                openIterator.close();
            }
            this.openIterators.clear();
        }
    }

    static class CollectionAsObjectSet<O>
    extends ObjectSet<O> {
        final Collection<O> collection;

        public CollectionAsObjectSet(Collection<O> collection) {
            this.collection = collection;
        }

        @Override
        public CloseableIterator<O> iterator() {
            final Iterator<O> iterator = this.collection.iterator();
            return new CloseableIterator<O>(){

                @Override
                public void close() {
                }

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }

                @Override
                public O next() {
                    return iterator.next();
                }

                @Override
                public void remove() {
                    iterator.remove();
                }
            };
        }

        @Override
        public boolean isEmpty() {
            return this.collection.isEmpty();
        }

        @Override
        public void close() {
        }
    }
}

