/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.cqengine.query.logical;

import com.googlecode.cqengine.query.Query;
import com.googlecode.cqengine.query.simple.SimpleQuery;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class LogicalQuery<O>
implements Query<O> {
    private final Collection<Query<O>> childQueries;
    private final List<LogicalQuery<O>> logicalQueries = new ArrayList<LogicalQuery<O>>();
    private final List<SimpleQuery<O, ?>> simpleQueries = new ArrayList();
    private final boolean hasLogicalQueries;
    private final boolean hasSimpleQueries;
    private final int size;
    private transient int cachedHashCode = 0;

    public LogicalQuery(Collection<Query<O>> childQueries) {
        for (Query<O> query : childQueries) {
            if (query instanceof LogicalQuery) {
                this.logicalQueries.add((LogicalQuery)query);
                continue;
            }
            if (query instanceof SimpleQuery) {
                this.simpleQueries.add((SimpleQuery)query);
                continue;
            }
            throw new IllegalStateException("Unexpected type of query: " + (query == null ? null : query + ", " + query.getClass()));
        }
        this.hasLogicalQueries = !this.logicalQueries.isEmpty();
        this.hasSimpleQueries = !this.simpleQueries.isEmpty();
        this.size = childQueries.size();
        this.childQueries = childQueries;
    }

    public List<LogicalQuery<O>> getLogicalQueries() {
        return this.logicalQueries;
    }

    public List<SimpleQuery<O, ?>> getSimpleQueries() {
        return this.simpleQueries;
    }

    public Collection<Query<O>> getChildQueries() {
        return this.childQueries;
    }

    public boolean hasLogicalQueries() {
        return this.hasLogicalQueries;
    }

    public boolean hasSimpleQueries() {
        return this.hasSimpleQueries;
    }

    public int size() {
        return this.size;
    }

    public int hashCode() {
        int h = this.cachedHashCode;
        if (h == 0) {
            h = this.calcHashCode();
            if (h == 0) {
                h = -976419167;
            }
            this.cachedHashCode = h;
        }
        return h;
    }

    protected abstract int calcHashCode();
}

