/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.cqengine.query.simple;

import com.googlecode.cqengine.IndexedCollection;
import com.googlecode.cqengine.attribute.Attribute;
import com.googlecode.cqengine.attribute.SimpleAttribute;
import com.googlecode.cqengine.query.Query;
import com.googlecode.cqengine.query.QueryFactory;
import com.googlecode.cqengine.query.option.QueryOptions;
import com.googlecode.cqengine.query.simple.SimpleQuery;

public class ExistsIn<O, F, A>
extends SimpleQuery<O, A> {
    final IndexedCollection<F> foreignCollection;
    final Attribute<O, A> localKeyAttribute;
    final Attribute<F, A> foreignKeyAttribute;
    final Query<F> foreignRestrictions;

    public ExistsIn(IndexedCollection<F> foreignCollection, Attribute<O, A> localKeyAttribute, Attribute<F, A> foreignKeyAttribute) {
        this(foreignCollection, localKeyAttribute, foreignKeyAttribute, null);
    }

    public ExistsIn(IndexedCollection<F> foreignCollection, Attribute<O, A> localKeyAttribute, Attribute<F, A> foreignKeyAttribute, Query<F> foreignRestrictions) {
        super(localKeyAttribute);
        this.foreignCollection = foreignCollection;
        this.localKeyAttribute = localKeyAttribute;
        this.foreignKeyAttribute = foreignKeyAttribute;
        this.foreignRestrictions = foreignRestrictions;
    }

    @Override
    protected boolean matchesSimpleAttribute(SimpleAttribute<O, A> attribute, O object, QueryOptions queryOptions) {
        A localValue = attribute.getValue(object, queryOptions);
        return this.foreignRestrictions == null ? this.foreignCollection.retrieve(QueryFactory.equal(this.foreignKeyAttribute, localValue)).isNotEmpty() : this.foreignCollection.retrieve(QueryFactory.and(QueryFactory.equal(this.foreignKeyAttribute, localValue), this.foreignRestrictions)).isNotEmpty();
    }

    @Override
    protected boolean matchesNonSimpleAttribute(Attribute<O, A> attribute, O object, QueryOptions queryOptions) {
        if (this.foreignRestrictions == null) {
            for (A localValue : attribute.getValues(object, queryOptions)) {
                boolean contained = this.foreignCollection.retrieve(QueryFactory.equal(this.foreignKeyAttribute, localValue)).isNotEmpty();
                if (!contained) continue;
                return true;
            }
            return false;
        }
        for (A localValue : attribute.getValues(object, queryOptions)) {
            boolean contained = this.foreignCollection.retrieve(QueryFactory.and(QueryFactory.equal(this.foreignKeyAttribute, localValue), this.foreignRestrictions)).isNotEmpty();
            if (!contained) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        if (this.foreignRestrictions == null) {
            return "existsIn(IndexedCollection<" + this.foreignKeyAttribute.getObjectType().getSimpleName() + ">" + ", " + ExistsIn.asLiteral(this.localKeyAttribute.getAttributeName()) + ", " + ExistsIn.asLiteral(this.foreignKeyAttribute.getAttributeName()) + ")";
        }
        return "existsIn(IndexedCollection<" + this.foreignKeyAttribute.getObjectType().getSimpleName() + ">" + ", " + ExistsIn.asLiteral(this.localKeyAttribute.getAttributeName()) + ", " + ExistsIn.asLiteral(this.foreignKeyAttribute.getAttributeName()) + ", " + this.foreignRestrictions + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExistsIn)) {
            return false;
        }
        ExistsIn existsIn = (ExistsIn)o;
        if (!this.foreignCollection.equals(existsIn.foreignCollection)) {
            return false;
        }
        if (!this.foreignKeyAttribute.equals(existsIn.foreignKeyAttribute)) {
            return false;
        }
        if (this.foreignRestrictions != null ? !this.foreignRestrictions.equals(existsIn.foreignRestrictions) : existsIn.foreignRestrictions != null) {
            return false;
        }
        return this.localKeyAttribute.equals(existsIn.localKeyAttribute);
    }

    @Override
    protected int calcHashCode() {
        int result = this.foreignCollection.hashCode();
        result = 31 * result + this.localKeyAttribute.hashCode();
        result = 31 * result + this.foreignKeyAttribute.hashCode();
        result = 31 * result + (this.foreignRestrictions != null ? this.foreignRestrictions.hashCode() : 0);
        return result;
    }
}

