/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.cqengine.resultset.order;

import com.googlecode.cqengine.resultset.ResultSet;
import com.googlecode.cqengine.resultset.common.WrappedResultSet;
import com.googlecode.cqengine.resultset.iterator.IteratorUtil;
import java.util.Comparator;
import java.util.Iterator;

public class MaterializedOrderedResultSet<O>
extends WrappedResultSet<O> {
    final Comparator<O> comparator;
    final boolean deduplicateSize;

    public MaterializedOrderedResultSet(ResultSet<O> wrappedResultSet, Comparator<O> comparator, boolean deduplicateSize) {
        super(wrappedResultSet);
        this.comparator = comparator;
        this.deduplicateSize = deduplicateSize;
    }

    @Override
    public Iterator<O> iterator() {
        return IteratorUtil.materializedSort(super.iterator(), this.comparator);
    }

    @Override
    public int getMergeCost() {
        long mergeCost = super.getMergeCost();
        return (int)Math.min(mergeCost * mergeCost, Integer.MAX_VALUE);
    }

    @Override
    public int size() {
        return this.deduplicateSize ? IteratorUtil.countElements(this) : super.size();
    }

    @Override
    public boolean isEmpty() {
        return this.wrappedResultSet.isEmpty();
    }

    @Override
    public boolean isNotEmpty() {
        return this.wrappedResultSet.isNotEmpty();
    }
}

