/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.kafka;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.joda.time.Instant;
import org.locationtech.geomesa.features.SerializationOption;
import org.locationtech.geomesa.features.kryo.KryoFeatureSerializer;
import org.locationtech.geomesa.features.kryo.KryoFeatureSerializer$;
import org.locationtech.geomesa.kafka.Clear;
import org.locationtech.geomesa.kafka.CreateOrUpdate;
import org.locationtech.geomesa.kafka.Delete;
import org.locationtech.geomesa.kafka.GeoMessage;
import org.locationtech.geomesa.kafka.GeoMessageDecoder$MsgKey$;
import org.locationtech.geomesa.kafka.GeoMessageEncoder$;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\u0005eg\u0001B\u0001\u0003\u0001-\u0011\u0011cR3p\u001b\u0016\u001c8/Y4f\t\u0016\u001cw\u000eZ3s\u0015\t\u0019A!A\u0003lC\u001a\\\u0017M\u0003\u0002\u0006\r\u00059q-Z8nKN\f'BA\u0004\t\u00031awnY1uS>tG/Z2i\u0015\u0005I\u0011aA8sO\u000e\u00011c\u0001\u0001\r%A\u0011Q\u0002E\u0007\u0002\u001d)\tq\"A\u0003tG\u0006d\u0017-\u0003\u0002\u0012\u001d\t1\u0011I\\=SK\u001a\u0004\"a\u0005\u000e\u000e\u0003QQ!!\u0006\f\u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\u0005]A\u0012\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0003e\t1aY8n\u0013\tYBCA\u0006MCjLHj\\4hS:<\u0007\u0002C\u000f\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0010\u0002\rM\u001c\u0007.Z7b!\tyb%D\u0001!\u0015\t\t#%\u0001\u0004tS6\u0004H.\u001a\u0006\u0003G\u0011\nqAZ3biV\u0014XM\u0003\u0002&\u0011\u00059q\u000e]3oO&\u001c\u0018BA\u0014!\u0005E\u0019\u0016.\u001c9mK\u001a+\u0017\r^;sKRK\b/\u001a\u0005\u0006S\u0001!\tAK\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005-j\u0003C\u0001\u0017\u0001\u001b\u0005\u0011\u0001\"B\u000f)\u0001\u0004qb\u0001B\u0018\u0001\u0001B\u0012a!T:h\u0017\u0016L8\u0003\u0002\u0018\rcQ\u0002\"!\u0004\u001a\n\u0005Mr!a\u0002)s_\u0012,8\r\u001e\t\u0003\u001bUJ!A\u000e\b\u0003\u0019M+'/[1mSj\f'\r\\3\t\u0011ar#Q3A\u0005\u0002e\nqA^3sg&|g.F\u0001;!\ti1(\u0003\u0002=\u001d\t!!)\u001f;f\u0011!qdF!E!\u0002\u0013Q\u0014\u0001\u0003<feNLwN\u001c\u0011\t\u0011\u0001s#Q3A\u0005\u0002e\nq!\\:h)f\u0004X\r\u0003\u0005C]\tE\t\u0015!\u0003;\u0003!i7o\u001a+za\u0016\u0004\u0003\u0002\u0003#/\u0005+\u0007I\u0011A#\u0002\u0005Q\u001cX#\u0001$\u0011\u0005\u001dcU\"\u0001%\u000b\u0005%S\u0015\u0001\u0002;j[\u0016T!a\u0013\u0005\u0002\t)|G-Y\u0005\u0003\u001b\"\u0013q!\u00138ti\u0006tG\u000f\u0003\u0005P]\tE\t\u0015!\u0003G\u0003\r!8\u000f\t\u0005\u0006S9\"\t!\u0015\u000b\u0005%R+f\u000b\u0005\u0002T]5\t\u0001\u0001C\u00039!\u0002\u0007!\bC\u0003A!\u0002\u0007!\bC\u0003E!\u0002\u0007a\tC\u0004Y]\u0005\u0005I\u0011A-\u0002\t\r|\u0007/\u001f\u000b\u0005%j[F\fC\u00049/B\u0005\t\u0019\u0001\u001e\t\u000f\u0001;\u0006\u0013!a\u0001u!9Ai\u0016I\u0001\u0002\u00041\u0005b\u00020/#\u0003%\taX\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\u0005\u0001'F\u0001\u001ebW\u0005\u0011\u0007CA2i\u001b\u0005!'BA3g\u0003%)hn\u00195fG.,GM\u0003\u0002h\u001d\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005%$'!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"91NLI\u0001\n\u0003y\u0016AD2paf$C-\u001a4bk2$HE\r\u0005\b[:\n\n\u0011\"\u0001o\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM*\u0012a\u001c\u0016\u0003\r\u0006Dq!\u001d\u0018\u0002\u0002\u0013\u0005#/A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0002gB\u0011A/_\u0007\u0002k*\u0011ao^\u0001\u0005Y\u0006twMC\u0001y\u0003\u0011Q\u0017M^1\n\u0005i,(AB*ue&tw\rC\u0004}]\u0005\u0005I\u0011A?\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0003y\u0004\"!D@\n\u0007\u0005\u0005aBA\u0002J]RD\u0011\"!\u0002/\u0003\u0003%\t!a\u0002\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011\u0011BA\b!\ri\u00111B\u0005\u0004\u0003\u001bq!aA!os\"I\u0011\u0011CA\u0002\u0003\u0003\u0005\rA`\u0001\u0004q\u0012\n\u0004\"CA\u000b]\u0005\u0005I\u0011IA\f\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA\r!\u0019\tY\"!\t\u0002\n5\u0011\u0011Q\u0004\u0006\u0004\u0003?q\u0011AC2pY2,7\r^5p]&!\u00111EA\u000f\u0005!IE/\u001a:bi>\u0014\b\"CA\u0014]\u0005\u0005I\u0011AA\u0015\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA\u0016\u0003c\u00012!DA\u0017\u0013\r\tyC\u0004\u0002\b\u0005>|G.Z1o\u0011)\t\t\"!\n\u0002\u0002\u0003\u0007\u0011\u0011\u0002\u0005\n\u0003kq\u0013\u0011!C!\u0003o\t\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0002}\"I\u00111\b\u0018\u0002\u0002\u0013\u0005\u0013QH\u0001\ti>\u001cFO]5oOR\t1\u000fC\u0005\u0002B9\n\t\u0011\"\u0011\u0002D\u00051Q-];bYN$B!a\u000b\u0002F!Q\u0011\u0011CA \u0003\u0003\u0005\r!!\u0003\b\u0013\u0005%\u0003!!A\t\u0002\u0005-\u0013AB'tO.+\u0017\u0010E\u0002T\u0003\u001b2\u0001b\f\u0001\u0002\u0002#\u0005\u0011qJ\n\u0006\u0003\u001b\n\t\u0006\u000e\t\t\u0003'\nIF\u000f\u001eG%6\u0011\u0011Q\u000b\u0006\u0004\u0003/r\u0011a\u0002:v]RLW.Z\u0005\u0005\u00037\n)FA\tBEN$(/Y2u\rVt7\r^5p]NBq!KA'\t\u0003\ty\u0006\u0006\u0002\u0002L!Q\u00111HA'\u0003\u0003%)%!\u0010\t\u0015\u0005\u0015\u0014QJA\u0001\n\u0003\u000b9'A\u0003baBd\u0017\u0010F\u0004S\u0003S\nY'!\u001c\t\ra\n\u0019\u00071\u0001;\u0011\u0019\u0001\u00151\ra\u0001u!1A)a\u0019A\u0002\u0019C!\"!\u001d\u0002N\u0005\u0005I\u0011QA:\u0003\u001d)h.\u00199qYf$B!!\u001e\u0002\u0002B)Q\"a\u001e\u0002|%\u0019\u0011\u0011\u0010\b\u0003\r=\u0003H/[8o!\u0019i\u0011Q\u0010\u001e;\r&\u0019\u0011q\u0010\b\u0003\rQ+\b\u000f\\34\u0011%\t\u0019)a\u001c\u0002\u0002\u0003\u0007!+A\u0002yIAB!\"a\"\u0002N\u0005\u0005I\u0011BAE\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005-\u0005c\u0001;\u0002\u000e&\u0019\u0011qR;\u0003\r=\u0013'.Z2u\u0011%\t\u0019\n\u0001b\u0001\n\u0013\t)*\u0001\u0006tKJL\u0017\r\\5{KJ,\"!a&\u0011\t\u0005e\u00151U\u0007\u0003\u00037SA!!(\u0002 \u0006!1N]=p\u0015\r\t\t\u000bB\u0001\tM\u0016\fG/\u001e:fg&!\u0011QUAN\u0005UY%/_8GK\u0006$XO]3TKJL\u0017\r\\5{KJD\u0001\"!+\u0001A\u0003%\u0011qS\u0001\fg\u0016\u0014\u0018.\u00197ju\u0016\u0014\b\u0005C\u0004\u0002.\u0002!\t!a,\u0002\r\u0011,7m\u001c3f)\u0019\t\t,a.\u0002BB\u0019A&a-\n\u0007\u0005U&A\u0001\u0006HK>lUm]:bO\u0016D\u0001\"!/\u0002,\u0002\u0007\u00111X\u0001\u0004W\u0016L\b\u0003B\u0007\u0002>jJ1!a0\u000f\u0005\u0015\t%O]1z\u0011!\t\u0019-a+A\u0002\u0005m\u0016aA7tO\"9\u0011q\u0019\u0001\u0005\u0012\u0005%\u0017!\u00033fG>$WmS3z)\r\u0011\u00161\u001a\u0005\t\u0003s\u000b)\r1\u0001\u0002<\"9\u0011q\u001a\u0001\u0005\n\u0005E\u0017A\u00043fG>$WMV3sg&|g.\r\u000b\t\u0003c\u000b\u0019.!6\u0002X\"1\u0001)!4A\u0002iBa\u0001RAg\u0001\u00041\u0005\u0002CAb\u0003\u001b\u0004\r!a/")
public class GeoMessageDecoder
implements LazyLogging {
    private final KryoFeatureSerializer serializer;
    private volatile GeoMessageDecoder$MsgKey$ MsgKey$module;
    private final Logger logger;
    private volatile boolean bitmap$0;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private GeoMessageDecoder$MsgKey$ MsgKey$lzycompute() {
        GeoMessageDecoder geoMessageDecoder = this;
        synchronized (geoMessageDecoder) {
            if (this.MsgKey$module != null) return this.MsgKey$module;
            this.MsgKey$module = new GeoMessageDecoder$MsgKey$(this);
            return this.MsgKey$module;
        }
    }

    private Logger logger$lzycompute() {
        GeoMessageDecoder geoMessageDecoder = this;
        synchronized (geoMessageDecoder) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public GeoMessageDecoder$MsgKey$ MsgKey() {
        return this.MsgKey$module == null ? this.MsgKey$lzycompute() : this.MsgKey$module;
    }

    private KryoFeatureSerializer serializer() {
        return this.serializer;
    }

    public GeoMessage decode(byte[] key, byte[] msg) {
        MsgKey msgKey = this.decodeKey(key);
        if (msgKey != null) {
            Tuple3 tuple3;
            byte version = msgKey.version();
            byte msgType = msgKey.msgType();
            Instant ts = msgKey.ts();
            Tuple3 tuple32 = tuple3 = new Tuple3((Object)BoxesRunTime.boxToByte((byte)version), (Object)BoxesRunTime.boxToByte((byte)msgType), (Object)ts);
            byte version2 = BoxesRunTime.unboxToByte((Object)tuple32._1());
            byte msgType2 = BoxesRunTime.unboxToByte((Object)tuple32._2());
            Instant ts2 = (Instant)tuple32._3();
            if (version2 == 1) {
                return this.decodeVersion1(msgType2, ts2, msg);
            }
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unknown serialization version: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToByte((byte)version2)})));
        }
        throw new MatchError((Object)msgKey);
    }

    public MsgKey decodeKey(byte[] key) {
        if (key == null || key.length == 0) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid message key: ", ".  Cannot determine serialization version."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.keyToString$1(key)})));
        }
        ByteBuffer buffer = ByteBuffer.wrap(key);
        byte version = buffer.get();
        if (version == 1) {
            if (key.length != 10) {
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid version 1 message key: ", ".  Expecting 10 bytes but found ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.keyToString$1(key), BoxesRunTime.boxToInteger((int)key.length)})));
            }
            byte msgType = buffer.get();
            Instant ts = new Instant(buffer.getLong());
            return new MsgKey(this, version, msgType, ts);
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid message key: ", ".  Unknown serialization version: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.keyToString$1(key), BoxesRunTime.boxToByte((byte)version)})));
    }

    private GeoMessage decodeVersion1(byte msgType, Instant ts, byte[] msg) {
        block5: {
            GeoMessage geoMessage;
            block3: {
                byte by;
                block4: {
                    block2: {
                        by = msgType;
                        if (GeoMessageEncoder$.MODULE$.createOrUpdateType() != by) break block2;
                        SimpleFeature sf = this.serializer().deserialize(msg);
                        geoMessage = new CreateOrUpdate(ts, sf);
                        break block3;
                    }
                    if (GeoMessageEncoder$.MODULE$.deleteType() != by) break block4;
                    String id = new String(msg, StandardCharsets.UTF_8);
                    geoMessage = new Delete(ts, id);
                    break block3;
                }
                if (GeoMessageEncoder$.MODULE$.clearType() != by) break block5;
                geoMessage = new Clear(ts);
            }
            return geoMessage;
        }
        throw new IllegalArgumentException(new StringBuilder().append((Object)"Unknown message type: ").append((Object)BoxesRunTime.boxToCharacter((char)((char)msgType))).toString());
    }

    private final String keyToString$1(byte[] key$1) {
        return key$1 == null ? "null" : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new String(key$1, StandardCharsets.UTF_8)}));
    }

    public GeoMessageDecoder(SimpleFeatureType schema) {
        LazyLogging.class.$init$((LazyLogging)this);
        this.serializer = KryoFeatureSerializer$.MODULE$.apply(schema, SerializationOption.SerializationOptions$.MODULE$.withUserData());
    }

    public class MsgKey
    implements Product,
    Serializable {
        private final byte version;
        private final byte msgType;
        private final Instant ts;
        public final /* synthetic */ GeoMessageDecoder $outer;

        public byte version() {
            return this.version;
        }

        public byte msgType() {
            return this.msgType;
        }

        public Instant ts() {
            return this.ts;
        }

        public MsgKey copy(byte version, byte msgType, Instant ts) {
            return new MsgKey(this.org$locationtech$geomesa$kafka$GeoMessageDecoder$MsgKey$$$outer(), version, msgType, ts);
        }

        public byte copy$default$1() {
            return this.version();
        }

        public byte copy$default$2() {
            return this.msgType();
        }

        public Instant copy$default$3() {
            return this.ts();
        }

        public String productPrefix() {
            return "MsgKey";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
                case 2: {
                    object = this.ts();
                    break;
                }
                case 1: {
                    object = BoxesRunTime.boxToByte((byte)this.msgType());
                    break;
                }
                case 0: {
                    object = BoxesRunTime.boxToByte((byte)this.version());
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof MsgKey;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.version());
            n = Statics.mix((int)n, (int)this.msgType());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.ts()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof MsgKey)) return false;
            if (((MsgKey)object).org$locationtech$geomesa$kafka$GeoMessageDecoder$MsgKey$$$outer() != this.org$locationtech$geomesa$kafka$GeoMessageDecoder$MsgKey$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            MsgKey msgKey = (MsgKey)x$1;
            if (this.version() != msgKey.version()) return false;
            if (this.msgType() != msgKey.msgType()) return false;
            Instant instant = this.ts();
            Instant instant2 = msgKey.ts();
            if (instant == null) {
                if (instant2 != null) {
                    return false;
                }
            } else if (!instant.equals(instant2)) return false;
            if (!msgKey.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ GeoMessageDecoder org$locationtech$geomesa$kafka$GeoMessageDecoder$MsgKey$$$outer() {
            return this.$outer;
        }

        public MsgKey(GeoMessageDecoder $outer, byte version, byte msgType, Instant ts) {
            this.version = version;
            this.msgType = msgType;
            this.ts = ts;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.class.$init$((Product)this);
        }
    }
}

