/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.kafka;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.locationtech.geomesa.features.SerializationOption;
import org.locationtech.geomesa.features.kryo.KryoFeatureSerializer;
import org.locationtech.geomesa.features.kryo.KryoFeatureSerializer$;
import org.locationtech.geomesa.kafka.Clear;
import org.locationtech.geomesa.kafka.CreateOrUpdate;
import org.locationtech.geomesa.kafka.Delete;
import org.locationtech.geomesa.kafka.GeoMessage;
import org.locationtech.geomesa.kafka.GeoMessageEncoder$;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001U<Q!\u0001\u0002\t\u0002-\t\u0011cR3p\u001b\u0016\u001c8/Y4f\u000b:\u001cw\u000eZ3s\u0015\t\u0019A!A\u0003lC\u001a\\\u0017M\u0003\u0002\u0006\r\u00059q-Z8nKN\f'BA\u0004\t\u00031awnY1uS>tG/Z2i\u0015\u0005I\u0011aA8sO\u000e\u0001\u0001C\u0001\u0007\u000e\u001b\u0005\u0011a!\u0002\b\u0003\u0011\u0003y!!E$f_6+7o]1hK\u0016s7m\u001c3feN\u0011Q\u0002\u0005\t\u0003#Qi\u0011A\u0005\u0006\u0002'\u0005)1oY1mC&\u0011QC\u0005\u0002\u0007\u0003:L(+\u001a4\t\u000b]iA\u0011\u0001\r\u0002\rqJg.\u001b;?)\u0005Y\u0001b\u0002\u000e\u000e\u0005\u0004%\taG\u0001\bm\u0016\u00148/[8o+\u0005a\u0002CA\t\u001e\u0013\tq\"C\u0001\u0003CsR,\u0007B\u0002\u0011\u000eA\u0003%A$\u0001\u0005wKJ\u001c\u0018n\u001c8!\u0011\u001d\u0011SB1A\u0005\u0002m\t!c\u0019:fCR,wJ]+qI\u0006$X\rV=qK\"1A%\u0004Q\u0001\nq\t1c\u0019:fCR,wJ]+qI\u0006$X\rV=qK\u0002BqAJ\u0007C\u0002\u0013\u00051$\u0001\u0006eK2,G/\u001a+za\u0016Da\u0001K\u0007!\u0002\u0013a\u0012a\u00033fY\u0016$X\rV=qK\u0002BqAK\u0007C\u0002\u0013\u00051$A\u0005dY\u0016\f'\u000fV=qK\"1A&\u0004Q\u0001\nq\t!b\u00197fCJ$\u0016\u0010]3!\u0011\u001dqSB1A\u0005\n=\nQ!R'Q)f+\u0012\u0001\r\t\u0004#Eb\u0012B\u0001\u001a\u0013\u0005\u0015\t%O]1z\u0011\u0019!T\u0002)A\u0005a\u00051Q)\u0014)U3\u00022AA\u0004\u0002\u0001mM\u0011Q\u0007\u0005\u0005\tqU\u0012\t\u0011)A\u0005s\u000511o\u00195f[\u0006\u0004\"AO!\u000e\u0003mR!\u0001P\u001f\u0002\rMLW\u000e\u001d7f\u0015\tqt(A\u0004gK\u0006$XO]3\u000b\u0005\u0001C\u0011aB8qK:<\u0017n]\u0005\u0003\u0005n\u0012\u0011cU5na2,g)Z1ukJ,G+\u001f9f\u0011\u00159R\u0007\"\u0001E)\t)e\t\u0005\u0002\rk!)\u0001h\u0011a\u0001s!9\u0001*\u000eb\u0001\n\u0013I\u0015AC:fe&\fG.\u001b>feV\t!\n\u0005\u0002L!6\tAJ\u0003\u0002N\u001d\u0006!1N]=p\u0015\tyE!\u0001\u0005gK\u0006$XO]3t\u0013\t\tFJA\u000bLef|g)Z1ukJ,7+\u001a:jC2L'0\u001a:\t\rM+\u0004\u0015!\u0003K\u0003-\u0019XM]5bY&TXM\u001d\u0011\t\u000bU+D\u0011\u0001,\u0002\u0013\u0015t7m\u001c3f\u0017\u0016LHC\u0001\u0019X\u0011\u0015AF\u000b1\u0001Z\u0003\ri7o\u001a\t\u0003\u0019iK!a\u0017\u0002\u0003\u0015\u001d+w.T3tg\u0006<W\rC\u0003^k\u0011\u0005a,A\u0007f]\u000e|G-Z'fgN\fw-\u001a\u000b\u0003a}CQ\u0001\u0017/A\u0002eCQ!Y\u001b\u0005\u0002\t\f1$\u001a8d_\u0012,7I]3bi\u0016|%/\u00169eCR,W*Z:tC\u001e,GC\u0001\u0019d\u0011\u0015A\u0006\r1\u0001e!\taQ-\u0003\u0002g\u0005\tq1I]3bi\u0016|%/\u00169eCR,\u0007\"\u000256\t\u0003I\u0017aE3oG>$W\rR3mKR,W*Z:tC\u001e,GC\u0001\u0019k\u0011\u0015Av\r1\u0001l!\taA.\u0003\u0002n\u0005\t1A)\u001a7fi\u0016DQa\\\u001b\u0005\u0002A\f!#\u001a8d_\u0012,7\t\\3be6+7o]1hKR\u0011\u0001'\u001d\u0005\u00061:\u0004\rA\u001d\t\u0003\u0019ML!\u0001\u001e\u0002\u0003\u000b\rcW-\u0019:")
public class GeoMessageEncoder {
    private final KryoFeatureSerializer serializer;

    public static byte clearType() {
        return GeoMessageEncoder$.MODULE$.clearType();
    }

    public static byte deleteType() {
        return GeoMessageEncoder$.MODULE$.deleteType();
    }

    public static byte createOrUpdateType() {
        return GeoMessageEncoder$.MODULE$.createOrUpdateType();
    }

    public static byte version() {
        return GeoMessageEncoder$.MODULE$.version();
    }

    private KryoFeatureSerializer serializer() {
        return this.serializer;
    }

    public byte[] encodeKey(GeoMessage msg) {
        GeoMessage geoMessage;
        block5: {
            byte by;
            block3: {
                block4: {
                    block2: {
                        geoMessage = msg;
                        if (!(geoMessage instanceof CreateOrUpdate)) break block2;
                        by = GeoMessageEncoder$.MODULE$.createOrUpdateType();
                        break block3;
                    }
                    if (!(geoMessage instanceof Delete)) break block4;
                    by = GeoMessageEncoder$.MODULE$.deleteType();
                    break block3;
                }
                if (!(geoMessage instanceof Clear)) break block5;
                by = GeoMessageEncoder$.MODULE$.clearType();
            }
            byte msgType = by;
            ByteBuffer bb = ByteBuffer.allocate(10);
            bb.put(GeoMessageEncoder$.MODULE$.version());
            bb.put(msgType);
            bb.putLong(msg.timestamp().getMillis());
            return bb.array();
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid message: '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{geoMessage})));
    }

    public byte[] encodeMessage(GeoMessage msg) {
        GeoMessage geoMessage;
        block5: {
            byte[] byArray;
            block3: {
                block4: {
                    block2: {
                        geoMessage = msg;
                        if (!(geoMessage instanceof CreateOrUpdate)) break block2;
                        CreateOrUpdate createOrUpdate = (CreateOrUpdate)geoMessage;
                        byArray = this.encodeCreateOrUpdateMessage(createOrUpdate);
                        break block3;
                    }
                    if (!(geoMessage instanceof Delete)) break block4;
                    Delete delete = (Delete)geoMessage;
                    byArray = this.encodeDeleteMessage(delete);
                    break block3;
                }
                if (!(geoMessage instanceof Clear)) break block5;
                Clear clear = (Clear)geoMessage;
                byArray = this.encodeClearMessage(clear);
            }
            return byArray;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid message: '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{geoMessage})));
    }

    public byte[] encodeCreateOrUpdateMessage(CreateOrUpdate msg) {
        return this.serializer().serialize(msg.feature());
    }

    public byte[] encodeDeleteMessage(Delete msg) {
        return msg.id().getBytes(StandardCharsets.UTF_8);
    }

    public byte[] encodeClearMessage(Clear msg) {
        return GeoMessageEncoder$.MODULE$.org$locationtech$geomesa$kafka$GeoMessageEncoder$$EMPTY();
    }

    public GeoMessageEncoder(SimpleFeatureType schema) {
        this.serializer = KryoFeatureSerializer$.MODULE$.apply(schema, SerializationOption.SerializationOptions$.MODULE$.withUserData());
    }
}

