/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.kafka;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.locationtech.geomesa.kafka.ReplayConfig;
import scala.Array$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.RichLong$;

public final class ReplayConfig$
implements LazyLogging,
Serializable {
    public static final ReplayConfig$ MODULE$;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new ReplayConfig$();
    }

    private Logger logger$lzycompute() {
        ReplayConfig$ replayConfig$ = this;
        synchronized (replayConfig$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public ReplayConfig apply(long start, long end, long readBehind) {
        return new ReplayConfig(new Instant(start), new Instant(end), Duration.millis((long)readBehind));
    }

    public String encode(ReplayConfig conf) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-", "-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{RichLong$.MODULE$.toHexString$extension(Predef$.MODULE$.longWrapper(conf.start().getMillis())), RichLong$.MODULE$.toHexString$extension(Predef$.MODULE$.longWrapper(conf.end().getMillis())), RichLong$.MODULE$.toHexString$extension(Predef$.MODULE$.longWrapper(conf.readBehind().getMillis()))}));
    }

    public Option<ReplayConfig> decode(String rcString) {
        None$ none$;
        try {
            Long[] values = (Long[])Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(rcString)).split('-')).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Long apply(String x$2) {
                    return Long.valueOf(x$2, 16);
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Long.class)));
            if (values.length != 3) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error(new StringBuilder().append((Object)"Unable to decode ReplayConfig. Wrong number of tokens splitting ").append((Object)rcString).toString());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                none$ = None$.MODULE$;
            } else {
                Instant start = new Instant((Object)values[0]);
                Instant end = new Instant((Object)values[1]);
                Duration duration = Duration.millis((long)Predef$.MODULE$.Long2long(values[2]));
                none$ = new Some((Object)new ReplayConfig(start, end, duration));
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error("Exception thrown decoding ReplayConfig.", (Throwable)illegalArgumentException);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public ReplayConfig apply(Instant start, Instant end, Duration readBehind) {
        return new ReplayConfig(start, end, readBehind);
    }

    public Option<Tuple3<Instant, Instant, Duration>> unapply(ReplayConfig x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple3((Object)x$0.start(), (Object)x$0.end(), (Object)x$0.readBehind()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private ReplayConfig$() {
        MODULE$ = this;
        LazyLogging.class.$init$((LazyLogging)this);
    }
}

