/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.memory.cqengine;

import com.googlecode.cqengine.ConcurrentIndexedCollection;
import com.googlecode.cqengine.IndexedCollection;
import com.googlecode.cqengine.attribute.Attribute;
import com.googlecode.cqengine.index.Index;
import com.googlecode.cqengine.index.hash.HashIndex;
import com.googlecode.cqengine.index.navigable.NavigableIndex;
import com.googlecode.cqengine.index.radix.RadixTreeIndex;
import com.googlecode.cqengine.index.unique.UniqueIndex;
import com.googlecode.cqengine.query.Query;
import com.googlecode.cqengine.query.QueryFactory;
import com.googlecode.cqengine.query.option.DeduplicationOption;
import com.googlecode.cqengine.query.option.DeduplicationStrategy;
import com.googlecode.cqengine.query.option.QueryOptions;
import com.googlecode.cqengine.query.simple.All;
import com.googlecode.cqengine.query.simple.Equal;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import com.vividsolutions.jts.geom.Geometry;
import java.util.Collection;
import java.util.Date;
import java.util.UUID;
import org.geotools.data.FeatureReader;
import org.geotools.data.collection.DelegateFeatureReader;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.collection.DelegateFeatureIterator;
import org.locationtech.geomesa.memory.cqengine.GeoCQEngine$;
import org.locationtech.geomesa.memory.cqengine.index.GeoIndex;
import org.locationtech.geomesa.memory.cqengine.utils.CQEngineQueryVisitor;
import org.locationtech.geomesa.memory.cqengine.utils.CQIndexType$;
import org.locationtech.geomesa.memory.cqengine.utils.CQIndexingOptions$;
import org.locationtech.geomesa.memory.cqengine.utils.SFTAttributes;
import org.locationtech.geomesa.memory.cqengine.utils.SFTAttributes$;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.FeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.IncludeFilter;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005ug\u0001B\u0001\u0003\u00015\u00111bR3p\u0007F+enZ5oK*\u00111\u0001B\u0001\tGF,gnZ5oK*\u0011QAB\u0001\u0007[\u0016lwN]=\u000b\u0005\u001dA\u0011aB4f_6,7/\u0019\u0006\u0003\u0013)\tA\u0002\\8dCRLwN\u001c;fG\"T\u0011aC\u0001\u0004_J<7\u0001A\n\u0004\u00019!\u0002CA\b\u0013\u001b\u0005\u0001\"\"A\t\u0002\u000bM\u001c\u0017\r\\1\n\u0005M\u0001\"AB!osJ+g\r\u0005\u0002\u001695\taC\u0003\u0002\u00181\u0005a1oY1mC2|wmZ5oO*\u0011\u0011DG\u0001\tif\u0004Xm]1gK*\t1$A\u0002d_6L!!\b\f\u0003\u00171\u000b'0\u001f'pO\u001eLgn\u001a\u0005\t?\u0001\u0011)\u0019!C\u0001A\u0005\u00191O\u001a;\u0016\u0003\u0005\u0002\"AI\u0015\u000e\u0003\rR!\u0001J\u0013\u0002\rMLW\u000e\u001d7f\u0015\t1s%A\u0004gK\u0006$XO]3\u000b\u0005!R\u0011aB8qK:<\u0017n]\u0005\u0003U\r\u0012\u0011cU5na2,g)Z1ukJ,G+\u001f9f\u0011!a\u0003A!A!\u0002\u0013\t\u0013\u0001B:gi\u0002B\u0001B\f\u0001\u0003\u0002\u0003\u0006IaL\u0001\u000fK:\f'\r\\3GS\u0012Le\u000eZ3y!\ty\u0001'\u0003\u00022!\t9!i\\8mK\u0006t\u0007\u0002C\u001a\u0001\u0005\u0003\u0005\u000b\u0011B\u0018\u0002\u001f\u0015t\u0017M\u00197f\u000f\u0016|W.\u00138eKbDQ!\u000e\u0001\u0005\u0002Y\na\u0001P5oSRtD\u0003B\u001c:um\u0002\"\u0001\u000f\u0001\u000e\u0003\tAQa\b\u001bA\u0002\u0005BqA\f\u001b\u0011\u0002\u0003\u0007q\u0006C\u00044iA\u0005\t\u0019A\u0018\t\u000fu\u0002!\u0019!C\u0001}\u000591-]2bG\",W#A \u0011\u0007\u0001#e)D\u0001B\u0015\t\u0019!I\u0003\u0002D5\u0005Qqm\\8hY\u0016\u001cw\u000eZ3\n\u0005\u0015\u000b%!E%oI\u0016DX\rZ\"pY2,7\r^5p]B\u0011!eR\u0005\u0003\u0011\u000e\u0012QbU5na2,g)Z1ukJ,\u0007B\u0002&\u0001A\u0003%q(\u0001\u0005dc\u000e\f7\r[3!\u0011\u001da\u0005A1A\u0005\u00025\u000b!\"\u0019;ue&\u0014W\u000f^3t+\u0005q\u0005CA(S\u001b\u0005\u0001&BA)\u0003\u0003\u0015)H/\u001b7t\u0013\t\u0019\u0006KA\u0007T\rR\u000bE\u000f\u001e:jEV$Xm\u001d\u0005\u0007+\u0002\u0001\u000b\u0011\u0002(\u0002\u0017\u0005$HO]5ckR,7\u000f\t\u0005\u0006/\u0002!\t\u0001W\u0001\u0007e\u0016lwN^3\u0015\u0005=J\u0006\"\u0002.W\u0001\u00041\u0015AA:g\u0011\u0015a\u0006\u0001\"\u0001^\u0003\r\tG\r\u001a\u000b\u0003_yCQAW.A\u0002\u0019CQ\u0001\u0019\u0001\u0005\u0002\u0005\fa!\u00193e\u00032dGCA\u0018c\u0011\u0015\u0019w\f1\u0001e\u0003\r\u0019hm\u001d\t\u0004K*4U\"\u00014\u000b\u0005\u001dD\u0017\u0001B;uS2T\u0011![\u0001\u0005U\u00064\u0018-\u0003\u0002lM\nQ1i\u001c7mK\u000e$\u0018n\u001c8\t\u000b5\u0004A\u0011\u00018\u0002\u000b\rdW-\u0019:\u0015\u0003=\u0004\"a\u00049\n\u0005E\u0004\"\u0001B+oSRDQa\u001d\u0001\u0005\u0002Q\fqaZ3u\u0005fLE\r\u0006\u0002vqB\u0019qB\u001e$\n\u0005]\u0004\"AB(qi&|g\u000eC\u0003ze\u0002\u0007!0\u0001\u0002jIB\u00111P \b\u0003\u001fqL!! \t\u0002\rA\u0013X\rZ3g\u0013\ry\u0018\u0011\u0001\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005u\u0004\u0002bBA\u0003\u0001\u0011\u0005\u0011qA\u0001\u0007kB$\u0017\r^3\u0015\u0007=\nI\u0001\u0003\u0004[\u0003\u0007\u0001\rA\u0012\u0005\b\u0003\u001b\u0001A\u0011AA\b\u0003I9W\r\u001e*fC\u0012,'OR8s\r&dG/\u001a:\u0015\t\u0005E\u0011q\b\t\u0005\u0003'\tID\u0004\u0003\u0002\u0016\u0005Mb\u0002BA\f\u0003[qA!!\u0007\u0002,9!\u00111DA\u0015\u001d\u0011\ti\"a\n\u000f\t\u0005}\u0011QE\u0007\u0003\u0003CQ1!a\t\r\u0003\u0019a$o\\8u}%\t1\"\u0003\u0002\n\u0015%\u0011q\u0001C\u0005\u0003#\u001aIA!a\f\u00022\u0005Aq-Z8u_>d7O\u0003\u0002R\r%!\u0011QGA\u001c\u0003\u001d\u0001\u0018mY6bO\u0016TA!a\f\u00022%!\u00111HA\u001f\u0005\t1%K\u0003\u0003\u00026\u0005]\u0002\u0002CA!\u0003\u0017\u0001\r!a\u0011\u0002\r\u0019LG\u000e^3s!\u0011\t)%!\u0013\u000e\u0005\u0005\u001d#bAA!O%!\u00111JA$\u0005\u00191\u0015\u000e\u001c;fe\"9\u0011q\n\u0001\u0005\u0002\u0005E\u0013aB9vKJL8)\u0015\u000b\u0007\u0003#\t\u0019&a\u0016\t\u0011\u0005U\u0013Q\na\u0001\u0003\u0007\n\u0011A\u001a\u0005\n\u00033\ni\u0005%AA\u0002=\nQ\u0001Z3ekBDq!!\u0018\u0001\t\u0003\ty&A\u0004j]\u000edW\u000fZ3\u0015\t\u0005E\u0011\u0011\r\u0005\t\u0003G\nY\u00061\u0001\u0002f\u0005\t\u0011\u000e\u0005\u0003\u0002F\u0005\u001d\u0014\u0002BA5\u0003\u000f\u0012Q\"\u00138dYV$WMR5mi\u0016\u0014\bbBA7\u0001\u0011%\u0011qN\u0001\tC\u0012$\u0017J\u001c3fqR\u0019q.!\u001d\t\u0011\u0005M\u00141\u000ea\u0001\u0003k\n!!\u00193\u0011\t\u0005]\u0014QP\u0007\u0003\u0003sR1!a\u001f&\u0003\u0011!\u0018\u0010]3\n\t\u0005}\u0014\u0011\u0010\u0002\u0014\u0003R$(/\u001b2vi\u0016$Um]2sSB$xN\u001d\u0005\u0007\u0003\u0007\u0003A\u0011\u00028\u0002\u0017\u0005$GMR5e\u0013:$W\r\u001f\u0005\b\u0003\u000f\u0003A\u0011BAE\u0003-\tG\rZ$f_&sG-\u001a=\u0015\u0007=\fY\t\u0003\u0005\u0002t\u0005\u0015\u0005\u0019AA;\u0011\u001d\ty\t\u0001C\u0005\u0003#\u000b\u0011#\u00193e\u001d\u00064\u0018nZ1cY\u0016Le\u000eZ3y)\ry\u00171\u0013\u0005\t\u0003g\ni\t1\u0001\u0002v!9\u0011q\u0013\u0001\u0005\n\u0005e\u0015!D1eIJ\u000bG-\u001b=J]\u0012,\u0007\u0010F\u0002p\u00037C\u0001\"a\u001d\u0002\u0016\u0002\u0007\u0011Q\u000f\u0005\b\u0003?\u0003A\u0011BAQ\u00039\tG\rZ+oSF,X-\u00138eKb$2a\\AR\u0011!\t\u0019(!(A\u0002\u0005U\u0004bBAT\u0001\u0011%\u0011\u0011V\u0001\rC\u0012$\u0007*Y:i\u0013:$W\r\u001f\u000b\u0004_\u0006-\u0006\u0002CA:\u0003K\u0003\r!!\u001e\t\u0013\u0005=\u0006!%A\u0005\u0002\u0005E\u0016!E9vKJL8)\u0015\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u00111\u0017\u0016\u0004_\u0005U6FAA\\!\u0011\tI,a1\u000e\u0005\u0005m&\u0002BA_\u0003\u007f\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u0005\u0007#\u0001\u0006b]:|G/\u0019;j_:LA!!2\u0002<\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\b\u0013\u0005%'!!A\t\u0002\u0005-\u0017aC$f_\u000e\u000bVI\\4j]\u0016\u00042\u0001OAg\r!\t!!!A\t\u0002\u0005=7cAAg\u001d!9Q'!4\u0005\u0002\u0005MGCAAf\u0011)\t9.!4\u0012\u0002\u0013\u0005\u0011\u0011W\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001a\t\u0015\u0005m\u0017QZI\u0001\n\u0003\t\t,A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$He\r")
public class GeoCQEngine
implements LazyLogging {
    private final SimpleFeatureType sft;
    private final IndexedCollection<SimpleFeature> cqcache;
    private final SFTAttributes attributes;
    private final Logger logger;
    private volatile boolean bitmap$0;

    public static boolean $lessinit$greater$default$3() {
        return GeoCQEngine$.MODULE$.$lessinit$greater$default$3();
    }

    public static boolean $lessinit$greater$default$2() {
        return GeoCQEngine$.MODULE$.$lessinit$greater$default$2();
    }

    private Logger logger$lzycompute() {
        GeoCQEngine geoCQEngine = this;
        synchronized (geoCQEngine) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public SimpleFeatureType sft() {
        return this.sft;
    }

    public IndexedCollection<SimpleFeature> cqcache() {
        return this.cqcache;
    }

    public SFTAttributes attributes() {
        return this.attributes;
    }

    public boolean remove(SimpleFeature sf) {
        return this.cqcache().remove((Object)sf);
    }

    public boolean add(SimpleFeature sf) {
        return this.cqcache().add((Object)sf);
    }

    public boolean addAll(Collection<SimpleFeature> sfs) {
        return this.cqcache().addAll(sfs);
    }

    public void clear() {
        this.cqcache().clear();
    }

    public Option<SimpleFeature> getById(String id) {
        return JavaConversions$.MODULE$.iterableAsScalaIterable((Iterable)this.cqcache().retrieve((Query)new Equal(SFTAttributes$.MODULE$.fidAttribute(), (Object)id))).headOption();
    }

    public boolean update(SimpleFeature sf) {
        Option<SimpleFeature> option;
        block4: {
            block3: {
                Object object;
                block2: {
                    option = this.getById(sf.getID());
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    SimpleFeature oldsf = (SimpleFeature)some.x();
                    object = BoxesRunTime.boxToBoolean((boolean)this.cqcache().remove((Object)oldsf));
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                object = BoxedUnit.UNIT;
            }
            return this.cqcache().add((Object)sf);
        }
        throw new MatchError(option);
    }

    public FeatureReader<SimpleFeatureType, SimpleFeature> getReaderForFilter(Filter filter) {
        FeatureReader<SimpleFeatureType, SimpleFeature> featureReader;
        Filter filter2 = filter;
        if (filter2 instanceof IncludeFilter) {
            IncludeFilter includeFilter = (IncludeFilter)filter2;
            featureReader = this.include(includeFilter);
        } else {
            featureReader = this.queryCQ(filter2, true);
        }
        return featureReader;
    }

    public FeatureReader<SimpleFeatureType, SimpleFeature> queryCQ(Filter f, boolean dedup) {
        CQEngineQueryVisitor visitor = new CQEngineQueryVisitor(this.sft());
        Object object = f.accept((FilterVisitor)visitor, null);
        if (object instanceof Query) {
            DelegateFeatureReader delegateFeatureReader;
            Query query;
            Query query2;
            Query query3 = query2 = (query = (Query)object);
            if (dedup) {
                DeduplicationOption dedupOpt = QueryFactory.deduplicate((DeduplicationStrategy)DeduplicationStrategy.LOGICAL_ELIMINATION);
                QueryOptions queryOptions = QueryFactory.queryOptions((Object[])new Object[]{dedupOpt});
                delegateFeatureReader = new DelegateFeatureReader((FeatureType)this.sft(), (FeatureIterator)new DelegateFeatureIterator(this.cqcache().retrieve(query3, queryOptions).iterator()));
            } else {
                delegateFeatureReader = new DelegateFeatureReader((FeatureType)this.sft(), (FeatureIterator)new DelegateFeatureIterator(this.cqcache().retrieve(query3).iterator()));
            }
            return delegateFeatureReader;
        }
        throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Filter visitor didn't recognize filter: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{f})));
    }

    public boolean queryCQ$default$2() {
        return true;
    }

    public FeatureReader<SimpleFeatureType, SimpleFeature> include(IncludeFilter i) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isWarnEnabled()) {
            this.logger().underlying().warn("Running Filter.INCLUDE");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return new DelegateFeatureReader((FeatureType)this.sft(), (FeatureIterator)new DelegateFeatureIterator(this.cqcache().retrieve((Query)new All(SimpleFeature.class)).iterator()));
    }

    public void org$locationtech$geomesa$memory$cqengine$GeoCQEngine$$addIndex(AttributeDescriptor ad) {
        Enumeration.Value value;
        block14: {
            block9: {
                block13: {
                    block12: {
                        block11: {
                            block10: {
                                block2: {
                                    Class clazz;
                                    block8: {
                                        block4: {
                                            block7: {
                                                block6: {
                                                    block5: {
                                                        block3: {
                                                            value = CQIndexingOptions$.MODULE$.getCQIndexType(ad);
                                                            Enumeration.Value value2 = CQIndexType$.MODULE$.DEFAULT();
                                                            Enumeration.Value value3 = value;
                                                            if (value2 != null ? !value2.equals(value3) : value3 != null) break block2;
                                                            clazz = ad.getType().getBinding();
                                                            if (!Integer.class.isAssignableFrom(clazz) && !Long.class.isAssignableFrom(clazz) && !Float.class.isAssignableFrom(clazz) && !Double.class.isAssignableFrom(clazz) && !Date.class.isAssignableFrom(clazz)) break block3;
                                                            this.addNavigableIndex(ad);
                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                            break block4;
                                                        }
                                                        if (!String.class.isAssignableFrom(clazz)) break block5;
                                                        this.addRadixIndex(ad);
                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                        break block4;
                                                    }
                                                    if (!Geometry.class.isAssignableFrom(clazz)) break block6;
                                                    this.addGeoIndex(ad);
                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                    break block4;
                                                }
                                                if (!UUID.class.isAssignableFrom(clazz)) break block7;
                                                this.addUniqueIndex(ad);
                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                break block4;
                                            }
                                            if (!Boolean.class.isAssignableFrom(clazz)) break block8;
                                            this.addHashIndex(ad);
                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                        }
                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                        break block9;
                                    }
                                    throw new MatchError((Object)clazz);
                                }
                                Enumeration.Value value4 = CQIndexType$.MODULE$.NAVIGABLE();
                                Enumeration.Value value5 = value;
                                if (value4 != null ? !value4.equals(value5) : value5 != null) break block10;
                                this.addNavigableIndex(ad);
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                break block9;
                            }
                            Enumeration.Value value6 = CQIndexType$.MODULE$.RADIX();
                            Enumeration.Value value7 = value;
                            if (value6 != null ? !value6.equals(value7) : value7 != null) break block11;
                            this.addRadixIndex(ad);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            break block9;
                        }
                        Enumeration.Value value8 = CQIndexType$.MODULE$.UNIQUE();
                        Enumeration.Value value9 = value;
                        if (value8 != null ? !value8.equals(value9) : value9 != null) break block12;
                        this.addUniqueIndex(ad);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block9;
                    }
                    Enumeration.Value value10 = CQIndexType$.MODULE$.HASH();
                    Enumeration.Value value11 = value;
                    if (value10 != null ? !value10.equals(value11) : value11 != null) break block13;
                    this.addHashIndex(ad);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block9;
                }
                Enumeration.Value value12 = CQIndexType$.MODULE$.NONE();
                Enumeration.Value value13 = value;
                if (value12 != null ? !value12.equals(value13) : value13 != null) break block14;
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError((Object)value);
    }

    private void addFidIndex() {
        Attribute<SimpleFeature, String> attribute = SFTAttributes$.MODULE$.fidAttribute();
        this.cqcache().addIndex((Index)HashIndex.onAttribute(attribute));
    }

    private void addGeoIndex(AttributeDescriptor ad) {
        Attribute geom = this.attributes().lookup(ad.getLocalName());
        this.cqcache().addIndex(GeoIndex.onAttribute(this.sft(), geom));
    }

    private void addNavigableIndex(AttributeDescriptor ad) {
        Class binding = ad.getType().getBinding();
        Class clazz = binding;
        if (Integer.class.isAssignableFrom(clazz)) {
            Attribute attr = this.attributes().lookup(ad.getLocalName());
            this.cqcache().addIndex((Index)NavigableIndex.onAttribute(attr));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (Long.class.isAssignableFrom(clazz)) {
            Attribute attr = this.attributes().lookup(ad.getLocalName());
            this.cqcache().addIndex((Index)NavigableIndex.onAttribute(attr));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (Float.class.isAssignableFrom(clazz)) {
            Attribute attr = this.attributes().lookup(ad.getLocalName());
            this.cqcache().addIndex((Index)NavigableIndex.onAttribute(attr));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (Double.class.isAssignableFrom(clazz)) {
            Attribute attr = this.attributes().lookup(ad.getLocalName());
            this.cqcache().addIndex((Index)NavigableIndex.onAttribute(attr));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (Date.class.isAssignableFrom(clazz)) {
            Attribute attr = this.attributes().lookup(ad.getLocalName());
            this.cqcache().addIndex((Index)NavigableIndex.onAttribute(attr));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to add a Navigable index for attribute ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ad.getLocalName()})));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        }
    }

    private void addRadixIndex(AttributeDescriptor ad) {
        BoxedUnit boxedUnit;
        if (String.class.isAssignableFrom(ad.getType().getBinding())) {
            Attribute attribute = this.attributes().lookup(ad.getLocalName());
            this.cqcache().addIndex((Index)RadixTreeIndex.onAttribute(attribute));
        } else if (this.logger().underlying().isWarnEnabled()) {
            this.logger().underlying().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to add a Radix index for attribute ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ad.getLocalName()})));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    private void addUniqueIndex(AttributeDescriptor ad) {
        Attribute attribute = this.attributes().lookup(ad.getLocalName());
        this.cqcache().addIndex((Index)UniqueIndex.onAttribute(attribute));
    }

    private void addHashIndex(AttributeDescriptor ad) {
        Attribute attribute = this.attributes().lookup(ad.getLocalName());
        this.cqcache().addIndex((Index)HashIndex.onAttribute(attribute));
    }

    public GeoCQEngine(SimpleFeatureType sft, boolean enableFidIndex, boolean enableGeomIndex) {
        this.sft = sft;
        LazyLogging.class.$init$((LazyLogging)this);
        this.cqcache = new ConcurrentIndexedCollection();
        this.attributes = new SFTAttributes(sft);
        if (enableGeomIndex) {
            this.addGeoIndex((AttributeDescriptor)sft.getGeometryDescriptor());
        }
        if (enableFidIndex) {
            this.addFidIndex();
        }
        JavaConversions$.MODULE$.asScalaBuffer(sft.getAttributeDescriptors()).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GeoCQEngine $outer;

            public final void apply(AttributeDescriptor x$1) {
                this.$outer.org$locationtech$geomesa$memory$cqengine$GeoCQEngine$$addIndex(x$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

