/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.memory.cqengine.index;

import com.googlecode.cqengine.attribute.Attribute;
import com.googlecode.cqengine.index.Index;
import com.googlecode.cqengine.index.support.AbstractAttributeIndex;
import com.googlecode.cqengine.index.support.indextype.OnHeapTypeIndex;
import com.googlecode.cqengine.persistence.support.ObjectSet;
import com.googlecode.cqengine.persistence.support.ObjectStore;
import com.googlecode.cqengine.query.Query;
import com.googlecode.cqengine.query.option.QueryOptions;
import com.googlecode.cqengine.resultset.ResultSet;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import java.util.HashSet;
import java.util.Set;
import org.locationtech.geomesa.memory.cqengine.query.Intersects;
import org.locationtech.geomesa.utils.index.BucketIndex;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.collection.Iterator;
import scala.collection.JavaConversions;
import scala.runtime.AbstractFunction1;

public class GeoIndex<A extends Geometry, O extends SimpleFeature>
extends AbstractAttributeIndex<A, O>
implements OnHeapTypeIndex {
    private static final Logger LOGGER = LoggerFactory.getLogger(GeoIndex.class);
    private static final int INDEX_RETRIEVAL_COST = 40;
    volatile BucketIndex<SimpleFeature> index = new BucketIndex(360, 180, new Envelope(-180.0, 180.0, -90.0, 90.0));
    int geomAttributeIndex;
    static Set<Class<? extends Query>> supportedQueries = new HashSet<Class<? extends Query>>(){
        {
            this.add(Intersects.class);
        }
    };

    public GeoIndex(SimpleFeatureType sft, Attribute<O, A> attribute) {
        super(attribute, supportedQueries);
        this.geomAttributeIndex = sft.indexOf(attribute.getAttributeName());
    }

    public static <A extends Geometry, O extends SimpleFeature> GeoIndex<A, O> onAttribute(SimpleFeatureType sft, Attribute<O, A> attribute) {
        return new GeoIndex<A, O>(sft, attribute);
    }

    public void init(ObjectStore<O> objectStore, QueryOptions queryOptions) {
        this.addAll(ObjectSet.fromObjectStore(objectStore, (QueryOptions)queryOptions), queryOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAll(ObjectSet<O> objectSet, QueryOptions queryOptions) {
        try {
            boolean modified = false;
            for (SimpleFeature object : objectSet) {
                Envelope env = ((Geometry)object.getDefaultGeometry()).getEnvelopeInternal();
                this.index.insert(env, (Object)object);
                modified = true;
            }
            boolean bl = modified;
            return bl;
        }
        finally {
            objectSet.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAll(ObjectSet<O> objectSet, QueryOptions queryOptions) {
        try {
            boolean modified = false;
            for (SimpleFeature object : objectSet) {
                Envelope env = ((Geometry)object.getDefaultGeometry()).getEnvelopeInternal();
                this.index.remove(env, (Object)object);
                modified = true;
            }
            boolean bl = modified;
            return bl;
        }
        finally {
            objectSet.close();
        }
    }

    public void clear(QueryOptions queryOptions) {
        this.index = new BucketIndex(360, 180, new Envelope(-180.0, 180.0, -90.0, 90.0));
    }

    public ResultSet<O> retrieve(final Query<O> query, final QueryOptions queryOptions) {
        return new ResultSet<O>(){

            public java.util.Iterator<O> iterator() {
                Iterator iter = GeoIndex.this.getSimpleFeatureIteratorInternal((Intersects)query, queryOptions);
                return JavaConversions.asJavaIterator((Iterator)iter);
            }

            public boolean contains(O object) {
                Intersects intersects = (Intersects)query;
                Geometry geom = (Geometry)object.getAttribute(GeoIndex.this.geomAttributeIndex);
                return intersects.matchesValue(geom, queryOptions);
            }

            public boolean matches(O object) {
                return query.matches(object, queryOptions);
            }

            public Query<O> getQuery() {
                return query;
            }

            public QueryOptions getQueryOptions() {
                return queryOptions;
            }

            public int getRetrievalCost() {
                return 40;
            }

            public int getMergeCost() {
                return this.size();
            }

            public int size() {
                return GeoIndex.this.getSimpleFeatureIteratorInternal((Intersects)query, queryOptions).size();
            }

            public void close() {
            }
        };
    }

    private Iterator<SimpleFeature> getSimpleFeatureIteratorInternal(Intersects query, final QueryOptions queryOptions) {
        final Intersects intersects = query;
        Envelope queryEnvelope = intersects.getEnvelope();
        return this.index.query(queryEnvelope, (Function1)new AbstractFunction1<SimpleFeature, Object>(){

            public Object apply(SimpleFeature feature) {
                try {
                    Geometry geom = (Geometry)feature.getAttribute(GeoIndex.this.geomAttributeIndex);
                    return intersects.matchesValue(geom, queryOptions);
                }
                catch (Exception e) {
                    LOGGER.warn("Caught exception while trying to look up geometry", (Throwable)e);
                    return false;
                }
            }
        });
    }

    public boolean isMutable() {
        return true;
    }

    public boolean isQuantized() {
        return false;
    }

    public Index<O> getEffectiveIndex() {
        return this;
    }
}

