/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.kafka10;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterException;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import kafka.tools.ConsoleConsumer$;
import org.locationtech.geomesa.kafka10.KafkaDataStore;
import org.locationtech.geomesa.kafka10.KafkaDataStore$;
import org.locationtech.geomesa.kafka10.KafkaDataStoreLogViewerParameters;
import org.locationtech.geomesa.kafka10.KafkaFeatureConfig;
import org.locationtech.geomesa.kafka10.KafkaGeoMessageFormatter$;
import org.locationtech.geomesa.kafka10.KafkaUtils10$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes$;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.sys.package$;

public final class KafkaDataStoreLogViewer$
implements LazyLogging {
    public static final KafkaDataStoreLogViewer$ MODULE$;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new KafkaDataStoreLogViewer$();
    }

    private Logger logger$lzycompute() {
        KafkaDataStoreLogViewer$ kafkaDataStoreLogViewer$ = this;
        synchronized (kafkaDataStoreLogViewer$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public void main(String[] args) {
        JCommander jc = new JCommander();
        jc.setProgramName("kafka-ds-log-viewer");
        KafkaDataStoreLogViewerParameters params = new KafkaDataStoreLogViewerParameters();
        jc.addObject((Object)params);
        try {
            jc.parse((String[])Predef$.MODULE$.refArrayOps((Object[])args).toArray(ClassTag$.MODULE$.apply(String.class)));
        }
        catch (ParameterException parameterException) {
            this.printUsageAndExit(jc, new StringBuilder().append((Object)"Error parsing arguments: ").append((Object)parameterException.getMessage()).toString());
        }
        String zookeepers = params.zookeeper();
        String zkPath = params.zkPath();
        String sftName = params.sftName();
        boolean fromBeginning = params.isFromBeginning();
        this.run(zookeepers, zkPath, sftName, fromBeginning);
    }

    public void run(String zookeeper, String zkPath, String sftName, boolean fromBeginning) {
        BoxedUnit boxedUnit;
        KafkaFeatureConfig featureConfig = new KafkaDataStore(zookeeper, zkPath, 1, 1, null, KafkaDataStore$.MODULE$.$lessinit$greater$default$6()).getFeatureConfig(sftName);
        String formatter = KafkaUtils10$.MODULE$.messageFormatClassName();
        String sftSpec = this.encodeSFT(featureConfig.sft());
        Seq ccArgs = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--topic", featureConfig.topic(), "--zookeeper", zookeeper, "--formatter", formatter, "--property", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{KafkaGeoMessageFormatter$.MODULE$.sftNameKey(), sftName})), "--property", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{KafkaGeoMessageFormatter$.MODULE$.sftSpecKey(), sftSpec}))}));
        if (fromBeginning) {
            ccArgs = (Seq)ccArgs.$colon$plus((Object)"--from-beginning", Seq$.MODULE$.canBuildFrom());
        }
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Running 'kafka-console-consumer ", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ccArgs.mkString(" ")})));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        ConsoleConsumer$.MODULE$.main((String[])ccArgs.toArray(ClassTag$.MODULE$.apply(String.class)));
    }

    public String encodeSFT(SimpleFeatureType sft) {
        return SimpleFeatureTypes$.MODULE$.encodeType(sft, SimpleFeatureTypes$.MODULE$.encodeType$default$2()).replaceAll("%", "%37").replaceAll("=", "%61");
    }

    public SimpleFeatureType decodeSFT(String name, String spec) {
        return SimpleFeatureTypes$.MODULE$.createType(name, spec.replaceAll("%61", "=").replaceAll("%37", "%"));
    }

    public void printUsageAndExit(JCommander jc, String message) {
        System.err.println(message);
        jc.usage();
        throw package$.MODULE$.exit(-1);
    }

    private KafkaDataStoreLogViewer$() {
        MODULE$ = this;
        LazyLogging.class.$init$((LazyLogging)this);
    }
}

