/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.kafka10;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.geotools.data.FeatureWriter;
import org.locationtech.geomesa.kafka.GeoMessage;
import org.locationtech.geomesa.kafka.GeoMessage$;
import org.locationtech.geomesa.kafka10.KafkaGeoMessageEncoder;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001q4Q!\u0001\u0002\u0002\u0002-\u0011!cS1gW\u00064U-\u0019;ve\u0016<&/\u001b;fe*\u00111\u0001B\u0001\bW\u000647.Y\u00191\u0015\t)a!A\u0004hK>lWm]1\u000b\u0005\u001dA\u0011\u0001\u00047pG\u0006$\u0018n\u001c8uK\u000eD'\"A\u0005\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001aA#\u000b\t\u0003\u001bIi\u0011A\u0004\u0006\u0003\u001fA\tA\u0001\\1oO*\t\u0011#\u0001\u0003kCZ\f\u0017BA\n\u000f\u0005\u0019y%M[3diB!QC\u0007\u000f'\u001b\u00051\"BA\f\u0019\u0003\u0011!\u0017\r^1\u000b\u0005eA\u0011\u0001C4f_R|w\u000e\\:\n\u0005m1\"!\u0004$fCR,(/Z,sSR,'\u000f\u0005\u0002\u001eI5\taD\u0003\u0002 A\u000511/[7qY\u0016T!!\t\u0012\u0002\u000f\u0019,\u0017\r^;sK*\u00111\u0005C\u0001\b_B,gnZ5t\u0013\t)cDA\tTS6\u0004H.\u001a$fCR,(/\u001a+za\u0016\u0004\"!H\u0014\n\u0005!r\"!D*j[BdWMR3biV\u0014X\r\u0005\u0002+c5\t1F\u0003\u0002-[\u0005a1oY1mC2|wmZ5oO*\u0011afL\u0001\tif\u0004Xm]1gK*\t\u0001'A\u0002d_6L!AM\u0016\u0003\u00171\u000b'0\u001f'pO\u001eLgn\u001a\u0005\ti\u0001\u0011\t\u0011)A\u00059\u0005\u00191O\u001a;\t\u0011Y\u0002!\u0011!Q\u0001\n]\n\u0001\u0002\u001d:pIV\u001cWM\u001d\t\u0005q\u0001\u0013%)D\u0001:\u0015\t1$H\u0003\u0002<y\u000591\r\\5f]R\u001c(BA\u001f?\u0003\u0015Y\u0017MZ6b\u0015\ty\u0004\"\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0003\u0003f\u0012QbS1gW\u0006\u0004&o\u001c3vG\u0016\u0014\bcA\"G\u00116\tAIC\u0001F\u0003\u0015\u00198-\u00197b\u0013\t9EIA\u0003BeJ\f\u0017\u0010\u0005\u0002D\u0013&\u0011!\n\u0012\u0002\u0005\u0005f$X\r\u0003\u0005M\u0001\t\u0005\t\u0015!\u0003N\u0003\u0015!x\u000e]5d!\tq\u0015K\u0004\u0002D\u001f&\u0011\u0001\u000bR\u0001\u0007!J,G-\u001a4\n\u0005I\u001b&AB*ue&twM\u0003\u0002Q\t\")Q\u000b\u0001C\u0001-\u00061A(\u001b8jiz\"BaV-[7B\u0011\u0001\fA\u0007\u0002\u0005!)A\u0007\u0016a\u00019!)a\u0007\u0016a\u0001o!)A\n\u0016a\u0001\u001b\"9Q\f\u0001b\u0001\n#q\u0016AC7tO\u0016s7m\u001c3feV\tq\f\u0005\u0002YA&\u0011\u0011M\u0001\u0002\u0017\u0017\u000647.Y$f_6+7o]1hK\u0016s7m\u001c3fe\"11\r\u0001Q\u0001\n}\u000b1\"\\:h\u000b:\u001cw\u000eZ3sA!1Q\r\u0001C\u0001\u0005\u0019\fQa\u001e:ji\u0016$\"a\u001a6\u0011\u0005\rC\u0017BA5E\u0005\u0011)f.\u001b;\t\u000b-$\u0007\u0019\u0001\u0014\u0002\u0005M4\u0007BB7\u0001\t\u0003\u0011a.\u0001\u0003tK:$GCA4p\u0011\u0015\u0001H\u000e1\u0001r\u0003\ri7o\u001a\t\u0003eRl\u0011a\u001d\u0006\u0003{\u0011I!!^:\u0003\u0015\u001d+w.T3tg\u0006<W\rC\u0003x\u0001\u0011\u0005\u00030\u0001\bhKR4U-\u0019;ve\u0016$\u0016\u0010]3\u0015\u0003qAQA\u001f\u0001\u0005Bm\fQa\u00197pg\u0016$\u0012a\u001a")
public abstract class KafkaFeatureWriter
implements FeatureWriter<SimpleFeatureType, SimpleFeature>,
LazyLogging {
    private final SimpleFeatureType sft;
    private final KafkaProducer<byte[], byte[]> producer;
    private final String topic;
    private final KafkaGeoMessageEncoder msgEncoder;
    private final Logger logger;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        KafkaFeatureWriter kafkaFeatureWriter = this;
        synchronized (kafkaFeatureWriter) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public KafkaGeoMessageEncoder msgEncoder() {
        return this.msgEncoder;
    }

    public void write(SimpleFeature sf) {
        this.send((GeoMessage)GeoMessage$.MODULE$.createOrUpdate(sf));
    }

    public void send(GeoMessage msg) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("sending message: {}", new Object[]{msg});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.producer.send(new ProducerRecord(this.topic, this.msgEncoder().encodeMessage(this.topic, msg).key(), this.msgEncoder().encodeMessage(this.topic, msg).message()));
    }

    public SimpleFeatureType getFeatureType() {
        return this.sft;
    }

    public void close() {
    }

    public KafkaFeatureWriter(SimpleFeatureType sft, KafkaProducer<byte[], byte[]> producer, String topic) {
        this.sft = sft;
        this.producer = producer;
        this.topic = topic;
        LazyLogging.class.$init$((LazyLogging)this);
        this.msgEncoder = new KafkaGeoMessageEncoder(sft);
    }
}

