/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.kafka10.consumer.offsets;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import kafka.api.OffsetCommitRequest;
import kafka.api.OffsetCommitRequest$;
import kafka.api.OffsetCommitResponse;
import kafka.api.OffsetCommitResponse$;
import kafka.api.OffsetRequest$;
import kafka.api.PartitionMetadata;
import kafka.api.Request$;
import kafka.api.RequestOrResponse;
import kafka.cluster.BrokerEndPoint;
import kafka.common.ErrorMapping$;
import kafka.common.OffsetAndMetadata;
import kafka.common.TopicAndPartition;
import kafka.consumer.ConsumerConfig;
import kafka.consumer.SimpleConsumer;
import kafka.message.ByteBufferMessageSet;
import kafka.message.Message;
import kafka.message.MessageAndOffset;
import kafka.network.BlockingChannel;
import org.locationtech.geomesa.kafka10.KafkaUtils10$;
import org.locationtech.geomesa.kafka10.ZkUtils10;
import org.locationtech.geomesa.kafka10.consumer.Broker;
import org.locationtech.geomesa.kafka10.consumer.Brokers$;
import org.locationtech.geomesa.kafka10.consumer.Fetcher;
import org.locationtech.geomesa.kafka10.consumer.Fetcher$class;
import org.locationtech.geomesa.kafka10.consumer.KafkaConsumer$;
import org.locationtech.geomesa.kafka10.consumer.WrappedConsumer;
import org.locationtech.geomesa.kafka10.consumer.offsets.DateOffset;
import org.locationtech.geomesa.kafka10.consumer.offsets.EarliestOffset$;
import org.locationtech.geomesa.kafka10.consumer.offsets.FindOffset;
import org.locationtech.geomesa.kafka10.consumer.offsets.GroupOffset$;
import org.locationtech.geomesa.kafka10.consumer.offsets.LatestOffset$;
import org.locationtech.geomesa.kafka10.consumer.offsets.OffsetManager$;
import org.locationtech.geomesa.kafka10.consumer.offsets.RequestedOffset;
import org.locationtech.geomesa.kafka10.consumer.offsets.SpecificOffset;
import org.locationtech.geomesa.kafka10.consumer.offsets.WrappedChannel;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.NotImplementedError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.VolatileByteRef;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\t\rd\u0001B\u0001\u0003\u0001=\u0011Qb\u00144gg\u0016$X*\u00198bO\u0016\u0014(BA\u0002\u0005\u0003\u001dygMZ:fiNT!!\u0002\u0004\u0002\u0011\r|gn];nKJT!a\u0002\u0005\u0002\u000f-\fgm[12a)\u0011\u0011BC\u0001\bO\u0016|W.Z:b\u0015\tYA\"\u0001\u0007m_\u000e\fG/[8oi\u0016\u001c\u0007NC\u0001\u000e\u0003\ry'oZ\u0002\u0001'\u0015\u0001\u0001C\u0006\u000e#!\t\tB#D\u0001\u0013\u0015\u0005\u0019\u0012!B:dC2\f\u0017BA\u000b\u0013\u0005\u0019\te.\u001f*fMB\u0011q\u0003G\u0007\u0002\t%\u0011\u0011\u0004\u0002\u0002\b\r\u0016$8\r[3s!\tY\u0002%D\u0001\u001d\u0015\tib$\u0001\u0002j_*\tq$\u0001\u0003kCZ\f\u0017BA\u0011\u001d\u0005%\u0019En\\:fC\ndW\r\u0005\u0002$U5\tAE\u0003\u0002&M\u0005a1oY1mC2|wmZ5oO*\u0011q\u0005K\u0001\tif\u0004Xm]1gK*\t\u0011&A\u0002d_6L!a\u000b\u0013\u0003\u00171\u000b'0\u001f'pO\u001eLgn\u001a\u0005\t[\u0001\u0011)\u0019!C\u0001]\u000511m\u001c8gS\u001e,\u0012a\f\t\u0003aQj\u0011!\r\u0006\u0003\u000bIR\u0011aM\u0001\u0006W\u000647.Y\u0005\u0003kE\u0012abQ8ogVlWM]\"p]\u001aLw\r\u0003\u00058\u0001\t\u0005\t\u0015!\u00030\u0003\u001d\u0019wN\u001c4jO\u0002BQ!\u000f\u0001\u0005\u0002i\na\u0001P5oSRtDCA\u001e>!\ta\u0004!D\u0001\u0003\u0011\u0015i\u0003\b1\u00010\u0011!y\u0004\u0001#b\u0001\n\u0013\u0001\u0015aB2iC:tW\r\\\u000b\u0002\u0003B\u0011AHQ\u0005\u0003\u0007\n\u0011ab\u0016:baB,Gm\u00115b]:,G\u000e\u0003\u0005F\u0001!\u0005\t\u0015)\u0003B\u0003!\u0019\u0007.\u00198oK2\u0004\u0003\u0002C$\u0001\u0011\u000b\u0007I\u0011\u0002%\u0002\u000fi\\W\u000b^5mgV\t\u0011\n\u0005\u0002K\u00176\ta!\u0003\u0002M\r\tI!l[+uS2\u001c\u0018\u0007\r\u0005\t\u001d\u0002A\t\u0011)Q\u0005\u0013\u0006A!p[+uS2\u001c\b\u0005C\u0003Q\u0001\u0011\u0005\u0011+\u0001\u0006hKR|eMZ:fiN$RAUA4\u0003S\u0002\"aU.\u000f\u0005q\"v!B+\u0003\u0011\u00031\u0016!D(gMN,G/T1oC\u001e,'\u000f\u0005\u0002=/\u001a)\u0011A\u0001E\u00011N\u0019q\u000b\u0005\u0012\t\u000be:F\u0011\u0001.\u0015\u0003Y+A\u0001X,\u0001;\n9qJ\u001a4tKR\u001c\b\u0003\u00020bI*t!!E0\n\u0005\u0001\u0014\u0012A\u0002)sK\u0012,g-\u0003\u0002cG\n\u0019Q*\u00199\u000b\u0005\u0001\u0014\u0002CA3i\u001b\u00051'BA43\u0003\u0019\u0019w.\\7p]&\u0011\u0011N\u001a\u0002\u0012)>\u0004\u0018nY!oIB\u000b'\u000f^5uS>t\u0007CA\tl\u0013\ta'C\u0001\u0003M_:<\u0007b\u00028X\u0005\u0004%Ia\\\u0001\tG2LWM\u001c;JIV\t\u0001\u000f\u0005\u0002ri6\t!O\u0003\u0002t=\u0005!A.\u00198h\u0013\t)(O\u0001\u0004TiJLgn\u001a\u0005\u0007o^\u0003\u000b\u0011\u00029\u0002\u0013\rd\u0017.\u001a8u\u0013\u0012\u0004\u0003\"B=X\t\u0003Q\u0018aD4fi\u001e\u0013x.\u001e9PM\u001a\u001cX\r^:\u0015\rml\u0018\u0011BA\u0013!\ta8,D\u0001X\u0011\u0015y\u0004\u00101\u0001\u007f!\ry\u0018QA\u0007\u0003\u0003\u0003Q1!a\u00013\u0003\u001dqW\r^<pe.LA!a\u0002\u0002\u0002\ty!\t\\8dW&twm\u00115b]:,G\u000eC\u0004\u0002\fa\u0004\r!!\u0004\u0002\u0015A\f'\u000f^5uS>t7\u000fE\u0003\u0002\u0010\u0005}AM\u0004\u0003\u0002\u0012\u0005ma\u0002BA\n\u00033i!!!\u0006\u000b\u0007\u0005]a\"\u0001\u0004=e>|GOP\u0005\u0002'%\u0019\u0011Q\u0004\n\u0002\u000fA\f7m[1hK&!\u0011\u0011EA\u0012\u0005\r\u0019V-\u001d\u0006\u0004\u0003;\u0011\u0002\"B\u0017y\u0001\u0004y\u0003bBA\u0015/\u0012\u0005\u00111F\u0001\u0011O\u0016$xJ\u001a4tKR\u001c()\u001a4pe\u0016$\u0012b_A\u0017\u0003k\t)%!\u0013\t\u0011\u0005=\u0012q\u0005a\u0001\u0003c\tQ\u0001^8qS\u000e\u00042AXA\u001a\u0013\t)8\r\u0003\u0005\u0002\f\u0005\u001d\u0002\u0019AA\u001c!\u0019\ty!a\b\u0002:A!\u00111HA!\u001b\t\tiDC\u0002\u0002@I\n1!\u00199j\u0013\u0011\t\u0019%!\u0010\u0003#A\u000b'\u000f^5uS>tW*\u001a;bI\u0006$\u0018\rC\u0004\u0002H\u0005\u001d\u0002\u0019\u00016\u0002\tQLW.\u001a\u0005\u0007[\u0005\u001d\u0002\u0019A\u0018\t\u000f\u00055s\u000b\"\u0003\u0002P\u0005\u0011\u0002.\u00198eY\u0016|eMZ:fi\u0016\u0013(o\u001c:t)\u0011\t\t&a\u0016\u0011\u0007E\t\u0019&C\u0002\u0002VI\u0011A!\u00168ji\"A\u0011\u0011LA&\u0001\u0004\tY&A\u0003d_\u0012,7\u000f\u0005\u0004\u0002\u0010\u0005u\u0013\u0011M\u0005\u0005\u0003?\n\u0019C\u0001\u0005Ji\u0016\u0014\u0018M\u00197f!\r\t\u00121M\u0005\u0004\u0003K\u0012\"!B*i_J$\bbBA\u0018\u001f\u0002\u0007\u0011\u0011\u0007\u0005\b\u0003Wz\u0005\u0019AA7\u0003\u00119\b.\u001a8\u0011\u0007q\ny'C\u0002\u0002r\t\u0011qBU3rk\u0016\u001cH/\u001a3PM\u001a\u001cX\r\u001e\u0005\u0007!\u0002!\t!!\u001e\u0015\u000fI\u000b9(!\u001f\u0002|!A\u0011qFA:\u0001\u0004\t\t\u0004\u0003\u0005\u0002\f\u0005M\u0004\u0019AA\u001c\u0011!\tY'a\u001dA\u0002\u00055\u0004bBA@\u0001\u0011\u0005\u0011\u0011Q\u0001\fM&tGm\u00144gg\u0016$8\u000fF\u0005S\u0003\u0007\u000b))a\"\u00022\"A\u0011qFA?\u0001\u0004\t\t\u0004\u0003\u0005\u0002\f\u0005u\u0004\u0019AA\u001c\u0011!\tI)! A\u0002\u0005-\u0015!\u00039sK\u0012L7-\u0019;f!\u0011\ti)a+\u000f\t\u0005=\u0015q\u0015\b\u0005\u0003#\u000b)K\u0004\u0003\u0002\u0014\u0006\rf\u0002BAK\u0003CsA!a&\u0002 :!\u0011\u0011TAO\u001d\u0011\t\u0019\"a'\n\u00035I!a\u0003\u0007\n\u0005%Q\u0011BA\u0004\t\u0013\t)a!\u0003\u0002\u0004\t%\u0019\u0011\u0011\u0016\u0002\u0002\u0015\u0019Kg\u000eZ(gMN,G/\u0003\u0003\u0002.\u0006=&\u0001E'fgN\fw-\u001a)sK\u0012L7-\u0019;f\u0015\r\tIK\u0001\u0005\u0007[\u0005u\u0004\u0019A\u0018\t\u0011\u0005U\u0006\u0001\"\u0002\u0007\u0003o\u000b!CY5oCJLxJ\u001a4tKR\u001cV-\u0019:dQRA\u0011\u0011XA`\u0003\u000f\fI\r\u0005\u0003\u0012\u0003wS\u0017bAA_%\t1q\n\u001d;j_:Dq!BAZ\u0001\u0004\t\t\rE\u0002\u0018\u0003\u0007L1!!2\u0005\u0005=9&/\u00199qK\u0012\u001cuN\\:v[\u0016\u0014\b\u0002CAE\u0003g\u0003\r!a#\t\u0011\u0005-\u00171\u0017a\u0001\u0003\u001b\faAY8v]\u0012\u001c\b#B\t\u0002P*T\u0017bAAi%\t1A+\u001e9mKJBC!a-\u0002VB!\u0011q[Ao\u001b\t\tINC\u0002\u0002\\J\t!\"\u00198o_R\fG/[8o\u0013\u0011\ty.!7\u0003\u000fQ\f\u0017\u000e\u001c:fG\"A\u00111\u001d\u0001\u0005\u0002\u0019\t)/\u0001\u0003ue&lGCBAt\u0003s\u0014\u0019\u0001E\u0003\u0012\u0003S\fi/C\u0002\u0002lJ\u0011Q!\u0011:sCf\u0004B!a<\u0002v6\u0011\u0011\u0011\u001f\u0006\u0004\u0003g\u0014\u0014aB7fgN\fw-Z\u0005\u0005\u0003o\f\tP\u0001\tNKN\u001c\u0018mZ3B]\u0012|eMZ:fi\"A\u00111`Aq\u0001\u0004\ti0\u0001\u0006nKN\u001c\u0018mZ3TKR\u0004B!a<\u0002\u0000&!!\u0011AAy\u0005Q\u0011\u0015\u0010^3Ck\u001a4WM]'fgN\fw-Z*fi\"9!QAAq\u0001\u0004Q\u0017aA3oI\"9!\u0011\u0002\u0001\u0005\n\t-\u0011\u0001\u0004:fiJLxJ\u001a4tKR\u001cH#\u0002*\u0003\u000e\t]\u0001\u0002\u0003B\b\u0005\u000f\u0001\rA!\u0005\u0002\u0011\u0019,hn\u0019;j_:\u0004B!\u0005B\n%&\u0019!Q\u0003\n\u0003\u0013\u0019+hn\u0019;j_:\u0004\u0004\u0002\u0003B\r\u0005\u000f\u0001\rAa\u0007\u0002\u000bQ\u0014\u0018.Z:\u0011\u0007E\u0011i\"C\u0002\u0003 I\u00111!\u00138uQ\u0011\u00119!!6\t\u000f\t\u0015\u0002\u0001\"\u0001\u0003(\u0005i1m\\7nSR|eMZ:fiN$b!!\u0015\u0003*\tM\u0002bB\u0002\u0003$\u0001\u0007!1\u0006\t\u0006=\u0006$'Q\u0006\t\u0004K\n=\u0012b\u0001B\u0019M\n\trJ\u001a4tKR\fe\u000eZ'fi\u0006$\u0017\r^1\t\u0015\tU\"1\u0005I\u0001\u0002\u0004\u00119$\u0001\u0007jg\u0006+Ho\\\"p[6LG\u000fE\u0002\u0012\u0005sI1Aa\u000f\u0013\u0005\u001d\u0011un\u001c7fC:DqA!\n\u0001\t\u0013\u0011y\u0004\u0006\u0004\u0002R\t\u0005#1\t\u0005\b\u0007\tu\u0002\u0019\u0001B\u0016\u0011!\u0011IB!\u0010A\u0002\tm\u0001\u0006\u0002B\u001f\u0003+DqA!\u0013\u0001\t\u0003\u0012Y%A\u0003dY>\u001cX\r\u0006\u0002\u0002R!I!q\n\u0001\u0012\u0002\u0013\u0005!\u0011K\u0001\u0018G>lW.\u001b;PM\u001a\u001cX\r^:%I\u00164\u0017-\u001e7uII*\"Aa\u0015+\t\t]\"QK\u0016\u0003\u0005/\u0002BA!\u0017\u0003`5\u0011!1\f\u0006\u0005\u0005;\nI.A\u0005v]\u000eDWmY6fI&!!\u0011\rB.\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a")
public class OffsetManager
implements Fetcher,
Closeable {
    private final ConsumerConfig config;
    private WrappedChannel org$locationtech$geomesa$kafka10$consumer$offsets$OffsetManager$$channel;
    private ZkUtils10 zkUtils;
    private final Logger logger;
    private volatile byte bitmap$0;

    public static Map<TopicAndPartition, Object> getOffsetsBefore(String string, Seq<PartitionMetadata> seq, long l, ConsumerConfig consumerConfig) {
        return OffsetManager$.MODULE$.getOffsetsBefore(string, seq, l, consumerConfig);
    }

    public static Map<TopicAndPartition, Object> getGroupOffsets(BlockingChannel blockingChannel, Seq<TopicAndPartition> seq, ConsumerConfig consumerConfig) {
        return OffsetManager$.MODULE$.getGroupOffsets(blockingChannel, seq, consumerConfig);
    }

    private WrappedChannel org$locationtech$geomesa$kafka10$consumer$offsets$OffsetManager$$channel$lzycompute() {
        OffsetManager offsetManager = this;
        synchronized (offsetManager) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.org$locationtech$geomesa$kafka10$consumer$offsets$OffsetManager$$channel = new WrappedChannel(this.zkUtils(), this.config());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.org$locationtech$geomesa$kafka10$consumer$offsets$OffsetManager$$channel;
        }
    }

    private ZkUtils10 zkUtils$lzycompute() {
        OffsetManager offsetManager = this;
        synchronized (offsetManager) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.zkUtils = KafkaUtils10$.MODULE$.createZkUtils(this.config());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.zkUtils;
        }
    }

    @Override
    public Try<ByteBufferMessageSet> fetch(SimpleConsumer consumer, String topic, int partition, long offset, int maxBytes) {
        return Fetcher$class.fetch(this, consumer, topic, partition, offset, maxBytes);
    }

    private Logger logger$lzycompute() {
        OffsetManager offsetManager = this;
        synchronized (offsetManager) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.logger$lzycompute() : this.logger;
    }

    public ConsumerConfig config() {
        return this.config;
    }

    public WrappedChannel org$locationtech$geomesa$kafka10$consumer$offsets$OffsetManager$$channel() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.org$locationtech$geomesa$kafka10$consumer$offsets$OffsetManager$$channel$lzycompute() : this.org$locationtech$geomesa$kafka10$consumer$offsets$OffsetManager$$channel;
    }

    private ZkUtils10 zkUtils() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.zkUtils$lzycompute() : this.zkUtils;
    }

    public Map<TopicAndPartition, Object> getOffsets(String topic, RequestedOffset when) {
        Seq<PartitionMetadata> partitions = KafkaConsumer$.MODULE$.findPartitions(topic, this.config());
        Predef$.MODULE$.assert(partitions.nonEmpty(), (Function0)new Serializable(this, topic){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OffsetManager $outer;
            private final String topic$2;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Topic ", " does not exist in brokers ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$2, Brokers$.MODULE$.apply(this.$outer.config()).mkString(",")}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topic$2 = topic$2;
            }
        });
        return this.getOffsets(topic, partitions, when);
    }

    public Map<TopicAndPartition, Object> getOffsets(String topic, Seq<PartitionMetadata> partitions, RequestedOffset when) {
        block14: {
            Map map;
            Object object;
            block9: {
                RequestedOffset requestedOffset;
                block13: {
                    block12: {
                        block11: {
                            block10: {
                                block8: {
                                    Predef$.MODULE$.assert(partitions.nonEmpty(), (Function0)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final String apply() {
                                            return "Topic and partitions are required";
                                        }
                                    });
                                    requestedOffset = when;
                                    if (!EarliestOffset$.MODULE$.equals(requestedOffset)) break block8;
                                    object = new Serializable(this, topic, partitions){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ OffsetManager $outer;
                                        private final String topic$1;
                                        private final Seq partitions$1;

                                        public final Map<TopicAndPartition, Object> apply() {
                                            return OffsetManager$.MODULE$.getOffsetsBefore(this.topic$1, (Seq<PartitionMetadata>)this.partitions$1, OffsetRequest$.MODULE$.EarliestTime(), this.$outer.config());
                                        }
                                        {
                                            if ($outer == null) {
                                                throw null;
                                            }
                                            this.$outer = $outer;
                                            this.topic$1 = topic$1;
                                            this.partitions$1 = partitions$1;
                                        }
                                    };
                                    break block9;
                                }
                                if (!LatestOffset$.MODULE$.equals(requestedOffset)) break block10;
                                object = new Serializable(this, topic, partitions){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ OffsetManager $outer;
                                    private final String topic$1;
                                    private final Seq partitions$1;

                                    public final Map<TopicAndPartition, Object> apply() {
                                        return OffsetManager$.MODULE$.getOffsetsBefore(this.topic$1, (Seq<PartitionMetadata>)this.partitions$1, OffsetRequest$.MODULE$.LatestTime(), this.$outer.config());
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                        this.topic$1 = topic$1;
                                        this.partitions$1 = partitions$1;
                                    }
                                };
                                break block9;
                            }
                            if (!(requestedOffset instanceof SpecificOffset)) break block11;
                            SpecificOffset specificOffset = (SpecificOffset)requestedOffset;
                            long s = specificOffset.offset();
                            object = new Serializable(this, topic, partitions, s){
                                public static final long serialVersionUID = 0L;
                                public final String topic$1;
                                private final Seq partitions$1;
                                public final long s$1;

                                public final Map<TopicAndPartition, Object> apply() {
                                    return ((TraversableOnce)this.partitions$1.map((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ $anonfun$3 $outer;

                                        public final Tuple2<TopicAndPartition, Object> apply(PartitionMetadata p) {
                                            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicAndPartition(this.$outer.topic$1, p.partitionId())), (Object)BoxesRunTime.boxToLong((long)this.$outer.s$1));
                                        }
                                        {
                                            if ($outer == null) {
                                                throw null;
                                            }
                                            this.$outer = $outer;
                                        }
                                    }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                                }
                                {
                                    this.topic$1 = topic$1;
                                    this.partitions$1 = partitions$1;
                                    this.s$1 = s$1;
                                }
                            };
                            break block9;
                        }
                        if (!(requestedOffset instanceof DateOffset)) break block12;
                        DateOffset dateOffset = (DateOffset)requestedOffset;
                        long date = dateOffset.date();
                        object = new Serializable(this, topic, partitions, date){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ OffsetManager $outer;
                            private final String topic$1;
                            private final Seq partitions$1;
                            private final long date$1;

                            public final Map<TopicAndPartition, Object> apply() {
                                return OffsetManager$.MODULE$.getOffsetsBefore(this.topic$1, (Seq<PartitionMetadata>)this.partitions$1, this.date$1, this.$outer.config());
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.topic$1 = topic$1;
                                this.partitions$1 = partitions$1;
                                this.date$1 = date$1;
                            }
                        };
                        break block9;
                    }
                    if (!(requestedOffset instanceof FindOffset)) break block13;
                    FindOffset findOffset = (FindOffset)requestedOffset;
                    Function1<Message, Object> pred = findOffset.predicate();
                    object = new Serializable(this, topic, partitions, pred){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ OffsetManager $outer;
                        private final String topic$1;
                        private final Seq partitions$1;
                        private final Function1 pred$1;

                        public final Map<TopicAndPartition, Object> apply() {
                            return this.$outer.findOffsets(this.topic$1, (Seq<PartitionMetadata>)this.partitions$1, (Function1<Message, Object>)this.pred$1, this.$outer.config());
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.topic$1 = topic$1;
                            this.partitions$1 = partitions$1;
                            this.pred$1 = pred$1;
                        }
                    };
                    break block9;
                }
                if (!GroupOffset$.MODULE$.equals(requestedOffset)) break block14;
                object = new Serializable(this, topic, partitions){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ OffsetManager $outer;
                    public final String topic$1;
                    private final Seq partitions$1;

                    public final Map<TopicAndPartition, Object> apply() {
                        Seq taps = (Seq)this.partitions$1.map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$6 $outer;

                            public final TopicAndPartition apply(PartitionMetadata p) {
                                return new TopicAndPartition(this.$outer.topic$1, p.partitionId());
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        }, Seq$.MODULE$.canBuildFrom());
                        return OffsetManager$.MODULE$.getGroupOffsets(this.$outer.org$locationtech$geomesa$kafka10$consumer$offsets$OffsetManager$$channel().channel(), (Seq<TopicAndPartition>)taps, this.$outer.config());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.topic$1 = topic$1;
                        this.partitions$1 = partitions$1;
                    }
                };
            }
            Serializable function = object;
            Map result = (Map)this.retryOffsets((Function0<Map<TopicAndPartition, Object>>)function, 1).filterNot((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<TopicAndPartition, Object> x0$1) {
                    Tuple2<TopicAndPartition, Object> tuple2 = x0$1;
                    if (tuple2 != null) {
                        long offset = tuple2._2$mcJ$sp();
                        boolean bl = offset < 0L;
                        return bl;
                    }
                    throw new MatchError(tuple2);
                }
            });
            if (result.size() == partitions.length()) {
                map = result;
            } else {
                BoxedUnit boxedUnit;
                RequestedOffset requestedOffset = when;
                LatestOffset$ latestOffset$ = LatestOffset$.MODULE$;
                if (!(requestedOffset != null ? !requestedOffset.equals(latestOffset$) : latestOffset$ != null)) {
                    throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not find a valid offset for partitions ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{partitions.mkString(",")})));
                }
                Seq remaining = (Seq)partitions.filterNot((Function1)new Serializable(this, topic, result){
                    public static final long serialVersionUID = 0L;
                    private final String topic$1;
                    private final Map result$1;

                    public final boolean apply(PartitionMetadata p) {
                        return this.result$1.contains((Object)new TopicAndPartition(this.topic$1, p.partitionId()));
                    }
                    {
                        this.topic$1 = topic$1;
                        this.result$1 = result$1;
                    }
                });
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Didn't find a valid offset for topic [", "] partitions "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[", "] looking for [", "] - defaulting to latest"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)remaining.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final int apply(PartitionMetadata x$1) {
                            return x$1.partitionId();
                        }
                    }, Seq$.MODULE$.canBuildFrom())).mkString(","), when}))).toString());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                map = result.$plus$plus(this.getOffsets(topic, (Seq<PartitionMetadata>)remaining, LatestOffset$.MODULE$));
            }
            return map;
        }
        throw new NotImplementedError();
    }

    public Map<TopicAndPartition, Object> findOffsets(String topic, Seq<PartitionMetadata> partitions, Function1<Message, Object> predicate, ConsumerConfig config) {
        return ((TraversableOnce)partitions.flatMap((Function1)new Serializable(this, topic, predicate, config){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OffsetManager $outer;
            private final String topic$4;
            private final Function1 predicate$1;
            public final ConsumerConfig config$2;

            /*
             * WARNING - void declaration
             */
            public final Iterable<Tuple2<TopicAndPartition, Object>> apply(PartitionMetadata partition) {
                Iterable iterable;
                TopicAndPartition tap = new TopicAndPartition(this.topic$4, partition.partitionId());
                Broker leader = (Broker)partition.leader().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Broker apply(BrokerEndPoint l) {
                        return new Broker(l.host(), l.port());
                    }
                }).getOrElse((Function0)new Serializable(this, tap){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$findOffsets$1 $outer;
                    private final TopicAndPartition tap$1;

                    public final Broker apply() {
                        return KafkaConsumer$.MODULE$.findNewLeader(this.tap$1, (Option<Broker>)None$.MODULE$, this.$outer.config$2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.tap$1 = tap$1;
                    }
                });
                WrappedConsumer consumer = new WrappedConsumer(KafkaConsumer$.MODULE$.createConsumer(leader.host(), leader.port(), this.config$2, "offsetLookup"), tap, this.config$2);
                try {
                    int consumerId = Request$.MODULE$.OrdinaryConsumerId();
                    long earliest = consumer.consumer().earliestOrLatestOffset(tap, OffsetRequest$.MODULE$.EarliestTime(), consumerId);
                    long latest = consumer.consumer().earliestOrLatestOffset(tap, OffsetRequest$.MODULE$.LatestTime(), consumerId);
                    iterable = Option$.MODULE$.option2Iterable(this.$outer.binaryOffsetSearch(consumer, (Function1<Message, Object>)this.predicate$1, (Tuple2<Object, Object>)new Tuple2.mcJJ.sp(earliest, latest)).map((Function1)new Serializable(this, tap){
                        public static final long serialVersionUID = 0L;
                        private final TopicAndPartition tap$1;

                        public final Tuple2<TopicAndPartition, Object> apply(long x$2) {
                            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tap$1), (Object)BoxesRunTime.boxToLong((long)x$2));
                        }
                        {
                            this.tap$1 = tap$1;
                        }
                    }));
                }
                catch (Throwable throwable) {
                    void var4_4;
                    var4_4.consumer().close();
                    throw throwable;
                }
                consumer.consumer().close();
                return iterable;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topic$4 = topic$4;
                this.predicate$1 = predicate$1;
                this.config$2 = config$2;
            }
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    /*
     * Unable to fully structure code
     */
    public final Option<Object> binaryOffsetSearch(WrappedConsumer consumer, Function1<Message, Object> predicate, Tuple2<Object, Object> bounds) {
        block41: {
            block42: {
                while (true) {
                    block45: {
                        block44: {
                            block43: {
                                bitmap$0 = VolatileByteRef.create((byte)0);
                                var7_6 = bounds;
                                if (var7_6 == null) break block41;
                                start = var7_6._1$mcJ$sp();
                                var12_9 = new Tuple2.mcJJ.sp(start, end = var7_6._2$mcJ$sp());
                                var6_5 = var12_9;
                                start = var6_5._1$mcJ$sp();
                                if (start == (end = var6_5._2$mcJ$sp())) {
                                    return new Some((Object)BoxesRunTime.boxToLong((long)end));
                                }
                                offset = (start + end) / 2L;
                                maxBytes = consumer.config().fetchMessageMaxBytes();
                                var21_15 = false;
                                var22_16 = null;
                                var23_17 = this.fetch(consumer.consumer(), consumer.tap().topic(), consumer.tap().partition(), offset, maxBytes);
                                if (!(var23_17 instanceof Success)) ** GOTO lbl-1000
                                var21_15 = true;
                                var22_16 = (Success)var23_17;
                                messageSet = (ByteBufferMessageSet)var22_16.value();
                                if (messageSet.nonEmpty()) {
                                    messages$lzy = ObjectRef.zero();
                                    last$lzy = ObjectRef.zero();
                                    lastCheck$lzy = IntRef.zero();
                                    if (this.logger().underlying().isDebugEnabled()) {
                                        this.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"checking ", " found (", ",", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{bounds, BoxesRunTime.boxToLong((long)((MessageAndOffset)messageSet.head()).offset()), BoxesRunTime.boxToLong((long)((MessageAndOffset)messageSet.last()).offset())})));
                                        v0 = BoxedUnit.UNIT;
                                    } else {
                                        v0 = BoxedUnit.UNIT;
                                    }
                                    head = (MessageAndOffset)messageSet.head();
                                    headCheck = BoxesRunTime.unboxToInt((Object)predicate.apply((Object)head.message()));
                                    if (headCheck == 0) {
                                        if (this.logger().underlying().isTraceEnabled()) {
                                            this.logger().underlying().trace(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"found offset = ", " (head)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)head.offset())})));
                                            v1 = BoxedUnit.UNIT;
                                        } else {
                                            v1 = BoxedUnit.UNIT;
                                        }
                                        v2 = package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToLong((long)head.offset()));
                                    } else if (headCheck > 0) {
                                        if (offset == start) {
                                            if (this.logger().underlying().isTraceEnabled()) {
                                                this.logger().underlying().trace(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"no more ranges to check.  using ", " (head)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)head.offset())})));
                                                v3 = BoxedUnit.UNIT;
                                            } else {
                                                v3 = BoxedUnit.UNIT;
                                            }
                                            v2 = package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToLong((long)head.offset()));
                                        } else {
                                            if (this.logger().underlying().isTraceEnabled()) {
                                                this.logger().underlying().trace(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"need to look left (headCheck > 0)"})).s((Seq)Nil$.MODULE$));
                                                v4 = BoxedUnit.UNIT;
                                            } else {
                                                v4 = BoxedUnit.UNIT;
                                            }
                                            v2 = package$.MODULE$.Left().apply((Object)new Tuple2.mcJJ.sp(start, offset));
                                        }
                                    } else if (this.lastCheck$1(predicate, end, messageSet, messages$lzy, last$lzy, lastCheck$lzy, bitmap$0) == 0) {
                                        if (this.logger().underlying().isTraceEnabled()) {
                                            this.logger().underlying().trace(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"found offset = ", " (last)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.last$1(end, messageSet, messages$lzy, last$lzy, bitmap$0).offset())})));
                                            v5 = BoxedUnit.UNIT;
                                        } else {
                                            v5 = BoxedUnit.UNIT;
                                        }
                                        v2 = package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToLong((long)this.last$1(end, messageSet, messages$lzy, last$lzy, bitmap$0).offset()));
                                    } else if (this.lastCheck$1(predicate, end, messageSet, messages$lzy, last$lzy, lastCheck$lzy, bitmap$0) < 0) {
                                        if (this.last$1(end, messageSet, messages$lzy, last$lzy, bitmap$0).offset() + 1L == end) {
                                            if (this.logger().underlying().isTraceEnabled()) {
                                                this.logger().underlying().trace(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"no more ranges to check.  using ", " (last)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.last$1(end, messageSet, messages$lzy, last$lzy, bitmap$0).offset())})));
                                                v6 = BoxedUnit.UNIT;
                                            } else {
                                                v6 = BoxedUnit.UNIT;
                                            }
                                            v2 = package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToLong((long)(this.last$1(end, messageSet, messages$lzy, last$lzy, bitmap$0).offset() + 1L)));
                                        } else {
                                            if (this.logger().underlying().isTraceEnabled()) {
                                                this.logger().underlying().trace(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"need to look right (lastCheck < 0)"})).s((Seq)Nil$.MODULE$));
                                                v7 = BoxedUnit.UNIT;
                                            } else {
                                                v7 = BoxedUnit.UNIT;
                                            }
                                            v2 = package$.MODULE$.Left().apply((Object)new Tuple2.mcJJ.sp(this.last$1(end, messageSet, messages$lzy, last$lzy, bitmap$0).offset() + 1L, end));
                                        }
                                    } else {
                                        offset = BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])this.messages$1(end, messageSet, messages$lzy, bitmap$0)).tail()).find((Function1)new Serializable(this, predicate){
                                            public static final long serialVersionUID = 0L;
                                            private final Function1 predicate$2;

                                            public final boolean apply(MessageAndOffset m) {
                                                return BoxesRunTime.unboxToInt((Object)this.predicate$2.apply((Object)m.message())) >= 0;
                                            }
                                            {
                                                this.predicate$2 = predicate$2;
                                            }
                                        }).map((Function1)new Serializable(this){
                                            public static final long serialVersionUID = 0L;

                                            public final long apply(MessageAndOffset x$4) {
                                                return x$4.offset();
                                            }
                                        }).get());
                                        if (this.logger().underlying().isTraceEnabled()) {
                                            this.logger().underlying().trace(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"found offset = ", " (in block)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)offset)})));
                                            v8 = BoxedUnit.UNIT;
                                        } else {
                                            v8 = BoxedUnit.UNIT;
                                        }
                                        v2 = package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToLong((long)offset));
                                    }
                                    var25_19 = v2;
                                } else lbl-1000:
                                // 2 sources

                                {
                                    if (!var21_15) break block42;
                                    if (this.logger().underlying().isDebugEnabled()) {
                                        this.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"checking ", " found no messages"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{bounds})));
                                        v9 = BoxedUnit.UNIT;
                                    } else {
                                        v9 = BoxedUnit.UNIT;
                                    }
                                    var25_19 = package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToLong((long)-1L));
                                }
                                result = var25_19;
                                var35_26 = false;
                                var36_27 = null;
                                var37_28 = result;
                                if (!(var37_28 instanceof Right)) break block43;
                                var35_26 = true;
                                var36_27 = var37_28;
                                found = BoxesRunTime.unboxToLong((Object)var36_27.b());
                                if (found == -1L) break block43;
                                var40_32 = new Some((Object)BoxesRunTime.boxToLong((long)found));
                                break block44;
                            }
                            if (!var35_26) break block45;
                            var40_32 = None$.MODULE$;
                        }
                        return var40_32;
                    }
                    if (!(var37_28 instanceof Left)) break;
                    var41_30 = (Left)var37_28;
                    bounds = nextBounds = (Tuple2)var41_30.a();
                }
                throw new MatchError((Object)var37_28);
            }
            if (var23_17 instanceof Failure) {
                var33_33 = (Failure)var23_17;
                e = var33_33.exception();
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn("Error fetching messages to find offsets", e);
                    v10 = BoxedUnit.UNIT;
                } else {
                    v10 = BoxedUnit.UNIT;
                }
                throw e;
            }
            throw new MatchError(var23_17);
        }
        throw new MatchError(var7_6);
    }

    public MessageAndOffset[] trim(ByteBufferMessageSet messageSet, long end) {
        return (MessageAndOffset[])((TraversableOnce)messageSet.takeWhile((Function1)new Serializable(this, end){
            public static final long serialVersionUID = 0L;
            private final long end$2;

            public final boolean apply(MessageAndOffset msg) {
                return msg.offset() < this.end$2;
            }
            {
                this.end$2 = end$2;
            }
        })).toArray(ClassTag$.MODULE$.apply(MessageAndOffset.class));
    }

    private Map<TopicAndPartition, Object> retryOffsets(Function0<Map<TopicAndPartition, Object>> function, int tries) {
        Exception exception2;
        block6: {
            Map map;
            while (true) {
                try {
                    map = (Map)function.apply();
                }
                catch (Exception exception2) {
                    if (tries < this.config().offsetsCommitMaxRetries()) {
                        BoxedUnit boxedUnit;
                        if (this.logger().underlying().isDebugEnabled()) {
                            this.logger().underlying().debug("Error getting offsets.  Retrying.");
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        Thread.sleep(this.config().offsetsChannelBackoffMs() * tries);
                        ++tries;
                        continue;
                    }
                    break block6;
                }
                break;
            }
            return map;
        }
        throw exception2;
    }

    public void commitOffsets(Map<TopicAndPartition, OffsetAndMetadata> offsets, boolean isAutoCommit) {
        if (isAutoCommit) {
            this.commitOffsets(offsets, this.config().offsetsCommitMaxRetries());
        } else {
            this.commitOffsets(offsets, 1);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void commitOffsets(Map<TopicAndPartition, OffsetAndMetadata> offsets, int tries) {
        while (true) {
            short version = OffsetCommitRequest$.MODULE$.CurrentVersion();
            OffsetCommitRequest request = new OffsetCommitRequest(this.config().groupId(), offsets, version, 0, OffsetManager$.MODULE$.org$locationtech$geomesa$kafka10$consumer$offsets$OffsetManager$$clientId(), OffsetCommitRequest$.MODULE$.$lessinit$greater$default$6(), OffsetCommitRequest$.MODULE$.$lessinit$greater$default$7(), OffsetCommitRequest$.MODULE$.$lessinit$greater$default$8());
            try {
                this.org$locationtech$geomesa$kafka10$consumer$offsets$OffsetManager$$channel().channel().send((RequestOrResponse)request);
                OffsetCommitResponse response = OffsetCommitResponse$.MODULE$.readFrom((ByteBuffer)KafkaUtils10$.MODULE$.channelToPayload().apply((Object)this.org$locationtech$geomesa$kafka10$consumer$offsets$OffsetManager$$channel().channel()));
                Map errors = (Map)response.commitStatus().filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Tuple2<TopicAndPartition, Object> x0$2) {
                        Tuple2<TopicAndPartition, Object> tuple2 = x0$2;
                        if (tuple2 != null) {
                            short code = BoxesRunTime.unboxToShort((Object)tuple2._2());
                            boolean bl = code != ErrorMapping$.MODULE$.NoError();
                            return bl;
                        }
                        throw new MatchError(tuple2);
                    }
                });
                errors.foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ OffsetManager $outer;

                    public final void apply(Tuple2<TopicAndPartition, Object> x0$3) {
                        Tuple2<TopicAndPartition, Object> tuple2 = x0$3;
                        if (tuple2 != null) {
                            BoxedUnit boxedUnit;
                            TopicAndPartition topicAndPartition = (TopicAndPartition)tuple2._1();
                            short code = BoxesRunTime.unboxToShort((Object)tuple2._2());
                            if (code == ErrorMapping$.MODULE$.OffsetMetadataTooLargeCode()) {
                                BoxedUnit boxedUnit2;
                                if (this.$outer.logger().underlying().isErrorEnabled()) {
                                    this.$outer.logger().underlying().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not commit offset for topic ", ": Metadata is too large"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicAndPartition})));
                                    boxedUnit2 = BoxedUnit.UNIT;
                                } else {
                                    boxedUnit2 = BoxedUnit.UNIT;
                                }
                                BoxedUnit boxedUnit3 = boxedUnit2;
                                return;
                            }
                            if (code == ErrorMapping$.MODULE$.NotCoordinatorForConsumerCode() || code == ErrorMapping$.MODULE$.ConsumerCoordinatorNotAvailableCode()) {
                                BoxedUnit boxedUnit4;
                                if (this.$outer.logger().underlying().isDebugEnabled()) {
                                    this.$outer.logger().underlying().debug("Could not commit offsets because coordinator is unavailable");
                                    boxedUnit4 = BoxedUnit.UNIT;
                                } else {
                                    boxedUnit4 = BoxedUnit.UNIT;
                                }
                                this.$outer.org$locationtech$geomesa$kafka10$consumer$offsets$OffsetManager$$channel().disconnect();
                                throw ErrorMapping$.MODULE$.exceptionFor(code);
                            }
                            if (this.$outer.logger().underlying().isErrorEnabled()) {
                                this.$outer.logger().underlying().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error committing offsets: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ErrorMapping$.MODULE$.exceptionFor(code)})));
                                boxedUnit = BoxedUnit.UNIT;
                            } else {
                                boxedUnit = BoxedUnit.UNIT;
                            }
                            throw ErrorMapping$.MODULE$.exceptionFor(code);
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                return;
            }
            catch (Exception exception) {
                if (tries >= this.config().offsetsCommitMaxRetries()) throw new IOException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error committing offsets"})).s((Seq)Nil$.MODULE$), exception);
                Thread.sleep(this.config().offsetsChannelBackoffMs());
                ++tries;
                continue;
            }
            break;
        }
    }

    public boolean commitOffsets$default$2() {
        return false;
    }

    @Override
    public void close() {
        this.org$locationtech$geomesa$kafka10$consumer$offsets$OffsetManager$$channel().disconnect();
        this.zkUtils().close();
    }

    private final MessageAndOffset[] messages$lzycompute$1(long end$1, ByteBufferMessageSet messageSet$1, ObjectRef messages$lzy$1, VolatileByteRef bitmap$0$1) {
        OffsetManager offsetManager = this;
        synchronized (offsetManager) {
            if ((byte)(bitmap$0$1.elem & 1) == 0) {
                messages$lzy$1.elem = this.trim(messageSet$1, end$1);
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 1);
            }
            return (MessageAndOffset[])messages$lzy$1.elem;
        }
    }

    private final MessageAndOffset[] messages$1(long end$1, ByteBufferMessageSet messageSet$1, ObjectRef messages$lzy$1, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 1) == 0 ? this.messages$lzycompute$1(end$1, messageSet$1, messages$lzy$1, bitmap$0$1) : (MessageAndOffset[])messages$lzy$1.elem;
    }

    private final MessageAndOffset last$lzycompute$1(long end$1, ByteBufferMessageSet messageSet$1, ObjectRef messages$lzy$1, ObjectRef last$lzy$1, VolatileByteRef bitmap$0$1) {
        OffsetManager offsetManager = this;
        synchronized (offsetManager) {
            if ((byte)(bitmap$0$1.elem & 2) == 0) {
                last$lzy$1.elem = (MessageAndOffset)Predef$.MODULE$.refArrayOps((Object[])this.messages$1(end$1, messageSet$1, messages$lzy$1, bitmap$0$1)).last();
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 2);
            }
            return (MessageAndOffset)last$lzy$1.elem;
        }
    }

    private final MessageAndOffset last$1(long end$1, ByteBufferMessageSet messageSet$1, ObjectRef messages$lzy$1, ObjectRef last$lzy$1, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 2) == 0 ? this.last$lzycompute$1(end$1, messageSet$1, messages$lzy$1, last$lzy$1, bitmap$0$1) : (MessageAndOffset)last$lzy$1.elem;
    }

    private final int lastCheck$lzycompute$1(Function1 predicate$2, long end$1, ByteBufferMessageSet messageSet$1, ObjectRef messages$lzy$1, ObjectRef last$lzy$1, IntRef lastCheck$lzy$1, VolatileByteRef bitmap$0$1) {
        OffsetManager offsetManager = this;
        synchronized (offsetManager) {
            if ((byte)(bitmap$0$1.elem & 4) == 0) {
                lastCheck$lzy$1.elem = BoxesRunTime.unboxToInt((Object)predicate$2.apply((Object)this.last$1(end$1, messageSet$1, messages$lzy$1, last$lzy$1, bitmap$0$1).message()));
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 4);
            }
            return lastCheck$lzy$1.elem;
        }
    }

    private final int lastCheck$1(Function1 predicate$2, long end$1, ByteBufferMessageSet messageSet$1, ObjectRef messages$lzy$1, ObjectRef last$lzy$1, IntRef lastCheck$lzy$1, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 4) == 0 ? this.lastCheck$lzycompute$1(predicate$2, end$1, messageSet$1, messages$lzy$1, last$lzy$1, lastCheck$lzy$1, bitmap$0$1) : lastCheck$lzy$1.elem;
    }

    public OffsetManager(ConsumerConfig config) {
        this.config = config;
        LazyLogging.class.$init$((LazyLogging)this);
        Fetcher$class.$init$(this);
    }
}

