/*
 * Decompiled with CFR 0.152.
 */
package org.geomesa.gs.wps.kafka10;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import org.geomesa.gs.wps.kafka10.GeomesaKafkaProcess;
import org.geomesa.gs.wps.kafka10.ReplayKafkaLayerCatalogListener;
import org.geomesa.gs.wps.kafka10.ReplayKafkaLayerReaperProcess$;
import org.geomesa.gs.wps.kafka10.ReplayKafkaLayerReaperProcess$$anonfun$execute$1$;
import org.geomesa.gs.wps.kafka10.VolatileLayer$;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.event.CatalogListener;
import org.geotools.process.factory.DescribeProcess;
import org.geotools.process.factory.DescribeResult;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Try$;
import scala.util.control.NonFatal$;

@DescribeProcess(title="GeoMesa Replay Kafka Layer Reaper", description="Removes Kafka Replay Layers from GeoServer", version="1.0.0")
@ScalaSignature(bytes="\u0006\u0001U4A!\u0001\u0002\u0001\u001b\ti\"+\u001a9mCf\\\u0015MZ6b\u0019\u0006LXM\u001d*fCB,'\u000f\u0015:pG\u0016\u001c8O\u0003\u0002\u0004\t\u000591.\u00194lCF\u0002$BA\u0003\u0007\u0003\r9\bo\u001d\u0006\u0003\u000f!\t!aZ:\u000b\u0005%Q\u0011aB4f_6,7/\u0019\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M)\u0001A\u0004\f\u001bIA\u0011q\u0002F\u0007\u0002!)\u0011\u0011CE\u0001\u0005Y\u0006twMC\u0001\u0014\u0003\u0011Q\u0017M^1\n\u0005U\u0001\"AB(cU\u0016\u001cG\u000f\u0005\u0002\u001815\t!!\u0003\u0002\u001a\u0005\t\u0019r)Z8nKN\f7*\u00194lCB\u0013xnY3tgB\u00111DI\u0007\u00029)\u0011QDH\u0001\rg\u000e\fG.\u00197pO\u001eLgn\u001a\u0006\u0003?\u0001\n\u0001\u0002^=qKN\fg-\u001a\u0006\u0002C\u0005\u00191m\\7\n\u0005\rb\"a\u0003'bufdunZ4j]\u001e\u0004\"aD\u0013\n\u0005\u0019\u0002\"\u0001\u0003*v]:\f'\r\\3\t\u0011!\u0002!Q1A\u0005\u0002%\nqaY1uC2|w-F\u0001+!\tYs&D\u0001-\u0015\tASF\u0003\u0002/\u0015\u0005Iq-Z8tKJ4XM]\u0005\u0003a1\u0012qaQ1uC2|w\r\u0003\u00053\u0001\t\u0005\t\u0015!\u0003+\u0003!\u0019\u0017\r^1m_\u001e\u0004\u0003\u0002\u0003\u001b\u0001\u0005\u000b\u0007I\u0011A\u001b\u0002\u000b!|WO]:\u0016\u0003Y\u0002\"a\u000e\u001e\u000e\u0003aR\u0011!O\u0001\u0006g\u000e\fG.Y\u0005\u0003wa\u00121!\u00138u\u0011!i\u0004A!A!\u0002\u00131\u0014A\u00025pkJ\u001c\b\u0005C\u0003@\u0001\u0011\u0005\u0001)\u0001\u0004=S:LGO\u0010\u000b\u0004\u0003\n\u001b\u0005CA\f\u0001\u0011\u0015Ac\b1\u0001+\u0011\u0015!d\b1\u00017\u0011\u0015)\u0005\u0001\"\u0001G\u0003\u001d)\u00070Z2vi\u0016$\u0012a\u0012\t\u0003o!K!!\u0013\u001d\u0003\u000f\t{w\u000e\\3b]\"2AiS+W1f\u0003\"\u0001T*\u000e\u00035S!AT(\u0002\u000f\u0019\f7\r^8ss*\u0011\u0001+U\u0001\baJ|7-Z:t\u0015\t\u0011&\"\u0001\u0005hK>$xn\u001c7t\u0013\t!VJ\u0001\bEKN\u001c'/\u001b2f%\u0016\u001cX\u000f\u001c;\u0002\t9\fW.Z\u0011\u0002/\u00061!/Z:vYR\f1\u0002Z3tGJL\u0007\u000f^5p]\u0006\n!,\u0001%JM\u0002\nG\u000e\u001c\u0011fY&<\u0017N\u00197fA1\f\u00170\u001a:tA],'/\u001a\u0011sK6|g/\u001a3!gV\u001c7-Z:tMVdG.\u001f\u0017!iJ,X\r\f\u0011pi\",'o^5tK\u00022\u0017\r\\:f]!9A\f\u0001b\u0001\n\u0013i\u0016aB7fgN\fw-Z\u000b\u0002=B\u0011qbX\u0005\u0003AB\u0011aa\u0015;sS:<\u0007B\u00022\u0001A\u0003%a,\u0001\u0005nKN\u001c\u0018mZ3!\u0011\u0015!\u0007\u0001\"\u0011f\u0003\r\u0011XO\u001c\u000b\u0002MB\u0011qgZ\u0005\u0003Qb\u0012A!\u00168ji\"B\u0001A[7o1B\u00148\u000f\u0005\u0002MW&\u0011A.\u0014\u0002\u0010\t\u0016\u001c8M]5cKB\u0013xnY3tg\u0006)A/\u001b;mK\u0006\nq.A\u0011HK>lUm]1!%\u0016\u0004H.Y=!\u0017\u000647.\u0019\u0011MCf,'\u000f\t*fCB,'/I\u0001r\u0003)\u0012V-\\8wKN\u00043*\u00194lC\u0002\u0012V\r\u001d7bs\u0002b\u0015-_3sg\u00022'o\\7!\u000f\u0016|7+\u001a:wKJ\fqA^3sg&|g.I\u0001u\u0003\u0015\td\u0006\r\u00181\u0001")
public class ReplayKafkaLayerReaperProcess
implements GeomesaKafkaProcess,
LazyLogging,
Runnable {
    private final Catalog catalog;
    private final int hours;
    private final String message;
    private final Logger logger;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        ReplayKafkaLayerReaperProcess replayKafkaLayerReaperProcess = this;
        synchronized (replayKafkaLayerReaperProcess) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public Catalog catalog() {
        return this.catalog;
    }

    public int hours() {
        return this.hours;
    }

    @DescribeResult(name="result", description="If all eligible layers were removed successfully, true, otherwise false.")
    public boolean execute() {
        return BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplayKafkaLayerReaperProcess $outer;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                Instant currentTime = new Instant(System.currentTimeMillis());
                Instant ageLimit = currentTime.minus((ReadableDuration)Duration.standardHours((long)this.$outer.hours()));
                BooleanRef error = BooleanRef.create((boolean)false);
                JavaConversions$.MODULE$.asScalaBuffer(this.$outer.catalog().getLayers()).foreach((Function1)new Serializable(this, ageLimit, error){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$execute$1 $outer;
                    public final Instant ageLimit$1;
                    public final BooleanRef error$1;

                    public final void apply(LayerInfo layer) {
                        VolatileLayer$.MODULE$.getVolatileAge(layer).withFilter((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$execute$1$$anonfun$apply$mcZ$sp$1 $outer;

                            public final boolean apply(Instant age) {
                                return age.isBefore((ReadableInstant)this.$outer.ageLimit$1);
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        }).foreach((Function1)new Serializable(this, layer){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$execute$1$$anonfun$apply$mcZ$sp$1 $outer;
                            private final LayerInfo layer$1;

                            public final void apply(Instant age) {
                                try {
                                    BoxedUnit boxedUnit;
                                    if (this.$outer.org$geomesa$gs$wps$kafka10$ReplayKafkaLayerReaperProcess$$anonfun$$anonfun$$$outer().org$geomesa$gs$wps$kafka10$ReplayKafkaLayerReaperProcess$$anonfun$$$outer().logger().underlying().isDebugEnabled()) {
                                        this.$outer.org$geomesa$gs$wps$kafka10$ReplayKafkaLayerReaperProcess$$anonfun$$anonfun$$$outer().org$geomesa$gs$wps$kafka10$ReplayKafkaLayerReaperProcess$$anonfun$$$outer().logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Deleting old replay layer ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.layer$1})));
                                        boxedUnit = BoxedUnit.UNIT;
                                    } else {
                                        boxedUnit = BoxedUnit.UNIT;
                                    }
                                    this.$outer.org$geomesa$gs$wps$kafka10$ReplayKafkaLayerReaperProcess$$anonfun$$anonfun$$$outer().org$geomesa$gs$wps$kafka10$ReplayKafkaLayerReaperProcess$$anonfun$$$outer().catalog().remove(this.layer$1);
                                }
                                catch (Throwable throwable) {
                                    BoxedUnit boxedUnit;
                                    Throwable throwable2 = throwable;
                                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                                    if (option.isEmpty()) {
                                        throw throwable;
                                    }
                                    Throwable e = (Throwable)option.get();
                                    if (this.$outer.org$geomesa$gs$wps$kafka10$ReplayKafkaLayerReaperProcess$$anonfun$$anonfun$$$outer().org$geomesa$gs$wps$kafka10$ReplayKafkaLayerReaperProcess$$anonfun$$$outer().logger().underlying().isErrorEnabled()) {
                                        this.$outer.org$geomesa$gs$wps$kafka10$ReplayKafkaLayerReaperProcess$$anonfun$$anonfun$$$outer().org$geomesa$gs$wps$kafka10$ReplayKafkaLayerReaperProcess$$anonfun$$$outer().logger().underlying().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error deleting old replay layer ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.layer$1})), e);
                                        boxedUnit = BoxedUnit.UNIT;
                                    } else {
                                        boxedUnit = BoxedUnit.UNIT;
                                    }
                                    this.$outer.error$1.elem = true;
                                    BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                                }
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.layer$1 = layer$1;
                            }
                        });
                    }

                    public /* synthetic */ $anonfun$execute$1 org$geomesa$gs$wps$kafka10$ReplayKafkaLayerReaperProcess$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.ageLimit$1 = ageLimit$1;
                        this.error$1 = error$1;
                    }
                });
                return error.elem;
            }

            public /* synthetic */ ReplayKafkaLayerReaperProcess org$geomesa$gs$wps$kafka10$ReplayKafkaLayerReaperProcess$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return false;
            }
        }));
    }

    private String message() {
        return this.message;
    }

    @Override
    public void run() {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(this.message());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.execute();
    }

    public ReplayKafkaLayerReaperProcess(Catalog catalog, int hours) {
        this.catalog = catalog;
        this.hours = hours;
        LazyLogging.class.$init$((LazyLogging)this);
        catalog.addListener((CatalogListener)new ReplayKafkaLayerCatalogListener());
        this.message = "Running Replay Kafka Layer Cleaner";
    }
}

