/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.cqengine.codegen;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class AttributeSourceGenerator {
    static final Map<Class<?>, Class<?>> PRIMITIVES_TO_WRAPPERS = new HashMap<Class<?>, Class<?>>(){
        {
            this.put(Boolean.TYPE, Boolean.class);
            this.put(Byte.TYPE, Byte.class);
            this.put(Short.TYPE, Short.class);
            this.put(Character.TYPE, Character.class);
            this.put(Integer.TYPE, Integer.class);
            this.put(Long.TYPE, Long.class);
            this.put(Float.TYPE, Float.class);
            this.put(Double.TYPE, Double.class);
        }
    };

    public static String generateAttributesForPastingIntoTargetClass(Class<?> targetClass) {
        return AttributeSourceGenerator.generateAttributesForClass(targetClass, false, "");
    }

    public static String generateSeparateAttributesClass(Class<?> targetClass, String packageOfAttributesClass) {
        return AttributeSourceGenerator.generateAttributesForClass(targetClass, true, packageOfAttributesClass);
    }

    public static String generateSeparateAttributesClass(Class<?> targetClass, Package packageOfAttributesClass) {
        return AttributeSourceGenerator.generateAttributesForClass(targetClass, true, packageOfAttributesClass.getName());
    }

    static String generateAttributesForClass(Class<?> targetClass, boolean separateAttributesClass, String packageOfAttributesClass) {
        StringBuilder sb = new StringBuilder();
        if (separateAttributesClass) {
            sb.append("package ").append(packageOfAttributesClass).append(";\n\n");
            sb.append("import com.googlecode.cqengine.attribute.*;\n");
            sb.append("import com.googlecode.cqengine.query.option.QueryOptions;\n");
            sb.append("import java.util.*;\n");
            String targetClassName = targetClass.getName().replace("$", ".");
            sb.append("import ").append(targetClassName).append(";\n\n");
            sb.append("/**\n");
            sb.append(" * CQEngine attributes for accessing fields in class {@code ").append(targetClassName).append("}.\n");
            sb.append(" * <p/>.\n");
            sb.append(" * Auto-generated by CQEngine's {@code ").append(AttributeSourceGenerator.class.getSimpleName()).append("}.\n");
            sb.append(" */\n");
            sb.append("public class CQ").append(targetClass.getSimpleName()).append(" {");
        }
        for (Class<?> currentClass = targetClass; currentClass != null && currentClass != Object.class; currentClass = currentClass.getSuperclass()) {
            for (Field field : Arrays.asList(currentClass.getDeclaredFields())) {
                int modifiers = field.getModifiers();
                if (Modifier.isStatic(modifiers)) continue;
                if (Modifier.isPrivate(modifiers)) {
                    if (separateAttributesClass || !currentClass.equals(targetClass)) continue;
                    sb.append("\n\n");
                    sb.append(AttributeSourceGenerator.generateAttributeForField(targetClass, field));
                    continue;
                }
                if (Modifier.isProtected(modifiers)) {
                    if (separateAttributesClass && !field.getDeclaringClass().getPackage().getName().equals(packageOfAttributesClass)) continue;
                    sb.append("\n\n");
                    sb.append(AttributeSourceGenerator.generateAttributeForField(targetClass, field));
                    continue;
                }
                if (Modifier.isPublic(modifiers)) {
                    sb.append("\n\n");
                    sb.append(AttributeSourceGenerator.generateAttributeForField(targetClass, field));
                    continue;
                }
                if ((separateAttributesClass || !currentClass.equals(targetClass)) && !field.getDeclaringClass().getPackage().getName().equals(packageOfAttributesClass)) continue;
                sb.append("\n\n");
                sb.append(AttributeSourceGenerator.generateAttributeForField(targetClass, field));
            }
        }
        if (separateAttributesClass) {
            sb.append("\n}\n");
        }
        return sb.toString();
    }

    static String generateAttributeForField(Class<?> enclosingClass, Field field) {
        try {
            if (field.getType().isPrimitive()) {
                return AttributeSourceGenerator.generateSimpleAttribute(enclosingClass.getSimpleName(), PRIMITIVES_TO_WRAPPERS.get(field.getType()).getSimpleName(), field.getName());
            }
            if (Iterable.class.isAssignableFrom(field.getType())) {
                ParameterizedType parameterizedType = (ParameterizedType)field.getGenericType();
                if (parameterizedType.getActualTypeArguments().length != 1) {
                    throw new UnsupportedOperationException();
                }
                Class genericType = (Class)parameterizedType.getActualTypeArguments()[0];
                return AttributeSourceGenerator.generateMultiValueNullableAttributeForIterable(enclosingClass.getSimpleName(), genericType.getSimpleName(), field.getName());
            }
            if (field.getType().isArray()) {
                if (field.getType().getComponentType().isPrimitive()) {
                    return AttributeSourceGenerator.generateMultiValueNullableAttributeForPrimitiveArray(enclosingClass.getSimpleName(), PRIMITIVES_TO_WRAPPERS.get(field.getType().getComponentType()).getSimpleName(), field.getType().getComponentType().getSimpleName(), field.getName());
                }
                return AttributeSourceGenerator.generateMultiValueNullableAttributeForObjectArray(enclosingClass.getSimpleName(), field.getType().getComponentType().getSimpleName(), field.getName());
            }
            return AttributeSourceGenerator.generateSimpleNullableAttribute(enclosingClass.getSimpleName(), field.getType().getSimpleName(), field.getName());
        }
        catch (Exception e) {
            return "    // *** Note: Could not generate CQEngine attribute automatically for field: " + enclosingClass.getSimpleName() + "." + field.getName() + " ***";
        }
    }

    static String generateSimpleAttribute(String objectType, String attributeType, String fieldName) {
        return "    /**\n     * CQEngine attribute for accessing field {@code " + objectType + "." + fieldName + "}.\n" + "     */\n" + "    public static final Attribute<" + objectType + ", " + attributeType + "> " + AttributeSourceGenerator.toUpperCaseWithUnderscores(fieldName) + " = new SimpleAttribute<" + objectType + ", " + attributeType + ">(\"" + AttributeSourceGenerator.toUpperCaseWithUnderscores(fieldName) + "\") {\n" + "        public " + attributeType + " getValue(" + objectType + " " + objectType.toLowerCase() + ", QueryOptions queryOptions) { return " + objectType.toLowerCase() + "." + fieldName + "; }\n" + "    };";
    }

    static String generateSimpleNullableAttribute(String objectType, String attributeType, String fieldName) {
        return "    /**\n     * CQEngine attribute for accessing field {@code " + objectType + "." + fieldName + "}.\n" + "     */\n" + "    // Note: For best performance:\n" + "    // - if this field cannot be null, replace this SimpleNullableAttribute with a SimpleAttribute\n" + "    public static final Attribute<" + objectType + ", " + attributeType + "> " + AttributeSourceGenerator.toUpperCaseWithUnderscores(fieldName) + " = new SimpleNullableAttribute<" + objectType + ", " + attributeType + ">(\"" + AttributeSourceGenerator.toUpperCaseWithUnderscores(fieldName) + "\") {\n" + "        public " + attributeType + " getValue(" + objectType + " " + objectType.toLowerCase() + ", QueryOptions queryOptions) { return " + objectType.toLowerCase() + "." + fieldName + "; }\n" + "    };";
    }

    static String generateMultiValueNullableAttributeForIterable(String objectType, String attributeType, String fieldName) {
        return "    /**\n     * CQEngine attribute for accessing field {@code " + objectType + "." + fieldName + "}.\n" + "     */\n" + "    // Note: For best performance:\n" + "    // - if the list cannot contain null elements change true to false in the following constructor, or\n" + "    // - if the list cannot contain null elements AND the field itself cannot be null, replace this\n" + "    //   MultiValueNullableAttribute with a MultiValueAttribute (and change getNullableValues() to getValues())\n" + "    public static final Attribute<" + objectType + ", " + attributeType + "> " + AttributeSourceGenerator.toUpperCaseWithUnderscores(fieldName) + " = new MultiValueNullableAttribute<" + objectType + ", " + attributeType + ">(\"" + AttributeSourceGenerator.toUpperCaseWithUnderscores(fieldName) + "\", true) {\n" + "        public Iterable<" + attributeType + "> getNullableValues(" + objectType + " " + objectType.toLowerCase() + ", QueryOptions queryOptions) { return " + objectType.toLowerCase() + "." + fieldName + "; }\n" + "    };";
    }

    static String generateMultiValueNullableAttributeForObjectArray(String objectType, String attributeType, String fieldName) {
        return "    /**\n     * CQEngine attribute for accessing field {@code " + objectType + "." + fieldName + "}.\n" + "     */\n" + "    // Note: For best performance:\n" + "    // - if the array cannot contain null elements change true to false in the following constructor, or\n" + "    // - if the array cannot contain null elements AND the field itself cannot be null, replace this\n" + "    //   MultiValueNullableAttribute with a MultiValueAttribute (and change getNullableValues() to getValues())\n" + "    public static final Attribute<" + objectType + ", " + attributeType + "> " + AttributeSourceGenerator.toUpperCaseWithUnderscores(fieldName) + " = new MultiValueNullableAttribute<" + objectType + ", " + attributeType + ">(\"" + AttributeSourceGenerator.toUpperCaseWithUnderscores(fieldName) + "\", true) {\n" + "        public Iterable<" + attributeType + "> getNullableValues(" + objectType + " " + objectType.toLowerCase() + ", QueryOptions queryOptions) { return Arrays.asList(" + objectType.toLowerCase() + "." + fieldName + "); }\n" + "    };";
    }

    static String generateMultiValueNullableAttributeForPrimitiveArray(String objectType, String attributeType, String primitiveType, String fieldName) {
        return "    /**\n     * CQEngine attribute for accessing field {@code " + objectType + "." + fieldName + "}.\n" + "     */\n" + "    // Note: For best performance:\n" + "    // - if this field cannot be null, replace this\n" + "    //   MultiValueNullableAttribute with a MultiValueAttribute (and change getNullableValues() to getValues())\n" + "    public static final Attribute<" + objectType + ", " + attributeType + "> " + AttributeSourceGenerator.toUpperCaseWithUnderscores(fieldName) + " = new MultiValueNullableAttribute<" + objectType + ", " + attributeType + ">(\"" + AttributeSourceGenerator.toUpperCaseWithUnderscores(fieldName) + "\", false) {\n" + "        public Iterable<" + attributeType + "> getNullableValues(final " + objectType + " " + objectType.toLowerCase() + ", QueryOptions queryOptions) {\n" + "            return new AbstractList<" + attributeType + ">() {\n" + "                public " + attributeType + " get(int i) { return " + objectType.toLowerCase() + "." + fieldName + "[i]; }\n" + "                public int size() { return " + objectType.toLowerCase() + "." + fieldName + ".length; }\n" + "            };\n" + "        }\n" + "    };";
    }

    static String toUpperCaseWithUnderscores(String camelCase) {
        String[] words = camelCase.split("(?<!(^|[A-Z]))(?=[A-Z])|(?<!^)(?=[A-Z][a-z])");
        StringBuilder sb = new StringBuilder();
        Iterator<String> iterator = Arrays.asList(words).iterator();
        while (iterator.hasNext()) {
            String word = iterator.next();
            sb.append(word.toUpperCase());
            if (!iterator.hasNext()) continue;
            sb.append("_");
        }
        return sb.toString();
    }

    AttributeSourceGenerator() {
    }
}

