/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.kafka10;

import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.List;
import org.I0Itec.zkclient.exception.ZkNodeExistsException;
import org.geotools.feature.NameImpl;
import org.locationtech.geomesa.kafka.KafkaDataStoreHelper$;
import org.locationtech.geomesa.kafka.ReplayConfig;
import org.locationtech.geomesa.kafka.ReplayConfig$;
import org.locationtech.geomesa.kafka10.KafkaDataStoreSchemaManager;
import org.locationtech.geomesa.kafka10.KafkaDataStoreSchemaManager$;
import org.locationtech.geomesa.kafka10.KafkaFeatureConfig;
import org.locationtech.geomesa.kafka10.KafkaUtils10$;
import org.locationtech.geomesa.kafka10.ZkUtils10;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes$;
import org.locationtech.geomesa.utils.index.GeoMesaSchemaValidator$;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.Name;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.util.Try;
import scala.util.Try$;
import scala.util.control.NonFatal$;

public abstract class KafkaDataStoreSchemaManager$class {
    public static void createSchema(KafkaDataStoreSchemaManager $this, SimpleFeatureType featureType) {
        KafkaFeatureConfig kfc = new KafkaFeatureConfig(featureType);
        String typeName = featureType.getTypeName();
        String schemaPath = $this.getSchemaPath(typeName);
        if ($this.org$locationtech$geomesa$kafka10$KafkaDataStoreSchemaManager$$zkUtils().zkClient().exists(schemaPath)) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Type ", " already exists at ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{typeName, $this.zkPath()})));
        }
        GeoMesaSchemaValidator$.MODULE$.validate(featureType);
        String data = SimpleFeatureTypes$.MODULE$.encodeType(featureType, true);
        KafkaDataStoreSchemaManager$class.org$locationtech$geomesa$kafka10$KafkaDataStoreSchemaManager$$createZkNode($this, schemaPath, data);
        KafkaDataStoreSchemaManager$class.org$locationtech$geomesa$kafka10$KafkaDataStoreSchemaManager$$createZkNode($this, $this.getTopicPath(typeName), kfc.topic());
        kfc.replayConfig().foreach((Function1)new Serializable($this, typeName){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaDataStoreSchemaManager $outer;
            private final String typeName$1;

            public final void apply(ReplayConfig r) {
                KafkaDataStoreSchemaManager$class.org$locationtech$geomesa$kafka10$KafkaDataStoreSchemaManager$$createZkNode(this.$outer, this.$outer.getReplayConfigPath(this.typeName$1), ReplayConfig$.MODULE$.encode(r));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.typeName$1 = typeName$1;
            }
        });
        if (!$this.org$locationtech$geomesa$kafka10$KafkaDataStoreSchemaManager$$zkUtils().topicExists(kfc.topic())) {
            $this.org$locationtech$geomesa$kafka10$KafkaDataStoreSchemaManager$$zkUtils().createTopic(kfc.topic(), $this.partitions(), $this.replication());
        }
        $this.waitUntilTopicReady($this.org$locationtech$geomesa$kafka10$KafkaDataStoreSchemaManager$$zkUtils(), kfc.topic(), $this.partitions(), $this.waitUntilTopicReady$default$4());
        $this.org$locationtech$geomesa$kafka10$KafkaDataStoreSchemaManager$$schemaCache().put((Object)typeName, (Object)kfc);
    }

    public static void waitUntilTopicReady(KafkaDataStoreSchemaManager $this, ZkUtils10 zkUtils, String topic, int partitions, long timeToWait) {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), partitions).foreach$mVc$sp((Function1)new Serializable($this, zkUtils, topic, timeToWait){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaDataStoreSchemaManager $outer;
            private final ZkUtils10 zkUtils$1;
            private final String topic$1;
            private final long timeToWait$1;

            public final void apply(int x$1) {
                this.apply$mcVI$sp(x$1);
            }

            public void apply$mcVI$sp(int x$1) {
                this.$outer.waitUntilTopicReadyForPartition(this.zkUtils$1, this.topic$1, x$1, this.timeToWait$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.zkUtils$1 = zkUtils$1;
                this.topic$1 = topic$1;
                this.timeToWait$1 = timeToWait$1;
            }
        });
    }

    public static long waitUntilTopicReady$default$4(KafkaDataStoreSchemaManager $this) {
        return 5000L;
    }

    public static void waitUntilTopicReadyForPartition(KafkaDataStoreSchemaManager $this, ZkUtils10 zkUtils, String topic, int partition, long timeToWait) {
        Option<Object> leader = None$.MODULE$;
        long start = System.currentTimeMillis();
        while (leader.isEmpty() && System.currentTimeMillis() < start + timeToWait) {
            BoxedUnit boxedUnit;
            leader = zkUtils.getLeaderForPartition(topic, partition);
            if (!leader.isEmpty()) continue;
            if ($this.logger().underlying().isDebugEnabled()) {
                $this.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Still waiting on a leader for topic: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic})));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            Thread.sleep(100L);
        }
        Option<Object> option = leader;
        if (option instanceof Some) {
            BoxedUnit boxedUnit;
            if ($this.logger().underlying().isDebugEnabled()) {
                $this.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Got a leader for topic: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic})));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
            return;
        }
        throw new Exception(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to get a leader for partition ", " of "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)partition)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"topic: ", " within ", " milliseconds."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic, BoxesRunTime.boxToLong((long)timeToWait)}))).toString());
    }

    public static KafkaFeatureConfig getFeatureConfig(KafkaDataStoreSchemaManager $this, String typeName) {
        return (KafkaFeatureConfig)$this.org$locationtech$geomesa$kafka10$KafkaDataStoreSchemaManager$$schemaCache().get((Object)typeName);
    }

    public static Option getLiveFeatureType(KafkaDataStoreSchemaManager $this, SimpleFeatureType replayType) {
        return (Option)Try$.MODULE$.apply((Function0)new Serializable($this, replayType){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaDataStoreSchemaManager $outer;
            private final SimpleFeatureType replayType$1;

            public final Option<SimpleFeatureType> apply() {
                return KafkaDataStoreHelper$.MODULE$.extractStreamingTypeName(this.replayType$1).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ KafkaDataStoreSchemaManager$.anonfun.getLiveFeatureType.1 $outer;

                    public final SimpleFeatureType apply(String x$2) {
                        return ((KafkaFeatureConfig)this.$outer.org$locationtech$geomesa$kafka10$KafkaDataStoreSchemaManager$$anonfun$$$outer().org$locationtech$geomesa$kafka10$KafkaDataStoreSchemaManager$$schemaCache().get((Object)x$2)).sft();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ KafkaDataStoreSchemaManager org$locationtech$geomesa$kafka10$KafkaDataStoreSchemaManager$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.replayType$1 = replayType$1;
            }
        }).getOrElse((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final None$ apply() {
                return None$.MODULE$;
            }
        });
    }

    public static List getNames(KafkaDataStoreSchemaManager $this) {
        return (List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter($this.org$locationtech$geomesa$kafka10$KafkaDataStoreSchemaManager$$zkUtils().zkClient().getChildren($this.zkPath())).asScala()).filter((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaDataStoreSchemaManager $outer;

            public final boolean apply(String name) {
                return this.$outer.org$locationtech$geomesa$kafka10$KafkaDataStoreSchemaManager$$zkUtils().zkClient().exists(this.$outer.getTopicPath(name));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        })).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Name apply(String name) {
                return new NameImpl(name);
            }
        }, Buffer$.MODULE$.canBuildFrom())).asJava();
    }

    public static void removeSchema(KafkaDataStoreSchemaManager $this, Name typeName) {
        $this.removeSchema(typeName.getLocalPart());
    }

    public static void removeSchema(KafkaDataStoreSchemaManager $this, String typeName) {
        Try fct = Try$.MODULE$.apply((Function0)new Serializable($this, typeName){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaDataStoreSchemaManager $outer;
            private final String typeName$2;

            public final KafkaFeatureConfig apply() {
                return this.$outer.getFeatureConfig(this.typeName$2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.typeName$2 = typeName$2;
            }
        });
        $this.org$locationtech$geomesa$kafka10$KafkaDataStoreSchemaManager$$schemaCache().invalidate((Object)typeName);
        $this.org$locationtech$geomesa$kafka10$KafkaDataStoreSchemaManager$$zkUtils().zkClient().deleteRecursive($this.getSchemaPath(typeName));
        fct.foreach((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaDataStoreSchemaManager $outer;

            public final void apply(KafkaFeatureConfig fc) {
                if (KafkaDataStoreHelper$.MODULE$.isStreamingSFT(fc.sft()) && this.$outer.org$locationtech$geomesa$kafka10$KafkaDataStoreSchemaManager$$zkUtils().topicExists(fc.topic())) {
                    this.$outer.org$locationtech$geomesa$kafka10$KafkaDataStoreSchemaManager$$zkUtils().deleteTopic(fc.topic());
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public static void updateKafkaSchema(KafkaDataStoreSchemaManager $this, String typeName, SimpleFeatureType sft) {
        void var4_4;
        SimpleFeatureType previousSft = $this.getSchema(typeName);
        String schemaTypeName = sft.getTypeName();
        if (schemaTypeName.equals(typeName.toString())) {
            if (previousSft == null) {
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No schema found for given type name ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{typeName})));
            }
            Set unmodifiableUserdataKeys = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{SimpleFeatureTypes.InternalConfigs$.MODULE$.SCHEMA_VERSION_KEY(), SimpleFeatureTypes.Configs$.MODULE$.TABLE_SHARING_KEY(), SimpleFeatureTypes.InternalConfigs$.MODULE$.SHARING_PREFIX_KEY(), SimpleFeatureTypes.Configs$.MODULE$.DEFAULT_DATE_KEY(), SimpleFeatureTypes.Configs$.MODULE$.ST_INDEX_SCHEMA_KEY(), SimpleFeatureTypes.Configs$.MODULE$.ENABLED_INDICES()}));
            unmodifiableUserdataKeys.foreach((Function1)new Serializable($this, previousSft, sft){
                public static final long serialVersionUID = 0L;
                private final SimpleFeatureType previousSft$1;
                private final SimpleFeatureType sft$2;

                public final void apply(String key) {
                    if (this.sft$2.getUserData().keySet().contains(key)) {
                        Option option = RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.userData$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(this.sft$2), (Object)key);
                        Option option2 = RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.userData$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(this.previousSft$1), (Object)key);
                        if (option == null ? option2 != null : !option.equals(option2)) {
                            throw new UnsupportedOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Updating ", " is not allowed"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key})));
                        }
                    }
                }
                {
                    this.previousSft$1 = previousSft$1;
                    this.sft$2 = sft$2;
                }
            });
            List previousColumns = previousSft.getAttributeDescriptors();
            List currentColumns = sft.getAttributeDescriptors();
            List list = previousColumns;
            List list2 = currentColumns;
            if (!(list != null ? !((Object)list).equals(list2) : list2 != null)) {
                $this.org$locationtech$geomesa$kafka10$KafkaDataStoreSchemaManager$$zkUtils().zkClient().writeData($this.getSchemaPath(typeName), (Object)SimpleFeatureTypes$.MODULE$.encodeType(sft, true));
                return;
            }
            throw new UnsupportedOperationException("Updating schema columns is not allowed");
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Provided type name ", " does not match schema type name ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{typeName, var4_4})));
    }

    public static void dispose(KafkaDataStoreSchemaManager $this) {
        $this.org$locationtech$geomesa$kafka10$KafkaDataStoreSchemaManager$$zkUtils().close();
    }

    public static KafkaFeatureConfig org$locationtech$geomesa$kafka10$KafkaDataStoreSchemaManager$$resolveTopicSchema(KafkaDataStoreSchemaManager $this, String typeName) {
        String schema = (String)$this.org$locationtech$geomesa$kafka10$KafkaDataStoreSchemaManager$$zkUtils().zkClient().readData($this.getSchemaPath(typeName));
        String topic = (String)$this.org$locationtech$geomesa$kafka10$KafkaDataStoreSchemaManager$$zkUtils().zkClient().readData($this.getTopicPath(typeName));
        SimpleFeatureType sft = SimpleFeatureTypes$.MODULE$.createType(typeName, schema);
        KafkaDataStoreHelper$.MODULE$.insertTopic(sft, topic);
        Option replay = Option$.MODULE$.apply($this.org$locationtech$geomesa$kafka10$KafkaDataStoreSchemaManager$$zkUtils().zkClient().readData($this.getReplayConfigPath(typeName), true));
        replay.foreach((Function1)new Serializable($this, sft){
            public static final long serialVersionUID = 0L;
            private final SimpleFeatureType sft$1;

            public final void apply(String x$3) {
                KafkaDataStoreHelper$.MODULE$.insertReplayConfig(this.sft$1, x$3);
            }
            {
                this.sft$1 = sft$1;
            }
        });
        return new KafkaFeatureConfig(sft);
    }

    public static String getSchemaPath(KafkaDataStoreSchemaManager $this, String typeName) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.zkPath(), typeName}));
    }

    public static String getTopicPath(KafkaDataStoreSchemaManager $this, String typeName) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", "/Topic"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.zkPath(), typeName}));
    }

    public static String getReplayConfigPath(KafkaDataStoreSchemaManager $this, String typeName) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", "/ReplayConfig"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.zkPath(), typeName}));
    }

    public static void org$locationtech$geomesa$kafka10$KafkaDataStoreSchemaManager$$createZkNode(KafkaDataStoreSchemaManager $this, String path, String data) {
        try {
            $this.org$locationtech$geomesa$kafka10$KafkaDataStoreSchemaManager$$zkUtils().zkClient().createPersistent(path, (Object)data);
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof ZkNodeExistsException) {
                ZkNodeExistsException zkNodeExistsException = (ZkNodeExistsException)throwable2;
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Node ", " already exists"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path})), zkNodeExistsException);
            }
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not create path in zookeeper at ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path})), e);
        }
    }

    private static final void liftedTree1$1(KafkaDataStoreSchemaManager $this, ZkUtils10 ret$1) {
        try {
            ret$1.zkClient().createPersistent($this.zkPath(), true);
        }
        catch (Exception exception) {
            throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not create path in zookeeper at ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.zkPath()})), exception);
        }
        catch (ZkNodeExistsException zkNodeExistsException) {
            // empty catch block
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void $init$(KafkaDataStoreSchemaManager $this) {
        void var1_1;
        ZkUtils10 ret = KafkaUtils10$.MODULE$.createZkUtils($this.zookeepers(), Integer.MAX_VALUE, Integer.MAX_VALUE);
        if (!ret.zkClient().exists($this.zkPath())) {
            KafkaDataStoreSchemaManager$class.liftedTree1$1($this, ret);
        }
        $this.org$locationtech$geomesa$kafka10$KafkaDataStoreSchemaManager$_setter_$org$locationtech$geomesa$kafka10$KafkaDataStoreSchemaManager$$zkUtils_$eq((ZkUtils10)var1_1);
        $this.org$locationtech$geomesa$kafka10$KafkaDataStoreSchemaManager$_setter_$org$locationtech$geomesa$kafka10$KafkaDataStoreSchemaManager$$schemaCache_$eq(Caffeine.newBuilder().build((CacheLoader)new CacheLoader<String, KafkaFeatureConfig>($this){
            private final /* synthetic */ KafkaDataStoreSchemaManager $outer;

            public KafkaFeatureConfig load(String k) {
                return KafkaDataStoreSchemaManager$class.org$locationtech$geomesa$kafka10$KafkaDataStoreSchemaManager$$resolveTopicSchema(this.$outer, k);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }));
    }
}

