/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.kafka10.consumer;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import kafka.common.ConsumerRebalanceFailedException;
import kafka.common.TopicAndPartition;
import kafka.consumer.AssignmentContext;
import kafka.consumer.ConsumerConfig;
import kafka.consumer.ConsumerThreadId;
import kafka.consumer.PartitionAssignor;
import kafka.consumer.PartitionAssignor$;
import kafka.utils.Json$;
import kafka.utils.SystemTime$;
import kafka.utils.ZKGroupDirs;
import kafka.utils.ZkUtils$;
import org.I0Itec.zkclient.IZkChildListener;
import org.I0Itec.zkclient.IZkDataListener;
import org.I0Itec.zkclient.IZkStateListener;
import org.I0Itec.zkclient.exception.ZkInterruptedException;
import org.I0Itec.zkclient.exception.ZkNodeExistsException;
import org.apache.zookeeper.Watcher;
import org.locationtech.geomesa.kafka10.KafkaUtils10$;
import org.locationtech.geomesa.kafka10.ZkUtils10;
import org.locationtech.geomesa.kafka10.consumer.Broker;
import org.locationtech.geomesa.kafka10.consumer.ConsumerRebalancer$;
import org.locationtech.geomesa.kafka10.consumer.KafkaConsumer;
import org.locationtech.geomesa.kafka10.consumer.offsets.RequestedOffset;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\r5a\u0001B\u0001\u0003\u00015\u0011!cQ8ogVlWM\u001d*fE\u0006d\u0017M\\2fe*\u00111\u0001B\u0001\tG>t7/^7fe*\u0011QAB\u0001\bW\u000647.Y\u00191\u0015\t9\u0001\"A\u0004hK>lWm]1\u000b\u0005%Q\u0011\u0001\u00047pG\u0006$\u0018n\u001c8uK\u000eD'\"A\u0006\u0002\u0007=\u0014xm\u0001\u0001\u0016\u0007914i\u0005\u0004\u0001\u001f]y\"%\n\t\u0003!Ui\u0011!\u0005\u0006\u0003%M\tA\u0001\\1oO*\tA#\u0001\u0003kCZ\f\u0017B\u0001\f\u0012\u0005\u0019y%M[3diB\u0011\u0001$H\u0007\u00023)\u0011!dG\u0001\tu.\u001cG.[3oi*\u0011ADC\u0001\u0007\u0013BJE/Z2\n\u0005yI\"\u0001E%[WN#\u0018\r^3MSN$XM\\3s!\tA\u0002%\u0003\u0002\"3\ty\u0011JW6ECR\fG*[:uK:,'\u000f\u0005\u0002\u0019G%\u0011A%\u0007\u0002\u0011\u0013j[7\t[5mI2K7\u000f^3oKJ\u0004\"AJ\u0017\u000e\u0003\u001dR!\u0001K\u0015\u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\u0005)Z\u0013\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u00031\n1aY8n\u0013\tqsEA\u0006MCjLHj\\4hS:<\u0007\u0002C\u0002\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0019\u0011\tE\u0012DGQ\u0007\u0002\u0005%\u00111G\u0001\u0002\u000e\u0017\u000647.Y\"p]N,X.\u001a:\u0011\u0005U2D\u0002\u0001\u0003\u0006o\u0001\u0011\r\u0001\u000f\u0002\u0002\u0017F\u0011\u0011h\u0010\t\u0003uuj\u0011a\u000f\u0006\u0002y\u0005)1oY1mC&\u0011ah\u000f\u0002\b\u001d>$\b.\u001b8h!\tQ\u0004)\u0003\u0002Bw\t\u0019\u0011I\\=\u0011\u0005U\u001aE!\u0002#\u0001\u0005\u0004A$!\u0001,\t\u0011\u0019\u0003!\u0011!Q\u0001\n\u001d\u000baaY8oM&<\u0007C\u0001%M\u001b\u0005I%BA\u0002K\u0015\u0005Y\u0015!B6bM.\f\u0017BA'J\u00059\u0019uN\\:v[\u0016\u00148i\u001c8gS\u001eDQa\u0014\u0001\u0005\u0002A\u000ba\u0001P5oSRtDcA)S'B!\u0011\u0007\u0001\u001bC\u0011\u0015\u0019a\n1\u00011\u0011\u00151e\n1\u0001H\u0011\u001d)\u0006A1A\u0005\nY\u000bqA_6Vi&d7/F\u0001X!\tA\u0016,D\u0001\u0005\u0013\tQFAA\u0005[WV#\u0018\u000e\\:2a!1A\f\u0001Q\u0001\n]\u000b\u0001B_6Vi&d7\u000f\t\u0005\b=\u0002\u0011\r\u0011\"\u0003`\u0003E\u0001\u0018M\u001d;ji&|g.Q:tS\u001etwN]\u000b\u0002AJ\u0019\u0011-\u001a4\u0007\t\t\u0004\u0001\u0001\u0019\u0002\ryI,g-\u001b8f[\u0016tGOP\u0005\u0003I&\u0013\u0011\u0003U1si&$\u0018n\u001c8BgNLwM\\8s!\tA5\r\u0005\u0002hU6\t\u0001N\u0003\u0002j\u0015\u0006)Q\u000f^5mg&\u00111\u000e\u001b\u0002\b\u0019><w-\u001b8h\u0011\u0019i\u0007\u0001)A\u0005A\u0006\u0011\u0002/\u0019:uSRLwN\\!tg&<gn\u001c:!\u0011\u001dy\u0007A1A\u0005\nA\f\u0001\u0003^8qS\u000e\u001cFO]3b[\u000e{WO\u001c;\u0016\u0003E\u0004RA]<z\u0003\u0003i\u0011a\u001d\u0006\u0003iV\fq!\\;uC\ndWM\u0003\u0002ww\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005a\u001c(aA'baB\u0011!0 \b\u0003umL!\u0001`\u001e\u0002\rA\u0013X\rZ3g\u0013\tqxP\u0001\u0004TiJLgn\u001a\u0006\u0003yn\u00022AOA\u0002\u0013\r\t)a\u000f\u0002\u0004\u0013:$\bbBA\u0005\u0001\u0001\u0006I!]\u0001\u0012i>\u0004\u0018nY*ue\u0016\fWnQ8v]R\u0004\u0003\"CA\u0007\u0001\t\u0007I\u0011BA\b\u0003=!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u001cXCAA\t!\u0015\u0011x/_A\n!\u0015Q\u0018QCA\u0001\u0013\r\t9b \u0002\u0004'\u0016$\b\u0002CA\u000e\u0001\u0001\u0006I!!\u0005\u0002!Q|\u0007/[2QCJ$\u0018\u000e^5p]N\u0004\u0003\"CA\u0010\u0001\u0001\u0007I\u0011BA\u0011\u0003II7oV1uG\",'\u000f\u0016:jO\u001e,'/\u001a3\u0016\u0005\u0005\r\u0002c\u0001\u001e\u0002&%\u0019\u0011qE\u001e\u0003\u000f\t{w\u000e\\3b]\"I\u00111\u0006\u0001A\u0002\u0013%\u0011QF\u0001\u0017SN<\u0016\r^2iKJ$&/[4hKJ,Gm\u0018\u0013fcR!\u0011qFA\u001b!\rQ\u0014\u0011G\u0005\u0004\u0003gY$\u0001B+oSRD!\"a\u000e\u0002*\u0005\u0005\t\u0019AA\u0012\u0003\rAH%\r\u0005\t\u0003w\u0001\u0001\u0015)\u0003\u0002$\u0005\u0019\u0012n],bi\u000eDWM\u001d+sS\u001e<WM]3eA!I\u0011q\b\u0001C\u0002\u0013%\u0011\u0011I\u0001\u0013o\u0006$8\r[3s)JLwmZ3s\u0019>\u001c7.\u0006\u0002\u0002DA!\u0011QIA*\u001b\t\t9E\u0003\u0003\u0002J\u0005-\u0013!\u00027pG.\u001c(\u0002BA'\u0003\u001f\n!bY8oGV\u0014(/\u001a8u\u0015\r\t\tfE\u0001\u0005kRLG.\u0003\u0003\u0002V\u0005\u001d#!\u0004*fK:$(/\u00198u\u0019>\u001c7\u000e\u0003\u0005\u0002Z\u0001\u0001\u000b\u0011BA\"\u0003M9\u0018\r^2iKJ$&/[4hKJdunY6!\u0011%\ti\u0006\u0001b\u0001\n\u0013\ty&A\fxCR\u001c\u0007.\u001a:Ue&<w-\u001a:D_:$\u0017\u000e^5p]V\u0011\u0011\u0011\r\t\u0005\u0003\u000b\n\u0019'\u0003\u0003\u0002f\u0005\u001d#!C\"p]\u0012LG/[8o\u0011!\tI\u0007\u0001Q\u0001\n\u0005\u0005\u0014\u0001G<bi\u000eDWM\u001d+sS\u001e<WM]\"p]\u0012LG/[8oA!I\u0011Q\u000e\u0001C\u0002\u0013%\u0011qN\u0001\u000ee\u0016\u0014\u0017\r\\1oG\u0016dunY6\u0016\u0003=Aq!a\u001d\u0001A\u0003%q\"\u0001\bsK\n\fG.\u00198dK2{7m\u001b\u0011\t\u0013\u0005]\u0004A1A\u0005\n\u0005e\u0014aB:uCJ$X\rZ\u000b\u0003\u0003w\u0002B!! \u0002\u00046\u0011\u0011q\u0010\u0006\u0005\u0003\u0003\u000bY%\u0001\u0004bi>l\u0017nY\u0005\u0005\u0003\u000b\u000byHA\u0007Bi>l\u0017n\u0019\"p_2,\u0017M\u001c\u0005\t\u0003\u0013\u0003\u0001\u0015!\u0003\u0002|\u0005A1\u000f^1si\u0016$\u0007\u0005C\u0005\u0002\u000e\u0002\u0011\r\u0011\"\u0003\u0002z\u0005Q\u0011n]*ikR$wn\u001e8\t\u0011\u0005E\u0005\u0001)A\u0005\u0003w\n1\"[:TQV$Hm\\<oA!I\u0011Q\u0013\u0001C\u0002\u0013%\u0011qS\u0001\u0006i>\u0004\u0018nY\u000b\u0002s\"9\u00111\u0014\u0001!\u0002\u0013I\u0018A\u0002;pa&\u001c\u0007\u0005C\u0005\u0002 \u0002\u0011\r\u0011\"\u0003\u0002\u0018\u0006Q1m\u001c8tk6,'/\u00133\t\u000f\u0005\r\u0006\u0001)A\u0005s\u0006Y1m\u001c8tk6,'/\u00133!\u0011%\t9\u000b\u0001b\u0001\n\u0013\tI+\u0001\u0003eSJ\u001cXCAAV!\r9\u0017QV\u0005\u0004\u0003_C'a\u0003.L\u000fJ|W\u000f\u001d#jeND\u0001\"a-\u0001A\u0003%\u00111V\u0001\u0006I&\u00148\u000f\t\u0005\n\u0003o\u0003!\u0019!C\u0005\u0003s\u000bQc^1uG\",'/\u0012=fGV$xN\u001d+ie\u0016\fG-\u0006\u0002\u0002<B\u0019\u0001#!0\n\u0007\u0005}\u0016C\u0001\u0004UQJ,\u0017\r\u001a\u0005\t\u0003\u0007\u0004\u0001\u0015!\u0003\u0002<\u00061r/\u0019;dQ\u0016\u0014X\t_3dkR|'\u000f\u00165sK\u0006$\u0007\u0005C\u0004\u0002H\u0002!\t%!3\u0002!!\fg\u000e\u001a7f\u001d\u0016<8+Z:tS>tGCAA\u0018Q\u0019\t)-!4\u0002lB)!(a4\u0002T&\u0019\u0011\u0011[\u001e\u0003\rQD'o\\<t!\u0011\t).!:\u000f\t\u0005]\u0017\u0011\u001d\b\u0005\u00033\fy.\u0004\u0002\u0002\\*\u0019\u0011Q\u001c\u0007\u0002\rq\u0012xn\u001c;?\u0013\u0005a\u0014bAArw\u00059\u0001/Y2lC\u001e,\u0017\u0002BAt\u0003S\u0014\u0011\"\u0012=dKB$\u0018n\u001c8\u000b\u0007\u0005\r8h\t\u0002\u0002T\"9\u0011q\u001e\u0001\u0005\u0002\u0005E\u0018a\b5b]\u0012dWmU3tg&|g.R:uC\nd\u0017n\u001d5nK:$XI\u001d:peR!\u0011qFAz\u0011!\t)0!<A\u0002\u0005]\u0018!\u0003;ie><\u0018M\u00197f!\u0011\t).!?\n\t\u0005m\u0018\u0011\u001e\u0002\n)\"\u0014xn^1cY\u0016Dq!a@\u0001\t\u0003\u0012\t!\u0001\niC:$G.Z*uCR,7\t[1oO\u0016$G\u0003BA\u0018\u0005\u0007A\u0001B!\u0002\u0002~\u0002\u0007!qA\u0001\u0006gR\fG/\u001a\t\u0005\u0005\u0013\u0011YC\u0004\u0003\u0003\f\t\u0015b\u0002\u0002B\u0007\u0005?qAAa\u0004\u0003\u001a9!!\u0011\u0003B\u000b\u001d\u0011\tINa\u0005\n\u0003-I1Aa\u0006\u000b\u0003\u0019\t\u0007/Y2iK&!!1\u0004B\u000f\u0003%Qxn\\6fKB,'OC\u0002\u0003\u0018)IAA!\t\u0003$\u00059q+\u0019;dQ\u0016\u0014(\u0002\u0002B\u000e\u0005;IAAa\n\u0003*\u0005)QI^3oi*!!\u0011\u0005B\u0012\u0013\u0011\u0011iCa\f\u0003\u0017-+W\r]3s'R\fG/\u001a\u0006\u0005\u0005O\u0011I\u0003\u000b\u0004\u0002~\u00065\u00171\u001e\u0005\b\u0005k\u0001A\u0011\tB\u001c\u0003AA\u0017M\u001c3mK\u0012\u000bG/Y\"iC:<W\r\u0006\u0004\u00020\te\"Q\b\u0005\b\u0005w\u0011\u0019\u00041\u0001z\u0003!!\u0017\r^1QCRD\u0007b\u0002B \u0005g\u0001\raP\u0001\u0005I\u0006$\u0018\r\u000b\u0004\u00034\u00055\u00171\u001e\u0005\b\u0005\u000b\u0002A\u0011\tB$\u0003EA\u0017M\u001c3mK\u0012\u000bG/\u0019#fY\u0016$X\r\u001a\u000b\u0005\u0003_\u0011I\u0005C\u0004\u0003<\t\r\u0003\u0019A=)\r\t\r\u0013QZAv\u0011\u001d\u0011y\u0005\u0001C!\u0005#\n\u0011\u0003[1oI2,7\t[5mI\u000eC\u0017M\\4f)\u0019\tyCa\u0015\u0003X!9!Q\u000bB'\u0001\u0004I\u0018A\u00039be\u0016tG\u000fU1uQ\"A!\u0011\fB'\u0001\u0004\u0011Y&\u0001\u0005dQ&dGM]3o!\u0015\u0011iFa\u0018z\u001b\t\ty%\u0003\u0003\u0003b\u0005=#\u0001\u0002'jgRDcA!\u0014\u0002N\u0006-\bb\u0002B4\u0001\u0011\u0005!\u0011N\u0001\u0006gR\f'\u000f\u001e\u000b\u0007\u0003_\u0011YGa\u001c\t\u0011\t5$Q\ra\u0001\u0003\u0003\t!B\\;n'R\u0014X-Y7t\u0011!\u0011\tH!\u001aA\u0002\tM\u0014AB8gMN,G\u000f\u0005\u0003\u0003v\tmTB\u0001B<\u0015\r\u0011IHA\u0001\b_\u001a47/\u001a;t\u0013\u0011\u0011iHa\u001e\u0003\u001fI+\u0017/^3ti\u0016$wJ\u001a4tKRDqA!!\u0001\t\u0003\tI-\u0001\u0005tQV$Hm\\<o\u0011\u001d\u0011)\t\u0001C\u0005\u0003\u0013\f1C]3hSN$XM\u001d.L\u0019&\u001cH/\u001a8feNDqA!#\u0001\t\u0013\tI-\u0001\u000bsK\u001eL7\u000f^3s\u0007>t7/^7fe&s'l\u0013\u0005\b\u0005\u001b\u0003A\u0011BAe\u0003e\u0011X\r\\3bg\u0016\u0004\u0016M\u001d;ji&|gnT<oKJ\u001c\b.\u001b9\t\u000f\tE\u0005\u0001\"\u0003\u0003\u0014\u0006qB-\u001a7fi\u0016\u0004\u0016M\u001d;ji&|gnT<oKJ\u001c\b.\u001b9Ge>l'l\u0013\u000b\u0007\u0003_\u0011)Ja&\t\u000f\u0005U%q\u0012a\u0001s\"A!\u0011\u0014BH\u0001\u0004\t\t!A\u0005qCJ$\u0018\u000e^5p]\"9!Q\u0014\u0001\u0005\n\u0005%\u0017a\u0006:fE\u0006d\u0017M\\2f\u000bZ,g\u000e\u001e+sS\u001e<WM]3e\u0011\u001d\u0011\t\u000b\u0001C\u0001\u0003\u0013\fqb]=oG\u0016$'+\u001a2bY\u0006t7-\u001a\u0005\b\u0005K\u0003A\u0011\u0002BT\u0003%\u0011XMY1mC:\u001cW\r\u0006\u0003\u00020\t%\u0006\u0002\u0003BV\u0005G\u0003\r!!\u0001\u0002\u00119,X\u000e\u0016:jKNDCAa)\u00030B!!\u0011\u0017B\\\u001b\t\u0011\u0019LC\u0002\u00036n\n!\"\u00198o_R\fG/[8o\u0013\u0011\u0011ILa-\u0003\u000fQ\f\u0017\u000e\u001c:fG\"9!Q\u0015\u0001\u0005\n\tuF\u0003BA\u0012\u0005\u007fC\u0001B!1\u0003<\u0002\u0007!1Y\u0001\bG2,8\u000f^3s!\u0019\t)N!2\u0003J&!!qYAu\u0005\r\u0019V-\u001d\t\u0004c\t-\u0017b\u0001Bg\u0005\t1!I]8lKJDqA!5\u0001\t\u0013\u0011\u0019.A\u0011sK\u001adWm\u0019;QCJ$\u0018\u000e^5p]>;h.\u001a:tQ&\u0004H)Z2jg&|g\u000e\u0006\u0003\u0002$\tU\u0007\u0002\u0003Bl\u0005\u001f\u0004\rA!7\u00025A\f'\u000f^5uS>twj\u001e8feND\u0017\u000e\u001d#fG&\u001c\u0018n\u001c8\u0011\u0011\tm'Q\u001cBp\u0005Wl\u0011!^\u0005\u0003qV\u0004BA!9\u0003h6\u0011!1\u001d\u0006\u0004\u0005KT\u0015AB2p[6|g.\u0003\u0003\u0003j\n\r(!\u0005+pa&\u001c\u0017I\u001c3QCJ$\u0018\u000e^5p]B\u0019\u0001J!<\n\u0007\t=\u0018J\u0001\tD_:\u001cX/\\3s)\"\u0014X-\u00193JI\u001e9!1\u001f\u0002\t\u0002\tU\u0018AE\"p]N,X.\u001a:SK\n\fG.\u00198dKJ\u00042!\rB|\r\u0019\t!\u0001#\u0001\u0003zN!!q\u001fB~!\rQ$Q`\u0005\u0004\u0005\u007f\\$AB!osJ+g\rC\u0004P\u0005o$\taa\u0001\u0015\u0005\tU\b\u0002CB\u0004\u0005o$\ta!\u0003\u0002\u0015\u001d,Go\u00117vgR,'\u000f\u0006\u0003\u0003D\u000e-\u0001BB+\u0004\u0006\u0001\u0007q\u000b")
public class ConsumerRebalancer<K, V>
implements IZkStateListener,
IZkDataListener,
IZkChildListener,
LazyLogging {
    private final KafkaConsumer<K, V> consumer;
    public final ConsumerConfig org$locationtech$geomesa$kafka10$consumer$ConsumerRebalancer$$config;
    private final ZkUtils10 org$locationtech$geomesa$kafka10$consumer$ConsumerRebalancer$$zkUtils;
    private final PartitionAssignor partitionAssignor;
    private final scala.collection.mutable.Map<String, Object> topicStreamCount;
    private final scala.collection.mutable.Map<String, Set<Object>> org$locationtech$geomesa$kafka10$consumer$ConsumerRebalancer$$topicPartitions;
    private boolean org$locationtech$geomesa$kafka10$consumer$ConsumerRebalancer$$isWatcherTriggered;
    private final ReentrantLock org$locationtech$geomesa$kafka10$consumer$ConsumerRebalancer$$watcherTriggerLock;
    private final Condition org$locationtech$geomesa$kafka10$consumer$ConsumerRebalancer$$watcherTriggerCondition;
    private final Object rebalanceLock;
    private final AtomicBoolean started;
    private final AtomicBoolean org$locationtech$geomesa$kafka10$consumer$ConsumerRebalancer$$isShutdown;
    private final String topic;
    private final String org$locationtech$geomesa$kafka10$consumer$ConsumerRebalancer$$consumerId;
    private final ZKGroupDirs dirs;
    private final Thread watcherExecutorThread;
    private final Logger logger;
    private volatile boolean bitmap$0;

    public static Seq<Broker> getCluster(ZkUtils10 zkUtils10) {
        return ConsumerRebalancer$.MODULE$.getCluster(zkUtils10);
    }

    private Logger logger$lzycompute() {
        ConsumerRebalancer consumerRebalancer = this;
        synchronized (consumerRebalancer) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public ZkUtils10 org$locationtech$geomesa$kafka10$consumer$ConsumerRebalancer$$zkUtils() {
        return this.org$locationtech$geomesa$kafka10$consumer$ConsumerRebalancer$$zkUtils;
    }

    private PartitionAssignor partitionAssignor() {
        return this.partitionAssignor;
    }

    private scala.collection.mutable.Map<String, Object> topicStreamCount() {
        return this.topicStreamCount;
    }

    public scala.collection.mutable.Map<String, Set<Object>> org$locationtech$geomesa$kafka10$consumer$ConsumerRebalancer$$topicPartitions() {
        return this.org$locationtech$geomesa$kafka10$consumer$ConsumerRebalancer$$topicPartitions;
    }

    public boolean org$locationtech$geomesa$kafka10$consumer$ConsumerRebalancer$$isWatcherTriggered() {
        return this.org$locationtech$geomesa$kafka10$consumer$ConsumerRebalancer$$isWatcherTriggered;
    }

    public void org$locationtech$geomesa$kafka10$consumer$ConsumerRebalancer$$isWatcherTriggered_$eq(boolean x$1) {
        this.org$locationtech$geomesa$kafka10$consumer$ConsumerRebalancer$$isWatcherTriggered = x$1;
    }

    public ReentrantLock org$locationtech$geomesa$kafka10$consumer$ConsumerRebalancer$$watcherTriggerLock() {
        return this.org$locationtech$geomesa$kafka10$consumer$ConsumerRebalancer$$watcherTriggerLock;
    }

    public Condition org$locationtech$geomesa$kafka10$consumer$ConsumerRebalancer$$watcherTriggerCondition() {
        return this.org$locationtech$geomesa$kafka10$consumer$ConsumerRebalancer$$watcherTriggerCondition;
    }

    private Object rebalanceLock() {
        return this.rebalanceLock;
    }

    private AtomicBoolean started() {
        return this.started;
    }

    public AtomicBoolean org$locationtech$geomesa$kafka10$consumer$ConsumerRebalancer$$isShutdown() {
        return this.org$locationtech$geomesa$kafka10$consumer$ConsumerRebalancer$$isShutdown;
    }

    private String topic() {
        return this.topic;
    }

    public String org$locationtech$geomesa$kafka10$consumer$ConsumerRebalancer$$consumerId() {
        return this.org$locationtech$geomesa$kafka10$consumer$ConsumerRebalancer$$consumerId;
    }

    private ZKGroupDirs dirs() {
        return this.dirs;
    }

    private Thread watcherExecutorThread() {
        return this.watcherExecutorThread;
    }

    public void handleNewSession() throws Exception {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ZK session expired; release old partition ownership; re-register consumer ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.org$locationtech$geomesa$kafka10$consumer$ConsumerRebalancer$$consumerId()})));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.registerConsumerInZK();
        this.registerZKListeners();
        this.syncedRebalance();
    }

    public void handleSessionEstablishmentError(Throwable throwable) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isErrorEnabled()) {
            this.logger().underlying().error("Could not establish session with zookeeper", throwable);
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void handleStateChanged(Watcher.Event.KeeperState state) throws Exception {
    }

    public void handleDataChange(String dataPath, Object data) throws Exception {
        try {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Topic info for path ", " changed to ", ", triggering rebalance"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dataPath, data})));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            this.rebalanceEventTriggered();
        }
        catch (Throwable throwable) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error while handling topic partition change for data path ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dataPath})), throwable);
                boxedUnit = BoxedUnit.UNIT;
            }
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void handleDataDeleted(String dataPath) throws Exception {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isWarnEnabled()) {
            this.logger().underlying().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Topic for path ", " gets deleted, which should not happen at this time"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dataPath})));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void handleChildChange(String parentPath, List<String> children) throws Exception {
        this.rebalanceEventTriggered();
    }

    public void start(int numStreams, RequestedOffset offset) {
        if (this.started().compareAndSet(false, true)) {
            this.topicStreamCount().put((Object)this.topic(), (Object)BoxesRunTime.boxToInteger((int)numStreams));
            this.registerConsumerInZK();
            this.consumer.initializeOffsets(this.org$locationtech$geomesa$kafka10$consumer$ConsumerRebalancer$$zkUtils().zkClient(), this.dirs(), offset);
            this.registerZKListeners();
            this.syncedRebalance();
            this.watcherExecutorThread().start();
            return;
        }
        throw new IllegalStateException("Rebalancer is already started");
    }

    public void shutdown() {
        this.org$locationtech$geomesa$kafka10$consumer$ConsumerRebalancer$$isShutdown().set(true);
        this.watcherExecutorThread().interrupt();
        this.org$locationtech$geomesa$kafka10$consumer$ConsumerRebalancer$$zkUtils().close();
    }

    private void registerZKListeners() {
        this.org$locationtech$geomesa$kafka10$consumer$ConsumerRebalancer$$zkUtils().zkClient().subscribeStateChanges((IZkStateListener)this);
        this.org$locationtech$geomesa$kafka10$consumer$ConsumerRebalancer$$zkUtils().zkClient().subscribeChildChanges(this.dirs().consumerRegistryDir(), (IZkChildListener)this);
        String topicPath = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ZkUtils$.MODULE$.BrokerTopicsPath(), this.topic()}));
        this.org$locationtech$geomesa$kafka10$consumer$ConsumerRebalancer$$zkUtils().zkClient().subscribeDataChanges(topicPath, (IZkDataListener)this);
    }

    private void registerConsumerInZK() {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Begin registering consumer ", " in ZK"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.org$locationtech$geomesa$kafka10$consumer$ConsumerRebalancer$$consumerId()})));
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        String timestamp = ((Object)BoxesRunTime.boxToLong((long)SystemTime$.MODULE$.milliseconds())).toString();
        String path = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.dirs().consumerRegistryDir(), this.org$locationtech$geomesa$kafka10$consumer$ConsumerRebalancer$$consumerId()}));
        int timeout = this.org$locationtech$geomesa$kafka10$consumer$ConsumerRebalancer$$config.zkSessionTimeoutMs();
        String consumerInfo = Json$.MODULE$.encode((Object)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"version"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"subscription"), this.topicStreamCount()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"pattern"), (Object)"static"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"timestamp"), (Object)timestamp)})));
        this.org$locationtech$geomesa$kafka10$consumer$ConsumerRebalancer$$zkUtils().createEphemeralPathExpectConflictHandleZKBug(path, consumerInfo, null, (Function2<String, Object, Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$1, Object x$2) {
                return true;
            }
        }, timeout);
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"End registering consumer ", " in ZK"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.org$locationtech$geomesa$kafka10$consumer$ConsumerRebalancer$$consumerId()})));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    private void releasePartitionOwnership() {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Releasing partition ownership");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.org$locationtech$geomesa$kafka10$consumer$ConsumerRebalancer$$topicPartitions().withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, Set<Object>> check$ifrefutable$1) {
                Tuple2<String, Set<Object>> tuple2 = check$ifrefutable$1;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConsumerRebalancer $outer;

            public final Option<Set<Object>> apply(Tuple2<String, Set<Object>> x$4) {
                Tuple2<String, Set<Object>> tuple2 = x$4;
                if (tuple2 != null) {
                    String topic = (String)tuple2._1();
                    Set partitions = (Set)tuple2._2();
                    partitions.foreach((Function1)new Serializable(this, topic){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$releasePartitionOwnership$2 $outer;
                        private final String topic$1;

                        public final void apply(int x$3) {
                            this.apply$mcVI$sp(x$3);
                        }

                        public void apply$mcVI$sp(int x$3) {
                            this.$outer.org$locationtech$geomesa$kafka10$consumer$ConsumerRebalancer$$anonfun$$$outer().org$locationtech$geomesa$kafka10$consumer$ConsumerRebalancer$$deletePartitionOwnershipFromZK(this.topic$1, x$3);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.topic$1 = topic$1;
                        }
                    });
                    Option option = this.$outer.org$locationtech$geomesa$kafka10$consumer$ConsumerRebalancer$$topicPartitions().remove((Object)topic);
                    return option;
                }
                throw new MatchError(tuple2);
            }

            public /* synthetic */ ConsumerRebalancer org$locationtech$geomesa$kafka10$consumer$ConsumerRebalancer$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public void org$locationtech$geomesa$kafka10$consumer$ConsumerRebalancer$$deletePartitionOwnershipFromZK(String topic, int partition) {
        BoxedUnit boxedUnit;
        String znode = this.org$locationtech$geomesa$kafka10$consumer$ConsumerRebalancer$$zkUtils().getConsumerPartitionOwnerPath(this.org$locationtech$geomesa$kafka10$consumer$ConsumerRebalancer$$config.groupId(), topic, partition);
        this.org$locationtech$geomesa$kafka10$consumer$ConsumerRebalancer$$zkUtils().deletePath(znode);
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Consumer ", " releasing ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.org$locationtech$geomesa$kafka10$consumer$ConsumerRebalancer$$consumerId(), znode})));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    private void rebalanceEventTriggered() {
        this.org$locationtech$geomesa$kafka10$consumer$ConsumerRebalancer$$watcherTriggerLock().lock();
        try {
            this.org$locationtech$geomesa$kafka10$consumer$ConsumerRebalancer$$isWatcherTriggered_$eq(true);
            this.org$locationtech$geomesa$kafka10$consumer$ConsumerRebalancer$$watcherTriggerCondition().signalAll();
            return;
        }
        finally {
            this.org$locationtech$geomesa$kafka10$consumer$ConsumerRebalancer$$watcherTriggerLock().unlock();
        }
    }

    public void syncedRebalance() {
        Object object = this.rebalanceLock();
        synchronized (object) {
            this.rebalance(1);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void rebalance(int numTries) {
        Throwable throwable2;
        block15: {
            while (true) {
                BoxedUnit boxedUnit;
                BoxedUnit boxedUnit2;
                boolean done;
                boolean bl;
                BoxedUnit boxedUnit3;
                if (this.org$locationtech$geomesa$kafka10$consumer$ConsumerRebalancer$$isShutdown().get()) {
                    return;
                }
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Begin rebalancing consumer ", " try ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.org$locationtech$geomesa$kafka10$consumer$ConsumerRebalancer$$consumerId(), BoxesRunTime.boxToInteger((int)numTries)})));
                    boxedUnit3 = BoxedUnit.UNIT;
                } else {
                    boxedUnit3 = BoxedUnit.UNIT;
                }
                try {
                    bl = this.rebalance(ConsumerRebalancer$.MODULE$.getCluster(this.org$locationtech$geomesa$kafka10$consumer$ConsumerRebalancer$$zkUtils()));
                }
                catch (Throwable throwable2) {
                    boolean bl2;
                    Throwable throwable3 = throwable2;
                    boolean bl3 = throwable3 instanceof ZkInterruptedException ? true : throwable3 instanceof InterruptedException;
                    if (bl3) {
                        bl2 = false;
                    } else {
                        BoxedUnit boxedUnit4;
                        if (!(throwable3 instanceof Exception)) break block15;
                        Exception exception = (Exception)throwable3;
                        if (this.logger().underlying().isInfoEnabled()) {
                            this.logger().underlying().info("Exception during rebalance", (Throwable)exception);
                            boxedUnit4 = BoxedUnit.UNIT;
                        } else {
                            boxedUnit4 = BoxedUnit.UNIT;
                        }
                        bl2 = false;
                    }
                    bl = done = bl2;
                }
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"End rebalancing consumer ", " try ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.org$locationtech$geomesa$kafka10$consumer$ConsumerRebalancer$$consumerId(), BoxesRunTime.boxToInteger((int)numTries)})));
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                if (done) {
                    return;
                }
                if (numTries >= this.org$locationtech$geomesa$kafka10$consumer$ConsumerRebalancer$$config.rebalanceMaxRetries()) break;
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug("Rebalancing attempt failed. Clearing the cache before the next rebalancing operation is triggered");
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                this.consumer.closeFetchers();
                Thread.sleep(this.org$locationtech$geomesa$kafka10$consumer$ConsumerRebalancer$$config.rebalanceBackoffMs());
                ++numTries;
            }
            throw new ConsumerRebalanceFailedException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " can't rebalance after ", " retries"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.org$locationtech$geomesa$kafka10$consumer$ConsumerRebalancer$$consumerId(), BoxesRunTime.boxToInteger((int)this.org$locationtech$geomesa$kafka10$consumer$ConsumerRebalancer$$config.rebalanceMaxRetries())})));
        }
        throw throwable2;
    }

    private boolean rebalance(Seq<Broker> cluster) {
        boolean bl;
        Seq<kafka.cluster.Broker> brokers = this.org$locationtech$geomesa$kafka10$consumer$ConsumerRebalancer$$zkUtils().getAllBrokersInCluster();
        if (brokers.size() == 0) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn("No brokers found when trying to rebalance.");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            this.org$locationtech$geomesa$kafka10$consumer$ConsumerRebalancer$$zkUtils().zkClient().subscribeChildChanges(ZkUtils$.MODULE$.BrokerIdsPath(), (IZkChildListener)this);
            bl = true;
        } else {
            this.consumer.closeFetchers();
            this.releasePartitionOwnership();
            AssignmentContext assignmentContext = this.org$locationtech$geomesa$kafka10$consumer$ConsumerRebalancer$$zkUtils().createAssignmentContext(this.org$locationtech$geomesa$kafka10$consumer$ConsumerRebalancer$$config.groupId(), this.org$locationtech$geomesa$kafka10$consumer$ConsumerRebalancer$$consumerId(), this.org$locationtech$geomesa$kafka10$consumer$ConsumerRebalancer$$config.excludeInternalTopics());
            scala.collection.immutable.Map<TopicAndPartition, ConsumerThreadId> partitionOwnershipDecision = KafkaUtils10$.MODULE$.assign(this.partitionAssignor(), assignmentContext);
            if (this.reflectPartitionOwnershipDecision((Map<TopicAndPartition, ConsumerThreadId>)partitionOwnershipDecision)) {
                Set partitions = ((TraversableOnce)partitionOwnershipDecision.keys().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(TopicAndPartition x$5) {
                        return x$5.partition();
                    }
                }, Iterable$.MODULE$.canBuildFrom())).toSet();
                this.org$locationtech$geomesa$kafka10$consumer$ConsumerRebalancer$$topicPartitions().put((Object)this.topic(), (Object)partitions);
                this.consumer.initializeFetchers((Set<Object>)partitions);
                bl = true;
            } else {
                bl = false;
            }
        }
        return bl;
    }

    private boolean reflectPartitionOwnershipDecision(Map<TopicAndPartition, ConsumerThreadId> partitionOwnershipDecision) {
        boolean bl;
        Iterable successfullyOwnedPartitions = (Iterable)partitionOwnershipDecision.flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConsumerRebalancer $outer;

            public final Iterable<TopicAndPartition> apply(Tuple2<TopicAndPartition, ConsumerThreadId> partitionOwner) {
                Iterable iterable;
                TopicAndPartition tap = (TopicAndPartition)partitionOwner._1();
                ConsumerThreadId consumerThreadId = (ConsumerThreadId)partitionOwner._2();
                String partitionOwnerPath = this.$outer.org$locationtech$geomesa$kafka10$consumer$ConsumerRebalancer$$zkUtils().getConsumerPartitionOwnerPath(this.$outer.org$locationtech$geomesa$kafka10$consumer$ConsumerRebalancer$$config.groupId(), tap.topic(), tap.partition());
                try {
                    BoxedUnit boxedUnit;
                    this.$outer.org$locationtech$geomesa$kafka10$consumer$ConsumerRebalancer$$zkUtils().createEphemeralPathExpectConflict(partitionOwnerPath, consumerThreadId.toString());
                    if (this.$outer.logger().underlying().isDebugEnabled()) {
                        this.$outer.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " successfully owned topic and partition ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{consumerThreadId, tap})));
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)tap));
                }
                catch (ZkNodeExistsException zkNodeExistsException) {
                    BoxedUnit boxedUnit;
                    if (this.$outer.logger().underlying().isDebugEnabled()) {
                        this.$outer.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"waiting for the partition ownership to be deleted for topic and partition ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tap})));
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                }
                return iterable;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Iterable$.MODULE$.canBuildFrom());
        if (successfullyOwnedPartitions.size() == partitionOwnershipDecision.size()) {
            bl = true;
        } else {
            successfullyOwnedPartitions.foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ConsumerRebalancer $outer;

                public final void apply(TopicAndPartition tap) {
                    this.$outer.org$locationtech$geomesa$kafka10$consumer$ConsumerRebalancer$$deletePartitionOwnershipFromZK(tap.topic(), tap.partition());
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            bl = false;
        }
        return bl;
    }

    public ConsumerRebalancer(KafkaConsumer<K, V> consumer, ConsumerConfig config) {
        this.consumer = consumer;
        this.org$locationtech$geomesa$kafka10$consumer$ConsumerRebalancer$$config = config;
        LazyLogging.class.$init$((LazyLogging)this);
        this.org$locationtech$geomesa$kafka10$consumer$ConsumerRebalancer$$zkUtils = KafkaUtils10$.MODULE$.createZkUtils(config);
        this.partitionAssignor = PartitionAssignor$.MODULE$.createInstance(config.partitionAssignmentStrategy());
        this.topicStreamCount = Map$.MODULE$.empty();
        this.org$locationtech$geomesa$kafka10$consumer$ConsumerRebalancer$$topicPartitions = Map$.MODULE$.empty();
        this.org$locationtech$geomesa$kafka10$consumer$ConsumerRebalancer$$isWatcherTriggered = false;
        this.org$locationtech$geomesa$kafka10$consumer$ConsumerRebalancer$$watcherTriggerLock = new ReentrantLock();
        this.org$locationtech$geomesa$kafka10$consumer$ConsumerRebalancer$$watcherTriggerCondition = this.org$locationtech$geomesa$kafka10$consumer$ConsumerRebalancer$$watcherTriggerLock().newCondition();
        this.rebalanceLock = new Object();
        this.started = new AtomicBoolean(false);
        this.org$locationtech$geomesa$kafka10$consumer$ConsumerRebalancer$$isShutdown = new AtomicBoolean(false);
        this.topic = consumer.topic();
        this.org$locationtech$geomesa$kafka10$consumer$ConsumerRebalancer$$consumerId = consumer.consumerId();
        this.dirs = new ZKGroupDirs(config.groupId());
        this.watcherExecutorThread = new Thread(this){
            private final /* synthetic */ ConsumerRebalancer $outer;

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                BoxedUnit boxedUnit;
                if (this.$outer.logger().underlying().isDebugEnabled()) {
                    this.$outer.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"starting watcher executor thread for consumer ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$locationtech$geomesa$kafka10$consumer$ConsumerRebalancer$$consumerId()})));
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                boolean doRebalance = false;
                while (true) {
                    BoxedUnit boxedUnit2;
                    if (this.$outer.org$locationtech$geomesa$kafka10$consumer$ConsumerRebalancer$$isShutdown().get()) {
                        BoxedUnit boxedUnit3;
                        if (this.$outer.logger().underlying().isDebugEnabled()) {
                            this.$outer.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"stopping watcher executor thread for consumer ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$locationtech$geomesa$kafka10$consumer$ConsumerRebalancer$$consumerId()})));
                            boxedUnit3 = BoxedUnit.UNIT;
                            return;
                        }
                        boxedUnit3 = BoxedUnit.UNIT;
                        return;
                    }
                    try {
                        boolean bl;
                        this.$outer.org$locationtech$geomesa$kafka10$consumer$ConsumerRebalancer$$watcherTriggerLock().lock();
                        {
                            Object object = this.$outer.org$locationtech$geomesa$kafka10$consumer$ConsumerRebalancer$$isWatcherTriggered() ? BoxedUnit.UNIT : BoxesRunTime.boxToBoolean((boolean)this.$outer.org$locationtech$geomesa$kafka10$consumer$ConsumerRebalancer$$watcherTriggerCondition().await(1000L, TimeUnit.MILLISECONDS));
                            bl = this.$outer.org$locationtech$geomesa$kafka10$consumer$ConsumerRebalancer$$isWatcherTriggered();
                            this.$outer.org$locationtech$geomesa$kafka10$consumer$ConsumerRebalancer$$isWatcherTriggered_$eq(false);
                            this.$outer.org$locationtech$geomesa$kafka10$consumer$ConsumerRebalancer$$watcherTriggerLock().unlock();
                        }
                        if (bl) {
                            this.$outer.syncedRebalance();
                        }
                        boxedUnit2 = BoxedUnit.UNIT;
                        continue;
                    }
                    catch (Exception exception) {
                        if (this.$outer.logger().underlying().isErrorEnabled()) {
                            this.$outer.logger().underlying().error("Error during syncedRebalance", (Throwable)exception);
                            boxedUnit2 = BoxedUnit.UNIT;
                            continue;
                        }
                        boxedUnit2 = BoxedUnit.UNIT;
                        continue;
                    }
                    break;
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "_watcher_executor"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$outer.org$locationtech$geomesa$kafka10$consumer$ConsumerRebalancer$$consumerId()})));
            }
        };
    }
}

