/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.kafka10.consumer;

import kafka.api.FetchRequest;
import kafka.api.FetchRequestBuilder;
import kafka.api.FetchResponse;
import kafka.common.ErrorMapping$;
import kafka.consumer.SimpleConsumer;
import org.locationtech.geomesa.kafka10.consumer.Fetcher;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

public abstract class Fetcher$class {
    public static Try fetch(Fetcher $this, SimpleConsumer consumer, String topic, int partition, long offset, int maxBytes) {
        Success success;
        FetchRequestBuilder requestBuilder = new FetchRequestBuilder().clientId(consumer.clientId());
        FetchRequest request = requestBuilder.addFetch(topic, partition, offset, maxBytes).build();
        FetchResponse response = consumer.fetch(request);
        if (response.hasError()) {
            BoxedUnit boxedUnit;
            short code = response.errorCode(topic, partition);
            if ($this.logger().underlying().isErrorEnabled()) {
                $this.logger().underlying().error(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error fetching data from the broker [", ":", "] - "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{consumer.host(), BoxesRunTime.boxToInteger((int)consumer.port())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"reason: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ErrorMapping$.MODULE$.exceptionFor(code)}))).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            success = new Failure(ErrorMapping$.MODULE$.exceptionFor(code));
        } else {
            success = new Success((Object)response.messageSet(topic, partition));
        }
        return success;
    }

    public static void $init$(Fetcher $this) {
    }
}

